/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util.dashboard;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.dashboard.DashboardDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;

public class DashboardController
implements MouseListener,
Disposable {
    private DashboardDialog dialog;
    private Component component;
    private WorldWindow wwd;

    public DashboardController(WorldWindow worldWindow, Component component) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.component = component;
        worldWindow.getInputHandler().addMouseListener(this);
    }

    @Override
    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        if (this.wwd.getInputHandler() != null) {
            this.wwd.getInputHandler().removeMouseListener(this);
        }
        this.wwd = null;
        this.component = null;
    }

    public void raiseDialog() {
        if (this.dialog == null) {
            this.dialog = new DashboardDialog(this.getParentFrame(this.component), this.wwd);
        }
        this.dialog.raiseDialog();
    }

    public void lowerDialog() {
        if (this.dialog != null) {
            this.dialog.lowerDialog();
        }
    }

    private Frame getParentFrame(Component component) {
        return component != null ? (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component) : null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && (mouseEvent.getModifiers() & 2) != 0 && (mouseEvent.getModifiers() & 8) != 0 && (mouseEvent.getModifiers() & 1) != 0) {
            this.raiseDialog();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

