/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.SessionCache;
import gov.nasa.worldwind.ogc.wms.WMSCapabilities;
import gov.nasa.worldwind.retrieve.URLRetriever;
import gov.nasa.worldwind.util.AbsentResourceList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.SessionCacheRetrievalPostProcessor;
import gov.nasa.worldwind.util.WWIO;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.logging.Level;

public class SessionCacheUtils {
    public static void retrieveSessionData(URL uRL, SessionCache sessionCache, Object object, AbsentResourceList absentResourceList, long l, PropertyChangeListener propertyChangeListener, String string) {
        if (uRL == null) {
            String string2 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sessionCache == null) {
            String string3 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (object == null) {
            String string4 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
            absentResourceList.markResourceAbsent(l);
            return;
        }
        SessionCacheRetrievalPostProcessor sessionCacheRetrievalPostProcessor = new SessionCacheRetrievalPostProcessor(sessionCache, object, absentResourceList, l, propertyChangeListener, string);
        sessionCacheRetrievalPostProcessor.setName(uRL.toString());
        URLRetriever uRLRetriever = URLRetriever.createRetriever(uRL, sessionCacheRetrievalPostProcessor);
        WorldWind.getRetrievalService().runRetriever(uRLRetriever);
    }

    public static WMSCapabilities getSessionCapabilities(SessionCache sessionCache, Object object, String string) {
        if (sessionCache == null) {
            String string2 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        Object object2 = sessionCache.get(object);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof WMSCapabilities) {
            return (WMSCapabilities)object2;
        }
        WMSCapabilities wMSCapabilities = SessionCacheUtils.parseCapabilities(object2, string);
        if (wMSCapabilities == null) {
            return null;
        }
        sessionCache.put(object, wMSCapabilities);
        return wMSCapabilities;
    }

    public static WMSCapabilities getOrRetrieveSessionCapabilities(URL uRL, SessionCache sessionCache, Object object, AbsentResourceList absentResourceList, long l, PropertyChangeListener propertyChangeListener, String string) {
        if (uRL == null) {
            String string2 = Logging.getMessage("nullValue.URLIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (sessionCache == null) {
            String string3 = Logging.getMessage("nullValue.CacheIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (object == null) {
            String string4 = Logging.getMessage("nullValue.CacheKeyIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        WMSCapabilities wMSCapabilities = SessionCacheUtils.getSessionCapabilities(sessionCache, object, uRL.toString());
        if (wMSCapabilities != null) {
            return wMSCapabilities;
        }
        SessionCacheUtils.retrieveSessionData(uRL, sessionCache, object, absentResourceList, l, propertyChangeListener, string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static WMSCapabilities parseCapabilities(Object object, String string) {
        if (object == null) {
            String string2 = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Object var2_3 = null;
        try {
            WMSCapabilities wMSCapabilities = new WMSCapabilities(object);
            WMSCapabilities wMSCapabilities2 = wMSCapabilities.parse(new Object[0]);
            return wMSCapabilities2;
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.CannotParseCapabilities", string);
            Logging.logger().log(Level.SEVERE, string3, exception);
        }
        finally {
            WWIO.closeStream(var2_3, string);
        }
        return null;
    }
}

