/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.util.Logging;

public class IntSet {
    protected static final int DEFAULT_NUM_BUCKETS = 128;
    protected static final int DEFAULT_BUCKET_CAPACITY = 8;
    protected Bucket[] buckets;
    protected int numBuckets;
    protected int bucketInitialCapacity;
    protected int size;

    public IntSet() {
        this(128, 8);
    }

    public IntSet(int n, int n2) {
        if (n < 1) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n2 < 1) {
            String string = Logging.getMessage("generic.SizeOutOfRange", n2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.buckets = new Bucket[n];
        this.numBuckets = n;
        this.bucketInitialCapacity = n2;
    }

    public int size() {
        return this.size;
    }

    public boolean add(int n) {
        int n2 = n % this.numBuckets;
        Bucket bucket = this.buckets[n2];
        if (bucket == null) {
            bucket = this.buckets[n2] = new Bucket(this.bucketInitialCapacity);
        } else {
            for (int i = 0; i < bucket.length; ++i) {
                if (bucket.values[i] != n) continue;
                return false;
            }
        }
        if (bucket.values.length <= bucket.length) {
            int[] nArray = new int[2 * bucket.values.length];
            System.arraycopy(bucket.values, 0, nArray, 0, bucket.values.length);
            bucket.values = nArray;
        }
        bucket.values[bucket.length++] = n;
        ++this.size;
        return true;
    }

    public boolean remove(int n) {
        int n2;
        int n3 = n % this.numBuckets;
        Bucket bucket = this.buckets[n3];
        if (bucket == null || bucket.length == 0) {
            return false;
        }
        for (n2 = 0; n2 < bucket.length && bucket.values[n2] != n; ++n2) {
        }
        if (n2 == bucket.length) {
            return false;
        }
        if (n2 < bucket.length - 1) {
            System.arraycopy(bucket.values, n2 + 1, bucket.values, n2, bucket.length - n2 - 1);
        }
        --bucket.length;
        --this.size;
        return true;
    }

    public boolean contains(int n) {
        int n2 = n % this.numBuckets;
        Bucket bucket = this.buckets[n2];
        if (bucket == null) {
            return false;
        }
        for (int i = 0; i < bucket.length; ++i) {
            if (bucket.values[i] != n) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (int i = 0; i < this.numBuckets; ++i) {
            if (this.buckets[i] == null) continue;
            this.buckets[i].length = 0;
        }
        this.size = 0;
    }

    public int[] toArray(int[] nArray) {
        if (nArray == null || nArray.length < this.size) {
            nArray = new int[this.size];
        }
        int n = 0;
        for (int i = 0; i < this.numBuckets; ++i) {
            Bucket bucket = this.buckets[i];
            if (bucket == null) continue;
            System.arraycopy(bucket.values, 0, nArray, n, bucket.length);
            n += bucket.length;
        }
        return nArray;
    }

    protected static class Bucket {
        public int[] values;
        public int length;

        public Bucket(int n) {
            if (n < 1) {
                String string = Logging.getMessage("generic.SizeOutOfRange", n);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.values = new int[n];
            this.length = 0;
        }
    }
}

