/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;

public class GLUTessellatorSupport {
    protected GLUtessellator tess;

    public GLUtessellator getGLUtessellator() {
        return this.tess;
    }

    public void beginTessellation(GLU gLU, GLUtessellatorCallback gLUtessellatorCallback, Vec4 vec4) {
        if (gLU == null) {
            String string = Logging.getMessage("nullValue.GLUIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (gLUtessellatorCallback == null) {
            String string = Logging.getMessage("nullValue.CallbackIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.NormalIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.tess = gLU.gluNewTess();
        gLU.gluTessNormal(this.tess, vec4.x, vec4.y, vec4.z);
        gLU.gluTessCallback(this.tess, 100100, gLUtessellatorCallback);
        gLU.gluTessCallback(this.tess, 100101, gLUtessellatorCallback);
        gLU.gluTessCallback(this.tess, 100102, gLUtessellatorCallback);
        gLU.gluTessCallback(this.tess, 100105, gLUtessellatorCallback);
    }

    public void endTessellation(GLU gLU) {
        if (gLU == null) {
            String string = Logging.getMessage("nullValue.GLUIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        gLU.gluTessCallback(this.tess, 100100, null);
        gLU.gluTessCallback(this.tess, 100101, null);
        gLU.gluTessCallback(this.tess, 100102, null);
        gLU.gluTessCallback(this.tess, 100105, null);
        this.tess = null;
    }

    public static GLUtessellatorCallback createOGLDrawPrimitivesCallback(GL gL) {
        if (gL == null) {
            String string = Logging.getMessage("nullValue.GLIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new OGLDrawPrimitivesCallback(gL);
    }

    public static class CollectIndexListsCallback
    extends GLUtessellatorCallbackAdapter {
        protected int numIndices;
        protected int currentType;
        protected List<Integer> currentPrim;
        protected List<List<Integer>> prims = new ArrayList<List<Integer>>();
        protected List<Integer> primTypes = new ArrayList<Integer>();

        public List<List<Integer>> getPrims() {
            return this.prims;
        }

        public List<Integer> getPrimTypes() {
            return this.primTypes;
        }

        public int getNumIndices() {
            return this.numIndices;
        }

        public void begin(int n) {
            this.currentType = n;
            this.currentPrim = new ArrayList<Integer>();
        }

        public void vertex(Object object) {
            this.currentPrim.add((Integer)object);
            ++this.numIndices;
        }

        public void end() {
            this.primTypes.add(this.currentType);
            this.prims.add(this.currentPrim);
            this.currentPrim = null;
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = objectArray[0];
        }
    }

    protected static class OGLDrawPrimitivesCallback
    extends GLUtessellatorCallbackAdapter {
        protected final GL gl;

        public OGLDrawPrimitivesCallback(GL gL) {
            if (gL == null) {
                String string = Logging.getMessage("nullValue.GLIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.gl = gL;
        }

        public void begin(int n) {
            this.gl.glBegin(n);
        }

        public void vertex(Object object) {
            double[] dArray = (double[])object;
            this.gl.glVertex3f((float)dArray[0], (float)dArray[1], (float)dArray[2]);
        }

        public void end() {
            this.gl.glEnd();
        }

        public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
            objectArray2[0] = dArray;
        }
    }
}

