/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.util;

import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public abstract class BitSetQuadTreeFilter {
    protected BitSet bits;
    protected int maxLevel;
    protected int numLevels;
    protected int[] powersOf4;
    protected int[] levelSizes;
    protected int[] path;

    protected abstract boolean doOperation(int var1, int var2, double[] var3, double[] var4);

    public BitSetQuadTreeFilter(int n, BitSet bitSet) {
        if (n < 1) {
            String string = Logging.getMessage("generic.DepthOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.numLevels = n;
        this.maxLevel = n - 1;
        this.powersOf4 = WWMath.computePowers(4, n);
        this.levelSizes = BitSetQuadTreeFilter.computeLevelSizes(n);
        this.path = new int[this.numLevels];
        this.bits = bitSet != null ? bitSet : new BitSet(this.levelSizes[n]);
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    protected static int[] computeLevelSizes(int n) {
        int[] nArray = new int[n + 1];
        nArray[0] = 0;
        double d = 0.0;
        for (int i = 1; i <= n; ++i) {
            nArray[i] = (int)(d += Math.pow(4.0, i));
        }
        return nArray;
    }

    protected void testAndDo(int n, int n2, double[] dArray, double[] dArray2) {
        if (this.intersects(dArray, dArray2) == 0) {
            return;
        }
        this.path[n] = n2;
        if (!this.doOperation(n, n2, dArray, dArray2)) {
            return;
        }
        if (n == this.maxLevel) {
            return;
        }
        double d = (dArray[1] + dArray[0]) / 2.0;
        double d2 = (dArray[3] + dArray[2]) / 2.0;
        double[] dArray3 = new double[]{dArray[0], d, dArray[2], d2};
        this.testAndDo(n + 1, 0, dArray3, dArray2);
        dArray3[2] = d2;
        dArray3[3] = dArray[3];
        this.testAndDo(n + 1, 1, dArray3, dArray2);
        dArray3[0] = d;
        dArray3[1] = dArray[1];
        this.testAndDo(n + 1, 2, dArray3, dArray2);
        dArray3[2] = dArray[2];
        dArray3[3] = d2;
        this.testAndDo(n + 1, 3, dArray3, dArray2);
    }

    protected int intersects(double[] dArray, double[] dArray2) {
        if (dArray2.length == 4) {
            return !(dArray2[1] < dArray[0] || dArray2[0] > dArray[1] || dArray2[3] < dArray[2] || dArray2[2] > dArray[3]) ? 1 : 0;
        }
        return dArray2[0] >= dArray[0] && dArray2[0] <= dArray[1] && dArray2[1] >= dArray[2] && dArray2[1] <= dArray[3] ? 1 : 0;
    }

    protected int computeBitPosition(int n, int n2) {
        int n3 = n2;
        for (int i = 0; i < n; ++i) {
            n3 += this.path[i] * this.powersOf4[n - i];
        }
        return n3 + this.levelSizes[n];
    }

    public static class FindIntersectingBitsOp
    extends BitSetQuadTreeFilter {
        protected List<Integer> intersectingBits;

        public FindIntersectingBitsOp(BitSetQuadTreeFilter bitSetQuadTreeFilter) {
            super(bitSetQuadTreeFilter.getNumLevels(), bitSetQuadTreeFilter.bits);
        }

        public List<Integer> getOnBits(List<double[]> list, Sector sector, List<Integer> list2) {
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.getOnBits(list, sector.asDegreesArray(), list2);
        }

        public List<Integer> getOnBits(List<double[]> list, double[] dArray, List<Integer> arrayList) {
            if (list == null) {
                String string = Logging.getMessage("generic.DepthOutOfRange", this.numLevels);
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (dArray == null) {
                String string = Logging.getMessage("nullValue.ArrayIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.intersectingBits = arrayList != null ? arrayList : new ArrayList();
            for (int i = 0; i < list.size(); ++i) {
                this.testAndDo(0, i, list.get(i), dArray);
            }
            return this.intersectingBits;
        }

        @Override
        protected boolean doOperation(int n, int n2, double[] dArray, double[] dArray2) {
            int n3 = this.computeBitPosition(n, n2);
            if (!this.bits.get(n3)) {
                return false;
            }
            if (n < this.maxLevel) {
                return true;
            }
            this.intersectingBits.add(n3);
            return false;
        }
    }
}

