/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.areas;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Ambush
extends AbstractMilStd2525TacticalGraphic {
    public static final double DEFAULT_ARROWHEAD_LENGTH = 0.2;
    public static final Angle DEFAULT_ARC_ANGLE = Angle.fromDegrees(60.0);
    public static final Angle DEFAULT_ARROWHEAD_ANGLE = Angle.fromDegrees(70.0);
    public static final double DEFAULT_LEG_LENGTH = 0.5;
    public static final int DEFAULT_NUM_INTERVALS = 32;
    public static final int DEFAULT_NUM_LEGS = 6;
    protected int intervals = 32;
    protected Angle arcAngle = DEFAULT_ARC_ANGLE;
    protected Angle arrowAngle = DEFAULT_ARROWHEAD_ANGLE;
    protected double arrowLength = 0.2;
    protected int numLegs = 6;
    protected double legLength = 0.5;
    protected Position position1;
    protected Position position2;
    protected Position position3;
    protected Path[] paths;

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-G-SLA--------");
    }

    public Ambush(String string) {
        super(string);
    }

    public int getIntervals() {
        return this.intervals;
    }

    public void setIntervals(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.intervals = n;
        this.onShapeChanged();
    }

    public Angle getArcAngle() {
        return this.arcAngle;
    }

    public void setArcAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arcAngle = angle;
    }

    public Angle getArrowAngle() {
        return this.arrowAngle;
    }

    public void setArrowAngle(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees <= 0.0 || angle.degrees >= 90.0) {
            String string = Logging.getMessage("generic.AngleOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowAngle = angle;
        this.onShapeChanged();
    }

    public double getArrowLength() {
        return this.arrowLength;
    }

    public void setArrowLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arrowLength = d;
        this.onShapeChanged();
    }

    public int getLegs() {
        return this.numLegs;
    }

    public void setLegs(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.numLegs = n;
        this.onShapeChanged();
    }

    public double getLegLength() {
        return this.legLength;
    }

    public void setLegLength(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.legLength = d;
        this.onShapeChanged();
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            Iterator<? extends Position> iterator = iterable.iterator();
            this.position1 = iterator.next();
            this.position2 = iterator.next();
            this.position3 = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = Logging.getMessage("generic.InsufficientPositions");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.onShapeChanged();
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return Arrays.asList(this.position1, this.position2, this.position3);
    }

    @Override
    public Position getReferencePosition() {
        return this.position1;
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        if (this.paths == null) {
            this.createShapes(drawContext);
        }
        for (Path path : this.paths) {
            path.render(drawContext);
        }
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        if (this.paths == null) {
            return;
        }
        for (Path path : this.paths) {
            path.setDelegateOwner(object);
        }
    }

    protected void onShapeChanged() {
        this.paths = null;
    }

    protected void createShapes(DrawContext drawContext) {
        this.paths = new Path[3 + this.getLegs()];
        ArcData arcData = this.computeArc(drawContext);
        List<Position> list = this.computeArcPositions(drawContext, arcData);
        this.paths[0] = this.createPath(list);
        this.paths[1] = this.createPath(Arrays.asList(arcData.midpoint, this.position1));
        list = this.computeArrowheadPositions(drawContext, this.position1, arcData);
        this.paths[2] = this.createPath(list);
        this.createLegs(drawContext, arcData, this.paths, 3, this.getLegs());
    }

    protected ArcData computeArc(DrawContext drawContext) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(this.position2);
        Vec4 vec42 = globe.computePointFromPosition(this.position3);
        Position position = new Position(LatLon.interpolate(0.5, this.position2, this.position3), 0.0);
        Vec4 vec43 = globe.computePointFromPosition(position);
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = globe.computeSurfaceNormalAtPoint(vec43);
        Vec4 vec46 = vec44.cross3(vec45).normalize3();
        ArcData arcData = new ArcData();
        double d = vec4.distanceTo3(vec42);
        Angle angle = this.getArcAngle();
        arcData.radius = d / (2.0 * angle.sinHalfAngle());
        double d2 = arcData.radius * angle.cosHalfAngle();
        Vec4 vec47 = globe.computePointFromPosition(this.position1).subtract3(vec43);
        double d3 = vec46.dot3(vec47);
        double d4 = d3 > 0.0 ? -1.0 : 1.0;
        arcData.direction = vec46.multiply3(d4);
        Vec4 vec48 = vec43.add3(arcData.direction.multiply3(d2));
        arcData.center = globe.computePositionFromPoint(vec48);
        arcData.startAngle = LatLon.greatCircleAzimuth(arcData.center, this.position2);
        Angle angle2 = LatLon.greatCircleAzimuth(arcData.center, this.position3);
        arcData.arcAngle = angle2.subtract(arcData.startAngle);
        double d5 = globe.getRadiusAt(arcData.center.getLatitude(), arcData.center.getLongitude());
        LatLon latLon = LatLon.greatCircleEndPosition(arcData.center, arcData.arcAngle.divide((double)2.0).radians + arcData.startAngle.radians, arcData.radius / d5);
        arcData.midpoint = new Position(latLon, 0.0);
        return arcData;
    }

    protected List<Position> computeArcPositions(DrawContext drawContext, ArcData arcData) {
        Globe globe = drawContext.getGlobe();
        Angle angle = arcData.arcAngle.divide(this.intervals);
        double d = globe.getRadiusAt(arcData.center.getLatitude(), arcData.center.getLongitude());
        double d2 = arcData.radius / d;
        int n = this.getIntervals();
        ArrayList<Position> arrayList = new ArrayList<Position>(n);
        for (int i = 0; i < n; ++i) {
            double d3 = (double)i * angle.radians + arcData.startAngle.radians;
            LatLon latLon = LatLon.greatCircleEndPosition(arcData.center, d3, d2);
            arrayList.add(new Position(latLon, 0.0));
        }
        arrayList.add(this.position3);
        return arrayList;
    }

    protected void createLegs(DrawContext drawContext, ArcData arcData, Path[] pathArray, int n, int n2) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(this.position1);
        Vec4 vec42 = globe.computePointFromLocation(arcData.midpoint);
        Vec4 vec43 = vec42.subtract3(vec4);
        vec43 = vec43.normalize3().multiply3(vec43.getLength3() * this.getLegLength());
        Angle angle = arcData.arcAngle.divide(n2);
        double d = globe.getRadiusAt(arcData.center.getLatitude(), arcData.center.getLongitude());
        double d2 = arcData.radius / d;
        for (int i = 0; i < n2; ++i) {
            double d3 = ((double)i + 0.5) * angle.radians + arcData.startAngle.radians;
            LatLon latLon = LatLon.greatCircleEndPosition(arcData.center, d3, d2);
            Vec4 vec44 = globe.computePointFromLocation(latLon);
            Vec4 vec45 = vec44.add3(vec43);
            pathArray[n + i] = this.createPath(TacticalGraphicUtil.asPositionList(globe, vec44, vec45));
        }
    }

    protected List<Position> computeArrowheadPositions(DrawContext drawContext, Position position, ArcData arcData) {
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(position);
        double d = LatLon.greatCircleDistance((LatLon)arcData.midpoint, (LatLon)position).radians * globe.getRadius();
        double d2 = d * this.getArrowLength();
        Vec4 vec42 = vec4.add3(arcData.direction.normalize3().multiply3(d2));
        Vec4 vec43 = globe.computeSurfaceNormalAtPoint(vec42);
        double d3 = d2 * this.getArrowAngle().tanHalfAngle();
        Vec4 vec44 = arcData.direction.cross3(vec43);
        vec44 = vec44.normalize3().multiply3(d3);
        Vec4 vec45 = vec42.add3(vec44);
        Vec4 vec46 = vec42.subtract3(vec44);
        return TacticalGraphicUtil.asPositionList(globe, vec45, vec4, vec46);
    }

    protected Path createPath(List<Position> list) {
        Path path = new Path(list);
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }

    protected static class ArcData {
        Position midpoint;
        LatLon center;
        double radius;
        Angle startAngle;
        Angle arcAngle;
        Vec4 direction;

        protected ArcData() {
        }
    }
}

