/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.symbology.SymbologyConstants;
import gov.nasa.worldwind.util.Logging;

public class SymbolCode
extends AVListImpl {
    protected static final String UNUSED_POSITION_CODE = "-";

    public SymbolCode() {
    }

    public SymbolCode(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.SymbolCodeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (string.length() != 15) {
            String string3 = Logging.getMessage("Symbology.SymbolCodeLengthInvalid", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        String string4 = this.parseSymCode(string);
        if (string4 != null) {
            Logging.logger().severe(string4);
            throw new WWUnrecognizedException(string4);
        }
    }

    public String getScheme() {
        return this.getStringValue("gov.nasa.worldwind.symbology.Scheme");
    }

    public void setScheme(String string) {
        this.setValue("gov.nasa.worldwind.symbology.Scheme", string);
    }

    public String getStandardIdentity() {
        return this.getStringValue("gov.nasa.worldwind.symbology.StandardIdentity");
    }

    public void setStandardIdentity(String string) {
        this.setValue("gov.nasa.worldwind.symbology.StandardIdentity", string);
    }

    public String getBattleDimension() {
        return this.getStringValue("gov.nasa.worldwind.symbology.BattleDimension");
    }

    public void setBattleDimension(String string) {
        this.setValue("gov.nasa.worldwind.symbology.BattleDimension", string);
    }

    public String getCategory() {
        return this.getStringValue("gov.nasa.worldwind.symbology.Category");
    }

    public void setCategory(String string) {
        this.setValue("gov.nasa.worldwind.symbology.Category", string);
    }

    public String getStatus() {
        return this.getStringValue("AL");
    }

    public void setStatus(String string) {
        this.setValue("AL", string);
    }

    public String getFunctionId() {
        return this.getStringValue("gov.nasa.worldwind.symbology.FunctionId");
    }

    public void setFunctionId(String string) {
        this.setValue("gov.nasa.worldwind.symbology.FunctionId", string);
    }

    public String getSymbolModifier() {
        return this.getStringValue("gov.nasa.worldwind.symbology.SymbolModifier");
    }

    public void setSymbolModifier(String string) {
        this.setValue("gov.nasa.worldwind.symbology.SymbolModifier", string);
    }

    public String getEchelon() {
        return this.getStringValue("B");
    }

    public void setEchelon(String string) {
        this.setValue("B", string);
    }

    public String getCountryCode() {
        return this.getStringValue("gov.nasa.worldwind.symbology.CountryCode");
    }

    public void setCountryCode(String string) {
        this.setValue("gov.nasa.worldwind.symbology.CountryCode", string);
    }

    public String getOrderOfBattle() {
        return this.getStringValue("gov.nasa.worldwind.symbology.OrderOfBattle");
    }

    public void setOrderOfBattle(String string) {
        this.setValue("gov.nasa.worldwind.symbology.OrderOfBattle", string);
    }

    public String getStaticDynamic() {
        return this.getStringValue("gov.nasa.worldwind.symbology.StaticDynamic");
    }

    public void setStaticDynamic(String string) {
        this.setValue("gov.nasa.worldwind.symbology.StaticDynamic", string);
    }

    public String getGraphicType() {
        return this.getStringValue("gov.nasa.worldwind.symbology.GraphicType");
    }

    public void setGraphicType(String string) {
        this.setValue("gov.nasa.worldwind.symbology.GraphicType", string);
    }

    public String toString() {
        return this.composeSymCode();
    }

    public String toMaskedString() {
        SymbolCode symbolCode = new SymbolCode();
        symbolCode.setValues(this);
        symbolCode.setStandardIdentity(null);
        symbolCode.setStatus(null);
        symbolCode.setEchelon(null);
        symbolCode.setSymbolModifier(null);
        symbolCode.setCountryCode(null);
        symbolCode.setOrderOfBattle(null);
        return symbolCode.toString();
    }

    public static AVList parseSymbolModifierCode(String string, AVList aVList) {
        if (string == null || string.length() != 2 || string.equals("--")) {
            return aVList;
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        String string2 = string.substring(0, 1);
        String string3 = string.substring(1, 2);
        String string4 = string.toUpperCase();
        String string5 = string2.toUpperCase();
        String string6 = string3.toUpperCase();
        if (SymbologyConstants.MODIFIER_CODE_ALL_UEI.contains(string5) || UNUSED_POSITION_CODE.equals(string5)) {
            if (SymbologyConstants.ECHELON_ALL.contains(string6)) {
                aVList.setValue("B", string3);
            }
            if (SymbologyConstants.MODIFIER_CODE_ALL_HEADQUARTERS.contains(string5)) {
                aVList.setValue("S", Boolean.TRUE);
            }
            if (SymbologyConstants.MODIFIER_CODE_ALL_TASK_FORCE.contains(string5)) {
                aVList.setValue("D", Boolean.TRUE);
            }
            if (SymbologyConstants.MODIFIER_CODE_ALL_FEINT_DUMMY.contains(string5)) {
                aVList.setValue("AB", Boolean.TRUE);
            }
        } else if (SymbologyConstants.INSTALLATION_ALL.contains(string4)) {
            aVList.setValue("AC", string);
            if ("HB".equalsIgnoreCase(string)) {
                aVList.setValue("AB", Boolean.TRUE);
            }
        } else if (SymbologyConstants.MOBILITY_ALL.contains(string4)) {
            aVList.setValue("R", string);
        } else if (SymbologyConstants.AUXILIARY_EQUIPMENT_ALL.contains(string4)) {
            aVList.setValue("AG", string);
        } else if (SymbologyConstants.OPERATIONAL_CONDITION_ALL.contains(string4)) {
            aVList.setValue("gov.nasa.worldwind.symbology.OperationalCondition", string);
        } else if (SymbologyConstants.OPERATIONAL_CONDITION_ALTERNATE_ALL.contains(string4)) {
            aVList.setValue("gov.nasa.worldwind.symbology.OperationalConditionAlternate", string);
        }
        return aVList;
    }

    public static String composeSymbolModifierCode(SymbolCode symbolCode, AVList aVList, String string) {
        String string2;
        if (symbolCode == null) {
            return null;
        }
        if (aVList == null || string == null) {
            return null;
        }
        Object object = aVList.getValue(string);
        String string3 = string2 = object != null ? object.toString().toUpperCase() : null;
        if ("B".equalsIgnoreCase(string) && SymbologyConstants.ECHELON_ALL.contains(string2)) {
            return UNUSED_POSITION_CODE + string2;
        }
        if ("D".equalsIgnoreCase(string) && Boolean.TRUE.equals(object)) {
            Object object2 = aVList.getValue("B");
            if (object2 != null && SymbologyConstants.ECHELON_ALL.contains(object2.toString().toUpperCase())) {
                return "E" + object2.toString().toUpperCase();
            }
            return "E-";
        }
        if ("AB".equalsIgnoreCase(string) && Boolean.TRUE.equals(object)) {
            return "F-";
        }
        if ("AC".equalsIgnoreCase(string) && SymbologyConstants.INSTALLATION_ALL.contains(string2)) {
            return string2;
        }
        if ("R".equalsIgnoreCase(string) && SymbologyConstants.MOBILITY_ALL.contains(string2)) {
            return string2;
        }
        if ("AG".equalsIgnoreCase(string) && SymbologyConstants.AUXILIARY_EQUIPMENT_ALL.contains(string2)) {
            return string2;
        }
        if ("gov.nasa.worldwind.symbology.OperationalCondition".equalsIgnoreCase(string)) {
            String string4;
            String string5 = symbolCode.getStatus();
            String string6 = string4 = string5 != null ? string5.toString().toUpperCase() : null;
            if ("D".equalsIgnoreCase(string4)) {
                return "OD";
            }
            if ("X".equalsIgnoreCase(string4)) {
                return "OX";
            }
        } else if ("gov.nasa.worldwind.symbology.OperationalConditionAlternate".equalsIgnoreCase(string)) {
            String string7;
            String string8 = symbolCode.getStatus();
            String string9 = string7 = string8 != null ? string8.toString().toUpperCase() : null;
            if ("C".equalsIgnoreCase(string7)) {
                return "PC";
            }
            if ("D".equalsIgnoreCase(string7)) {
                return "PD";
            }
            if ("X".equalsIgnoreCase(string7)) {
                return "PX";
            }
            if ("F".equalsIgnoreCase(string7)) {
                return "PF";
            }
        }
        return null;
    }

    protected String parseSymCode(String string) {
        String string2 = string.substring(0, 1);
        if ("S".equalsIgnoreCase(string2)) {
            return this.parseWarfightingSymCode(string);
        }
        if ("G".equalsIgnoreCase(string2)) {
            return this.parseTacticalGraphicsSymCode(string);
        }
        if ("W".equalsIgnoreCase(string2)) {
            return this.parseMetocSymCode(string);
        }
        if ("I".equalsIgnoreCase(string2)) {
            return this.parseIntelligenceSymCode(string);
        }
        if ("O".equalsIgnoreCase(string2)) {
            return this.parseStabilityOperationsSymCode(string);
        }
        if ("E".equalsIgnoreCase(string2)) {
            return this.parseEmergencyManagementSymCode(string);
        }
        return this.parseUnrecognizedSymCode(string);
    }

    protected String parseUnrecognizedSymCode(String string) {
        String string2 = string.substring(0, 1);
        return Logging.getMessage("Symbology.SymbolCodeSchemeUnrecognized", string2, string);
    }

    protected String parseWarfightingSymCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, 1);
        if (string2 != null && string2.equalsIgnoreCase("S")) {
            this.setScheme(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.scheme"));
        }
        string2 = string.substring(1, 2);
        if (SymbologyConstants.STANDARD_IDENTITY_ALL.contains(string2.toUpperCase())) {
            this.setStandardIdentity(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.standardIdentity"));
        }
        string2 = string.substring(2, 3);
        if (SymbologyConstants.BATTLE_DIMENSION_ALL.contains(string2.toUpperCase())) {
            this.setBattleDimension(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.battleDimension"));
        }
        string2 = string.substring(3, 4);
        if (SymbologyConstants.STATUS_ALL_UEI_SIGINT_SO_EM.contains(string2.toUpperCase())) {
            this.setStatus(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.status"));
        }
        string2 = string.substring(4, 10);
        if (!"------".equals(string2)) {
            this.setFunctionId(string2);
        }
        if (this.isUnitsAndEquipmentSymbolModifier(string2 = string.substring(10, 12)) || SymbologyConstants.INSTALLATION_ALL.contains(string2.toUpperCase()) || SymbologyConstants.MOBILITY_ALL.contains(string2.toUpperCase()) || SymbologyConstants.AUXILIARY_EQUIPMENT_ALL.contains(string2.toUpperCase())) {
            this.setSymbolModifier(string2);
        } else if (!"--".equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.symbolModifier"));
        }
        string2 = string.substring(12, 14);
        if (!"--".equals(string2)) {
            this.setCountryCode(string2);
        }
        if (SymbologyConstants.ORDER_OF_BATTLE_ALL_UEI_SIGINT_SO_EM.contains((string2 = string.substring(14, 15)).toUpperCase())) {
            this.setOrderOfBattle(string2);
        } else if (!UNUSED_POSITION_CODE.equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.orderOfBattle"));
        }
        return stringBuilder.length() > 0 ? Logging.getMessage("Symbology.SymbolCodeFieldsUnrecognized", stringBuilder.toString(), string) : null;
    }

    protected String parseTacticalGraphicsSymCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, 1);
        if (string2 != null && string2.equalsIgnoreCase("G")) {
            this.setScheme(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.scheme"));
        }
        string2 = string.substring(1, 2);
        if (SymbologyConstants.STANDARD_IDENTITY_ALL.contains(string2.toUpperCase())) {
            this.setStandardIdentity(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.standardIdentity"));
        }
        string2 = string.substring(2, 3);
        if (SymbologyConstants.CATEGORY_ALL_TACTICAL_GRAPHICS.contains(string2.toUpperCase())) {
            this.setCategory(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.category"));
        }
        string2 = string.substring(3, 4);
        if (SymbologyConstants.STATUS_ALL_TACTICAL_GRAPHICS_METOC.contains(string2.toUpperCase())) {
            this.setStatus(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.status"));
        }
        string2 = string.substring(4, 10);
        if (!"------".equals(string2)) {
            this.setFunctionId(string2);
        }
        if (SymbologyConstants.ECHELON_ALL.contains((string2 = string.substring(11, 12)).toUpperCase())) {
            this.setEchelon(string2);
        } else if (!UNUSED_POSITION_CODE.equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.echelon"));
        }
        string2 = string.substring(12, 14);
        if (!"--".equals(string2)) {
            this.setCountryCode(string2);
        }
        if (SymbologyConstants.ORDER_OF_BATTLE_ALL_TACTICAL_GRAPHICS.contains((string2 = string.substring(14, 15)).toUpperCase())) {
            this.setOrderOfBattle(string2);
        } else if (!UNUSED_POSITION_CODE.equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.orderOfBattle"));
        }
        return stringBuilder.length() > 0 ? Logging.getMessage("Symbology.SymbolCodeFieldsUnrecognized", stringBuilder.toString(), string) : null;
    }

    protected String parseMetocSymCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, 1);
        if ("W".equalsIgnoreCase(string2)) {
            this.setScheme(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.scheme"));
        }
        string2 = string.substring(1, 2);
        if (SymbologyConstants.CATEGORY_ALL_METOC.contains(string2.toUpperCase())) {
            this.setCategory(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.category"));
        }
        string2 = string.substring(2, 4);
        if (SymbologyConstants.STATIC_DYNAMIC_ALL.contains(string2.toUpperCase())) {
            this.setStaticDynamic(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.status"));
        }
        string2 = string.substring(4, 10);
        if (!"------".equals(string2)) {
            this.setFunctionId(string2);
        }
        if (SymbologyConstants.GRAPHIC_TYPE_ALL.contains((string2 = string.substring(10, 13)).toUpperCase())) {
            this.setGraphicType(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.echelon"));
        }
        return stringBuilder.length() > 0 ? Logging.getMessage("Symbology.SymbolCodeFieldsUnrecognized", stringBuilder.toString(), string) : null;
    }

    protected String parseIntelligenceSymCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, 1);
        if (string2 != null && string2.equalsIgnoreCase("I")) {
            this.setScheme(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.scheme"));
        }
        string2 = string.substring(1, 2);
        if (SymbologyConstants.STANDARD_IDENTITY_ALL.contains(string2.toUpperCase())) {
            this.setStandardIdentity(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.standardIdentity"));
        }
        string2 = string.substring(2, 3);
        if (SymbologyConstants.BATTLE_DIMENSION_ALL_INTELLIGENCE.contains(string2.toUpperCase())) {
            this.setBattleDimension(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.battleDimension"));
        }
        string2 = string.substring(3, 4);
        if (SymbologyConstants.STATUS_ALL_UEI_SIGINT_SO_EM.contains(string2.toUpperCase())) {
            this.setStatus(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.status"));
        }
        string2 = string.substring(4, 10);
        if (!"------".equals(string2)) {
            this.setFunctionId(string2);
        }
        if (!"--".equals(string2 = string.substring(10, 12))) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.symbolModifier"));
        }
        if (!"--".equals(string2 = string.substring(12, 14))) {
            this.setCountryCode(string2);
        }
        if (SymbologyConstants.ORDER_OF_BATTLE_ALL_UEI_SIGINT_SO_EM.contains((string2 = string.substring(14, 15)).toUpperCase())) {
            this.setOrderOfBattle(string2);
        } else if (!UNUSED_POSITION_CODE.equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.orderOfBattle"));
        }
        return stringBuilder.length() > 0 ? Logging.getMessage("Symbology.SymbolCodeFieldsUnrecognized", stringBuilder.toString(), string) : null;
    }

    protected String parseStabilityOperationsSymCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, 1);
        if (string2 != null && string2.equalsIgnoreCase("O")) {
            this.setScheme(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.scheme"));
        }
        string2 = string.substring(1, 2);
        if (SymbologyConstants.STANDARD_IDENTITY_ALL.contains(string2.toUpperCase())) {
            this.setStandardIdentity(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.standardIdentity"));
        }
        string2 = string.substring(2, 3);
        if (SymbologyConstants.CATEGORY_ALL_STABILITY_OPERATIONS.contains(string2.toUpperCase())) {
            this.setCategory(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.category"));
        }
        string2 = string.substring(3, 4);
        if (SymbologyConstants.STATUS_ALL_UEI_SIGINT_SO_EM.contains(string2.toUpperCase())) {
            this.setStatus(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.status"));
        }
        string2 = string.substring(4, 10);
        if (!"------".equals(string2)) {
            this.setFunctionId(string2);
        }
        if (this.isUnitsAndEquipmentSymbolModifier(string2 = string.substring(10, 12)) || SymbologyConstants.INSTALLATION_ALL.contains(string2.toUpperCase())) {
            this.setSymbolModifier(string2);
        } else if (!"--".equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.symbolModifier"));
        }
        string2 = string.substring(12, 14);
        if (!"--".equals(string2)) {
            this.setCountryCode(string2);
        }
        if (SymbologyConstants.ORDER_OF_BATTLE_ALL_UEI_SIGINT_SO_EM.contains((string2 = string.substring(14, 15)).toUpperCase())) {
            this.setOrderOfBattle(string2);
        } else if (!UNUSED_POSITION_CODE.equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.orderOfBattle"));
        }
        return stringBuilder.length() > 0 ? Logging.getMessage("Symbology.SymbolCodeFieldsUnrecognized", stringBuilder.toString(), string) : null;
    }

    protected String parseEmergencyManagementSymCode(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = string.substring(0, 1);
        if (string2 != null && string2.equalsIgnoreCase("E")) {
            this.setScheme(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.scheme"));
        }
        string2 = string.substring(1, 2);
        if (SymbologyConstants.STANDARD_IDENTITY_ALL.contains(string2.toUpperCase())) {
            this.setStandardIdentity(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.standardIdentity"));
        }
        string2 = string.substring(2, 3);
        if (SymbologyConstants.CATEGORY_ALL_EMERGENCY_MANAGEMENT.contains(string2.toUpperCase())) {
            this.setCategory(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.category"));
        }
        string2 = string.substring(3, 4);
        if (SymbologyConstants.STATUS_ALL_UEI_SIGINT_SO_EM.contains(string2.toUpperCase())) {
            this.setStatus(string2);
        } else {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.status"));
        }
        string2 = string.substring(4, 10);
        if (!"------".equals(string2)) {
            this.setFunctionId(string2);
        }
        if (SymbologyConstants.INSTALLATION_ALL.contains((string2 = string.substring(10, 12)).toUpperCase()) || SymbologyConstants.MOBILITY_ALL.contains(string2.toUpperCase())) {
            this.setSymbolModifier(string2);
        } else if (!"--".equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.symbolModifier"));
        }
        string2 = string.substring(12, 14);
        if (!"--".equals(string2)) {
            this.setCountryCode(string2);
        }
        if (SymbologyConstants.ORDER_OF_BATTLE_ALL_UEI_SIGINT_SO_EM.contains((string2 = string.substring(14, 15)).toUpperCase())) {
            this.setOrderOfBattle(string2);
        } else if (!UNUSED_POSITION_CODE.equals(string2)) {
            stringBuilder.append(stringBuilder.length() > 0 ? ", " : "").append(Logging.getMessage("term.orderOfBattle"));
        }
        return stringBuilder.length() > 0 ? Logging.getMessage("Symbology.SymbolCodeFieldsUnrecognized", stringBuilder.toString(), string) : null;
    }

    protected boolean isUnitsAndEquipmentSymbolModifier(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1, 2).toUpperCase();
        return (UNUSED_POSITION_CODE.equals(string2) || SymbologyConstants.MODIFIER_CODE_ALL_UEI.contains(string2)) && SymbologyConstants.ECHELON_ALL.contains(string3.toUpperCase());
    }

    protected String composeSymCode() {
        String string = this.getScheme();
        if ("S".equalsIgnoreCase(string)) {
            return this.composeWarfightingSymCode();
        }
        if ("G".equalsIgnoreCase(string)) {
            return this.composeTacticalGraphicsSymCode();
        }
        if ("W".equalsIgnoreCase(string)) {
            return this.composeMetocSymCode();
        }
        if ("I".equalsIgnoreCase(string)) {
            return this.composeIntelligenceSymCode();
        }
        if ("O".equalsIgnoreCase(string)) {
            return this.composeStabilityOperationsSymCode();
        }
        if ("E".equalsIgnoreCase(string)) {
            return this.composeEmergencyManagementSymCode();
        }
        return this.composeUnrecognizedSymCode();
    }

    protected String composeUnrecognizedSymCode() {
        return null;
    }

    protected String composeWarfightingSymCode() {
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, this.getScheme(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStandardIdentity(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getBattleDimension(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStatus(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getFunctionId(), 6);
        SymbolCode.appendFieldValue(stringBuilder, this.getSymbolModifier(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getCountryCode(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getOrderOfBattle(), 1);
        return stringBuilder.toString();
    }

    protected String composeTacticalGraphicsSymCode() {
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, this.getScheme(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStandardIdentity(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getCategory(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStatus(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getFunctionId(), 6);
        stringBuilder.append(UNUSED_POSITION_CODE);
        SymbolCode.appendFieldValue(stringBuilder, this.getEchelon(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getCountryCode(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getOrderOfBattle(), 1);
        return stringBuilder.toString();
    }

    protected String composeMetocSymCode() {
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, this.getScheme(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getCategory(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStaticDynamic(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getFunctionId(), 6);
        SymbolCode.appendFieldValue(stringBuilder, this.getGraphicType(), 3);
        stringBuilder.append(UNUSED_POSITION_CODE);
        stringBuilder.append(UNUSED_POSITION_CODE);
        return stringBuilder.toString();
    }

    protected String composeIntelligenceSymCode() {
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, this.getScheme(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStandardIdentity(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getBattleDimension(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStatus(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getFunctionId(), 6);
        stringBuilder.append(UNUSED_POSITION_CODE).append(UNUSED_POSITION_CODE);
        SymbolCode.appendFieldValue(stringBuilder, this.getCountryCode(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getOrderOfBattle(), 1);
        return stringBuilder.toString();
    }

    protected String composeStabilityOperationsSymCode() {
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, this.getScheme(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStandardIdentity(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getCategory(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStatus(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getFunctionId(), 6);
        SymbolCode.appendFieldValue(stringBuilder, this.getSymbolModifier(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getCountryCode(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getOrderOfBattle(), 1);
        return stringBuilder.toString();
    }

    protected String composeEmergencyManagementSymCode() {
        StringBuilder stringBuilder = new StringBuilder();
        SymbolCode.appendFieldValue(stringBuilder, this.getScheme(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStandardIdentity(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getCategory(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getStatus(), 1);
        SymbolCode.appendFieldValue(stringBuilder, this.getFunctionId(), 6);
        SymbolCode.appendFieldValue(stringBuilder, this.getSymbolModifier(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getCountryCode(), 2);
        SymbolCode.appendFieldValue(stringBuilder, this.getOrderOfBattle(), 1);
        return stringBuilder.toString();
    }

    public static void appendFieldValue(StringBuilder stringBuilder, String string, int n) {
        int n2;
        if (stringBuilder == null) {
            String string2 = Logging.getMessage("nullValue.StringBuilderIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (n < 0) {
            String string3 = Logging.getMessage("generic.LengthIsInvalid", n);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string != null && string.length() > 0) {
            stringBuilder.append(string, 0, string.length() < n ? string.length() : n);
        }
        int n3 = n2 = string != null ? string.length() : 0;
        while (n2 < n) {
            stringBuilder.append(UNUSED_POSITION_CODE);
            ++n2;
        }
    }

    public static boolean isFieldEmpty(String string) {
        return string == null || string.isEmpty() || string.replaceAll(UNUSED_POSITION_CODE, "").trim().isEmpty();
    }
}

