/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.symbology.TacticalCircle;
import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.TacticalGraphicFactory;
import gov.nasa.worldwind.symbology.TacticalPoint;
import gov.nasa.worldwind.symbology.TacticalQuad;
import gov.nasa.worldwind.symbology.TacticalRoute;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525PointGraphic;
import gov.nasa.worldwind.symbology.milstd2525.MilStd2525TacticalGraphic;
import gov.nasa.worldwind.symbology.milstd2525.SymbolCode;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AirfieldZone;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.Airhead;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.Ambush;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AttackByFirePosition;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.AviationZone;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BasicArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.BattlePosition;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.CircularFireSupportArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.CircularPositionArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.CircularRangeFan;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.CombatSupportArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.Dummy;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.Encirclement;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.FilledArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.FortifiedArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.GroupOfTargets;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.IrregularFireSupportArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.LimitedAccessArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.MinimumSafeDistanceZones;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.OffenseArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.RectangularFireSupportArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.RectangularPositionArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.RectangularTarget;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.SearchArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.SectorRangeFan;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.Smoke;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.SpecialInterestArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.SupportByFirePosition;
import gov.nasa.worldwind.symbology.milstd2525.graphics.areas.WeaponsFreeZone;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.AdvanceForFeint;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.Airborne;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.AttackRotaryWing;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.Aviation;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.Boundary;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.DirectionOfAttack;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.DirectionOfAttackAviation;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.DirectionOfAttackForFeint;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.DoseRateContourLine;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.FireSupportLine;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.ForwardEdgeOfBattleArea;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.ForwardLineOfOwnTroops;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.HoldingLine;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.InfiltrationLane;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.LineOfContact;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.LinearTarget;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.MainAttack;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.MunitionFlightPath;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.PhaseLine;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.PrincipleDirectionOfFire;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.PullUpPoint;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.Route;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.RoutePoint;
import gov.nasa.worldwind.symbology.milstd2525.graphics.lines.SupportingAttack;
import gov.nasa.worldwind.util.Logging;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MilStd2525GraphicFactory
implements TacticalGraphicFactory {
    protected Map<String, Class> classMap = new ConcurrentHashMap<String, Class>();

    public MilStd2525GraphicFactory() {
        this.populateClassMap();
    }

    protected void populateClassMap() {
        this.mapClass(MilStd2525PointGraphic.class, MilStd2525PointGraphic.getSupportedGraphics());
        this.mapClass(Boundary.class, Boundary.getSupportedGraphics());
        this.mapClass(PhaseLine.class, PhaseLine.getSupportedGraphics());
        this.mapClass(ForwardLineOfOwnTroops.class, ForwardLineOfOwnTroops.getSupportedGraphics());
        this.mapClass(LineOfContact.class, LineOfContact.getSupportedGraphics());
        this.mapClass(BasicArea.class, BasicArea.getSupportedGraphics());
        this.mapClass(AirfieldZone.class, AirfieldZone.getSupportedGraphics());
        this.mapClass(FortifiedArea.class, FortifiedArea.getSupportedGraphics());
        this.mapClass(WeaponsFreeZone.class, WeaponsFreeZone.getSupportedGraphics());
        this.mapClass(AviationZone.class, AviationZone.getSupportedGraphics());
        this.mapClass(Route.class, Route.getSupportedGraphics());
        this.mapClass(RoutePoint.class, RoutePoint.getSupportedGraphics());
        this.mapClass(PullUpPoint.class, PullUpPoint.getSupportedGraphics());
        this.mapClass(OffenseArea.class, OffenseArea.getSupportedGraphics());
        this.mapClass(CombatSupportArea.class, CombatSupportArea.getSupportedGraphics());
        this.mapClass(SpecialInterestArea.class, SpecialInterestArea.getSupportedGraphics());
        this.mapClass(Airhead.class, Airhead.getSupportedGraphics());
        this.mapClass(DirectionOfAttack.class, DirectionOfAttack.getSupportedGraphics());
        this.mapClass(DirectionOfAttackAviation.class, DirectionOfAttackAviation.getSupportedGraphics());
        this.mapClass(Aviation.class, Aviation.getSupportedGraphics());
        this.mapClass(Airborne.class, Airborne.getSupportedGraphics());
        this.mapClass(MainAttack.class, MainAttack.getSupportedGraphics());
        this.mapClass(AttackRotaryWing.class, AttackRotaryWing.getSupportedGraphics());
        this.mapClass(SupportingAttack.class, SupportingAttack.getSupportedGraphics());
        this.mapClass(Dummy.class, Dummy.getSupportedGraphics());
        this.mapClass(SupportByFirePosition.class, SupportByFirePosition.getSupportedGraphics());
        this.mapClass(Ambush.class, Ambush.getSupportedGraphics());
        this.mapClass(ForwardEdgeOfBattleArea.class, ForwardEdgeOfBattleArea.getSupportedGraphics());
        this.mapClass(BattlePosition.class, BattlePosition.getSupportedGraphics());
        this.mapClass(PrincipleDirectionOfFire.class, PrincipleDirectionOfFire.getSupportedGraphics());
        this.mapClass(Encirclement.class, Encirclement.getSupportedGraphics());
        this.mapClass(SearchArea.class, SearchArea.getSupportedGraphics());
        this.mapClass(InfiltrationLane.class, InfiltrationLane.getSupportedGraphics());
        this.mapClass(AdvanceForFeint.class, AdvanceForFeint.getSupportedGraphics());
        this.mapClass(DirectionOfAttackForFeint.class, DirectionOfAttackForFeint.getSupportedGraphics());
        this.mapClass(HoldingLine.class, HoldingLine.getSupportedGraphics());
        this.mapClass(LimitedAccessArea.class, LimitedAccessArea.getSupportedGraphics());
        this.mapClass(MinimumSafeDistanceZones.class, MinimumSafeDistanceZones.getSupportedGraphics());
        this.mapClass(FilledArea.class, FilledArea.getSupportedGraphics());
        this.mapClass(DoseRateContourLine.class, DoseRateContourLine.getSupportedGraphics());
        this.mapClass(RectangularTarget.class, RectangularTarget.getSupportedGraphics());
        this.mapClass(LinearTarget.class, LinearTarget.getSupportedGraphics());
        this.mapClass(RectangularFireSupportArea.class, RectangularFireSupportArea.getSupportedGraphics());
        this.mapClass(CircularFireSupportArea.class, CircularFireSupportArea.getSupportedGraphics());
        this.mapClass(IrregularFireSupportArea.class, IrregularFireSupportArea.getSupportedGraphics());
        this.mapClass(Smoke.class, Smoke.getSupportedGraphics());
        this.mapClass(CircularRangeFan.class, CircularRangeFan.getSupportedGraphics());
        this.mapClass(SectorRangeFan.class, SectorRangeFan.getSupportedGraphics());
        this.mapClass(CircularPositionArea.class, CircularPositionArea.getSupportedGraphics());
        this.mapClass(RectangularPositionArea.class, RectangularPositionArea.getSupportedGraphics());
        this.mapClass(GroupOfTargets.class, GroupOfTargets.getSupportedGraphics());
        this.mapClass(AttackByFirePosition.class, AttackByFirePosition.getSupportedGraphics());
        this.mapClass(FireSupportLine.class, FireSupportLine.getSupportedGraphics());
        this.mapClass(MunitionFlightPath.class, MunitionFlightPath.getSupportedGraphics());
    }

    protected void mapClass(Class clazz, List<String> list) {
        for (String string : list) {
            this.classMap.put(string, clazz);
        }
    }

    @Override
    public MilStd2525TacticalGraphic createGraphic(String string, Iterable<? extends Position> iterable, AVList aVList) {
        MilStd2525TacticalGraphic milStd2525TacticalGraphic;
        SymbolCode symbolCode = new SymbolCode(string);
        Class clazz = this.getClassForCode(symbolCode);
        if (clazz == null) {
            return null;
        }
        if (!MilStd2525TacticalGraphic.class.isAssignableFrom(clazz)) {
            String string2 = Logging.getMessage("Symbology.CannotCast", clazz, MilStd2525TacticalGraphic.class);
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            Constructor constructor = clazz.getConstructor(String.class);
            milStd2525TacticalGraphic = (MilStd2525TacticalGraphic)constructor.newInstance(string);
            if (iterable != null) {
                milStd2525TacticalGraphic.setPositions(iterable);
            }
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("Symbology.ExceptionCreatingGraphic", exception.getMessage());
            Logging.logger().severe(string3);
            throw new WWRuntimeException(exception);
        }
        if (aVList != null) {
            this.setModifiers(milStd2525TacticalGraphic, aVList);
        }
        return milStd2525TacticalGraphic;
    }

    @Override
    public TacticalPoint createPoint(String string, Position position, AVList aVList) {
        TacticalGraphic tacticalGraphic = this.createGraphic(string, Arrays.asList(position), aVList);
        if (tacticalGraphic instanceof TacticalPoint) {
            return (TacticalPoint)tacticalGraphic;
        }
        if (tacticalGraphic != null) {
            String string2 = tacticalGraphic.getClass().getName();
            String string3 = Logging.getMessage("Symbology.CannotCast", string2, TacticalPoint.class.getName());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return null;
    }

    @Override
    public TacticalCircle createCircle(String string, Position position, double d, AVList aVList) {
        TacticalPoint tacticalPoint = this.createPoint(string, position, aVList);
        if (tacticalPoint instanceof TacticalCircle) {
            TacticalCircle tacticalCircle = (TacticalCircle)tacticalPoint;
            tacticalCircle.setRadius(d);
            return tacticalCircle;
        }
        if (tacticalPoint != null) {
            String string2 = tacticalPoint.getClass().getName();
            String string3 = Logging.getMessage("Symbology.CannotCast", string2, TacticalCircle.class.getName());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return null;
    }

    @Override
    public TacticalQuad createQuad(String string, Iterable<? extends Position> iterable, AVList aVList) {
        TacticalGraphic tacticalGraphic = this.createGraphic(string, (Iterable)iterable, aVList);
        if (tacticalGraphic instanceof TacticalQuad) {
            return (TacticalQuad)tacticalGraphic;
        }
        if (tacticalGraphic != null) {
            String string2 = tacticalGraphic.getClass().getName();
            String string3 = Logging.getMessage("Symbology.CannotCast", string2, TacticalQuad.class.getName());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return null;
    }

    @Override
    public TacticalRoute createRoute(String string, Iterable<? extends TacticalPoint> iterable, AVList aVList) {
        TacticalGraphic tacticalGraphic = this.createGraphic(string, (Iterable)null, aVList);
        if (tacticalGraphic instanceof TacticalRoute) {
            TacticalRoute tacticalRoute = (TacticalRoute)tacticalGraphic;
            tacticalRoute.setControlPoints(iterable);
            return tacticalRoute;
        }
        if (tacticalGraphic != null) {
            String string2 = tacticalGraphic.getClass().getName();
            String string3 = Logging.getMessage("Symbology.CannotCast", string2, TacticalRoute.class.getName());
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        return null;
    }

    @Override
    public boolean isSupported(String string) {
        SymbolCode symbolCode = new SymbolCode(string);
        String string2 = symbolCode.toMaskedString();
        return this.classMap.containsKey(string2);
    }

    protected void setModifiers(TacticalGraphic tacticalGraphic, AVList aVList) {
        for (Map.Entry<String, Object> entry : aVList.getEntries()) {
            tacticalGraphic.setModifier(entry.getKey(), entry.getValue());
        }
    }

    protected Class getClassForCode(SymbolCode symbolCode) {
        String string = symbolCode.toMaskedString();
        return string != null ? this.classMap.get(string) : null;
    }
}

