/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.symbology.TacticalGraphic;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.util.Logging;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TacticalGraphicUtil {
    public static List<Position> asPositionList(Globe globe, Vec4 ... vec4Array) {
        ArrayList<Position> arrayList = new ArrayList<Position>(vec4Array.length);
        for (Vec4 vec4 : vec4Array) {
            arrayList.add(globe.computePositionFromPoint(vec4));
        }
        return arrayList;
    }

    public static Object[] getDateRange(TacticalGraphic tacticalGraphic) {
        Object object = null;
        Object var2_2 = null;
        Object object2 = tacticalGraphic.getModifier("W");
        if (object2 instanceof Iterable) {
            Iterator iterator = ((Iterable)object2).iterator();
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            if (iterator.hasNext()) {
                var2_2 = iterator.next();
            }
        } else {
            object = object2;
        }
        return new Object[]{object, var2_2};
    }

    public static Object[] getAltitudeRange(TacticalGraphic tacticalGraphic) {
        Object object = null;
        Object var2_2 = null;
        Object object2 = tacticalGraphic.getModifier("X");
        if (object2 instanceof Iterable) {
            Iterator iterator = ((Iterable)object2).iterator();
            if (iterator.hasNext()) {
                object = iterator.next();
            }
            if (iterator.hasNext()) {
                var2_2 = iterator.next();
            }
        } else {
            object = object2;
        }
        return new Object[]{object, var2_2};
    }

    public static void placeLabelsOnPath(DrawContext drawContext, Iterable<? extends Position> iterable, TacticalGraphicLabel tacticalGraphicLabel, TacticalGraphicLabel tacticalGraphicLabel2, double d) {
        double d2;
        Iterator<? extends Position> iterator = iterable.iterator();
        Globe globe = drawContext.getGlobe();
        Position position = null;
        double d3 = 0.0;
        Position position2 = iterator.next();
        Vec4 vec4 = globe.computePointFromPosition(position2);
        for (d2 = 0.0; iterator.hasNext() && d2 < d; d2 += d3) {
            position = position2;
            Vec4 vec42 = vec4;
            position2 = iterator.next();
            vec4 = globe.computePointFromLocation(position2);
            d3 = vec4.distanceTo2(vec42);
        }
        if (position != null && position2 != null && d3 > 0.0) {
            double d4 = d2 - d;
            LatLon latLon = LatLon.interpolateGreatCircle(d4 / d3, position, position2);
            position = new Position(latLon, 0.0);
            tacticalGraphicLabel.setPosition(position);
            tacticalGraphicLabel.setOrientationPosition(position2);
            if (tacticalGraphicLabel2 != null) {
                tacticalGraphicLabel2.setPosition(position);
                tacticalGraphicLabel2.setOrientationPosition(position2);
            }
        }
    }

    public static Vec4 bezierCurve(Vec4[] vec4Array, double d, int[] nArray) {
        if (nArray == null || vec4Array == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length != vec4Array.length) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray[0] != 1) {
            TacticalGraphicUtil.binomial(nArray.length - 1, nArray);
        }
        int n = vec4Array.length - 1;
        Vec4 vec4 = Vec4.ZERO;
        for (int i = 0; i <= n; ++i) {
            double d2 = (double)nArray[i] * Math.pow(d, i) * Math.pow(1.0 - d, n - i);
            vec4 = vec4.add3(vec4Array[i].multiply3(d2));
        }
        return vec4;
    }

    protected static void binomial(int n, int[] nArray) {
        if (nArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (nArray.length != n + 1) {
            String string = Logging.getMessage("generic.ArrayInvalidLength", nArray.length);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i <= n; ++i) {
            nArray[i] = 1;
            for (int j = i - 1; j > 0; --j) {
                int n2 = j;
                nArray[n2] = nArray[n2] + nArray[j - 1];
            }
        }
    }
}

