/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class TacticalGraphicLabel
implements OrderedRenderable {
    public static final Font DEFAULT_FONT = Font.decode("Arial-BOLD-16");
    public static final Offset DEFAULT_OFFSET = new Offset(0.0, -0.5, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    public static final Insets DEFAULT_INSETS = new Insets(5, 5, 5, 5);
    public static final double DEFAULT_INTERIOR_OPACITY = 0.7;
    public static final String DEFAULT_TEXT_EFFECT = "gov.nasa.worldwind.avkey.TextEffectShadow";
    protected String[] lines;
    protected Position position;
    protected Offset offset = DEFAULT_OFFSET;
    protected String textAlign = "gov.nasa.worldwind.avkey.Left";
    protected Position orientationPosition;
    protected Material material = Material.BLACK;
    protected double opacity = 1.0;
    protected double interiorOpacity = 0.7;
    protected Font font = DEFAULT_FONT;
    protected int lineSpacing = 5;
    protected String effect = "gov.nasa.worldwind.avkey.TextEffectShadow";
    protected Insets insets = DEFAULT_INSETS;
    protected boolean drawInterior;
    protected boolean enableBatchRendering = false;
    protected boolean enableBatchPicking = true;
    protected Object delegateOwner;
    protected long frameTimeStamp = -1L;
    protected Vec4 placePoint;
    protected Vec4 screenPlacePoint;
    protected Point screenPoint;
    protected Angle rotation;
    protected int lineHeight;
    protected Rectangle2D bounds;
    protected Rectangle2D[] lineBounds;
    protected Rectangle screenExtent;
    protected double eyeDistance;
    protected OGLStackHandler BEogsh = new OGLStackHandler();
    protected PickSupport pickSupport = new PickSupport();
    protected Layer pickLayer;

    public TacticalGraphicLabel() {
    }

    public TacticalGraphicLabel(String string) {
        this.setText(string);
    }

    public String getText() {
        if (this.lines != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.lines.length - 1; ++i) {
                stringBuilder.append(this.lines[i]).append("\n");
            }
            stringBuilder.append(this.lines[this.lines.length - 1]);
            return stringBuilder.toString();
        }
        return null;
    }

    public void setText(String string) {
        this.lines = string != null ? string.split("\n") : null;
        this.bounds = null;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
        this.screenExtent = null;
    }

    public String getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.textAlign = string;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        if (offset == null) {
            String string = Logging.getMessage("nullValue.OffsetIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.offset = offset;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (font != this.font) {
            this.font = font;
            this.bounds = null;
        }
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lineSpacing = n;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.material = material;
    }

    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.opacity = d;
    }

    public double getInteriorOpacity() {
        return this.interiorOpacity;
    }

    public void setInteriorOpacity(double d) {
        if (this.opacity < 0.0 || this.opacity > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", this.opacity);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorOpacity = d;
    }

    public Position getOrientationPosition() {
        return this.orientationPosition;
    }

    public void setOrientationPosition(Position position) {
        this.orientationPosition = position;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        if (insets == null) {
            String string = Logging.getMessage("nullValue.InsetsIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.insets = insets;
    }

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.effect = string;
    }

    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    public boolean isEnableBatchRendering() {
        return this.enableBatchRendering;
    }

    public void setEnableBatchRendering(boolean bl) {
        this.enableBatchRendering = bl;
    }

    public Rectangle getBounds(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.computeGeometryIfNeeded(drawContext);
        return this.screenExtent;
    }

    protected void computeGeometryIfNeeded(DrawContext drawContext) {
        long l = drawContext.getFrameTimeStamp();
        if (l != this.frameTimeStamp || this.screenExtent == null) {
            this.computeGeometry(drawContext);
            this.frameTimeStamp = l;
        }
    }

    protected void computeBoundsIfNeeded(DrawContext drawContext) {
        if (this.bounds != null) {
            return;
        }
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), this.getFont());
        int n = 0;
        int n2 = 0;
        this.lineBounds = new Rectangle2D[this.lines.length];
        for (int i = 0; i < this.lines.length; ++i) {
            Rectangle2D rectangle2D = textRenderer.getBounds(this.lines[i]);
            n = (int)Math.max(rectangle2D.getWidth(), (double)n);
            double d = Math.abs(rectangle2D.getY());
            n2 = (int)Math.max(d, (double)n2);
            this.lineBounds[i] = rectangle2D;
        }
        this.lineHeight = n2;
        this.bounds = new Rectangle(this.lines.length, n2, n, this.lines.length * n2 + this.lines.length * this.lineSpacing);
    }

    protected void computeGeometry(DrawContext drawContext) {
        Object object;
        Object object2;
        Position position = this.getPosition();
        if (position == null) {
            return;
        }
        this.placePoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        this.screenPlacePoint = drawContext.getView().project(this.placePoint);
        this.eyeDistance = this.placePoint.distanceTo3(drawContext.getView().getEyePoint());
        boolean bl = false;
        if (this.orientationPosition != null) {
            object2 = drawContext.computeTerrainPoint(this.orientationPosition.getLatitude(), this.orientationPosition.getLongitude(), 0.0);
            object = drawContext.getView().project((Vec4)object2);
            this.rotation = this.computeRotation(this.screenPlacePoint, (Vec4)object);
            bl = ((Vec4)object).x <= this.screenPlacePoint.x;
        }
        this.computeBoundsIfNeeded(drawContext);
        object2 = this.getOffset();
        object = ((Offset)object2).computeOffset(this.bounds.getWidth(), this.bounds.getHeight(), null, null);
        if (this.rotation != null) {
            double d = ((Point2D)object).getY();
            if (bl) {
                d = -(d + this.bounds.getHeight());
            }
            Vec4 vec4 = new Vec4(((Point2D)object).getX(), d);
            Matrix matrix = Matrix.fromRotationZ(this.rotation.multiply(-1.0));
            vec4 = vec4.transformBy3(matrix);
            object = new Point((int)vec4.getX(), (int)vec4.getY());
        }
        int n = (int)(this.screenPlacePoint.x + ((Point2D)object).getX());
        int n2 = (int)(this.screenPlacePoint.y - ((Point2D)object).getY());
        this.screenPoint = new Point(n, n2);
        this.screenExtent = this.computeTextExtent(n, n2, this.rotation);
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        View view = drawContext.getView();
        Frustum frustum = view.getFrustumInModelCoordinates();
        if (this.placePoint != null && (frustum.getNear().distanceTo(this.placePoint) < 0.0 || frustum.getFar().distanceTo(this.placePoint) < 0.0)) {
            return false;
        }
        if (drawContext.isPickingMode()) {
            return drawContext.getPickFrustums().intersectsAny(this.screenExtent);
        }
        return view.getViewport().intersects(this.screenExtent);
    }

    protected Angle computeRotation(Vec4 vec4, Vec4 vec42) {
        double d = vec4.x - vec42.x;
        double d2 = vec4.y - vec42.y;
        if (d != 0.0) {
            double d3 = Math.atan(d2 / d);
            return Angle.fromRadians(d3);
        }
        return Angle.POS90;
    }

    @Override
    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (this.lines == null || this.position == null) {
            return;
        }
        this.computeGeometryIfNeeded(drawContext);
        double d = drawContext.getView().getHorizonDistance();
        if (this.eyeDistance > d) {
            return;
        }
        if (this.intersectsFrustum(drawContext)) {
            drawContext.addOrderedRenderable(this);
        }
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginDrawing(drawContext);
        try {
            this.doDrawOrderedRenderable(drawContext, this.pickSupport);
            if (this.isEnableBatchRendering()) {
                this.drawBatched(drawContext);
            }
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), this.font);
        if (drawContext.isPickingMode()) {
            this.doPick(drawContext, pickSupport);
        } else {
            this.drawText(drawContext, textRenderer);
        }
    }

    protected void beginDrawing(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = 30977;
        this.BEogsh.pushAttrib(gL, n);
        if (!drawContext.isPickingMode()) {
            gL.glEnable(3042);
            OGLUtil.applyBlending(gL, false);
        }
        gL.glDisable(2929);
        gL.glDepthMask(false);
        this.BEogsh.pushProjectionIdentity(gL);
        gL.glOrtho(0.0, (double)drawContext.getView().getViewport().width, 0.0, (double)drawContext.getView().getViewport().height, -1.0, 1.0);
        this.BEogsh.pushModelviewIdentity(gL);
    }

    protected void endDrawing(DrawContext drawContext) {
        this.BEogsh.pop(drawContext.getGL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPick(DrawContext drawContext, PickSupport pickSupport) {
        GL gL = drawContext.getGL();
        Angle angle = this.rotation;
        double d = angle != null ? angle.degrees : 0.0;
        int n = this.screenPoint.x;
        int n2 = this.screenPoint.y;
        boolean bl = false;
        try {
            if (d != 0.0) {
                gL.glPushMatrix();
                bl = true;
                gL.glTranslated((double)n, (double)n2, 0.0);
                gL.glRotated(d, 0.0, 0.0, 1.0);
                gL.glTranslated((double)(-n), (double)(-n2), 0.0);
            }
            for (int i = 0; i < this.lines.length; ++i) {
                Rectangle2D rectangle2D = this.lineBounds[i];
                double d2 = rectangle2D.getWidth();
                double d3 = rectangle2D.getHeight();
                n = this.screenPoint.x;
                if (this.textAlign.equals("gov.nasa.worldwind.avkey.Center")) {
                    n -= (int)(d2 / 2.0);
                } else if (this.textAlign.equals("gov.nasa.worldwind.avkey.Right")) {
                    n -= (int)d2;
                }
                n2 -= this.lineHeight;
                Color color = drawContext.getUniquePickColor();
                int n3 = color.getRGB();
                PickedObject pickedObject = new PickedObject(n3, this.getPickedObject(), this.position, false);
                pickSupport.addPickableObject(pickedObject);
                gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                try {
                    gL.glBegin(9);
                    gL.glVertex3d((double)n, (double)n2, 0.0);
                    gL.glVertex3d((double)n + d2 - 1.0, (double)n2, 0.0);
                    gL.glVertex3d((double)n + d2 - 1.0, (double)n2 + d3 - 1.0, 0.0);
                    gL.glVertex3d((double)n, (double)n2 + d3 - 1.0, 0.0);
                    gL.glVertex3d((double)n, (double)n2, 0.0);
                }
                finally {
                    gL.glEnd();
                }
                n2 -= this.lineSpacing;
            }
        }
        finally {
            if (bl) {
                gL.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawText(DrawContext drawContext, TextRenderer textRenderer) {
        GL gL = drawContext.getGL();
        Angle angle = this.rotation;
        double d = angle != null ? angle.degrees : 0.0;
        boolean bl = false;
        try {
            int n = this.screenPoint.x;
            int n2 = this.screenPoint.y;
            if (d != 0.0) {
                gL.glPushMatrix();
                bl = true;
                gL.glTranslated((double)n, (double)n2, 0.0);
                gL.glRotated(d, 0.0, 0.0, 1.0);
                gL.glTranslated((double)(-n), (double)(-n2), 0.0);
            }
            if (this.isDrawInterior()) {
                this.drawInterior(drawContext);
            }
            textRenderer.begin3DRendering();
            try {
                this.doDrawText(textRenderer);
                if (this.isEnableBatchRendering()) {
                    this.drawBatchedText(drawContext, textRenderer);
                }
            }
            finally {
                textRenderer.end3DRendering();
            }
        }
        finally {
            if (bl) {
                gL.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawInterior(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        double d = this.bounds.getWidth();
        double d2 = this.bounds.getHeight();
        int n = this.screenPoint.x;
        int n2 = this.screenPoint.y;
        int n3 = n;
        if ("gov.nasa.worldwind.avkey.Center".equals(this.textAlign)) {
            n3 = n - (int)(d / 2.0);
        } else if ("gov.nasa.worldwind.avkey.Right".equals(this.textAlign)) {
            n3 = n - (int)d;
        }
        int n4 = (int)((double)n2 - d2);
        Insets insets = this.getInsets();
        n3 -= insets.left;
        d = d + (double)insets.left + (double)insets.right;
        n4 -= insets.bottom;
        d2 = d2 + (double)insets.bottom + (double)insets.top;
        if (!drawContext.isPickingMode()) {
            Color color = this.computeBackgroundColor(this.getMaterial().getDiffuse());
            gL.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)(this.interiorOpacity < 1.0 ? (int)(this.interiorOpacity * 255.0 + 0.5) : 255));
        }
        try {
            gL.glPushMatrix();
            gL.glTranslated((double)n3, (double)n4, 0.0);
            gL.glScaled(d, d2, 1.0);
            drawContext.drawUnitQuad();
        }
        finally {
            gL.glPopMatrix();
        }
    }

    protected void doDrawText(TextRenderer textRenderer) {
        Color color = this.material.getDiffuse();
        Color color2 = this.computeBackgroundColor(color);
        float f = (float)this.getOpacity();
        int n = this.screenPoint.x;
        int n2 = this.screenPoint.y;
        float[] fArray = new float[3];
        if (DEFAULT_TEXT_EFFECT.equals(this.effect) && color2 != null) {
            color2.getRGBColorComponents(fArray);
            textRenderer.setColor(fArray[0], fArray[1], fArray[2], f);
            this.drawMultiLineText(textRenderer, n + 1, n2 - 1);
        }
        color.getRGBColorComponents(fArray);
        textRenderer.setColor(fArray[0], fArray[1], fArray[2], f);
        this.drawMultiLineText(textRenderer, n, n2);
    }

    protected void drawMultiLineText(TextRenderer textRenderer, int n, int n2) {
        if (this.lines == null) {
            String string = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < this.lines.length; ++i) {
            String string = this.lines[i];
            Rectangle2D rectangle2D = this.lineBounds[i];
            int n3 = n;
            if (this.textAlign.equals("gov.nasa.worldwind.avkey.Center")) {
                n3 = n - (int)(rectangle2D.getWidth() / 2.0);
            } else if (this.textAlign.equals("gov.nasa.worldwind.avkey.Right")) {
                n3 = n - (int)rectangle2D.getWidth();
            }
            textRenderer.draw3D(string, (float)n3, (float)(n2 -= this.lineHeight), 0.0f, 1.0f);
            n2 -= this.lineSpacing;
        }
    }

    protected void drawBatched(DrawContext drawContext) {
        block3: {
            TacticalGraphicLabel tacticalGraphicLabel;
            OrderedRenderable orderedRenderable;
            block2: {
                TacticalGraphicLabel tacticalGraphicLabel2;
                orderedRenderable = drawContext.peekOrderedRenderables();
                if (drawContext.isPickingMode()) break block2;
                while (orderedRenderable != null && orderedRenderable instanceof TacticalGraphicLabel && (tacticalGraphicLabel2 = (TacticalGraphicLabel)orderedRenderable).isEnableBatchRendering()) {
                    drawContext.pollOrderedRenderables();
                    tacticalGraphicLabel2.doDrawOrderedRenderable(drawContext, this.pickSupport);
                    orderedRenderable = drawContext.peekOrderedRenderables();
                }
                break block3;
            }
            if (!this.isEnableBatchPicking()) break block3;
            while (orderedRenderable != null && orderedRenderable instanceof TacticalGraphicLabel && (tacticalGraphicLabel = (TacticalGraphicLabel)orderedRenderable).isEnableBatchRendering() && tacticalGraphicLabel.isEnableBatchPicking() && tacticalGraphicLabel.pickLayer == this.pickLayer) {
                drawContext.pollOrderedRenderables();
                tacticalGraphicLabel.doDrawOrderedRenderable(drawContext, this.pickSupport);
                orderedRenderable = drawContext.peekOrderedRenderables();
            }
        }
    }

    protected void drawBatchedText(DrawContext drawContext, TextRenderer textRenderer) {
        OrderedRenderable orderedRenderable = drawContext.peekOrderedRenderables();
        if (!drawContext.isPickingMode()) {
            TacticalGraphicLabel tacticalGraphicLabel;
            while (orderedRenderable != null && orderedRenderable instanceof TacticalGraphicLabel && (tacticalGraphicLabel = (TacticalGraphicLabel)orderedRenderable).isEnableBatchRendering()) {
                boolean bl = this.font.equals(tacticalGraphicLabel.getFont());
                boolean bl2 = this.rotation == null && tacticalGraphicLabel.rotation == null || this.rotation != null && this.rotation.equals(tacticalGraphicLabel.rotation);
                boolean bl3 = tacticalGraphicLabel.isDrawInterior();
                if (!bl || !bl2 || bl3) break;
                drawContext.pollOrderedRenderables();
                tacticalGraphicLabel.doDrawText(textRenderer);
                orderedRenderable = drawContext.peekOrderedRenderables();
            }
        }
    }

    protected Object getPickedObject() {
        Object object = this.getDelegateOwner();
        return object != null ? object : this;
    }

    protected Rectangle computeTextExtent(int n, int n2, Angle angle) {
        double d = this.bounds.getWidth();
        double d2 = this.bounds.getHeight();
        String string = this.getTextAlign();
        int n3 = n;
        if ("gov.nasa.worldwind.avkey.Center".equals(string)) {
            n3 = n - (int)(d / 2.0);
        } else if ("gov.nasa.worldwind.avkey.Right".equals(string)) {
            n3 = n - (int)d;
        }
        int n4 = (int)((double)n2 - d2);
        Rectangle rectangle = new Rectangle(n3, n4, (int)d, (int)d2);
        if (angle != null && angle.degrees != 0.0) {
            rectangle = this.computeRotatedScreenExtent(rectangle, n, n2, angle);
        }
        return rectangle;
    }

    protected Rectangle computeRotatedScreenExtent(Rectangle rectangle, int n, int n2, Angle angle) {
        int n3;
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.translate(-n, -n2);
        Vec4[] vec4Array = new Vec4[]{new Vec4(rectangle2.getMaxX(), rectangle2.getMaxY()), new Vec4(rectangle2.getMaxX(), rectangle2.getMinY()), new Vec4(rectangle2.getMinX(), rectangle2.getMaxY()), new Vec4(rectangle2.getMinX(), rectangle2.getMinY())};
        Matrix matrix = Matrix.fromRotationZ(angle);
        for (n3 = 0; n3 < vec4Array.length; ++n3) {
            vec4Array[n3] = vec4Array[n3].transformBy3(matrix);
        }
        n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = -2147483647;
        int n6 = -2147483647;
        for (Vec4 vec4 : vec4Array) {
            if (vec4.x > (double)n5) {
                n5 = (int)vec4.x;
            }
            if (vec4.x < (double)n3) {
                n3 = (int)vec4.x;
            }
            if (vec4.y > (double)n6) {
                n6 = (int)vec4.y;
            }
            if (!(vec4.y < (double)n4)) continue;
            n4 = (int)vec4.y;
        }
        rectangle2.setBounds(n3, n4, n5 - n3, n6 - n4);
        rectangle2.translate(n, n2);
        return rectangle2;
    }

    protected Color computeBackgroundColor(Color color) {
        float[] fArray = new float[4];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        if ((double)fArray[2] > 0.5) {
            return new Color(0.0f, 0.0f, 0.0f, 0.7f);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.7f);
    }
}

