/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces;

import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.airspaces.AbstractAirspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.DetailLevel;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.render.airspaces.ScreenSizeDetailLevel;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL;

public class Orbit
extends AbstractAirspace {
    protected static final int DEFAULT_ARC_SLICES = 16;
    protected static final int DEFAULT_LENGTH_SLICES = 32;
    protected static final int DEFAULT_STACKS = 1;
    protected static final int DEFAULT_LOOPS = 4;
    protected static final int MINIMAL_GEOMETRY_ARC_SLICES = 4;
    protected static final int MINIMAL_GEOMETRY_LENGTH_SLICES = 8;
    protected static final int MINIMAL_GEOMETRY_LOOPS = 2;
    private LatLon location1 = LatLon.ZERO;
    private LatLon location2 = LatLon.ZERO;
    private String orbitType = "Center";
    private double width = 1.0;
    private boolean enableCaps = true;
    private int arcSlices = 16;
    private int lengthSlices = 32;
    private int stacks = 1;
    private int loops = 4;

    public Orbit(LatLon latLon, LatLon latLon2, String string, double d) {
        if (latLon == null) {
            String string2 = "nullValue.Location1IsNull";
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (latLon2 == null) {
            String string3 = "nullValue.Location2IsNull";
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string == null) {
            String string4 = "nullValue.OrbitTypeIsNull";
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (d < 0.0) {
            String string5 = Logging.getMessage("generic.ArgumentOutOfRange", "width=" + d);
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        this.location1 = latLon;
        this.location2 = latLon2;
        this.orbitType = string;
        this.width = d;
        this.makeDefaultDetailLevels();
    }

    public Orbit(AirspaceAttributes airspaceAttributes) {
        super(airspaceAttributes);
        this.makeDefaultDetailLevels();
    }

    public Orbit() {
        this.makeDefaultDetailLevels();
    }

    private void makeDefaultDetailLevels() {
        ArrayList<DetailLevel> arrayList = new ArrayList<DetailLevel>();
        double[] dArray = ScreenSizeDetailLevel.computeDefaultScreenSizeRamp(5);
        ScreenSizeDetailLevel screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[0], "Detail-Level-0");
        screenSizeDetailLevel.setValue("ArcSlices", 16);
        screenSizeDetailLevel.setValue("LengthSlices", 32);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 4);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[1], "Detail-Level-1");
        screenSizeDetailLevel.setValue("ArcSlices", 13);
        screenSizeDetailLevel.setValue("LengthSlices", 25);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 3);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[2], "Detail-Level-2");
        screenSizeDetailLevel.setValue("ArcSlices", 10);
        screenSizeDetailLevel.setValue("LengthSlices", 18);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 2);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[3], "Detail-Level-3");
        screenSizeDetailLevel.setValue("ArcSlices", 7);
        screenSizeDetailLevel.setValue("LengthSlices", 11);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", false);
        arrayList.add(screenSizeDetailLevel);
        screenSizeDetailLevel = new ScreenSizeDetailLevel(dArray[4], "Detail-Level-4");
        screenSizeDetailLevel.setValue("ArcSlices", 4);
        screenSizeDetailLevel.setValue("LengthSlices", 4);
        screenSizeDetailLevel.setValue("Stacks", 1);
        screenSizeDetailLevel.setValue("Loops", 1);
        screenSizeDetailLevel.setValue("DisableTerrainConformance", true);
        arrayList.add(screenSizeDetailLevel);
        this.setDetailLevels(arrayList);
    }

    public LatLon[] getLocations() {
        LatLon[] latLonArray = new LatLon[]{this.location1, this.location2};
        return latLonArray;
    }

    public void setLocations(LatLon latLon, LatLon latLon2) {
        if (latLon == null) {
            String string = "nullValue.Location1IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (latLon2 == null) {
            String string = "nullValue.Location2IsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.location1 = latLon;
        this.location2 = latLon2;
        this.setExtentOutOfDate();
    }

    public String getOrbitType() {
        return this.orbitType;
    }

    public void setOrbitType(String string) {
        if (string == null) {
            String string2 = "nullValue.OrbitTypeIsNull";
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.orbitType = string;
        this.setExtentOutOfDate();
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "width=" + d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.width = d;
        this.setExtentOutOfDate();
    }

    public boolean isEnableCaps() {
        return this.enableCaps;
    }

    public void setEnableCaps(boolean bl) {
        this.enableCaps = bl;
    }

    @Override
    public Position getReferencePosition() {
        double[] dArray = this.getAltitudes();
        return new Position(this.location1, dArray[0]);
    }

    @Override
    protected Extent computeExtent(Globe globe, double d) {
        List<Vec4> list = this.computeMinimalGeometry(globe, d);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return Box.computeBoundingBox(list);
    }

    @Override
    protected List<Vec4> computeMinimalGeometry(Globe globe, double d) {
        Matrix matrix = this.computeTransform(globe, d);
        Vec4 vec4 = globe.computePointFromPosition(this.location1.getLatitude(), this.location1.getLongitude(), 0.0);
        Vec4 vec42 = globe.computePointFromPosition(this.location2.getLatitude(), this.location2.getLongitude(), 0.0);
        double d2 = this.width / 2.0;
        double d3 = vec4.distanceTo3(vec42);
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        int n = geometryBuilder.getLongDiskIndexCount(4, 8, 2);
        int n2 = 3 * n;
        float[] fArray = new float[n2];
        geometryBuilder.makeLongDiskVertices(0.0f, (float)d2, (float)d3, 4, 8, 2, fArray);
        ArrayList<Position> arrayList = new ArrayList<Position>();
        for (int i = 0; i < n2; i += 3) {
            Vec4 vec43 = new Vec4(fArray[i], fArray[i + 1], fArray[i + 2]);
            vec43 = vec43.transformBy4(matrix);
            arrayList.add(globe.computePositionFromPoint(vec43));
        }
        ArrayList<Vec4> arrayList2 = new ArrayList<Vec4>();
        this.makeExtremePoints(globe, d, arrayList, arrayList2);
        return arrayList2;
    }

    @Override
    protected void doMoveTo(Position position, Position position2) {
        if (position == null) {
            String string = "nullValue.OldRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (position2 == null) {
            String string = "nullValue.NewRefIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        super.doMoveTo(position, position2);
        LatLon[] latLonArray = this.getLocations();
        int n = latLonArray.length;
        for (int i = 0; i < n; ++i) {
            double d = LatLon.greatCircleDistance((LatLon)position, (LatLon)latLonArray[i]).radians;
            double d2 = LatLon.greatCircleAzimuth((LatLon)position, (LatLon)latLonArray[i]).radians;
            latLonArray[i] = LatLon.greatCircleEndPosition((LatLon)position2, d2, d);
        }
        this.setLocations(latLonArray[0], latLonArray[1]);
    }

    protected int getArcSlices() {
        return this.arcSlices;
    }

    protected void setArcSlices(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "arcSlices=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.arcSlices = n;
    }

    protected int getLengthSlices() {
        return this.lengthSlices;
    }

    protected void setLengthSlices(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "lengthSlices=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lengthSlices = n;
    }

    protected int getStacks() {
        return this.stacks;
    }

    protected int getLoops() {
        return this.loops;
    }

    protected void setLoops(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "loops=" + n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.loops = n;
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (drawContext.getGlobe() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Globe globe = drawContext.getGlobe();
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        Vec4 vec4 = globe.computePointFromPosition(this.location1.getLatitude(), this.location1.getLongitude(), dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(this.location2.getLatitude(), this.location2.getLongitude(), dArray[0]);
        Vec4 vec43 = Vec4.mix3(0.5, vec4, vec42);
        Position position = globe.computePositionFromPoint(vec43);
        return globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), dArray[0]);
    }

    protected Matrix computeTransform(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getAltitudes(d);
        double d2 = this.width / 2.0;
        Vec4 vec4 = globe.computePointFromPosition(this.location1.getLatitude(), this.location1.getLongitude(), dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(this.location2.getLatitude(), this.location2.getLongitude(), dArray[0]);
        Vec4 vec43 = Vec4.mix3(0.5, vec4, vec42);
        Vec4 vec44 = globe.computeSurfaceNormalAtPoint(vec43);
        Vec4 vec45 = vec42.subtract3(vec4);
        vec45 = vec45.normalize3();
        Matrix matrix = Matrix.fromModelLookAt(vec4, vec4.add3(vec44), vec45);
        if ("Left".equals(this.orbitType)) {
            matrix = matrix.multiply(Matrix.fromTranslation(-d2, 0.0, 0.0));
        } else if ("Right".equals(this.orbitType)) {
            matrix = matrix.multiply(Matrix.fromTranslation(d2, 0.0, 0.0));
        }
        return matrix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string) {
        Object object;
        Object object2;
        if (drawContext == null) {
            String string2 = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (drawContext.getGL() == null) {
            String string3 = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (drawContext.getGlobe() == null) {
            String string4 = Logging.getMessage("nullValue.DrawingContextGlobeIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        double[] dArray = this.getAltitudes(drawContext.getVerticalExaggeration());
        boolean[] blArray = this.isTerrainConforming();
        double[] dArray2 = new double[]{0.0, this.width / 2.0};
        String string5 = this.orbitType;
        int n = this.arcSlices;
        int n2 = this.lengthSlices;
        int n3 = this.stacks;
        int n4 = this.loops;
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = globe.computePointFromPosition(this.location1.getLatitude(), this.location1.getLongitude(), dArray[0]);
        Vec4 vec42 = globe.computePointFromPosition(this.location2.getLatitude(), this.location2.getLongitude(), dArray[0]);
        double d = vec4.distanceTo3(vec42);
        if (this.isEnableLevelOfDetail()) {
            object2 = this.computeDetailLevel(drawContext);
            object = object2.getValue("ArcSlices");
            if (object != null && object instanceof Integer) {
                n = (Integer)object;
            }
            if ((object = object2.getValue("LengthSlices")) != null && object instanceof Integer) {
                n2 = (Integer)object;
            }
            if ((object = object2.getValue("Stacks")) != null && object instanceof Integer) {
                n3 = (Integer)object;
            }
            if ((object = object2.getValue("Loops")) != null && object instanceof Integer) {
                n4 = (Integer)object;
            }
            if ((object = object2.getValue("DisableTerrainConformance")) != null && object instanceof Boolean && ((Boolean)object).booleanValue()) {
                blArray[1] = false;
                blArray[0] = false;
            }
        }
        object2 = this.computeReferenceCenter(drawContext);
        this.setExpiryTime(this.nextExpiryTime(drawContext, blArray));
        this.clearElevationMap();
        object = drawContext.getGL();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            drawContext.getView().pushReferenceCenter(drawContext, (Vec4)object2);
            if ("Airspace.DrawStyleOutline".equals(string)) {
                this.drawLongCylinderOutline(drawContext, dArray2[1], d, dArray, blArray, string5, n, n2, n3, 0, (Vec4)object2);
            } else if ("Airspace.DrawStyleFill".equals(string)) {
                if (this.enableCaps) {
                    oGLStackHandler.pushAttrib((GL)object, 8);
                    object.glEnable(2884);
                    object.glFrontFace(2305);
                }
                if (this.enableCaps && dArray2[0] != dArray2[1]) {
                    this.drawLongDisk(drawContext, dArray2, d, dArray[1], blArray[1], string5, n, n2, n4, 0, (Vec4)object2);
                    if (!this.isAirspaceCollapsed()) {
                        this.drawLongDisk(drawContext, dArray2, d, dArray[0], blArray[0], string5, n, n2, n4, 1, (Vec4)object2);
                    }
                }
                if (!this.isAirspaceCollapsed()) {
                    this.drawLongCylinder(drawContext, dArray2[1], d, dArray, blArray, string5, n, n2, n3, 0, (Vec4)object2);
                }
            }
        }
        finally {
            drawContext.getView().popReferenceCenter(drawContext);
            oGLStackHandler.pop((GL)object);
        }
    }

    private void drawLongCylinder(DrawContext drawContext, double d, double d2, double[] dArray, boolean[] blArray, String string, int n, int n2, int n3, int n4, Vec4 vec4) {
        Geometry geometry = this.createLongCylinderVertexGeometry(drawContext, d, d2, dArray, blArray, string, n, n2, n3, n4, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "LongCylinder.Indices", n, n2, n3, n4);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeLongCylinderIndices(n, n2, n3, n4, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void drawLongCylinderOutline(DrawContext drawContext, double d, double d2, double[] dArray, boolean[] blArray, String string, int n, int n2, int n3, int n4, Vec4 vec4) {
        Geometry geometry = this.createLongCylinderVertexGeometry(drawContext, d, d2, dArray, blArray, string, n, n2, n3, n4, vec4);
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(this.getClass(), "LongCylinder.OutlineIndices", n, n2, n3, n4);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeLongCylinderOutlineIndices(n, n2, n3, n4, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private Geometry createLongCylinderVertexGeometry(DrawContext drawContext, double d, double d2, double[] dArray, boolean[] blArray, String string, int n, int n2, int n3, int n4, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "LongCylinder.Vertices", d, d2, dArray[0], dArray[1], blArray[0], blArray[1], string, n, n2, n3, n4, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeLongCylinder(drawContext, d, d2, dArray, blArray, n, n2, n3, n4, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        return geometry;
    }

    private void makeLongCylinder(DrawContext drawContext, double d, double d2, double[] dArray, boolean[] blArray, int n, int n2, int n3, int n4, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n4);
        float f = (float)(dArray[1] - dArray[0]);
        int n5 = geometryBuilder.getLongCylinderVertexCount(n, n2, n3);
        int n6 = 3 * n5;
        float[] fArray = new float[n6];
        float[] fArray2 = new float[n6];
        geometryBuilder.makeLongCylinderVertices((float)d, (float)d2, f, n, n2, n3, fArray);
        this.makeLongCylinderTerrainConformant(drawContext, n, n2, n3, fArray, dArray, blArray, vec4);
        geometryBuilder.makeLongCylinderNormals(n, n2, n3, fArray2);
        geometry.setVertexData(n5, fArray);
        geometry.setNormalData(n5, fArray2);
    }

    private void makeLongCylinderTerrainConformant(DrawContext drawContext, int n, int n2, int n3, float[] fArray, double[] dArray, boolean[] blArray, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        int n4 = 2 * (n + 1) + 2 * (n2 - 1);
        for (int i = 0; i < n4; ++i) {
            int n5 = i;
            n5 = 3 * n5;
            Vec4 vec42 = new Vec4(fArray[n5], fArray[n5 + 1], fArray[n5 + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            for (int j = 0; j <= n3; ++j) {
                double d = dArray[j];
                if (blArray[j]) {
                    d += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
                }
                vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
                n5 = i + j * n4;
                n5 = 3 * n5;
                fArray[n5] = (float)(vec42.x - vec4.x);
                fArray[n5 + 1] = (float)(vec42.y - vec4.y);
                fArray[n5 + 2] = (float)(vec42.z - vec4.z);
            }
        }
    }

    private void makeLongCylinderIndices(int n, int n2, int n3, int n4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n4);
        int n5 = geometryBuilder.getLongCylinderDrawMode();
        int n6 = geometryBuilder.getLongCylinderIndexCount(n, n2, n3);
        int[] nArray = new int[n6];
        geometryBuilder.makeLongCylinderIndices(n, n2, n3, nArray);
        geometry.setElementData(n5, n6, nArray);
    }

    private void makeLongCylinderOutlineIndices(int n, int n2, int n3, int n4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n4);
        int n5 = geometryBuilder.getLongCylinderOutlineDrawMode();
        int n6 = geometryBuilder.getLongCylinderOutlineIndexCount(n, n2, n3);
        int[] nArray = new int[n6];
        geometryBuilder.makeLongCylinderOutlineIndices(n, n2, n3, nArray);
        geometry.setElementData(n5, n6, nArray);
    }

    private void drawLongDisk(DrawContext drawContext, double[] dArray, double d, double d2, boolean bl, String string, int n, int n2, int n3, int n4, Vec4 vec4) {
        Geometry.CacheKey cacheKey = new Geometry.CacheKey(drawContext.getGlobe(), this.getClass(), "LongDisk.Vertices", dArray[0], dArray[1], d, d2, bl, string, n, n2, n3, n4, vec4);
        Geometry geometry = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry == null || this.isExpired(drawContext, geometry)) {
            if (geometry == null) {
                geometry = new Geometry();
            }
            this.makeLongDisk(drawContext, dArray, d, d2, bl, n, n2, n3, n4, vec4, geometry);
            this.updateExpiryCriteria(drawContext, geometry);
            this.getGeometryCache().add(cacheKey, geometry);
        }
        cacheKey = new Geometry.CacheKey(this.getClass(), "LongDisk.Indices", n, n2, n3, n4);
        Geometry geometry2 = (Geometry)this.getGeometryCache().getObject(cacheKey);
        if (geometry2 == null) {
            geometry2 = new Geometry();
            this.makeLongDiskIndices(n, n2, n3, n4, geometry2);
            this.getGeometryCache().add(cacheKey, geometry2);
        }
        this.getRenderer().drawGeometry(drawContext, geometry2, geometry);
    }

    private void makeLongDisk(DrawContext drawContext, double[] dArray, double d, double d2, boolean bl, int n, int n2, int n3, int n4, Vec4 vec4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n4);
        int n5 = geometryBuilder.getLongDiskVertexCount(n, n2, n3);
        int n6 = 3 * n5;
        float[] fArray = new float[n6];
        float[] fArray2 = new float[n6];
        geometryBuilder.makeLongDiskVertices((float)dArray[0], (float)dArray[1], (float)d, n, n2, n3, fArray);
        this.makeLongDiskTerrainConformant(drawContext, n6, fArray, d2, bl, vec4);
        geometryBuilder.makeLongDiskVertexNormals((float)dArray[0], (float)dArray[1], (float)d, n, n2, n3, fArray, fArray2);
        geometry.setVertexData(n5, fArray);
        geometry.setNormalData(n5, fArray2);
    }

    private void makeLongDiskTerrainConformant(DrawContext drawContext, int n, float[] fArray, double d, boolean bl, Vec4 vec4) {
        Globe globe = drawContext.getGlobe();
        Matrix matrix = this.computeTransform(drawContext.getGlobe(), drawContext.getVerticalExaggeration());
        for (int i = 0; i < n; i += 3) {
            Vec4 vec42 = new Vec4(fArray[i], fArray[i + 1], fArray[i + 2]);
            vec42 = vec42.transformBy4(matrix);
            Position position = globe.computePositionFromPoint(vec42);
            double d2 = d;
            if (bl) {
                d2 += this.computeElevationAt(drawContext, position.getLatitude(), position.getLongitude());
            }
            vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d2);
            fArray[i] = (float)(vec42.x - vec4.x);
            fArray[i + 1] = (float)(vec42.y - vec4.y);
            fArray[i + 2] = (float)(vec42.z - vec4.z);
        }
    }

    private void makeLongDiskIndices(int n, int n2, int n3, int n4, Geometry geometry) {
        GeometryBuilder geometryBuilder = this.getGeometryBuilder();
        geometryBuilder.setOrientation(n4);
        int n5 = geometryBuilder.getLongDiskDrawMode();
        int n6 = geometryBuilder.getLongDiskIndexCount(n, n2, n3);
        int[] nArray = new int[n6];
        geometryBuilder.makeLongDiskIndices(n, n2, n3, nArray);
        geometry.setElementData(n5, n6, nArray);
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsLatLon(stateObject, "location1", this.location1);
        restorableSupport.addStateValueAsLatLon(stateObject, "location2", this.location2);
        restorableSupport.addStateValueAsString(stateObject, "orbitType", this.orbitType);
        restorableSupport.addStateValueAsDouble(stateObject, "width", this.width);
        restorableSupport.addStateValueAsBoolean(stateObject, "enableCaps", this.enableCaps);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        Boolean bl;
        Double d;
        LatLon latLon;
        super.doRestoreState(restorableSupport, stateObject);
        LatLon latLon2 = restorableSupport.getStateValueAsLatLon(stateObject, "location1");
        if (latLon2 == null) {
            latLon2 = this.getLocations()[0];
        }
        if ((latLon = restorableSupport.getStateValueAsLatLon(stateObject, "location2")) == null) {
            latLon = this.getLocations()[1];
        }
        this.setLocations(latLon2, latLon);
        String string = restorableSupport.getStateValueAsString(stateObject, "orbitType");
        if (string != null) {
            this.setOrbitType(string);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "width")) != null) {
            this.setWidth(d);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableCaps")) != null) {
            this.setEnableCaps(bl);
        }
    }

    public static interface OrbitType {
        public static final String LEFT = "Left";
        public static final String CENTER = "Center";
        public static final String RIGHT = "Right";
    }
}

