/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.terrain.SectorGeometry;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public abstract class SurfaceTileRenderer
implements Disposable {
    private static final int DEFAULT_ALPHA_TEXTURE_SIZE = 1024;
    protected Texture alphaTexture;
    protected Texture outlineTexture;
    private boolean showImageTileOutlines = false;

    @Override
    public void dispose() {
        if (GLContext.getCurrent() == null) {
            return;
        }
        if (this.alphaTexture != null) {
            this.alphaTexture.dispose();
        }
        this.alphaTexture = null;
        if (this.outlineTexture != null) {
            this.outlineTexture.dispose();
        }
        this.outlineTexture = null;
    }

    public boolean isShowImageTileOutlines() {
        return this.showImageTileOutlines;
    }

    public void setShowImageTileOutlines(boolean bl) {
        this.showImageTileOutlines = bl;
    }

    public void renderTile(DrawContext drawContext, SurfaceTile surfaceTile) {
        if (surfaceTile == null) {
            String string = Logging.getMessage("nullValue.TileIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        ArrayList<SurfaceTile> arrayList = new ArrayList<SurfaceTile>(1);
        arrayList.add(surfaceTile);
        this.renderTiles(drawContext, arrayList);
        arrayList.clear();
    }

    protected abstract void preComputeTextureTransform(DrawContext var1, SectorGeometry var2, Transform var3);

    protected abstract void computeTextureTransform(DrawContext var1, SurfaceTile var2, Transform var3);

    protected abstract Iterable<SurfaceTile> getIntersectingTiles(DrawContext var1, SectorGeometry var2, Iterable<? extends SurfaceTile> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderTiles(DrawContext drawContext, Iterable<? extends SurfaceTile> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.TileIterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        int n = 33985;
        boolean bl = this.showImageTileOutlines && drawContext.getGLRuntimeCapabilities().getNumTextureUnits() > 2;
        gL.glPushAttrib(28929);
        try {
            this.alphaTexture = drawContext.getTextureCache().getTexture(this);
            if (this.alphaTexture == null) {
                this.initAlphaTexture(1024);
                drawContext.getTextureCache().put(this, this.alphaTexture);
            }
            if (bl && this.outlineTexture == null) {
                this.initOutlineTexture(128);
            }
            gL.glEnable(2929);
            gL.glDepthFunc(515);
            gL.glEnable(3008);
            gL.glAlphaFunc(516, 0.01f);
            gL.glActiveTexture(33984);
            gL.glEnable(3553);
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            if (!drawContext.isPickingMode()) {
                gL.glTexEnvi(8960, 8704, 8448);
            } else {
                gL.glTexEnvf(8960, 8704, 34160.0f);
                gL.glTexEnvf(8960, 34176, 34168.0f);
                gL.glTexEnvf(8960, 34161, 7681.0f);
            }
            int n2 = 2;
            if (bl) {
                n2 = 3;
                n = 33986;
                gL.glActiveTexture(33985);
                gL.glEnable(3553);
                gL.glMatrixMode(5890);
                gL.glPushMatrix();
                gL.glTexEnvi(8960, 8704, 260);
            }
            gL.glActiveTexture(n);
            gL.glEnable(3553);
            gL.glMatrixMode(5890);
            gL.glPushMatrix();
            gL.glTexEnvi(8960, 8704, 8448);
            drawContext.getSurfaceGeometry().beginRendering(drawContext);
            Transform transform = new Transform();
            for (SectorGeometry sectorGeometry : drawContext.getSurfaceGeometry()) {
                Iterable<SurfaceTile> iterable2 = this.getIntersectingTiles(drawContext, sectorGeometry, iterable);
                if (iterable2 == null) continue;
                sectorGeometry.beginRendering(drawContext, n2);
                this.preComputeTextureTransform(drawContext, sectorGeometry, transform);
                for (SurfaceTile surfaceTile : iterable2) {
                    gL.glActiveTexture(33984);
                    if (!surfaceTile.bind(drawContext)) continue;
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                    surfaceTile.applyInternalTransform(drawContext, true);
                    this.computeTextureTransform(drawContext, surfaceTile, transform);
                    gL.glScaled(transform.HScale, transform.VScale, 1.0);
                    gL.glTranslated(transform.HShift, transform.VShift, 0.0);
                    if (bl) {
                        gL.glActiveTexture(33985);
                        this.outlineTexture.bind();
                        gL.glMatrixMode(5890);
                        gL.glLoadIdentity();
                        gL.glScaled(transform.HScale, transform.VScale, 1.0);
                        gL.glTranslated(transform.HShift, transform.VShift, 0.0);
                    }
                    gL.glActiveTexture(n);
                    this.alphaTexture.bind();
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                    gL.glScaled(transform.HScale, transform.VScale, 1.0);
                    gL.glTranslated(transform.HShift, transform.VShift, 0.0);
                    sectorGeometry.renderMultiTexture(drawContext, n2);
                }
                sectorGeometry.endRendering(drawContext);
            }
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("generic.ExceptionWhileRenderingLayer", this.getClass().getName()), exception);
        }
        finally {
            drawContext.getSurfaceGeometry().endRendering(drawContext);
            gL.glActiveTexture(n);
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glDisable(3553);
            if (bl) {
                gL.glActiveTexture(33985);
                gL.glMatrixMode(5890);
                gL.glPopMatrix();
                gL.glDisable(3553);
            }
            gL.glActiveTexture(33984);
            gL.glMatrixMode(5890);
            gL.glPopMatrix();
            gL.glDisable(3553);
            gL.glTexEnvf(8960, 8704, 8448.0f);
            if (drawContext.isPickingMode()) {
                gL.glTexEnvf(8960, 34176, 5890.0f);
                gL.glTexEnvf(8960, 34161, 8448.0f);
            }
            gL.glPopAttrib();
        }
    }

    private static void fillByteBuffer(ByteBuffer byteBuffer, byte by) {
        for (int i = 0; i < byteBuffer.capacity(); ++i) {
            byteBuffer.put(by);
        }
    }

    protected void initAlphaTexture(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(n * n));
        SurfaceTileRenderer.fillByteBuffer(byteBuffer, (byte)-1);
        TextureData textureData = new TextureData(6406, n, n, 0, 6406, 5121, false, false, false, byteBuffer.rewind(), null);
        this.alphaTexture = TextureIO.newTexture((TextureData)textureData);
        this.alphaTexture.bind();
        this.alphaTexture.setTexParameteri(10240, 9728);
        this.alphaTexture.setTexParameteri(10241, 9728);
        this.alphaTexture.setTexParameteri(10242, 33069);
        this.alphaTexture.setTexParameteri(10243, 33069);
    }

    protected void initOutlineTexture(int n) {
        ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(n * n));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                byte by = i == 0 || j == 0 || i == n - 1 || j == n - 1 ? (byte)-1 : 0;
                byteBuffer.put(i * n + j, by);
            }
        }
        TextureData textureData = new TextureData(6409, n, n, 0, 6409, 5121, false, false, false, byteBuffer.rewind(), null);
        this.outlineTexture = TextureIO.newTexture((TextureData)textureData);
        this.outlineTexture.bind();
        this.outlineTexture.setTexParameteri(10240, 9728);
        this.outlineTexture.setTexParameteri(10241, 9728);
        this.outlineTexture.setTexParameteri(10242, 33071);
        this.outlineTexture.setTexParameteri(10243, 33071);
    }

    protected static class Transform {
        double HScale;
        double VScale;
        double HShift;
        double VShift;
        double rotationDegrees;

        protected Transform() {
        }
    }
}

