/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OffsetsList;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.render.airspaces.Geometry;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.GeometryBuilder;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.RestorableSupport;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.media.opengl.GL;

public abstract class RigidShape
extends AbstractShape {
    protected int faceCount = 1;
    protected Position centerPosition = Position.ZERO;
    protected double northSouthRadius = 1.0;
    protected double verticalRadius = 1.0;
    protected double eastWestRadius = 1.0;
    protected Angle heading;
    protected Angle tilt;
    protected Angle roll;
    protected Angle skewNorthSouth = Angle.POS90;
    protected Angle skewEastWest = Angle.POS90;
    protected boolean renderExtent = false;
    protected double detailHint = 0.0;
    protected GeometryBuilder geometryBuilder = new GeometryBuilder();
    protected static final String GEOMETRY_CACHE_KEY = Geometry.class.getName();
    protected static final long DEFAULT_GEOMETRY_CACHE_SIZE = 0x1000000L;
    protected static final String GEOMETRY_CACHE_NAME = "Airspace Geometry";
    protected Map<Integer, Object> imageSources = new HashMap<Integer, Object>();
    protected Map<Integer, WWTexture> textures = new HashMap<Integer, WWTexture>();
    protected Map<Integer, OffsetsList> offsets = new HashMap<Integer, OffsetsList>();
    protected Map<Integer, FloatBuffer> offsetTextureCoords = new HashMap<Integer, FloatBuffer>();
    protected Terrain previousIntersectionTerrain;
    protected Object previousIntersectionGlobeStateKey;
    protected ShapeData previousIntersectionShapeData;

    protected ShapeData getCurrentShapeData() {
        return (ShapeData)this.getCurrentData();
    }

    @Override
    protected void reset() {
        this.previousIntersectionShapeData = null;
        this.previousIntersectionTerrain = null;
        this.previousIntersectionGlobeStateKey = null;
        super.reset();
    }

    protected WWTexture getTexture(int n) {
        return this.textures.get(n);
    }

    protected void setTexture(int n, WWTexture wWTexture) {
        this.textures.put(n, wWTexture);
    }

    public Object getImageSource(int n) {
        return this.imageSources.get(n);
    }

    public void setImageSources(Object object) {
        if (object != null) {
            for (int i = 0; i < this.getFaceCount(); ++i) {
                this.setImageSource(i, object);
            }
        }
    }

    public void setImageSources(Iterable iterable) {
        if (iterable != null) {
            int n = 0;
            for (Object t : iterable) {
                this.setImageSource(n, t);
                ++n;
            }
        }
    }

    public void setImageSource(int n, Object object) {
        if (object != null) {
            WWTexture wWTexture = null;
            for (Integer n2 : this.imageSources.keySet()) {
                if (!object.equals(this.imageSources.get(n2))) continue;
                wWTexture = this.textures.get(n2);
                break;
            }
            this.setTexture(n, wWTexture == null ? this.makeTexture(object) : wWTexture);
            this.imageSources.put(n, object);
        }
    }

    public int getFaceCount() {
        return this.faceCount;
    }

    protected void setFaceCount(int n) {
        this.faceCount = n;
    }

    abstract int getSubdivisions();

    public float[] getOffsets(int n, int n2) {
        return this.offsets.get(n) != null ? this.offsets.get(n).getOffset(n2) : null;
    }

    public void setOffset(int n, int n2, float f, float f2) {
        if (this.offsets.get(n) != null) {
            this.offsets.get(n).setOffset(n2, f, f2);
        }
    }

    public Position getCenterPosition() {
        return this.centerPosition;
    }

    public void setCenterPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.centerPosition = position;
        this.reset();
    }

    @Override
    public Position getReferencePosition() {
        return this.centerPosition;
    }

    public double getNorthSouthRadius() {
        return this.northSouthRadius;
    }

    public void setNorthSouthRadius(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "northSouthRadius <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.northSouthRadius = d;
        this.reset();
    }

    public double getEastWestRadius() {
        return this.eastWestRadius;
    }

    public void setEastWestRadius(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "eastWestRadius <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.eastWestRadius = d;
        this.reset();
    }

    public double getVerticalRadius() {
        return this.verticalRadius;
    }

    public void setVerticalRadius(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "verticalRadius <= 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.verticalRadius = d;
        this.reset();
    }

    public Angle getHeading() {
        return this.heading;
    }

    public void setHeading(Angle angle) {
        double d;
        for (d = angle.getDegrees(); d < 0.0; d += 360.0) {
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        this.heading = Angle.fromDegrees(d);
        this.reset();
    }

    public Angle getTilt() {
        return this.tilt;
    }

    public void setTilt(Angle angle) {
        double d;
        for (d = angle.getDegrees(); d < 0.0; d += 360.0) {
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        this.tilt = Angle.fromDegrees(d);
        this.reset();
    }

    public Angle getRoll() {
        return this.roll;
    }

    public void setRoll(Angle angle) {
        double d;
        for (d = angle.getDegrees(); d < 0.0; d += 360.0) {
        }
        while (d > 360.0) {
            d -= 360.0;
        }
        this.roll = Angle.fromDegrees(d);
        this.reset();
    }

    public Angle getSkewNorthSouth() {
        return this.skewNorthSouth;
    }

    public void setSkewNorthSouth(Angle angle) {
        if (angle.compareTo(Angle.POS180) >= 0 || angle.compareTo(Angle.ZERO) <= 0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", "skew >= 180 degrees or skew <= 0 degrees");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.skewNorthSouth = angle;
        this.reset();
    }

    public Angle getSkewEastWest() {
        return this.skewEastWest;
    }

    public void setSkewEastWest(Angle angle) {
        if (angle.compareTo(Angle.POS180) >= 0 || angle.compareTo(Angle.ZERO) <= 0) {
            String string = Logging.getMessage("generic.AngleOutOfRange", "skew >= 180 degrees or skew <= 0 degrees");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.skewEastWest = angle;
        this.reset();
    }

    @Override
    protected void initialize() {
    }

    public double getDetailHint() {
        return this.detailHint;
    }

    public void setDetailHint(double d) {
        this.detailHint = d;
        this.reset();
    }

    protected void setUpGeometryCache() {
        if (!WorldWind.getMemoryCacheSet().containsCache(GEOMETRY_CACHE_KEY)) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.AirspaceGeometryCacheSize", 0x1000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName(GEOMETRY_CACHE_NAME);
            WorldWind.getMemoryCacheSet().addCache(GEOMETRY_CACHE_KEY, basicMemoryCache);
        }
    }

    protected MemoryCache getGeometryCache() {
        return WorldWind.getMemoryCache(GEOMETRY_CACHE_KEY);
    }

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new ShapeData(drawContext, this);
    }

    @Override
    protected boolean mustApplyTexture(DrawContext drawContext) {
        boolean bl = false;
        for (int i = 0; i < this.getFaceCount(); ++i) {
            if (this.getTexture(i) == null || this.getCurrentShapeData().getMesh(i).getBuffer(0) == null) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean mustApplyTexture(int n) {
        return this.getTexture(n) != null && this.getCurrentShapeData().getMesh(n).getBuffer(0) != null;
    }

    @Override
    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrentShapeData();
        if (shapeData == null || shapeData.getMeshes() == null || shapeData.getMeshes().size() < 1) {
            return true;
        }
        if (shapeData.getMesh(0) == null || shapeData.getMesh(0).getBuffer(2) == null) {
            return true;
        }
        if (drawContext.getVerticalExaggeration() != shapeData.getVerticalExaggeration()) {
            return true;
        }
        if (this.getAltitudeMode() == 0 && shapeData.getGlobeStateKey() != null && shapeData.getGlobeStateKey().equals(drawContext.getGlobe().getGlobeStateKey(drawContext))) {
            return false;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    @Override
    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        ShapeData shapeData = this.getCurrentShapeData();
        Vec4 vec4 = this.computeReferencePoint(drawContext);
        if (vec4 == null) {
            return false;
        }
        shapeData.setReferencePoint(vec4);
        shapeData.setEyeDistance(drawContext.getView().getEyePoint().distanceTo3(vec4));
        shapeData.setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
        shapeData.setVerticalExaggeration(drawContext.getVerticalExaggeration());
        this.computeSubdivisions(drawContext, shapeData);
        this.makeGeometry(shapeData);
        if (shapeData.getMesh(0).getBuffer(2) != null) {
            shapeData.setExtent(this.computeExtent(drawContext));
        }
        if (shapeData.getExtent() == null || drawContext.isSmall(shapeData.getExtent(), 1)) {
            return false;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        return shapeData.getMesh(0) != null && shapeData.getMesh(0).getBuffer(2) != null && shapeData.getMesh(0).getCount(2) >= 2;
    }

    @Override
    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        return this.getCurrentShapeData().getMesh(0).getBuffer(2) != null;
    }

    @Override
    protected OGLStackHandler beginDrawing(DrawContext drawContext, int n) {
        OGLStackHandler oGLStackHandler = super.beginDrawing(drawContext, n);
        if (!drawContext.isPickingMode()) {
            oGLStackHandler.pushTextureIdentity(drawContext.getGL());
        }
        return oGLStackHandler;
    }

    @Override
    protected void doDrawOutline(DrawContext drawContext) {
        for (int i = 0; i < this.getFaceCount(); ++i) {
            Geometry geometry = this.getCurrentShapeData().getMesh(i);
            geometry.setMode(1, 1);
            this.setModelViewMatrix(drawContext);
            this.drawGeometry(drawContext, this.getCurrentShapeData(), i);
            geometry.setMode(1, 4);
        }
    }

    @Override
    protected void doDrawInterior(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        if (this.renderExtent) {
            Box box = (Box)this.getCurrentShapeData().getExtent();
            box.render(drawContext);
        }
        this.setModelViewMatrix(drawContext);
        for (int i = 0; i < this.getFaceCount(); ++i) {
            if (!drawContext.isPickingMode() && this.mustApplyTexture(i) && this.getTexture(i).bind(drawContext)) {
                this.getTexture(i).applyInternalTransform(drawContext);
                Geometry geometry = this.getCurrentShapeData().getMesh(i);
                if (this.getOffsets(i, 0) != null) {
                    int n = geometry.getBuffer(0).limit();
                    FloatBuffer floatBuffer = (FloatBuffer)geometry.getBuffer(0);
                    FloatBuffer floatBuffer2 = BufferUtil.newFloatBuffer((int)n);
                    for (int j = 0; j < n; j += 2) {
                        float f = floatBuffer.get(j);
                        float f2 = floatBuffer.get(j + 1);
                        float f3 = -this.getOffsets(i, 0)[0] * (1.0f - f) * f2 - this.getOffsets(i, 1)[0] * f * f2 - this.getOffsets(i, 2)[0] * (1.0f - f) * (1.0f - f2) - this.getOffsets(i, 3)[0] * f * (1.0f - f2) + f;
                        float f4 = -this.getOffsets(i, 0)[1] * (1.0f - f) * f2 - this.getOffsets(i, 1)[1] * f * f2 - this.getOffsets(i, 2)[1] * (1.0f - f) * (1.0f - f2) - this.getOffsets(i, 3)[1] * f * (1.0f - f2) + f2;
                        floatBuffer2.put(j, f3);
                        floatBuffer2.put(j + 1, f4);
                    }
                    gL.glTexCoordPointer(2, 5126, 0, floatBuffer2.rewind());
                } else {
                    gL.glTexCoordPointer(2, 5126, 0, geometry.getBuffer(0).rewind());
                }
                gL.glEnable(3553);
                gL.glEnableClientState(32888);
                gL.glTexParameteri(3553, 10242, 10497);
                gL.glTexParameteri(3553, 10243, 10497);
            } else {
                gL.glDisable(3553);
                gL.glDisableClientState(32888);
            }
            this.drawGeometry(drawContext, this.getCurrentShapeData(), i);
        }
    }

    protected Extent computeExtent(DrawContext drawContext) {
        Matrix matrix = this.computeRenderMatrix(drawContext);
        Vector<Vec4> vector = new Vector<Vec4>(4);
        Vec4 vec4 = matrix.transformBy3(matrix, -1.0, 1.0, -1.0);
        vector.add(vec4);
        vec4 = matrix.transformBy3(matrix, 1.0, 1.0, 1.0);
        vector.add(vec4);
        vec4 = matrix.transformBy3(matrix, 1.0, -1.0, -1.0);
        vector.add(vec4);
        vec4 = matrix.transformBy3(matrix, -1.0, -1.0, 1.0);
        vector.add(vec4);
        Box box = Box.computeBoundingBox(vector);
        Vec4 vec42 = this.getCurrentData().getReferencePoint();
        return box != null ? box.translate(vec42) : null;
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = this.computeRenderMatrix(globe, d);
        Vector<Vec4> vector = new Vector<Vec4>(4);
        Vec4 vec4 = matrix.transformBy3(matrix, -1.0, 1.0, -1.0);
        vector.add(vec4);
        vec4 = matrix.transformBy3(matrix, 1.0, 1.0, 1.0);
        vector.add(vec4);
        vec4 = matrix.transformBy3(matrix, 1.0, -1.0, -1.0);
        vector.add(vec4);
        vec4 = matrix.transformBy3(matrix, -1.0, -1.0, 1.0);
        vector.add(vec4);
        Box box = Box.computeBoundingBox(vector);
        Position position = this.getCenterPosition();
        if (position == null) {
            return null;
        }
        Vec4 vec42 = this.computeReferencePoint(globe, d);
        return box != null ? box.translate(vec42) : null;
    }

    @Override
    public Sector getSector() {
        return null;
    }

    protected FloatBuffer computeTransformedVertices(FloatBuffer floatBuffer, int n, Matrix matrix) {
        int n2 = n * 3;
        FloatBuffer floatBuffer2 = BufferUtil.newFloatBuffer((int)n2);
        for (int i = 0; i < n; ++i) {
            Vec4 vec4 = matrix.transformBy3(matrix, floatBuffer.get(3 * i), floatBuffer.get(3 * i + 1), floatBuffer.get(3 * i + 2));
            floatBuffer2.put((float)vec4.getX()).put((float)vec4.getY()).put((float)vec4.getZ());
        }
        floatBuffer2.rewind();
        return floatBuffer2;
    }

    public Vec4 computeReferencePoint(DrawContext drawContext) {
        Position position = this.getCenterPosition();
        if (position == null) {
            return null;
        }
        return this.computePoint(drawContext.getTerrain(), position);
    }

    protected Vec4 computeReferencePoint(Globe globe, double d) {
        Position position = this.getCenterPosition();
        if (position == null) {
            return null;
        }
        double d2 = globe.getElevation(position.latitude, position.longitude);
        double d3 = this.getAltitudeMode() == 1 ? 0.0 + d2 * d : (this.getAltitudeMode() == 2 ? position.getAltitude() + d2 * d : position.getAltitude() * d);
        return globe.computePointFromPosition(position, d3);
    }

    public Matrix computeRenderMatrix(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.IDENTITY;
        Position position = globe.computePositionFromPoint(this.computeReferencePoint(globe, d));
        matrix = matrix.multiply(globe.computeSurfaceOrientationAtPosition(position));
        if (this.roll != null) {
            matrix = matrix.multiply(Matrix.fromRotationY(Angle.POS360.subtract(this.roll)));
        }
        if (this.tilt != null) {
            matrix = matrix.multiply(Matrix.fromRotationX(Angle.POS360.subtract(this.tilt)));
        }
        if (this.heading != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ(Angle.POS360.subtract(this.heading)));
        }
        matrix = matrix.multiply(Matrix.fromSkew(this.skewEastWest, this.skewNorthSouth));
        matrix = matrix.multiply(Matrix.fromScale(this.getEastWestRadius(), this.getNorthSouthRadius(), this.getVerticalRadius()));
        return matrix;
    }

    public Matrix computeRenderMatrix(DrawContext drawContext) {
        Matrix matrix = Matrix.IDENTITY;
        Position position = drawContext.getGlobe().computePositionFromPoint(this.getCurrentShapeData().getReferencePoint());
        matrix = matrix.multiply(drawContext.getGlobe().computeSurfaceOrientationAtPosition(position));
        if (this.roll != null) {
            matrix = matrix.multiply(Matrix.fromRotationY(Angle.POS360.subtract(this.roll)));
        }
        if (this.tilt != null) {
            matrix = matrix.multiply(Matrix.fromRotationX(Angle.POS360.subtract(this.tilt)));
        }
        if (this.heading != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ(Angle.POS360.subtract(this.heading)));
        }
        matrix = matrix.multiply(Matrix.fromSkew(this.skewEastWest, this.skewNorthSouth));
        matrix = matrix.multiply(Matrix.fromScale(this.getEastWestRadius(), this.getNorthSouthRadius(), this.getVerticalRadius()));
        return matrix;
    }

    public Matrix computeRenderMatrixInverse(Globe globe, double d) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(Matrix.fromScale(1.0 / this.getEastWestRadius(), 1.0 / this.getNorthSouthRadius(), 1.0 / this.getVerticalRadius()));
        matrix = matrix.multiply(Matrix.fromSkew(Angle.POS180.subtract(this.skewEastWest), Angle.POS180.subtract(this.skewNorthSouth)));
        if (this.heading != null) {
            matrix = matrix.multiply(Matrix.fromRotationZ(this.heading));
        }
        if (this.tilt != null) {
            matrix = matrix.multiply(Matrix.fromRotationX(this.tilt));
        }
        if (this.roll != null) {
            matrix = matrix.multiply(Matrix.fromRotationY(this.roll));
        }
        Position position = globe.computePositionFromPoint(this.computeReferencePoint(globe, d));
        matrix = matrix.multiply(globe.computeSurfaceOrientationAtPosition(position).getInverse());
        return matrix;
    }

    protected void setModelViewMatrix(DrawContext drawContext) {
        if (drawContext.getGL() == null) {
            String string = Logging.getMessage("nullValue.DrawingContextGLIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Matrix matrix = drawContext.getView().getModelviewMatrix();
        matrix = matrix.multiply(this.computeRenderMatrix(drawContext));
        GL gL = drawContext.getGL();
        gL.glEnable(2977);
        gL.glMatrixMode(5888);
        double[] dArray = new double[16];
        matrix.toArray(dArray, 0, false);
        gL.glLoadMatrixd(dArray, 0);
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.setCenterPosition(position);
        this.reset();
    }

    protected abstract void computeSubdivisions(DrawContext var1, ShapeData var2);

    protected abstract void makeGeometry(ShapeData var1);

    protected GeometryBuilder getGeometryBuilder() {
        return this.geometryBuilder;
    }

    protected void drawGeometry(DrawContext drawContext, ShapeData shapeData, int n) {
        Geometry geometry = shapeData.getMesh(n);
        if (geometry.getBuffer(1) == null) {
            String string = "nullValue.ElementBufferIsNull";
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n2 = geometry.getMode(1);
        int n3 = geometry.getCount(1);
        int n4 = geometry.getGLType(1);
        Buffer buffer = geometry.getBuffer(1);
        this.drawGeometry(drawContext, n2, n3, n4, buffer, shapeData, n);
    }

    protected abstract void drawGeometry(DrawContext var1, int var2, int var3, int var4, Buffer var5, ShapeData var6, int var7);

    protected int[] getVboIds(int n, DrawContext drawContext) {
        Object object;
        ShapeData shapeData = (ShapeData)this.getCurrentData();
        if (shapeData != null && (object = shapeData.getVboCacheKey(n)) != null) {
            return (int[])drawContext.getGpuResourceCache().get(object);
        }
        return null;
    }

    @Override
    protected void clearCachedVbos(DrawContext drawContext) {
        for (Integer n : ((ShapeData)this.getCurrentData()).vboCacheKeys.keySet()) {
            drawContext.getGpuResourceCache().remove(((ShapeData)this.getCurrentData()).getVboCacheKey(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillVBO(DrawContext drawContext) {
        int n;
        int[] nArray;
        GL gL = drawContext.getGL();
        ShapeData shapeData = this.getCurrentShapeData();
        List<Geometry> list = shapeData.getMeshes();
        if (shapeData.getVboCacheKey(this.getSubdivisions()) == null) {
            shapeData.setVboCacheKey(this.getSubdivisions(), this.getClass().toString() + this.getSubdivisions());
        }
        if ((nArray = (int[])drawContext.getGpuResourceCache().get(shapeData.getVboCacheKey(this.getSubdivisions()))) == null) {
            n = 0;
            for (int i = 0; i < this.getFaceCount(); ++i) {
                n += list.get(i).getBuffer(2).limit() * 4;
                n += list.get(i).getBuffer(1).limit() * 4;
            }
            nArray = new int[2 * this.getFaceCount()];
            gL.glGenBuffers(nArray.length, nArray, 0);
            drawContext.getGpuResourceCache().put(shapeData.getVboCacheKey(this.getSubdivisions()), nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n);
            shapeData.refillIndexVBO = true;
        }
        if (shapeData.refillIndexVBO) {
            try {
                for (n = 0; n < this.getFaceCount(); ++n) {
                    IntBuffer intBuffer = (IntBuffer)list.get(n).getBuffer(1);
                    gL.glBindBuffer(34963, nArray[2 * n + 1]);
                    gL.glBufferData(34963, intBuffer.limit() * 4, intBuffer.rewind(), 35048);
                }
                shapeData.refillIndexVBO = false;
            }
            finally {
                gL.glBindBuffer(34963, 0);
            }
        }
        try {
            for (n = 0; n < this.getFaceCount(); ++n) {
                FloatBuffer floatBuffer = (FloatBuffer)list.get(n).getBuffer(2);
                gL.glBindBuffer(34962, nArray[2 * n]);
                gL.glBufferData(34962, floatBuffer.limit() * 4, floatBuffer.rewind(), 35044);
            }
        }
        finally {
            gL.glBindBuffer(34962, 0);
        }
    }

    protected boolean isSameAsPreviousTerrain(Terrain terrain) {
        if (terrain == null || this.previousIntersectionTerrain == null || terrain != this.previousIntersectionTerrain) {
            return false;
        }
        if (terrain.getVerticalExaggeration() != this.previousIntersectionTerrain.getVerticalExaggeration()) {
            return false;
        }
        return this.previousIntersectionGlobeStateKey != null && terrain.getGlobe().getGlobeStateKey().equals(this.previousIntersectionGlobeStateKey);
    }

    public void clearIntersectionGeometry() {
        this.previousIntersectionGlobeStateKey = null;
        this.previousIntersectionShapeData = null;
        this.previousIntersectionTerrain = null;
    }

    @Override
    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (int i = 0; i < this.getFaceCount(); ++i) {
            List<Intersection> list = this.intersect(line, terrain, i);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public List<Intersection> intersect(Line line, Terrain terrain, int n) throws InterruptedException {
        ShapeData shapeData;
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        if (this.getCurrentShapeData().getMesh(n).getBuffer(2) == null) {
            return null;
        }
        ShapeData shapeData2 = shapeData = this.isSameAsPreviousTerrain(terrain) ? this.previousIntersectionShapeData : null;
        if (shapeData == null) {
            shapeData = this.createIntersectionGeometry(terrain);
            if (shapeData.getMesh(n) == null) {
                return null;
            }
            this.previousIntersectionShapeData = shapeData;
            this.previousIntersectionTerrain = terrain;
            this.previousIntersectionGlobeStateKey = terrain.getGlobe().getGlobeStateKey();
        }
        if (shapeData.getExtent() != null && shapeData.getExtent().intersect(line) == null) {
            return null;
        }
        Line line2 = new Line(line.getOrigin().subtract3(shapeData.getReferencePoint()), line.getDirection());
        ArrayList<Intersection> arrayList = new ArrayList<Intersection>();
        for (int i = 0; i < this.getFaceCount(); ++i) {
            ArrayList<Intersection> arrayList2 = new ArrayList<Intersection>();
            this.intersect(line2, shapeData, arrayList2, n);
            if (arrayList2.size() == 0) continue;
            for (Intersection intersection : arrayList2) {
                Vec4 vec4 = intersection.getIntersectionPoint().add3(shapeData.getReferencePoint());
                intersection.setIntersectionPoint(vec4);
                Position position2 = terrain.getGlobe().computePositionFromPoint(vec4);
                Vec4 vec42 = terrain.getSurfacePoint(position2.getLatitude(), position2.getLongitude(), 0.0);
                double d = Math.sqrt(vec4.dotSelf3()) - Math.sqrt(vec42.dotSelf3());
                intersection.setIntersectionPosition(new Position(position2, d));
                intersection.setObject(this);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    protected void intersect(Line line, ShapeData shapeData, List<Intersection> list, int n) throws InterruptedException {
        IntBuffer intBuffer = (IntBuffer)shapeData.getMesh(n).getBuffer(1);
        intBuffer.rewind();
        FloatBuffer floatBuffer = (FloatBuffer)shapeData.getMesh(n).getBuffer(2);
        floatBuffer.rewind();
        List<Intersection> list2 = Triangle.intersectTriangleTypes(line, floatBuffer, intBuffer, 4);
        if (list2 != null && list2.size() > 0) {
            list.addAll(list2);
        }
    }

    protected abstract ShapeData createIntersectionGeometry(Terrain var1);

    public List<Intersection> intersectFace(Line line, int n, Matrix matrix) throws InterruptedException {
        Geometry geometry;
        FloatBuffer floatBuffer;
        Line line2 = new Line(line.getOrigin().subtract3(this.getCurrentShapeData().getReferencePoint()), line.getDirection());
        List<Intersection> list = Triangle.intersectTriangleTypes(line2, floatBuffer = this.computeTransformedVertices((FloatBuffer)(geometry = this.getCurrentShapeData().getMesh(n)).getBuffer(2), geometry.getCount(2), matrix), (IntBuffer)geometry.getBuffer(1), 4);
        if (list == null || list.size() == 0) {
            return null;
        }
        for (Intersection intersection : list) {
            Vec4 vec4 = intersection.getIntersectionPoint().add3(this.getCurrentShapeData().getReferencePoint());
            intersection.setIntersectionPoint(vec4);
            intersection.setObject(this);
        }
        return list;
    }

    @Override
    public String getRestorableState() {
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        this.doGetRestorableState(restorableSupport, null);
        return restorableSupport.getStateAsXml();
    }

    @Override
    protected void doGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyGetRestorableState(restorableSupport, stateObject);
    }

    private void doMyGetRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        super.doGetRestorableState(restorableSupport, stateObject);
        restorableSupport.addStateValueAsPosition(stateObject, "centerPosition", this.getCenterPosition());
        restorableSupport.addStateValueAsDouble(stateObject, "northSouthRadius", this.getNorthSouthRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "eastWestRadius", this.getEastWestRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "verticalRadius", this.getVerticalRadius());
        restorableSupport.addStateValueAsDouble(stateObject, "heading", this.getHeading().degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "tilt", this.getTilt().degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "roll", this.getRoll().degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "skewNorthSouth", this.getSkewNorthSouth().degrees);
        restorableSupport.addStateValueAsDouble(stateObject, "skewEastWest", this.getSkewEastWest().degrees);
        restorableSupport.addStateValueAsOffsetsList(stateObject, "offsets", this.offsets);
        restorableSupport.addStateValueAsImageSourceList(stateObject, "imageSources", this.imageSources, this.getFaceCount());
    }

    @Override
    public void restoreState(String string) {
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        this.doRestoreState(restorableSupport, null);
    }

    @Override
    protected void doRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        this.doMyRestoreState(restorableSupport, stateObject);
    }

    private void doMyRestoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        HashMap<Integer, Object> hashMap;
        HashMap<Integer, OffsetsList> hashMap2;
        Double d;
        super.doRestoreState(restorableSupport, stateObject);
        Position position = restorableSupport.getStateValueAsPosition(stateObject, "centerPosition");
        if (position != null) {
            this.setCenterPosition(position);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "northSouthRadius")) != null) {
            this.setNorthSouthRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "eastWestRadius")) != null) {
            this.setEastWestRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "verticalRadius")) != null) {
            this.setVerticalRadius(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "heading")) != null) {
            this.setHeading(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "tilt")) != null) {
            this.setTilt(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "roll")) != null) {
            this.setRoll(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "skewNorthSouth")) != null) {
            this.setSkewNorthSouth(Angle.fromDegrees(d));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "skewEastWest")) != null) {
            this.setSkewEastWest(Angle.fromDegrees(d));
        }
        if ((hashMap2 = restorableSupport.getStateValueAsOffsetsList(stateObject, "offsets")) != null) {
            this.offsets = hashMap2;
        }
        if ((hashMap = restorableSupport.getStateValueAsImageSourceList(stateObject, "imageSources")) != null) {
            for (int i = 0; i < hashMap.size(); ++i) {
                this.setImageSource(i, hashMap.get(i));
            }
        }
    }

    public class Offsets {
        protected Map<Integer, float[]> offsets = new HashMap<Integer, float[]>();

        public Offsets() {
            float[] fArray = new float[]{0.0f, 0.0f};
            for (int i = 0; i < 4; ++i) {
                this.offsets.put(i, fArray);
            }
        }

        public float[] getOffset(int n) {
            return this.offsets.get(n);
        }

        public void setOffset(int n, float f, float f2) {
            float[] fArray = new float[]{f, f2};
            this.offsets.put(n, fArray);
        }
    }

    protected static class ShapeData
    extends AbstractShape.AbstractShapeData {
        protected List<Geometry> meshes = new ArrayList<Geometry>();
        protected Map<Integer, Object> vboCacheKeys = new HashMap<Integer, Object>();
        protected boolean refillIndexBuffer = true;
        protected boolean refillIndexVBO = true;

        public ShapeData(DrawContext drawContext, RigidShape rigidShape) {
            super(drawContext, rigidShape.minExpiryTime, rigidShape.maxExpiryTime);
        }

        public Geometry getMesh() {
            return this.meshes.get(0);
        }

        public Geometry getMesh(int n) {
            return this.meshes.get(n);
        }

        public List<Geometry> getMeshes() {
            return this.meshes;
        }

        public void setMesh(Geometry geometry) {
            this.addMesh(0, geometry);
        }

        public void setMeshes(List<Geometry> list) {
            this.meshes = list;
        }

        public void addMesh(Geometry geometry) {
            this.addMesh(this.meshes.size(), geometry);
        }

        public void addMesh(int n, Geometry geometry) {
            this.meshes.add(n, geometry);
        }

        public Object getVboCacheKey(int n) {
            return this.vboCacheKeys.get(n);
        }

        public void setVboCacheKey(int n, Object object) {
            this.vboCacheKeys.put(n, object);
        }

        public int getVboCacheSize() {
            return this.vboCacheKeys.size();
        }
    }
}

