/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Exportable;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PointPlacemarkAttributes
implements Exportable {
    protected String imageAddress;
    protected Double scale;
    protected Double heading;
    protected String headingReference;
    protected Double pitch;
    protected Offset imageOffset;
    protected Color imageColor;
    protected Double lineWidth;
    protected Material lineMaterial;
    protected int antiAliasHint = 4353;
    protected Font labelFont;
    protected Offset labelOffset;
    protected Material labelMaterial;
    protected Double labelScale;
    protected boolean usePointAsDefaultImage = false;
    protected boolean unresolved;
    public static final String DEFAULT_IMAGE_PATH = Configuration.getStringValue("gov.nasa.worldwind.render.PointPlacemarkAttributes.DefaultImagePath", "images/pushpins/plain-yellow.png");
    public static final Offset DEFAULT_IMAGE_OFFSET = new Offset(19.0, 8.0, "gov.nasa.worldwind.avkey.Pixels", "gov.nasa.worldwind.avkey.Pixels");
    public static final Double DEFAULT_IMAGE_SCALE = 0.6;
    public static final Double DEFAULT_LABEL_SCALE = 1.0;
    protected static final Color DEFAULT_IMAGE_COLOR = Color.WHITE;
    public static final Offset DEFAULT_LABEL_OFFSET = new Offset(0.9, 0.6, "gov.nasa.worldwind.avkey.Fraction", "gov.nasa.worldwind.avkey.Fraction");
    protected static final Font DEFAULT_LABEL_FONT = Font.decode(Configuration.getStringValue("gov.nasa.worldwind.render.PointPlacemarkAttributes.DefaultLabelFont", "Arial-BOLD-14"));
    protected static final Color DEFAULT_LABEL_COLOR = Color.WHITE;
    protected static final Color DEFAULT_LINE_COLOR = Color.WHITE;

    public PointPlacemarkAttributes() {
    }

    public PointPlacemarkAttributes(PointPlacemarkAttributes pointPlacemarkAttributes) {
        this.copy(pointPlacemarkAttributes);
    }

    public void copy(PointPlacemarkAttributes pointPlacemarkAttributes) {
        if (pointPlacemarkAttributes != null) {
            this.setImageAddress(pointPlacemarkAttributes.getImageAddress());
            this.setScale(pointPlacemarkAttributes.getScale());
            this.setHeading(pointPlacemarkAttributes.getHeading());
            this.setHeadingReference(pointPlacemarkAttributes.getHeadingReference());
            this.setPitch(pointPlacemarkAttributes.getPitch());
            this.setImageOffset(pointPlacemarkAttributes.getImageOffset());
            this.setImageColor(pointPlacemarkAttributes.getImageColor());
            this.setLineWidth(pointPlacemarkAttributes.getLineWidth());
            this.setLineMaterial(pointPlacemarkAttributes.getLineMaterial());
            this.setAntiAliasHint(pointPlacemarkAttributes.getAntiAliasHint());
            this.setLabelFont(pointPlacemarkAttributes.getLabelFont());
            this.setLabelOffset(pointPlacemarkAttributes.getLabelOffset());
            this.setLabelMaterial(pointPlacemarkAttributes.getLabelMaterial());
            this.setLabelScale(pointPlacemarkAttributes.getLabelScale());
            this.setUsePointAsDefaultImage(pointPlacemarkAttributes.isUsePointAsDefaultImage());
        }
    }

    public Double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(Double d) {
        this.lineWidth = d;
    }

    public Material getLineMaterial() {
        return this.lineMaterial;
    }

    public Color getLineColor() {
        return this.lineMaterial == null ? null : this.lineMaterial.getDiffuse();
    }

    public void setLineMaterial(Material material) {
        this.lineMaterial = material;
    }

    public void setLineColor(String string) {
        this.setLineMaterial(new Material(WWUtil.decodeColorABGR(string)));
    }

    public Color getImageColor() {
        return this.imageColor;
    }

    public void setImageColor(Color color) {
        this.imageColor = color;
    }

    public int getAntiAliasHint() {
        return this.antiAliasHint;
    }

    public void setAntiAliasHint(int n) {
        this.antiAliasHint = n;
    }

    public String getImageAddress() {
        return this.imageAddress;
    }

    public void setImageAddress(String string) {
        this.imageAddress = string;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double d) {
        this.scale = d;
    }

    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double d) {
        this.heading = d;
    }

    public String getHeadingReference() {
        return this.headingReference;
    }

    public void setHeadingReference(String string) {
        this.headingReference = string;
    }

    public Double getPitch() {
        return this.pitch;
    }

    public void setPitch(Double d) {
        this.pitch = d;
    }

    public Offset getImageOffset() {
        return this.imageOffset;
    }

    public void setImageOffset(Offset offset) {
        this.imageOffset = offset;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    public void setUnresolved(boolean bl) {
        this.unresolved = bl;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Offset getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(Offset offset) {
        this.labelOffset = offset;
    }

    public Material getLabelMaterial() {
        return this.labelMaterial;
    }

    public Color getLabelColor() {
        return this.labelMaterial == null ? null : this.labelMaterial.getDiffuse();
    }

    public void setLabelMaterial(Material material) {
        this.labelMaterial = material;
    }

    public void setLabelColor(String string) {
        this.setLabelMaterial(new Material(WWUtil.decodeColorABGR(string)));
    }

    public Double getLabelScale() {
        return this.labelScale;
    }

    public void setLabelScale(Double d) {
        this.labelScale = d;
    }

    public boolean isUsePointAsDefaultImage() {
        return this.usePointAsDefaultImage;
    }

    public void setUsePointAsDefaultImage(boolean bl) {
        this.usePointAsDefaultImage = bl;
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    @Override
    public void export(String string, Object object) throws IOException, UnsupportedOperationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    protected void exportAsKML(Object object) throws XMLStreamException {
        Color color;
        Color color2;
        Offset offset;
        String string;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string2 = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string2);
            throw new IllegalArgumentException(string2);
        }
        xMLStreamWriter.writeStartElement("Style");
        xMLStreamWriter.writeStartElement("IconStyle");
        Color color3 = this.getImageColor();
        if (color3 != null) {
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(KMLExportUtil.stripHexPrefix(WWUtil.encodeColorABGR(color3)));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("colorMode");
            xMLStreamWriter.writeCharacters("normal");
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("scale");
        xMLStreamWriter.writeCharacters(Double.toString(this.getScale()));
        xMLStreamWriter.writeEndElement();
        Double d = this.getHeading();
        if (d != null) {
            xMLStreamWriter.writeStartElement("heading");
            xMLStreamWriter.writeCharacters(Double.toString(this.getHeading()));
            xMLStreamWriter.writeEndElement();
        }
        if ((string = this.getImageAddress()) != null) {
            xMLStreamWriter.writeStartElement("Icon");
            xMLStreamWriter.writeStartElement("href");
            xMLStreamWriter.writeCharacters(string);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        if ((offset = this.getImageOffset()) != null) {
            xMLStreamWriter.writeStartElement("hotSpot");
            xMLStreamWriter.writeAttribute("x", Double.toString(offset.getX()));
            xMLStreamWriter.writeAttribute("y", Double.toString(offset.getY()));
            xMLStreamWriter.writeAttribute("xunits", offset.getXUnits());
            xMLStreamWriter.writeAttribute("yunits", offset.getYUnits());
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("LabelStyle");
        Double d2 = this.getLabelScale();
        if (d2 != null) {
            xMLStreamWriter.writeStartElement("scale");
            xMLStreamWriter.writeCharacters(Double.toString(d2));
            xMLStreamWriter.writeEndElement();
        }
        if ((color2 = this.getLabelColor()) != null) {
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(KMLExportUtil.stripHexPrefix(WWUtil.encodeColorABGR(color2)));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("colorMode");
            xMLStreamWriter.writeCharacters("normal");
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("LineStyle");
        Double d3 = this.getLineWidth();
        if (d3 != null) {
            xMLStreamWriter.writeStartElement("width");
            xMLStreamWriter.writeCharacters(Double.toString(d3));
            xMLStreamWriter.writeEndElement();
        }
        if ((color = this.getLineColor()) != null) {
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(KMLExportUtil.stripHexPrefix(WWUtil.encodeColorABGR(color)));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("colorMode");
            xMLStreamWriter.writeCharacters("normal");
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

