/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.texture.TextureCoords;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.cache.GpuResourceCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.PickPointFrustum;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AnnotationRenderer;
import gov.nasa.worldwind.render.BasicAnnotationRenderer;
import gov.nasa.worldwind.render.BasicLightingModel;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GLRuntimeCapabilities;
import gov.nasa.worldwind.render.GeographicSurfaceTileRenderer;
import gov.nasa.worldwind.render.LightingModel;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.OutlinedShape;
import gov.nasa.worldwind.render.ScreenCredit;
import gov.nasa.worldwind.render.SurfaceTileRenderer;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.IntSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.PerformanceStatistic;
import gov.nasa.worldwind.util.PickPointFrustumList;
import gov.nasa.worldwind.util.SectorVisibilityTree;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.glu.GLU;

public class DrawContextImpl
extends WWObjectImpl
implements DrawContext {
    protected long frameTimestamp;
    protected GLContext glContext;
    protected GLRuntimeCapabilities glRuntimeCaps;
    protected GLU glu = new GLU();
    protected View view;
    protected Model model;
    protected Globe globe;
    protected double verticalExaggeration = 1.0;
    protected Sector visibleSector;
    protected SectorGeometryList surfaceGeometry;
    protected PickedObjectList pickedObjects = new PickedObjectList();
    protected PickedObjectList objectsInPickRect = new PickedObjectList();
    protected int uniquePickNumber = 0;
    protected Color clearColor = new Color(0, 0, 0, 0);
    protected ByteBuffer pixelColors;
    protected IntSet uniquePixelColors = new IntSet();
    protected boolean pickingMode = false;
    protected boolean deepPickingMode = false;
    protected Point pickPoint = null;
    protected Rectangle pickRect = null;
    protected boolean isOrderedRenderingMode = false;
    protected boolean preRenderMode = false;
    protected Point viewportCenterScreenPoint = null;
    protected Position viewportCenterPosition = null;
    protected SurfaceTileRenderer geographicSurfaceTileRenderer = new GeographicSurfaceTileRenderer();
    protected AnnotationRenderer annotationRenderer = new BasicAnnotationRenderer();
    protected GpuResourceCache gpuResourceCache;
    protected TextRendererCache textRendererCache;
    protected Set<String> perFrameStatisticsKeys;
    protected Collection<PerformanceStatistic> perFrameStatistics;
    protected SectorVisibilityTree visibleSectors;
    protected Layer currentLayer;
    protected int redrawRequested = 0;
    protected PickPointFrustumList pickFrustumList = new PickPointFrustumList();
    protected Collection<Throwable> renderingExceptions;
    protected Dimension pickPointFrustumDimension = new Dimension(3, 3);
    protected LightingModel standardLighting = new BasicLightingModel();
    protected PriorityQueue<OrderedRenderableEntry> orderedRenderables = new PriorityQueue<OrderedRenderableEntry>(100, new Comparator<OrderedRenderableEntry>(){

        @Override
        public int compare(OrderedRenderableEntry orderedRenderableEntry, OrderedRenderableEntry orderedRenderableEntry2) {
            double d = orderedRenderableEntry.distanceFromEye;
            double d2 = orderedRenderableEntry2.distanceFromEye;
            return d > d2 ? -1 : (d == d2 ? (orderedRenderableEntry.time < orderedRenderableEntry2.time ? -1 : (orderedRenderableEntry.time == orderedRenderableEntry2.time ? 0 : 1)) : 1);
        }
    });
    protected Queue<OrderedRenderable> orderedSurfaceRenderables = new ArrayDeque<OrderedRenderable>();
    protected LinkedHashMap<ScreenCredit, Long> credits = new LinkedHashMap();
    public static final float DEFAULT_DEPTH_OFFSET_FACTOR = 1.0f;
    public static final float DEFAULT_DEPTH_OFFSET_UNITS = 1.0f;
    protected Terrain terrain = new Terrain(){

        @Override
        public Globe getGlobe() {
            return DrawContextImpl.this.getGlobe();
        }

        @Override
        public double getVerticalExaggeration() {
            return DrawContextImpl.this.getVerticalExaggeration();
        }

        @Override
        public Vec4 getSurfacePoint(Position position) {
            if (position == null) {
                String string = Logging.getMessage("nullValue.PositionIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            SectorGeometryList sectorGeometryList = DrawContextImpl.this.getSurfaceGeometry();
            if (sectorGeometryList == null) {
                return null;
            }
            Vec4 vec4 = sectorGeometryList.getSurfacePoint(position);
            if (vec4 == null) {
                double d = this.getGlobe().getElevation(position.getLatitude(), position.getLongitude());
                vec4 = this.getGlobe().computePointFromPosition(position, position.getAltitude() + d * this.getVerticalExaggeration());
            }
            return vec4;
        }

        @Override
        public Vec4 getSurfacePoint(Angle angle, Angle angle2, double d) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.LatLonIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            SectorGeometryList sectorGeometryList = DrawContextImpl.this.getSurfaceGeometry();
            if (sectorGeometryList == null) {
                return null;
            }
            Vec4 vec4 = sectorGeometryList.getSurfacePoint(angle, angle2, d);
            if (vec4 == null) {
                double d2 = this.getGlobe().getElevation(angle, angle2);
                vec4 = this.getGlobe().computePointFromPosition(angle, angle2, d + d2 * this.getVerticalExaggeration());
            }
            return vec4;
        }

        @Override
        public Intersection[] intersect(Position position, Position position2) {
            SectorGeometryList sectorGeometryList = DrawContextImpl.this.getSurfaceGeometry();
            if (sectorGeometryList == null) {
                return null;
            }
            Vec4 vec4 = this.getSurfacePoint(position);
            Vec4 vec42 = this.getSurfacePoint(position2);
            if (position == null || position2 == null) {
                return null;
            }
            return sectorGeometryList.intersect(new Line(vec4, vec42.subtract3(vec4)));
        }

        @Override
        public Double getElevation(LatLon latLon) {
            if (latLon == null) {
                String string = Logging.getMessage("nullValue.LatLonIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            Vec4 vec4 = this.getSurfacePoint(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            if (vec4 == null) {
                return null;
            }
            Vec4 vec42 = this.getGlobe().computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0);
            return vec42.distanceTo3(vec4);
        }
    };

    @Override
    public void dispose() {
        this.geographicSurfaceTileRenderer.dispose();
    }

    @Override
    public final GL getGL() {
        return this.getGLContext().getGL();
    }

    @Override
    public final GLU getGLU() {
        return this.glu;
    }

    @Override
    public final GLContext getGLContext() {
        return this.glContext;
    }

    @Override
    public final int getDrawableHeight() {
        return this.getGLDrawable().getHeight();
    }

    @Override
    public final int getDrawableWidth() {
        return this.getGLDrawable().getWidth();
    }

    @Override
    public final GLDrawable getGLDrawable() {
        return this.getGLContext().getGLDrawable();
    }

    @Override
    public GLRuntimeCapabilities getGLRuntimeCapabilities() {
        return this.glRuntimeCaps;
    }

    @Override
    public void setGLRuntimeCapabilities(GLRuntimeCapabilities gLRuntimeCapabilities) {
        if (gLRuntimeCapabilities == null) {
            String string = Logging.getMessage("nullValue.GLRuntimeCapabilitiesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glRuntimeCaps = gLRuntimeCapabilities;
    }

    @Override
    public final void initialize(GLContext gLContext) {
        if (gLContext == null) {
            String string = Logging.getMessage("nullValue.GLContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glContext = gLContext;
        this.visibleSector = null;
        if (this.surfaceGeometry != null) {
            this.surfaceGeometry.clear();
        }
        this.surfaceGeometry = null;
        this.pickedObjects.clear();
        this.objectsInPickRect.clear();
        this.orderedRenderables.clear();
        this.orderedSurfaceRenderables.clear();
        this.uniquePickNumber = 0;
        this.deepPickingMode = false;
        this.redrawRequested = 0;
        this.pickFrustumList.clear();
        this.currentLayer = null;
    }

    @Override
    public final void setModel(Model model) {
        this.model = model;
        if (this.model == null) {
            return;
        }
        Globe globe = this.model.getGlobe();
        if (globe != null) {
            this.globe = globe;
        }
    }

    @Override
    public final Model getModel() {
        return this.model;
    }

    @Override
    public final LayerList getLayers() {
        return this.model.getLayers();
    }

    @Override
    public final Sector getVisibleSector() {
        return this.visibleSector;
    }

    @Override
    public final void setVisibleSector(Sector sector) {
        this.visibleSector = sector;
    }

    @Override
    public void setSurfaceGeometry(SectorGeometryList sectorGeometryList) {
        this.surfaceGeometry = sectorGeometryList;
    }

    @Override
    public SectorGeometryList getSurfaceGeometry() {
        return this.surfaceGeometry;
    }

    @Override
    public final Globe getGlobe() {
        return this.globe != null ? this.globe : this.model.getGlobe();
    }

    @Override
    public final void setView(View view) {
        this.view = view;
    }

    @Override
    public final View getView() {
        return this.view;
    }

    @Override
    public final void setGLContext(GLContext gLContext) {
        if (gLContext == null) {
            String string = Logging.getMessage("nullValue.GLContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glContext = gLContext;
    }

    @Override
    public final double getVerticalExaggeration() {
        return this.verticalExaggeration;
    }

    @Override
    public final void setVerticalExaggeration(double d) {
        this.verticalExaggeration = d;
    }

    @Override
    public GpuResourceCache getTextureCache() {
        return this.gpuResourceCache;
    }

    @Override
    public GpuResourceCache getGpuResourceCache() {
        return this.gpuResourceCache;
    }

    @Override
    public void setGpuResourceCache(GpuResourceCache gpuResourceCache) {
        if (gpuResourceCache == null) {
            String string = Logging.getMessage("nullValue.GpuResourceCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.gpuResourceCache = gpuResourceCache;
    }

    @Override
    public TextRendererCache getTextRendererCache() {
        return this.textRendererCache;
    }

    @Override
    public void setTextRendererCache(TextRendererCache textRendererCache) {
        if (textRendererCache == null) {
            String string = Logging.getMessage("nullValue.TextRendererCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.textRendererCache = textRendererCache;
    }

    @Override
    public AnnotationRenderer getAnnotationRenderer() {
        return this.annotationRenderer;
    }

    @Override
    public void setAnnotationRenderer(AnnotationRenderer annotationRenderer) {
        if (annotationRenderer == null) {
            String string = Logging.getMessage("nullValue.RendererIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.annotationRenderer = annotationRenderer;
    }

    @Override
    public LightingModel getStandardLightingModel() {
        return this.standardLighting;
    }

    @Override
    public void setStandardLightingModel(LightingModel lightingModel) {
        this.standardLighting = lightingModel;
    }

    @Override
    public Point getPickPoint() {
        return this.pickPoint;
    }

    @Override
    public void setPickPoint(Point point) {
        this.pickPoint = point;
    }

    @Override
    public Rectangle getPickRectangle() {
        return this.pickRect;
    }

    @Override
    public void setPickRectangle(Rectangle rectangle) {
        this.pickRect = rectangle;
    }

    @Override
    public Point getViewportCenterScreenPoint() {
        return this.viewportCenterScreenPoint;
    }

    @Override
    public void setViewportCenterScreenPoint(Point point) {
        this.viewportCenterScreenPoint = point;
    }

    @Override
    public Position getViewportCenterPosition() {
        return this.viewportCenterPosition;
    }

    @Override
    public void setViewportCenterPosition(Position position) {
        this.viewportCenterPosition = position;
    }

    @Override
    public void addPickedObjects(PickedObjectList pickedObjectList) {
        if (pickedObjectList == null) {
            String string = Logging.getMessage("nullValue.PickedObjectList");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.pickedObjects == null) {
            this.pickedObjects = pickedObjectList;
            return;
        }
        for (PickedObject pickedObject : pickedObjectList) {
            this.pickedObjects.add(pickedObject);
        }
    }

    @Override
    public void addPickedObject(PickedObject pickedObject) {
        if (null == pickedObject) {
            String string = Logging.getMessage("nullValue.PickedObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (null == this.pickedObjects) {
            this.pickedObjects = new PickedObjectList();
        }
        this.pickedObjects.add(pickedObject);
    }

    @Override
    public PickedObjectList getPickedObjects() {
        return this.pickedObjects;
    }

    @Override
    public PickedObjectList getObjectsInPickRectangle() {
        return this.objectsInPickRect;
    }

    @Override
    public void addObjectInPickRectangle(PickedObject pickedObject) {
        if (pickedObject == null) {
            String string = Logging.getMessage("nullValue.PickedObject");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.objectsInPickRect.add(pickedObject);
    }

    @Override
    public Color getUniquePickColor() {
        ++this.uniquePickNumber;
        int n = this.getClearColor().getRGB();
        if (n == this.uniquePickNumber) {
            ++this.uniquePickNumber;
        }
        if (this.uniquePickNumber >= 0xFFFFFF) {
            this.uniquePickNumber = 1;
            if (n == this.uniquePickNumber) {
                ++this.uniquePickNumber;
            }
        }
        return new Color(this.uniquePickNumber, true);
    }

    @Override
    public Color getClearColor() {
        return this.clearColor;
    }

    @Override
    public int getPickColorAtPoint(Point point) {
        if (point == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Rectangle rectangle = this.getView().getViewport();
        int n = point.x;
        int n2 = rectangle.height - point.y - 1;
        if (this.pixelColors == null || this.pixelColors.capacity() < 3) {
            this.pixelColors = BufferUtil.newByteBuffer((int)3);
        }
        this.pixelColors.clear();
        this.getGL().glReadPixels(n, n2, 1, 1, 6407, 5121, (Buffer)this.pixelColors);
        int n3 = (this.pixelColors.get(0) & 0xFF) << 16 | (this.pixelColors.get(1) & 0xFF) << 8 | this.pixelColors.get(2) & 0xFF;
        return n3 != this.clearColor.getRGB() ? n3 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPickColorsInRectangle(Rectangle rectangle, int[] nArray) {
        if (rectangle == null) {
            String string = Logging.getMessage("nullValue.RectangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Rectangle rectangle2 = this.getView().getViewport();
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle2.height - rectangle.y - 1, rectangle.width, rectangle.height);
        if ((rectangle3 = rectangle3.intersection(rectangle2)).isEmpty()) {
            return null;
        }
        if (nArray == null) {
            nArray = new int[]{0, Integer.MAX_VALUE};
        }
        int n = rectangle3.width * rectangle3.height;
        if (this.pixelColors == null || this.pixelColors.capacity() < 3 * n) {
            this.pixelColors = BufferUtil.newByteBuffer((int)(3 * n));
        }
        this.pixelColors.clear();
        GL gL = this.getGL();
        int[] nArray2 = new int[1];
        gL.glGetIntegerv(3333, nArray2, 0);
        try {
            gL.glPixelStorei(3333, 1);
            gL.glReadPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, 6407, 5121, (Buffer)this.pixelColors);
        }
        finally {
            gL.glPixelStorei(3333, nArray2[0]);
        }
        int n2 = this.clearColor.getRGB();
        for (int i = 0; i < n; ++i) {
            int n3 = (this.pixelColors.get() & 0xFF) << 16 | (this.pixelColors.get() & 0xFF) << 8 | this.pixelColors.get() & 0xFF;
            if (n3 == n2 || n3 < nArray[0] || n3 > nArray[1]) continue;
            this.uniquePixelColors.add(n3);
        }
        int[] nArray3 = new int[this.uniquePixelColors.size()];
        this.uniquePixelColors.toArray(nArray3);
        this.uniquePixelColors.clear();
        return nArray3;
    }

    @Override
    public boolean isPickingMode() {
        return this.pickingMode;
    }

    @Override
    public void enablePickingMode() {
        this.pickingMode = true;
    }

    @Override
    public void disablePickingMode() {
        this.pickingMode = false;
    }

    @Override
    public boolean isDeepPickingEnabled() {
        return this.deepPickingMode;
    }

    @Override
    public void setDeepPickingEnabled(boolean bl) {
        this.deepPickingMode = bl;
    }

    @Override
    public boolean isPreRenderMode() {
        return this.preRenderMode;
    }

    @Override
    public void setPreRenderMode(boolean bl) {
        this.preRenderMode = bl;
    }

    @Override
    public boolean isOrderedRenderingMode() {
        return this.isOrderedRenderingMode;
    }

    @Override
    public void setOrderedRenderingMode(boolean bl) {
        this.isOrderedRenderingMode = bl;
    }

    @Override
    public void addOrderedRenderable(OrderedRenderable orderedRenderable) {
        if (null == orderedRenderable) {
            String string = Logging.getMessage("nullValue.OrderedRenderable");
            Logging.logger().warning(string);
            return;
        }
        this.orderedRenderables.add(new OrderedRenderableEntry(orderedRenderable, System.nanoTime()));
    }

    @Override
    public void addOrderedRenderable(OrderedRenderable orderedRenderable, boolean bl) {
        if (null == orderedRenderable) {
            String string = Logging.getMessage("nullValue.OrderedRenderable");
            Logging.logger().warning(string);
            return;
        }
        double d = bl ? Double.MAX_VALUE : orderedRenderable.getDistanceFromEye();
        this.orderedRenderables.add(new OrderedRenderableEntry(orderedRenderable, d, System.nanoTime()));
    }

    @Override
    public OrderedRenderable peekOrderedRenderables() {
        OrderedRenderableEntry orderedRenderableEntry = this.orderedRenderables.peek();
        return orderedRenderableEntry != null ? orderedRenderableEntry.or : null;
    }

    @Override
    public OrderedRenderable pollOrderedRenderables() {
        OrderedRenderableEntry orderedRenderableEntry = this.orderedRenderables.poll();
        return orderedRenderableEntry != null ? orderedRenderableEntry.or : null;
    }

    @Override
    public void addOrderedSurfaceRenderable(OrderedRenderable orderedRenderable) {
        if (orderedRenderable == null) {
            String string = Logging.getMessage("nullValue.OrderedRenderable");
            Logging.logger().warning(string);
            return;
        }
        this.orderedSurfaceRenderables.add(orderedRenderable);
    }

    @Override
    public Queue<OrderedRenderable> getOrderedSurfaceRenderables() {
        return this.orderedSurfaceRenderables;
    }

    @Override
    public void drawUnitQuad() {
        GL gL = this.getGL();
        gL.glBegin(7);
        gL.glVertex2d(0.0, 0.0);
        gL.glVertex2d(1.0, 0.0);
        gL.glVertex2d(1.0, 1.0);
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public void drawUnitQuad(TextureCoords textureCoords) {
        GL gL = this.getGL();
        gL.glBegin(7);
        gL.glTexCoord2d((double)textureCoords.left(), (double)textureCoords.bottom());
        gL.glVertex2d(0.0, 0.0);
        gL.glTexCoord2d((double)textureCoords.right(), (double)textureCoords.bottom());
        gL.glVertex2d(1.0, 0.0);
        gL.glTexCoord2d((double)textureCoords.right(), (double)textureCoords.top());
        gL.glVertex2d(1.0, 1.0);
        gL.glTexCoord2d((double)textureCoords.left(), (double)textureCoords.top());
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public void drawUnitQuadOutline() {
        GL gL = this.getGL();
        gL.glBegin(2);
        gL.glVertex2d(0.0, 0.0);
        gL.glVertex2d(1.0, 0.0);
        gL.glVertex2d(1.0, 1.0);
        gL.glVertex2d(0.0, 1.0);
        gL.glEnd();
    }

    @Override
    public void drawNormals(float f, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (floatBuffer == null || floatBuffer2 == null) {
            return;
        }
        GL gL = this.getGL();
        floatBuffer.rewind();
        floatBuffer2.rewind();
        gL.glBegin(1);
        while (floatBuffer2.hasRemaining()) {
            float f2 = floatBuffer.get();
            float f3 = floatBuffer.get();
            float f4 = floatBuffer.get();
            float f5 = floatBuffer2.get() * f;
            float f6 = floatBuffer2.get() * f;
            float f7 = floatBuffer2.get() * f;
            gL.glVertex3f(f2, f3, f4);
            gL.glVertex3f(f2 + f5, f3 + f6, f4 + f7);
        }
        gL.glEnd();
    }

    @Override
    public Vec4 getPointOnTerrain(Angle angle, Angle angle2) {
        Vec4 vec4;
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.getVisibleSector() == null) {
            return null;
        }
        if (!this.getVisibleSector().contains(angle, angle2)) {
            return null;
        }
        SectorGeometryList sectorGeometryList = this.getSurfaceGeometry();
        if (sectorGeometryList != null && (vec4 = sectorGeometryList.getSurfacePoint(angle, angle2)) != null) {
            return vec4;
        }
        return null;
    }

    @Override
    public SurfaceTileRenderer getGeographicSurfaceTileRenderer() {
        return this.geographicSurfaceTileRenderer;
    }

    @Override
    public Collection<PerformanceStatistic> getPerFrameStatistics() {
        return this.perFrameStatistics;
    }

    @Override
    public void setPerFrameStatisticsKeys(Set<String> set, Collection<PerformanceStatistic> collection) {
        this.perFrameStatisticsKeys = set;
        this.perFrameStatistics = collection;
    }

    @Override
    public Set<String> getPerFrameStatisticsKeys() {
        return this.perFrameStatisticsKeys;
    }

    @Override
    public void setPerFrameStatistic(String string, String string2, Object object) {
        if (this.perFrameStatistics == null || this.perFrameStatisticsKeys == null) {
            return;
        }
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.KeyIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (string2 == null) {
            String string4 = Logging.getMessage("nullValue.DisplayNameIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.perFrameStatisticsKeys.contains(string) || this.perFrameStatisticsKeys.contains("gov.nasa.worldwind.perfstat.All")) {
            this.perFrameStatistics.add(new PerformanceStatistic(string, string2, object));
        }
    }

    @Override
    public void setPerFrameStatistics(Collection<PerformanceStatistic> collection) {
        if (collection == null) {
            String string = Logging.getMessage("nullValue.ListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.perFrameStatistics == null || this.perFrameStatisticsKeys == null) {
            return;
        }
        for (PerformanceStatistic performanceStatistic : collection) {
            this.perFrameStatistics.add(performanceStatistic);
        }
    }

    @Override
    public long getFrameTimeStamp() {
        return this.frameTimestamp;
    }

    @Override
    public void setFrameTimeStamp(long l) {
        this.frameTimestamp = l;
    }

    @Override
    public List<Sector> getVisibleSectors(double[] dArray, long l, Sector sector) {
        if (dArray == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (l <= 0L) {
            String string = Logging.getMessage("generic.TimeNegative", l);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (sector == null) {
            sector = this.visibleSector;
        }
        if (this.visibleSectors == null) {
            this.visibleSectors = new SectorVisibilityTree();
        } else if (this.visibleSectors.getSectorSize() == dArray[dArray.length - 1] && this.visibleSectors.getTimeStamp() == this.frameTimestamp) {
            return this.visibleSectors.getSectors();
        }
        long l2 = System.currentTimeMillis();
        List<Sector> list = this.visibleSectors.refresh((DrawContext)this, dArray[0], sector);
        for (int i = 1; i < dArray.length && System.currentTimeMillis() < l2 + l; ++i) {
            list = this.visibleSectors.refresh((DrawContext)this, dArray[i], list);
        }
        this.visibleSectors.setTimeStamp(this.frameTimestamp);
        return this.visibleSectors.getSectors();
    }

    @Override
    public void setCurrentLayer(Layer layer) {
        this.currentLayer = layer;
    }

    @Override
    public Layer getCurrentLayer() {
        return this.currentLayer;
    }

    @Override
    public void addScreenCredit(ScreenCredit screenCredit) {
        if (screenCredit == null) {
            String string = Logging.getMessage("nullValue.ScreenCreditIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.credits.put(screenCredit, this.frameTimestamp);
    }

    @Override
    public Map<ScreenCredit, Long> getScreenCredits() {
        return this.credits;
    }

    @Override
    public int getRedrawRequested() {
        return this.redrawRequested;
    }

    @Override
    public void setRedrawRequested(int n) {
        this.redrawRequested = n;
    }

    @Override
    public PickPointFrustumList getPickFrustums() {
        return this.pickFrustumList;
    }

    @Override
    public void setPickPointFrustumDimension(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dimension.width < 3 || dimension.height < 3) {
            String string = Logging.getMessage("DrawContext.PickPointFrustumDimensionTooSmall");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickPointFrustumDimension = new Dimension(dimension);
    }

    @Override
    public Dimension getPickPointFrustumDimension() {
        return this.pickPointFrustumDimension;
    }

    @Override
    public void addPickPointFrustum() {
        if (this.getPickPoint() != null) {
            Rectangle rectangle = this.getView().getViewport();
            double d = rectangle.getWidth() <= 0.0 ? 1.0 : rectangle.getWidth();
            double d2 = rectangle.getHeight() <= 0.0 ? 1.0 : rectangle.getHeight();
            Point point = new Point(this.getPickPoint());
            point.y = (int)d2 - point.y;
            point.translate((int)(-d / 2.0), (int)(-d2 / 2.0));
            int n = this.pickPointFrustumDimension.width / 2;
            int n2 = this.pickPointFrustumDimension.height / 2;
            if (n == 0 || n2 == 0) {
                return;
            }
            double d3 = this.getView().getFieldOfView().tanHalfAngle() * this.getView().getNearClipDistance();
            double d4 = d3 / (d / 2.0);
            double d5 = this.getView().getNearClipDistance() / d4;
            Vec4 vec4 = new Vec4(point.x - n, point.y + n2, -d5);
            Vec4 vec42 = new Vec4(point.x + n, point.y + n2, -d5);
            Vec4 vec43 = new Vec4(point.x - n, point.y - n2, -d5);
            Vec4 vec44 = new Vec4(point.x + n, point.y - n2, -d5);
            Frustum frustum = Frustum.fromPerspectiveVecs(vec4, vec42, vec43, vec44, this.getView().getNearClipDistance(), this.getView().getFarClipDistance());
            Rectangle rectangle2 = new Rectangle(this.getPickPoint().x - n, (int)d2 - this.getPickPoint().y - n2, this.pickPointFrustumDimension.width, this.pickPointFrustumDimension.height);
            Matrix matrix = this.getView().getModelviewMatrix().getTranspose();
            if (matrix != null) {
                frustum = frustum.transformBy(matrix);
            }
            this.pickFrustumList.add(new PickPointFrustum(frustum, rectangle2));
        }
    }

    @Override
    public void addPickRectangleFrustum() {
        if (this.getPickRectangle() == null || this.getPickRectangle().isEmpty()) {
            return;
        }
        View view = this.getView();
        Rectangle rectangle = view.getViewport();
        double d = rectangle.getWidth() <= 0.0 ? 1.0 : rectangle.getWidth();
        double d2 = rectangle.getHeight() <= 0.0 ? 1.0 : rectangle.getHeight();
        Rectangle rectangle2 = new Rectangle(this.getPickRectangle());
        rectangle2.y = (int)d2 - rectangle2.y;
        rectangle2.translate((int)(-d / 2.0), (int)(-d2 / 2.0));
        double d3 = d / (2.0 * view.getFieldOfView().tanHalfAngle());
        Vec4 vec4 = new Vec4(rectangle2.getMinX(), rectangle2.getMaxY(), -d3);
        Vec4 vec42 = new Vec4(rectangle2.getMaxX(), rectangle2.getMaxY(), -d3);
        Vec4 vec43 = new Vec4(rectangle2.getMinX(), rectangle2.getMinY(), -d3);
        Vec4 vec44 = new Vec4(rectangle2.getMaxX(), rectangle2.getMinY(), -d3);
        Frustum frustum = Frustum.fromPerspectiveVecs(vec4, vec42, vec43, vec44, view.getNearClipDistance(), view.getFarClipDistance());
        Matrix matrix = view.getModelviewMatrix().getTranspose();
        if (matrix != null) {
            frustum = frustum.transformBy(matrix);
        }
        Rectangle rectangle3 = new Rectangle(this.getPickRectangle());
        rectangle3.y = (int)d2 - rectangle3.y;
        this.pickFrustumList.add(new PickPointFrustum(frustum, rectangle3));
    }

    @Override
    public Collection<Throwable> getRenderingExceptions() {
        return this.renderingExceptions;
    }

    @Override
    public void setRenderingExceptions(Collection<Throwable> collection) {
        this.renderingExceptions = collection;
    }

    @Override
    public void addRenderingException(Throwable throwable) {
        if (this.renderingExceptions == null) {
            return;
        }
        if (throwable == null) {
            String string = Logging.getMessage("nullValue.ThrowableIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.renderingExceptions.add(throwable);
    }

    @Override
    public void pushProjectionOffest(Double d) {
        GL gL = this.getGL();
        float[] fArray = new float[16];
        gL.glGetFloatv(2983, fArray, 0);
        fArray[10] = (float)((double)fArray[10] * (d != null ? d : 0.99));
        gL.glPushAttrib(4096);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadMatrixf(fArray, 0);
    }

    @Override
    public void popProjectionOffest() {
        GL gL = this.getGL();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawOutlinedShape(OutlinedShape outlinedShape, Object object) {
        GL gL = this.getGL();
        if (this.isDeepPickingEnabled()) {
            if (outlinedShape.isDrawInterior(this, object)) {
                outlinedShape.drawInterior(this, object);
            }
            if (outlinedShape.isDrawOutline(this, object)) {
                outlinedShape.drawOutline(this, object);
            }
            return;
        }
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        int n = 16648;
        oGLStackHandler.pushAttrib(gL, n);
        try {
            gL.glEnable(2929);
            gL.glDepthFunc(515);
            if (outlinedShape.isDrawOutline(this, object) && outlinedShape.isDrawInterior(this, object)) {
                gL.glColorMask(true, true, true, true);
                gL.glDepthMask(false);
                outlinedShape.drawOutline(this, object);
            }
            if (outlinedShape.isDrawInterior(this, object)) {
                if (outlinedShape.isEnableDepthOffset(this, object)) {
                    gL.glColorMask(false, false, false, false);
                    gL.glDepthMask(true);
                    gL.glEnable(32823);
                    Double d = outlinedShape.getDepthOffsetFactor(this, object);
                    Double d2 = outlinedShape.getDepthOffsetUnits(this, object);
                    gL.glPolygonOffset(d != null ? d.floatValue() : 1.0f, d2 != null ? d2.floatValue() : 1.0f);
                    outlinedShape.drawInterior(this, object);
                    gL.glColorMask(true, true, true, true);
                    gL.glDepthMask(false);
                    gL.glDisable(32823);
                    outlinedShape.drawInterior(this, object);
                } else {
                    gL.glColorMask(true, true, true, true);
                    gL.glDepthMask(true);
                    outlinedShape.drawInterior(this, object);
                }
            }
            if (outlinedShape.isDrawOutline(this, object)) {
                gL.glColorMask(true, true, true, true);
                gL.glDepthMask(true);
                outlinedShape.drawOutline(this, object);
            }
        }
        finally {
            oGLStackHandler.pop(gL);
        }
    }

    @Override
    public void beginStandardLighting() {
        if (this.standardLighting != null) {
            this.standardLighting.beginLighting(this);
            this.getGL().glEnable(2896);
        }
    }

    @Override
    public void endStandardLighting() {
        if (this.standardLighting != null) {
            this.standardLighting.endLighting(this);
        }
    }

    @Override
    public boolean isSmall(Extent extent, int n) {
        return extent != null && extent.getDiameter() <= (double)n * this.getView().computePixelSizeAtDistance(this.getView().getEyePoint().distanceTo3(extent.getCenter()));
    }

    @Override
    public Terrain getTerrain() {
        return this.terrain;
    }

    @Override
    public Vec4 computeTerrainPoint(Angle angle, Angle angle2, double d) {
        return this.getTerrain().getSurfacePoint(angle, angle2, d);
    }

    @Override
    public void restoreDefaultBlending() {
        this.getGL().glBlendFunc(1, 0);
        this.getGL().glDisable(3042);
    }

    @Override
    public void restoreDefaultCurrentColor() {
        this.getGL().glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void restoreDefaultDepthTesting() {
        this.getGL().glEnable(2929);
        this.getGL().glDepthMask(true);
    }

    @Override
    public Vec4 computePointFromPosition(Position position, int n) {
        Vec4 vec4;
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n == 1) {
            vec4 = this.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        } else if (n == 2) {
            vec4 = this.computeTerrainPoint(position.getLatitude(), position.getLongitude(), position.getAltitude());
        } else {
            double d = position.getElevation() * this.getVerticalExaggeration();
            vec4 = this.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        }
        return vec4;
    }

    protected static class OrderedRenderableEntry {
        protected OrderedRenderable or;
        protected double distanceFromEye;
        protected long time;

        public OrderedRenderableEntry(OrderedRenderable orderedRenderable, long l) {
            this.or = orderedRenderable;
            this.distanceFromEye = orderedRenderable.getDistanceFromEye();
            this.time = l;
        }

        public OrderedRenderableEntry(OrderedRenderable orderedRenderable, double d, long l) {
            this.or = orderedRenderable;
            this.distanceFromEye = d;
            this.time = l;
        }
    }
}

