/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class BasicShapeAttributes
implements ShapeAttributes {
    protected boolean unresolved;
    protected boolean drawInterior;
    protected boolean drawOutline;
    protected boolean enableAntialiasing;
    protected boolean enableLighting;
    protected Material interiorMaterial;
    protected Material outlineMaterial;
    protected double interiorOpacity;
    protected double outlineOpacity;
    protected double outlineWidth;
    protected int outlineStippleFactor;
    protected short outlineStipplePattern;
    protected Object imageSource;
    protected double imageScale;

    public BasicShapeAttributes() {
        this.drawInterior = true;
        this.drawOutline = true;
        this.enableAntialiasing = true;
        this.enableLighting = false;
        this.interiorMaterial = Material.WHITE;
        this.outlineMaterial = Material.BLACK;
        this.interiorOpacity = 1.0;
        this.outlineOpacity = 1.0;
        this.outlineWidth = 1.0;
        this.outlineStippleFactor = 0;
        this.outlineStipplePattern = (short)-3856;
        this.imageSource = null;
        this.imageScale = 1.0;
    }

    public BasicShapeAttributes(ShapeAttributes shapeAttributes) {
        if (shapeAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.drawInterior = shapeAttributes.isDrawInterior();
        this.drawOutline = shapeAttributes.isDrawOutline();
        this.enableAntialiasing = shapeAttributes.isEnableAntialiasing();
        this.enableLighting = shapeAttributes.isEnableLighting();
        this.interiorMaterial = shapeAttributes.getInteriorMaterial();
        this.outlineMaterial = shapeAttributes.getOutlineMaterial();
        this.interiorOpacity = shapeAttributes.getInteriorOpacity();
        this.outlineOpacity = shapeAttributes.getOutlineOpacity();
        this.outlineWidth = shapeAttributes.getOutlineWidth();
        this.outlineStippleFactor = shapeAttributes.getOutlineStippleFactor();
        this.outlineStipplePattern = shapeAttributes.getOutlineStipplePattern();
        this.imageSource = shapeAttributes.getImageSource();
        this.imageScale = shapeAttributes.getImageScale();
    }

    @Override
    public ShapeAttributes copy() {
        return new BasicShapeAttributes(this);
    }

    @Override
    public void copy(ShapeAttributes shapeAttributes) {
        if (shapeAttributes != null) {
            this.drawInterior = shapeAttributes.isDrawInterior();
            this.drawOutline = shapeAttributes.isDrawOutline();
            this.enableAntialiasing = shapeAttributes.isEnableAntialiasing();
            this.enableLighting = shapeAttributes.isEnableLighting();
            this.interiorMaterial = shapeAttributes.getInteriorMaterial();
            this.outlineMaterial = shapeAttributes.getOutlineMaterial();
            this.interiorOpacity = shapeAttributes.getInteriorOpacity();
            this.outlineOpacity = shapeAttributes.getOutlineOpacity();
            this.outlineWidth = shapeAttributes.getOutlineWidth();
            this.outlineStippleFactor = shapeAttributes.getOutlineStippleFactor();
            this.outlineStipplePattern = shapeAttributes.getOutlineStipplePattern();
            this.imageSource = shapeAttributes.getImageSource();
            this.imageScale = shapeAttributes.getImageScale();
        }
    }

    @Override
    public boolean isUnresolved() {
        return this.unresolved;
    }

    @Override
    public void setUnresolved(boolean bl) {
        this.unresolved = bl;
    }

    @Override
    public boolean isDrawInterior() {
        return this.drawInterior;
    }

    @Override
    public void setDrawInterior(boolean bl) {
        this.drawInterior = bl;
    }

    @Override
    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    @Override
    public void setDrawOutline(boolean bl) {
        this.drawOutline = bl;
    }

    @Override
    public boolean isEnableAntialiasing() {
        return this.enableAntialiasing;
    }

    @Override
    public void setEnableAntialiasing(boolean bl) {
        this.enableAntialiasing = bl;
    }

    @Override
    public boolean isEnableLighting() {
        return this.enableLighting;
    }

    @Override
    public void setEnableLighting(boolean bl) {
        this.enableLighting = bl;
    }

    @Override
    public Material getInteriorMaterial() {
        return this.interiorMaterial;
    }

    @Override
    public void setInteriorMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorMaterial = material;
    }

    @Override
    public Material getOutlineMaterial() {
        return this.outlineMaterial;
    }

    @Override
    public void setOutlineMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineMaterial = material;
    }

    @Override
    public double getInteriorOpacity() {
        return this.interiorOpacity;
    }

    @Override
    public void setInteriorOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.interiorOpacity = d;
    }

    @Override
    public double getOutlineOpacity() {
        return this.outlineOpacity;
    }

    @Override
    public void setOutlineOpacity(double d) {
        if (d < 0.0 || d > 1.0) {
            String string = Logging.getMessage("generic.OpacityOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineOpacity = d;
    }

    @Override
    public double getOutlineWidth() {
        return this.outlineWidth;
    }

    @Override
    public void setOutlineWidth(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("Geom.WidthIsNegative", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineWidth = d;
    }

    @Override
    public int getOutlineStippleFactor() {
        return this.outlineStippleFactor;
    }

    @Override
    public void setOutlineStippleFactor(int n) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "factor < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.outlineStippleFactor = n;
    }

    @Override
    public short getOutlineStipplePattern() {
        return this.outlineStipplePattern;
    }

    @Override
    public void setOutlineStipplePattern(short s) {
        this.outlineStipplePattern = s;
    }

    @Override
    public Object getImageSource() {
        return this.imageSource;
    }

    @Override
    public void setImageSource(Object object) {
        this.imageSource = object;
    }

    @Override
    public double getImageScale() {
        return this.imageScale;
    }

    @Override
    public void setImageScale(double d) {
        if (d <= 0.0) {
            String string = Logging.getMessage("generic.ScaleOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageScale = d;
    }

    @Override
    public void getRestorableState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        if (restorableSupport == null) {
            String string = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        restorableSupport.addStateValueAsBoolean(stateObject, "drawInterior", this.isDrawInterior());
        restorableSupport.addStateValueAsBoolean(stateObject, "drawOutline", this.isDrawOutline());
        restorableSupport.addStateValueAsBoolean(stateObject, "enableAntialiasing", this.isEnableAntialiasing());
        this.getInteriorMaterial().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "interiorMaterial"));
        this.getOutlineMaterial().getRestorableState(restorableSupport, restorableSupport.addStateObject(stateObject, "outlineMaterial"));
        restorableSupport.addStateValueAsDouble(stateObject, "interiorOpacity", this.getInteriorOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "outlineOpacity", this.getOutlineOpacity());
        restorableSupport.addStateValueAsDouble(stateObject, "outlineWidth", this.getOutlineWidth());
        restorableSupport.addStateValueAsInteger(stateObject, "outlineStippleFactor", this.getOutlineStippleFactor());
        restorableSupport.addStateValueAsInteger(stateObject, "outlineStipplePattern", this.getOutlineStipplePattern());
        if (this.getImageSource() != null && this.getImageSource() instanceof String) {
            restorableSupport.addStateValueAsString(stateObject, "interiorImagePath", (String)this.getImageSource());
        }
        restorableSupport.addStateValueAsDouble(stateObject, "interiorImageScale", this.getImageScale());
    }

    @Override
    public void restoreState(RestorableSupport restorableSupport, RestorableSupport.StateObject stateObject) {
        String string;
        Integer n;
        Double d;
        RestorableSupport.StateObject stateObject2;
        if (restorableSupport == null) {
            String string2 = Logging.getMessage("nullValue.RestorableSupportIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        Boolean bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawInterior");
        if (bl != null) {
            this.setDrawInterior(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "drawOutline")) != null) {
            this.setDrawOutline(bl);
        }
        if ((bl = restorableSupport.getStateValueAsBoolean(stateObject, "enableAntialiasing")) != null) {
            this.setEnableAntialiasing(bl);
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "interiorMaterial")) != null) {
            this.setInteriorMaterial(this.getInteriorMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((stateObject2 = restorableSupport.getStateObject(stateObject, "outlineMaterial")) != null) {
            this.setOutlineMaterial(this.getOutlineMaterial().restoreState(restorableSupport, stateObject2));
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "interiorOpacity")) != null) {
            this.setInteriorOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outlineOpacity")) != null) {
            this.setOutlineOpacity(d);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "outlineWidth")) != null) {
            this.setOutlineWidth(d);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "outlineStippleFactor")) != null) {
            this.setOutlineStippleFactor(n);
        }
        if ((n = restorableSupport.getStateValueAsInteger(stateObject, "outlineStipplePattern")) != null) {
            this.setOutlineStipplePattern(n.shortValue());
        }
        if ((string = restorableSupport.getStateValueAsString(stateObject, "interiorImagePath")) != null) {
            this.setImageSource(string);
        }
        if ((d = restorableSupport.getStateValueAsDouble(stateObject, "interiorImageScale")) != null) {
            this.setImageScale(d);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasicShapeAttributes basicShapeAttributes = (BasicShapeAttributes)object;
        if (this.unresolved != basicShapeAttributes.unresolved) {
            return false;
        }
        if (this.drawInterior != basicShapeAttributes.drawInterior) {
            return false;
        }
        if (this.drawOutline != basicShapeAttributes.drawOutline) {
            return false;
        }
        if (this.enableAntialiasing != basicShapeAttributes.enableAntialiasing) {
            return false;
        }
        if (this.enableLighting != basicShapeAttributes.enableLighting) {
            return false;
        }
        if (this.interiorMaterial != null ? !this.interiorMaterial.equals(basicShapeAttributes.interiorMaterial) : basicShapeAttributes.interiorMaterial != null) {
            return false;
        }
        if (this.outlineMaterial != null ? !this.outlineMaterial.equals(basicShapeAttributes.outlineMaterial) : basicShapeAttributes.outlineMaterial != null) {
            return false;
        }
        if (Double.compare(this.interiorOpacity, basicShapeAttributes.interiorOpacity) != 0) {
            return false;
        }
        if (Double.compare(this.outlineOpacity, basicShapeAttributes.outlineOpacity) != 0) {
            return false;
        }
        if (Double.compare(this.outlineWidth, basicShapeAttributes.outlineWidth) != 0) {
            return false;
        }
        if (this.outlineStippleFactor != basicShapeAttributes.outlineStippleFactor) {
            return false;
        }
        if (this.outlineStipplePattern != basicShapeAttributes.outlineStipplePattern) {
            return false;
        }
        if (this.imageSource != null ? !this.imageSource.equals(basicShapeAttributes.imageSource) : basicShapeAttributes.imageSource != null) {
            return false;
        }
        return Double.compare(this.imageScale, basicShapeAttributes.imageScale) == 0;
    }

    public int hashCode() {
        int n = this.unresolved ? 1 : 0;
        n = 31 * n + (this.drawInterior ? 1 : 0);
        n = 31 * n + (this.drawOutline ? 1 : 0);
        n = 31 * n + (this.enableAntialiasing ? 1 : 0);
        n = 31 * n + (this.enableLighting ? 1 : 0);
        n = 31 * n + (this.interiorMaterial != null ? this.interiorMaterial.hashCode() : 0);
        n = 31 * n + (this.outlineMaterial != null ? this.outlineMaterial.hashCode() : 0);
        long l = this.interiorOpacity != 0.0 ? Double.doubleToLongBits(this.interiorOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.outlineOpacity != 0.0 ? Double.doubleToLongBits(this.outlineOpacity) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        l = this.outlineWidth != 0.0 ? Double.doubleToLongBits(this.outlineWidth) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        n = 31 * n + this.outlineStippleFactor;
        n = 31 * n + this.outlineStipplePattern;
        n = 31 * n + (this.imageSource != null ? this.imageSource.hashCode() : 0);
        l = this.imageScale != 0.0 ? Double.doubleToLongBits(this.imageScale) : 0L;
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    @Override
    public String isExportFormatSupported(String string) {
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            return "Export.FormatSupported";
        }
        return "Export.FormatNotSupported";
    }

    @Override
    public void export(String string, Object object) throws IOException, UnsupportedOperationException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (object == null) {
            String string3 = Logging.getMessage("nullValue.OutputBufferIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if ("application/vnd.google-earth.kml+xml".equalsIgnoreCase(string)) {
            try {
                this.exportAsKML(object);
            }
            catch (XMLStreamException xMLStreamException) {
                Logging.logger().throwing(this.getClass().getName(), "export", xMLStreamException);
                throw new IOException(xMLStreamException);
            }
        } else {
            String string4 = Logging.getMessage("Export.UnsupportedFormat", string);
            Logging.logger().warning(string4);
            throw new UnsupportedOperationException(string4);
        }
    }

    protected void exportAsKML(Object object) throws XMLStreamException {
        Double d;
        XMLStreamWriter xMLStreamWriter = null;
        XMLOutputFactory xMLOutputFactory = XMLOutputFactory.newInstance();
        boolean bl = true;
        if (object instanceof XMLStreamWriter) {
            xMLStreamWriter = (XMLStreamWriter)object;
            bl = false;
        } else if (object instanceof Writer) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((Writer)object);
        } else if (object instanceof OutputStream) {
            xMLStreamWriter = xMLOutputFactory.createXMLStreamWriter((OutputStream)object);
        }
        if (xMLStreamWriter == null) {
            String string = Logging.getMessage("Export.UnsupportedOutputObject");
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        xMLStreamWriter.writeStartElement("Style");
        xMLStreamWriter.writeStartElement("LineStyle");
        Color color = this.getOutlineMaterial().getDiffuse();
        if (color != null) {
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(KMLExportUtil.stripHexPrefix(WWUtil.encodeColorABGR(color)));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("colorMode");
            xMLStreamWriter.writeCharacters("normal");
            xMLStreamWriter.writeEndElement();
        }
        if ((d = Double.valueOf(this.getOutlineWidth())) != null) {
            xMLStreamWriter.writeStartElement("width");
            xMLStreamWriter.writeCharacters(Double.toString(d));
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("PolyStyle");
        Color color2 = this.getInteriorMaterial().getDiffuse();
        if (color2 != null) {
            xMLStreamWriter.writeStartElement("color");
            xMLStreamWriter.writeCharacters(KMLExportUtil.stripHexPrefix(WWUtil.encodeColorABGR(color2)));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeStartElement("colorMode");
            xMLStreamWriter.writeCharacters("normal");
            xMLStreamWriter.writeEndElement();
        }
        xMLStreamWriter.writeStartElement("fill");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isDrawInterior()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("outline");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isDrawOutline()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.flush();
        if (bl) {
            xMLStreamWriter.close();
        }
    }
}

