/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wfs;

import gov.nasa.worldwind.ogc.ows.OWSBoundingBox;
import gov.nasa.worldwind.ogc.ows.OWSKeywords;
import gov.nasa.worldwind.ogc.ows.OWSLanguageString;
import gov.nasa.worldwind.ogc.wfs.WFSExtendedDescription;
import gov.nasa.worldwind.ogc.wfs.WFSMetadataURL;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringSetXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class WFSFeatureType
extends AbstractXMLEventParser {
    protected QName TITLE;
    protected QName ABSTRACT;
    protected QName OUTPUT_FORMATS;
    protected QName DEFAULT_CRS;
    protected QName OTHER_CRS;
    protected QName NO_CRS;
    protected List<OWSLanguageString> titles = new ArrayList<OWSLanguageString>();
    protected List<OWSLanguageString> abstracts = new ArrayList<OWSLanguageString>();
    protected List<OWSKeywords> keywordLists = new ArrayList<OWSKeywords>();
    protected String defaultCRS;
    protected Set<String> otherCRS = new HashSet<String>();
    protected boolean noCRS;
    protected Set<String> outputFormats = new HashSet<String>();
    protected List<OWSBoundingBox> boundingBoxes = new ArrayList<OWSBoundingBox>();
    protected List<WFSMetadataURL> metadataURLs = new ArrayList<WFSMetadataURL>();

    public WFSFeatureType(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.TITLE = new QName(this.getNamespaceURI(), "Title");
        this.ABSTRACT = new QName(this.getNamespaceURI(), "Abstract");
        this.OUTPUT_FORMATS = new QName(this.getNamespaceURI(), "OutputFormats");
        this.DEFAULT_CRS = new QName(this.getNamespaceURI(), "DefaultCRS");
        this.OTHER_CRS = new QName(this.getNamespaceURI(), "OtherCRS");
        this.NO_CRS = new QName(this.getNamespaceURI(), "NoCRS");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.TITLE)) {
            this.addTitle((OWSLanguageString)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ABSTRACT)) {
            this.addAbstract((OWSLanguageString)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.OUTPUT_FORMATS)) {
            this.addAllOutputFormats((StringSetXMLEventParser)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.DEFAULT_CRS)) {
            this.setDefaultCRS((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.OTHER_CRS)) {
            this.addOtherCRS((String)object);
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.NO_CRS)) {
            this.setNoCRS(true);
        } else if (object instanceof OWSKeywords) {
            this.addKeywordList((OWSKeywords)object);
        } else if (object instanceof OWSBoundingBox) {
            this.addBoundingBox((OWSBoundingBox)object);
        } else if (object instanceof WFSMetadataURL) {
            this.addMetadataURL((WFSMetadataURL)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addTitle(OWSLanguageString oWSLanguageString) {
        this.titles.add(oWSLanguageString);
    }

    protected void addAbstract(OWSLanguageString oWSLanguageString) {
        this.abstracts.add(oWSLanguageString);
    }

    protected void addKeywordList(OWSKeywords oWSKeywords) {
        this.keywordLists.add(oWSKeywords);
    }

    protected void setDefaultCRS(String string) {
        this.defaultCRS = string;
    }

    protected void addOtherCRS(String string) {
        this.otherCRS.add(string);
    }

    protected void setNoCRS(boolean bl) {
        this.noCRS = bl;
    }

    protected void addAllOutputFormats(Iterable<String> iterable) {
        for (String string : iterable) {
            this.outputFormats.add(string);
        }
    }

    protected void addBoundingBox(OWSBoundingBox oWSBoundingBox) {
        this.boundingBoxes.add(oWSBoundingBox);
    }

    protected void addMetadataURL(WFSMetadataURL wFSMetadataURL) {
        this.metadataURLs.add(wFSMetadataURL);
    }

    public String getName() {
        return (String)this.getField("Name");
    }

    public List<OWSLanguageString> getTitles() {
        return this.titles;
    }

    public List<OWSLanguageString> getAbstracts() {
        return this.abstracts;
    }

    public List<OWSKeywords> getKeywordLists() {
        return this.keywordLists;
    }

    public String getDefaultCRS() {
        return this.defaultCRS;
    }

    public Set<String> getOtherCRS() {
        return this.otherCRS;
    }

    public boolean isNoCRS() {
        return this.noCRS;
    }

    public Set<String> getOutputFormats() {
        return this.outputFormats;
    }

    public List<OWSBoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public List<WFSMetadataURL> getMetadataURLs() {
        return this.metadataURLs;
    }

    public WFSExtendedDescription getExtendedDescription() {
        return (WFSExtendedDescription)this.getField("ExtendedDescription");
    }
}

