/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSOperationsMetadata;
import gov.nasa.worldwind.ogc.ows.OWSServiceIdentification;
import gov.nasa.worldwind.ogc.ows.OWSServiceProvider;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.StringSetXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OWSCapabilitiesBase
extends AbstractXMLEventParser {
    protected QName LANGUAGES;
    protected Set<String> languages = new HashSet<String>();

    public OWSCapabilitiesBase(String string) {
        super(string);
        this.initialize();
    }

    protected void initialize() {
        this.LANGUAGES = new QName(this.getNamespaceURI(), "Languages");
    }

    @Override
    protected void doAddEventContent(Object object, XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        if (xMLEventParserContext.isStartElement(xMLEvent, this.LANGUAGES)) {
            this.addAllLanguages((StringSetXMLEventParser)object);
        } else {
            super.doAddEventContent(object, xMLEventParserContext, xMLEvent, objectArray);
        }
    }

    protected void addAllLanguages(Iterable<String> iterable) {
        for (String string : iterable) {
            this.languages.add(string);
        }
    }

    public OWSServiceIdentification getServiceIdentification() {
        return (OWSServiceIdentification)this.getField("ServiceIdentification");
    }

    public OWSServiceProvider getServiceProvider() {
        return (OWSServiceProvider)this.getField("ServiceProvider");
    }

    public OWSOperationsMetadata getOperationsMetadata() {
        return (OWSOperationsMetadata)this.getField("OperationsMetadata");
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    public String getVersion() {
        return (String)this.getField("version");
    }

    public String getUpdateSequence() {
        return (String)this.getField("updateSequence");
    }
}

