/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.event.Message;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.ogc.kml.KMLAbstractFeature;
import gov.nasa.worldwind.ogc.kml.KMLAbstractGeometry;
import gov.nasa.worldwind.ogc.kml.KMLAbstractSubStyle;
import gov.nasa.worldwind.ogc.kml.KMLGroundOverlay;
import gov.nasa.worldwind.ogc.kml.KMLLineStyle;
import gov.nasa.worldwind.ogc.kml.KMLLinearRing;
import gov.nasa.worldwind.ogc.kml.KMLPlacemark;
import gov.nasa.worldwind.ogc.kml.KMLPolyStyle;
import gov.nasa.worldwind.ogc.kml.KMLPolygon;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfacePolygon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.util.Iterator;

public class KMLSurfacePolygonImpl
extends SurfacePolygon
implements KMLRenderable {
    protected final KMLAbstractFeature parent;
    protected boolean highlightAttributesResolved = false;
    protected boolean normalAttributesResolved = false;

    public KMLSurfacePolygonImpl(KMLTraversalContext kMLTraversalContext, KMLPlacemark kMLPlacemark, KMLAbstractGeometry kMLAbstractGeometry) {
        Object object;
        if (kMLTraversalContext == null) {
            String string = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (kMLPlacemark == null) {
            String string = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.parent = kMLPlacemark;
        KMLPolygon kMLPolygon = (KMLPolygon)kMLAbstractGeometry;
        this.setPathType("gov.nasa.worldwind.avkey.Linear");
        KMLLinearRing kMLLinearRing = kMLPolygon.getOuterBoundary();
        if (kMLLinearRing != null && (object = kMLLinearRing.getCoordinates()) != null && ((Position.PositionList)object).list != null) {
            this.setOuterBoundary(kMLLinearRing.getCoordinates().list);
        }
        if ((object = kMLPolygon.getInnerBoundaries()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                KMLLinearRing kMLLinearRing2 = (KMLLinearRing)iterator.next();
                Position.PositionList positionList = kMLLinearRing2.getCoordinates();
                if (positionList == null || positionList.list == null) continue;
                this.addInnerBoundary(kMLLinearRing2.getCoordinates().list);
            }
        }
        if (kMLPlacemark.getName() != null) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", kMLPlacemark.getName());
        }
        if (kMLPlacemark.getDescription() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Description", kMLPlacemark.getDescription());
        }
        if (kMLPlacemark.getSnippetText() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", kMLPlacemark.getSnippetText());
        }
        this.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
    }

    public KMLSurfacePolygonImpl(KMLTraversalContext kMLTraversalContext, KMLGroundOverlay kMLGroundOverlay) {
        String string;
        if (kMLTraversalContext == null) {
            String string2 = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (kMLGroundOverlay == null) {
            String string3 = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.parent = kMLGroundOverlay;
        Position.PositionList positionList = kMLGroundOverlay.getPositions();
        this.setOuterBoundary(positionList.list);
        if (kMLGroundOverlay.getName() != null) {
            this.setValue("gov.nasa.worldwind.avkey.DisplayName", kMLGroundOverlay.getName());
        }
        if (kMLGroundOverlay.getDescription() != null) {
            this.setValue("gov.nasa.worldwind.avkey.BalloonText", kMLGroundOverlay.getDescription());
        }
        if (kMLGroundOverlay.getSnippetText() != null) {
            this.setValue("gov.nasa.worldwind.avkey.Server.ShortDescription", kMLGroundOverlay.getSnippetText());
        }
        if (!WWUtil.isEmpty(string = kMLGroundOverlay.getColor())) {
            Color color = WWUtil.decodeColorABGR(string);
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
            basicShapeAttributes.setDrawInterior(true);
            basicShapeAttributes.setInteriorMaterial(new Material(color));
            this.setAttributes(basicShapeAttributes);
        }
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        ShapeAttributes shapeAttributes;
        if (this.isHighlighted()) {
            ShapeAttributes shapeAttributes2;
            if (!this.highlightAttributesResolved && ((shapeAttributes2 = this.getHighlightAttributes()) == null || shapeAttributes2.isUnresolved()) && (shapeAttributes2 = this.makeAttributesCurrent("highlight")) != null) {
                this.setHighlightAttributes(shapeAttributes2);
                if (!shapeAttributes2.isUnresolved()) {
                    this.highlightAttributesResolved = true;
                }
            }
        } else if (!this.normalAttributesResolved && ((shapeAttributes = this.getAttributes()) == null || shapeAttributes.isUnresolved()) && (shapeAttributes = this.makeAttributesCurrent("normal")) != null) {
            this.setAttributes(shapeAttributes);
            if (!shapeAttributes.isUnresolved()) {
                this.normalAttributesResolved = true;
            }
        }
        this.preRender(drawContext);
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        this.render(drawContext);
    }

    @Override
    protected PickedObject createPickedObject(DrawContext drawContext, Color color) {
        PickedObject pickedObject = super.createPickedObject(drawContext, color);
        pickedObject.setValue("gov.nasa.worldwind.avkey.Context", this.parent);
        return pickedObject;
    }

    protected ShapeAttributes makeAttributesCurrent(String string) {
        ShapeAttributes shapeAttributes = this.getInitialAttributes(this.isHighlighted() ? "highlight" : "normal");
        KMLAbstractSubStyle kMLAbstractSubStyle = this.parent.getSubStyle(new KMLLineStyle(null), string);
        if (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle)) {
            KMLUtil.assembleLineAttributes(shapeAttributes, (KMLLineStyle)kMLAbstractSubStyle);
            if (kMLAbstractSubStyle.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                shapeAttributes.setUnresolved(true);
            }
        }
        KMLAbstractSubStyle kMLAbstractSubStyle2 = this.parent.getSubStyle(new KMLPolyStyle(null), string);
        if (!this.isHighlighted() || KMLUtil.isHighlightStyleState(kMLAbstractSubStyle)) {
            KMLUtil.assembleInteriorAttributes(shapeAttributes, (KMLPolyStyle)kMLAbstractSubStyle2);
            if (kMLAbstractSubStyle2.hasField("gov.nasa.worldwind.avkey.Unresolved")) {
                shapeAttributes.setUnresolved(true);
            }
        }
        shapeAttributes.setDrawInterior(((KMLPolyStyle)kMLAbstractSubStyle2).isFill());
        shapeAttributes.setDrawOutline(((KMLPolyStyle)kMLAbstractSubStyle2).isOutline());
        return shapeAttributes;
    }

    protected ShapeAttributes getInitialAttributes(String string) {
        BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes();
        if ("highlight".equals(string)) {
            basicShapeAttributes.setOutlineMaterial(Material.RED);
            basicShapeAttributes.setInteriorMaterial(Material.PINK);
        } else {
            basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            basicShapeAttributes.setInteriorMaterial(Material.LIGHT_GRAY);
        }
        return basicShapeAttributes;
    }

    @Override
    public void onMessage(Message message) {
        super.onMessage(message);
        if ("KMLAbstractObject.StyleChanged".equals(message.getName())) {
            this.normalAttributesResolved = false;
            this.highlightAttributesResolved = false;
            if (this.getAttributes() != null) {
                this.getAttributes().setUnresolved(true);
            }
            if (this.getHighlightAttributes() != null) {
                this.getHighlightAttributes().setUnresolved(true);
            }
        }
    }
}

