/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.kml.impl;

import gov.nasa.worldwind.ogc.kml.KMLScreenOverlay;
import gov.nasa.worldwind.ogc.kml.KMLVec2;
import gov.nasa.worldwind.ogc.kml.impl.KMLRenderable;
import gov.nasa.worldwind.ogc.kml.impl.KMLTraversalContext;
import gov.nasa.worldwind.ogc.kml.impl.KMLUtil;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.ScreenImage;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.io.IOException;

public class KMLScreenImageImpl
extends ScreenImage
implements KMLRenderable {
    protected static final int KML_NATIVE_DIMENSION = -1;
    protected static final int KML_MAINTAIN_ASPECT_RATIO = 0;
    protected final KMLScreenOverlay parent;

    public KMLScreenImageImpl(KMLTraversalContext kMLTraversalContext, KMLScreenOverlay kMLScreenOverlay) {
        Object object;
        String string;
        this.parent = kMLScreenOverlay;
        if (kMLTraversalContext == null) {
            String string2 = Logging.getMessage("nullValue.TraversalContextIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (kMLScreenOverlay == null) {
            String string3 = Logging.getMessage("nullValue.ParentIsNull");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        KMLVec2 kMLVec2 = this.parent.getScreenXY();
        if (kMLVec2 != null) {
            this.screenOffset = new Offset(kMLVec2.getX(), kMLVec2.getY(), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getXunits()), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getYunits()));
        }
        if ((kMLVec2 = this.parent.getOverlayXY()) != null) {
            this.imageOffset = new Offset(kMLVec2.getX(), kMLVec2.getY(), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getXunits()), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getYunits()));
        }
        this.setRotation(kMLScreenOverlay.getRotation());
        kMLVec2 = this.parent.getRotationXY();
        if (kMLVec2 != null) {
            this.setRotationOffset(new Offset(kMLVec2.getX(), kMLVec2.getY(), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getXunits()), KMLUtil.kmlUnitsToWWUnits(kMLVec2.getYunits())));
        }
        if ((string = kMLScreenOverlay.getColor()) != null) {
            object = WWUtil.decodeColorABGR(string);
            this.setColor((Color)object);
        }
        if ((object = this.parent.getSize()) != null) {
            Size size = new Size();
            size.setWidth(this.getSizeMode(((KMLVec2)object).getX()), ((KMLVec2)object).getX(), KMLUtil.kmlUnitsToWWUnits(((KMLVec2)object).getXunits()));
            size.setHeight(this.getSizeMode(((KMLVec2)object).getY()), ((KMLVec2)object).getY(), KMLUtil.kmlUnitsToWWUnits(((KMLVec2)object).getYunits()));
            this.setSize(size);
        }
    }

    @Override
    public void preRender(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
    }

    protected boolean mustResolveHref() {
        return this.getImageSource() == null && this.parent.getIcon() != null && this.parent.getIcon().getHref() != null;
    }

    @Override
    public void render(KMLTraversalContext kMLTraversalContext, DrawContext drawContext) {
        if (this.mustResolveHref()) {
            String string = this.parent.getIcon().getHref();
            String string2 = null;
            try {
                string2 = this.parent.getRoot().getSupportFilePath(string);
            }
            catch (IOException iOException) {
                String string3 = Logging.getMessage("generic.UnableToResolveReference", string);
                Logging.logger().warning(string3);
            }
            this.setImageSource(string2 != null ? string2 : string);
        }
        this.render(drawContext);
    }

    protected String getSizeMode(Double d) {
        if (d == null) {
            return "gov.nasa.worldwind.render.Size.NativeDimension";
        }
        int n = (int)d.doubleValue();
        if (n == -1) {
            return "gov.nasa.worldwind.render.Size.NativeDimension";
        }
        if (d == 0.0) {
            return "gov.nasa.worldwind.render.Size.MaintainAspectRatio";
        }
        return "gov.nasa.worldwind.render.Size.ExplicitDimension";
    }
}

