/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.ogc.collada.ColladaBindMaterial;
import gov.nasa.worldwind.ogc.collada.ColladaGeometry;
import gov.nasa.worldwind.ogc.collada.ColladaInstanceGeometry;
import gov.nasa.worldwind.ogc.collada.ColladaLines;
import gov.nasa.worldwind.ogc.collada.ColladaMatrix;
import gov.nasa.worldwind.ogc.collada.ColladaMesh;
import gov.nasa.worldwind.ogc.collada.ColladaRoot;
import gov.nasa.worldwind.ogc.collada.ColladaTriangles;
import gov.nasa.worldwind.ogc.collada.impl.ColladaMeshShape;
import gov.nasa.worldwind.ogc.collada.impl.ColladaRenderable;
import gov.nasa.worldwind.ogc.collada.impl.ColladaTraversalContext;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.WWUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColladaNode
extends ColladaAbstractObject
implements ColladaRenderable {
    protected List<ColladaRenderable> children;
    protected List<ColladaInstanceGeometry> geometries;
    protected List<ColladaMeshShape> shapes;
    protected Matrix matrix;

    public ColladaNode(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preRender(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        List<ColladaRenderable> list = this.getChildren();
        if (WWUtil.isEmpty(list)) {
            return;
        }
        Matrix matrix = this.getMatrix();
        try {
            if (matrix != null && matrix != Matrix.IDENTITY) {
                colladaTraversalContext.pushMatrix();
                colladaTraversalContext.multiplyMatrix(matrix);
            }
            for (ColladaRenderable colladaRenderable : list) {
                colladaRenderable.preRender(colladaTraversalContext, drawContext);
            }
        }
        finally {
            if (matrix != null && matrix != Matrix.IDENTITY) {
                colladaTraversalContext.popMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ColladaTraversalContext colladaTraversalContext, DrawContext drawContext) {
        if (this.shapes == null) {
            this.shapes = this.createShapes();
        }
        Matrix matrix = this.getMatrix();
        try {
            if (matrix != null && matrix != Matrix.IDENTITY) {
                colladaTraversalContext.pushMatrix();
                colladaTraversalContext.multiplyMatrix(matrix);
            }
            ColladaRoot colladaRoot = this.getRoot();
            boolean bl = colladaRoot.isHighlighted();
            int n = colladaRoot.getAltitudeMode();
            Position position = colladaRoot.getPosition();
            Matrix matrix2 = colladaTraversalContext.peekMatrix();
            for (ColladaMeshShape object : this.shapes) {
                object.setModelPosition(position);
                object.setAltitudeMode(n);
                object.setHighlighted(bl);
                object.render(drawContext, matrix2);
            }
            for (ColladaRenderable colladaRenderable : this.getChildren()) {
                colladaRenderable.render(colladaTraversalContext, drawContext);
            }
        }
        finally {
            if (matrix != null && matrix != Matrix.IDENTITY) {
                colladaTraversalContext.popMatrix();
            }
        }
    }

    protected List<ColladaMeshShape> createShapes() {
        if (WWUtil.isEmpty(this.geometries)) {
            return Collections.emptyList();
        }
        ArrayList<ColladaMeshShape> arrayList = new ArrayList<ColladaMeshShape>();
        for (ColladaInstanceGeometry colladaInstanceGeometry : this.geometries) {
            this.createShapesForGeometry(colladaInstanceGeometry, arrayList);
        }
        return arrayList;
    }

    protected void createShapesForGeometry(ColladaInstanceGeometry colladaInstanceGeometry, List<ColladaMeshShape> list) {
        Object object;
        ColladaGeometry colladaGeometry = (ColladaGeometry)colladaInstanceGeometry.get();
        if (colladaGeometry == null) {
            return;
        }
        ColladaMesh colladaMesh = colladaGeometry.getMesh();
        if (colladaMesh == null) {
            return;
        }
        ColladaBindMaterial colladaBindMaterial = colladaInstanceGeometry.getBindMaterial();
        ColladaRoot colladaRoot = this.getRoot();
        List<ColladaTriangles> list2 = colladaMesh.getTriangles();
        if (!WWUtil.isEmpty(list2)) {
            object = ColladaMeshShape.createTriangleMesh(list2, colladaBindMaterial);
            ((AbstractShape)object).setDelegateOwner(colladaRoot);
            list.add((ColladaMeshShape)object);
        }
        if (!WWUtil.isEmpty(object = colladaMesh.getLines())) {
            ColladaMeshShape colladaMeshShape = ColladaMeshShape.createLineMesh((List<ColladaLines>)object, colladaBindMaterial);
            colladaMeshShape.setDelegateOwner(colladaRoot);
            list.add(colladaMeshShape);
        }
    }

    @Override
    public void setField(String string, Object object) {
        if ("node".equals(string) || "instance_node".equals(string)) {
            if (this.children == null) {
                this.children = new ArrayList<ColladaRenderable>();
            }
            this.children.add((ColladaRenderable)object);
        } else if ("instance_geometry".equals(string)) {
            if (this.geometries == null) {
                this.geometries = new ArrayList<ColladaInstanceGeometry>();
            }
            this.geometries.add((ColladaInstanceGeometry)object);
        } else {
            super.setField(string, object);
        }
    }

    protected List<ColladaRenderable> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    protected Matrix getMatrix() {
        if (this.matrix != null) {
            return this.matrix;
        }
        ColladaMatrix colladaMatrix = (ColladaMatrix)this.getField("matrix");
        if (colladaMatrix == null) {
            this.matrix = Matrix.IDENTITY;
            return this.matrix;
        }
        String string = colladaMatrix.getCharacters();
        String string2 = string.replaceAll("\n", " ");
        double[] dArray = this.parseDoubleArray(string2);
        this.matrix = Matrix.fromArray(dArray, 0, true);
        return this.matrix;
    }

    protected double[] parseDoubleArray(String string) {
        String[] stringArray = string.trim().split("\\s+");
        double[] dArray = new double[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            dArray[n++] = Double.parseDouble(string2);
        }
        return dArray;
    }
}

