/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.placename;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.event.BulkRetrievalListener;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayerBulkDownloader;
import gov.nasa.worldwind.layers.placename.PlaceNameService;
import gov.nasa.worldwind.layers.placename.PlaceNameServiceSet;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.GeographicText;
import gov.nasa.worldwind.render.GeographicTextRenderer;
import gov.nasa.worldwind.render.UserFacingText;
import gov.nasa.worldwind.retrieve.AbstractRetrievalPostProcessor;
import gov.nasa.worldwind.retrieve.BulkRetrievable;
import gov.nasa.worldwind.retrieve.BulkRetrievalThread;
import gov.nasa.worldwind.retrieve.HTTPRetriever;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PlaceNameLayer
extends AbstractLayer
implements BulkRetrievable {
    protected final PlaceNameServiceSet placeNameServiceSet;
    protected PriorityBlockingQueue<Runnable> requestQ = new PriorityBlockingQueue(64);
    protected Vec4 referencePoint;
    protected final Object fileLock = new Object();
    protected boolean cullNames = false;
    public static final double LEVEL_A = 3.3554432E7;
    public static final double LEVEL_B = 1.6777216E7;
    public static final double LEVEL_C = 8388608.0;
    public static final double LEVEL_D = 4194304.0;
    public static final double LEVEL_E = 2097152.0;
    public static final double LEVEL_F = 1048576.0;
    public static final double LEVEL_G = 524288.0;
    public static final double LEVEL_H = 262144.0;
    public static final double LEVEL_I = 131072.0;
    public static final double LEVEL_J = 65536.0;
    public static final double LEVEL_K = 32768.0;
    public static final double LEVEL_L = 16384.0;
    public static final double LEVEL_M = 8192.0;
    public static final double LEVEL_N = 4096.0;
    public static final double LEVEL_O = 2048.0;
    public static final double LEVEL_P = 1024.0;
    public static final LatLon GRID_1x1 = new LatLon(Angle.fromDegrees(180.0), Angle.fromDegrees(360.0));
    public static final LatLon GRID_4x8 = new LatLon(Angle.fromDegrees(45.0), Angle.fromDegrees(45.0));
    public static final LatLon GRID_8x16 = new LatLon(Angle.fromDegrees(22.5), Angle.fromDegrees(22.5));
    public static final LatLon GRID_16x32 = new LatLon(Angle.fromDegrees(11.25), Angle.fromDegrees(11.25));
    public static final LatLon GRID_36x72 = new LatLon(Angle.fromDegrees(5.0), Angle.fromDegrees(5.0));
    public static final LatLon GRID_72x144 = new LatLon(Angle.fromDegrees(2.5), Angle.fromDegrees(2.5));
    public static final LatLon GRID_144x288 = new LatLon(Angle.fromDegrees(1.25), Angle.fromDegrees(1.25));
    public static final LatLon GRID_288x576 = new LatLon(Angle.fromDegrees(0.625), Angle.fromDegrees(0.625));
    public static final LatLon GRID_576x1152 = new LatLon(Angle.fromDegrees(0.3125), Angle.fromDegrees(0.3125));
    public static final LatLon GRID_1152x2304 = new LatLon(Angle.fromDegrees(0.1563), Angle.fromDegrees(0.1563));
    protected List<NavigationTile> navTiles = new ArrayList<NavigationTile>();
    protected final GeographicTextRenderer placeNameRenderer = new GeographicTextRenderer();

    public PlaceNameLayer(PlaceNameServiceSet placeNameServiceSet) {
        if (placeNameServiceSet == null) {
            String string = Logging.getMessage("nullValue.PlaceNameServiceSetIsNull");
            Logging.logger().fine(string);
            throw new IllegalArgumentException(string);
        }
        this.placeNameServiceSet = placeNameServiceSet.deepCopy();
        for (int i = 0; i < this.placeNameServiceSet.getServiceCount(); ++i) {
            int n = (int)(PlaceNameService.TILING_SECTOR.getDeltaLatDegrees() / this.placeNameServiceSet.getService(i).getTileDelta().getLatitude().getDegrees());
            int n2 = (int)Math.log(n);
            this.navTiles.add(new NavigationTile(this.placeNameServiceSet.getService(i), PlaceNameService.TILING_SECTOR, n2, "top"));
        }
        if (!WorldWind.getMemoryCacheSet().containsCache(Tile.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.PlacenameLayerCacheSize", 2000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName("Placename Tiles");
            WorldWind.getMemoryCacheSet().addCache(Tile.class.getName(), basicMemoryCache);
        }
    }

    public boolean isCullNames() {
        return this.cullNames;
    }

    public void setCullNames(boolean bl) {
        this.cullNames = bl;
        this.placeNameRenderer.setCullTextEnabled(bl);
    }

    public final PlaceNameServiceSet getPlaceNameServiceSet() {
        return this.placeNameServiceSet;
    }

    protected PriorityBlockingQueue<Runnable> getRequestQ() {
        return this.requestQ;
    }

    protected Tile[] buildTiles(PlaceNameService placeNameService, NavigationTile navigationTile) {
        Angle angle = placeNameService.getTileDelta().getLatitude();
        Angle angle2 = placeNameService.getTileDelta().getLongitude();
        int n = Tile.computeRow(angle, navigationTile.navSector.getMinLatitude());
        int n2 = Tile.computeColumn(angle2, navigationTile.navSector.getMinLongitude());
        int n3 = Tile.computeRow(angle, navigationTile.navSector.getMaxLatitude().subtract(angle));
        int n4 = Tile.computeColumn(angle2, navigationTile.navSector.getMaxLongitude().subtract(angle2));
        int n5 = n3 - n + 1;
        int n6 = n4 - n2 + 1;
        Tile[] tileArray = new Tile[n5 * n6];
        Angle angle3 = Tile.computeRowLatitude(n, angle);
        for (int i = 0; i <= n3 - n; ++i) {
            Angle angle4 = angle3.add(angle);
            Angle angle5 = Tile.computeColumnLongitude(n2, angle2);
            for (int j = 0; j <= n4 - n2; ++j) {
                Angle angle6 = angle5.add(angle2);
                tileArray[j + i * n6] = new Tile(placeNameService, new Sector(angle3, angle4, angle5, angle6), i + n, j + n2);
                angle5 = angle6;
            }
            angle3 = angle4;
        }
        return tileArray;
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        this.referencePoint = this.computeReferencePoint(drawContext);
        int n = this.placeNameServiceSet.getServiceCount();
        for (int i = 0; i < n; ++i) {
            PlaceNameService placeNameService = this.placeNameServiceSet.getService(i);
            if (!PlaceNameLayer.isServiceVisible(drawContext, placeNameService)) continue;
            double d = placeNameService.getMinDisplayDistance() * placeNameService.getMinDisplayDistance();
            double d2 = placeNameService.getMaxDisplayDistance() * placeNameService.getMaxDisplayDistance();
            if (!PlaceNameLayer.isSectorVisible(drawContext, placeNameService.getMaskingSector(), d, d2)) continue;
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            NavigationTile navigationTile = this.navTiles.get(i);
            List<NavigationTile> list = navigationTile.navTilesVisible(drawContext, d, d2);
            for (NavigationTile navigationTile2 : list) {
                arrayList.addAll(navigationTile2.getTiles());
            }
            for (Tile tile : arrayList) {
                try {
                    this.drawOrRequestTile(drawContext, tile, d, d2);
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionRenderingTile"), exception);
                }
            }
        }
        this.sendRequests();
        this.requestQ.clear();
    }

    protected Vec4 computeReferencePoint(DrawContext drawContext) {
        if (drawContext.getViewportCenterPosition() != null) {
            return drawContext.getGlobe().computePointFromPosition(drawContext.getViewportCenterPosition());
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        int n = (int)((RectangularShape)rectangle).getWidth() / 2;
        for (int i = (int)(0.5 * ((RectangularShape)rectangle).getHeight()); i >= 0; --i) {
            Position position = drawContext.getView().computePositionFromScreenPoint(n, i);
            if (position == null) continue;
            return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), 0.0);
        }
        return null;
    }

    protected Vec4 getReferencePoint() {
        return this.referencePoint;
    }

    protected void drawOrRequestTile(DrawContext drawContext, Tile tile, double d, double d2) {
        if (!PlaceNameLayer.isTileVisible(drawContext, tile, d, d2)) {
            return;
        }
        if (tile.isTileInMemoryWithData()) {
            PlaceNameChunk placeNameChunk = tile.getDataChunk();
            if (placeNameChunk.numEntries > 0) {
                Iterable<GeographicText> iterable = placeNameChunk.makeIterable(drawContext);
                this.placeNameRenderer.render(drawContext, iterable);
            }
            return;
        }
        if (!tile.getPlaceNameService().isResourceAbsent(tile.getPlaceNameService().getTileNumber(tile.row, tile.column))) {
            this.requestTile(drawContext, tile);
        }
    }

    protected static boolean isServiceVisible(DrawContext drawContext, PlaceNameService placeNameService) {
        if (!placeNameService.isEnabled()) {
            return false;
        }
        return drawContext.getVisibleSector() != null && placeNameService.getMaskingSector().intersects(drawContext.getVisibleSector());
    }

    protected static boolean isSectorVisible(DrawContext drawContext, Sector sector, double d, double d2) {
        View view = drawContext.getView();
        Position position = view.getEyePosition();
        if (position == null) {
            return false;
        }
        Angle angle = PlaceNameLayer.clampAngle(position.getLatitude(), sector.getMinLatitude(), sector.getMaxLatitude());
        Angle angle2 = PlaceNameLayer.clampAngle(position.getLongitude(), sector.getMinLongitude(), sector.getMaxLongitude());
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, 0.0);
        double d3 = drawContext.getView().getEyePoint().distanceToSquared3(vec4);
        return !(d > d3) && !(d2 < d3);
    }

    protected static boolean isTileVisible(DrawContext drawContext, Tile tile, double d, double d2) {
        if (!tile.getSector().intersects(drawContext.getVisibleSector())) {
            return false;
        }
        View view = drawContext.getView();
        Position position = view.getEyePosition();
        if (position == null) {
            return false;
        }
        Angle angle = PlaceNameLayer.clampAngle(position.getLatitude(), tile.getSector().getMinLatitude(), tile.getSector().getMaxLatitude());
        Angle angle2 = PlaceNameLayer.clampAngle(position.getLongitude(), tile.getSector().getMinLongitude(), tile.getSector().getMaxLongitude());
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, 0.0);
        double d3 = drawContext.getView().getEyePoint().distanceToSquared3(vec4);
        return !(d > d3) && !(d2 < d3);
    }

    protected static boolean isNameVisible(DrawContext drawContext, PlaceNameService placeNameService, Position position) {
        double d = drawContext.getVerticalExaggeration() * position.getElevation();
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        Vec4 vec42 = drawContext.getView().getEyePoint();
        double d2 = vec42.distanceTo3(vec4);
        return d2 >= placeNameService.getMinDisplayDistance() && d2 <= placeNameService.getMaxDisplayDistance();
    }

    protected static Angle clampAngle(Angle angle, Angle angle2, Angle angle3) {
        double d = angle.degrees;
        double d2 = angle2.degrees;
        double d3 = angle3.degrees;
        return Angle.fromDegrees(d < d2 ? d2 : (d > d3 ? d3 : d));
    }

    protected void requestTile(DrawContext drawContext, Tile tile) {
        Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(tile.getSector().getCentroid(), 0.0);
        if (this.getReferencePoint() != null) {
            tile.setPriority(vec4.distanceTo3(this.getReferencePoint()));
        }
        RequestTask requestTask = new RequestTask(tile, this);
        this.getRequestQ().add(requestTask);
    }

    protected void sendRequests() {
        Runnable runnable = this.requestQ.poll();
        while (runnable != null) {
            if (!WorldWind.getTaskService().isFull()) {
                WorldWind.getTaskService().addTask(runnable);
            }
            runnable = this.requestQ.poll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadTile(Tile tile, URL uRL) {
        PlaceNameChunk placeNameChunk;
        if (WWIO.isFileOutOfDate(uRL, this.placeNameServiceSet.getExpiryTime())) {
            this.getDataFileStore().removeFile(uRL);
            String string = Logging.getMessage("generic.DataFileExpired", uRL);
            Logging.logger().fine(string);
            return false;
        }
        Object object = this.fileLock;
        synchronized (object) {
            placeNameChunk = PlaceNameLayer.readTileData(tile, uRL);
        }
        if (placeNameChunk == null) {
            this.getDataFileStore().removeFile(uRL);
            tile.getPlaceNameService().markResourceAbsent(tile.getPlaceNameService().getTileNumber(tile.row, tile.column));
            object = Logging.getMessage("generic.DeletedCorruptDataFile", uRL);
            Logging.logger().fine((String)object);
            return false;
        }
        tile.setDataChunk(placeNameChunk);
        WorldWind.getMemoryCache(Tile.class.getName()).add(tile.getFileCachePath(), tile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PlaceNameChunk readTileData(Tile tile, URL uRL) {
        InputStream inputStream = null;
        try {
            String string = uRL.getFile();
            string = string.replaceAll("%20", " ");
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            inputStream = new GZIPInputStream(bufferedInputStream);
            GMLPlaceNameSAXHandler gMLPlaceNameSAXHandler = new GMLPlaceNameSAXHandler();
            SAXParserFactory.newInstance().newSAXParser().parse(inputStream, (DefaultHandler)gMLPlaceNameSAXHandler);
            PlaceNameChunk placeNameChunk = gMLPlaceNameSAXHandler.createPlaceNameChunk(tile.getPlaceNameService());
            return placeNameChunk;
        }
        catch (Exception exception) {
            Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionAttemptingToReadFile", uRL.toString()), exception);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionAttemptingToReadFile", uRL.toString()), iOException);
            }
        }
        return null;
    }

    protected static CharBuffer newCharBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2 * n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.asCharBuffer();
    }

    protected void downloadTile(Tile tile) {
        this.downloadTile(tile, null);
    }

    protected void downloadTile(Tile tile, DownloadPostProcessor downloadPostProcessor) {
        Integer n;
        Integer n2;
        URL uRL;
        if (!this.isNetworkRetrievalEnabled()) {
            return;
        }
        if (!WorldWind.getRetrievalService().isAvailable()) {
            return;
        }
        try {
            uRL = tile.getRequestURL();
            if (WorldWind.getNetworkStatus().isHostUnavailable(uRL)) {
                return;
            }
        }
        catch (MalformedURLException malformedURLException) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("layers.PlaceNameLayer.ExceptionCreatingUrl", tile), malformedURLException);
            return;
        }
        if ("http".equalsIgnoreCase(uRL.getProtocol()) || "https".equalsIgnoreCase(uRL.getProtocol())) {
            if (downloadPostProcessor == null) {
                downloadPostProcessor = new DownloadPostProcessor(this, tile);
            }
        } else {
            Logging.logger().severe(Logging.getMessage("layers.PlaceNameLayer.UnknownRetrievalProtocol", uRL.toString()));
            return;
        }
        HTTPRetriever hTTPRetriever = new HTTPRetriever(uRL, downloadPostProcessor);
        hTTPRetriever.setValue("URLRetriever.ExtractZipEntry", "true");
        Integer n3 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLConnectTimeout");
        if (n3 != null && n3 > 0) {
            hTTPRetriever.setConnectTimeout(n3);
        }
        if ((n2 = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.URLReadTimeout")) != null && n2 > 0) {
            hTTPRetriever.setReadTimeout(n2);
        }
        if ((n = AVListImpl.getIntegerValue(this, "gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit")) != null && n > 0) {
            hTTPRetriever.setStaleRequestLimit(n);
        }
        WorldWind.getRetrievalService().runRetriever(hTTPRetriever, tile.getPriority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBuffer(ByteBuffer byteBuffer, File file) throws IOException {
        Object object = this.fileLock;
        synchronized (object) {
            WWIO.saveBuffer(byteBuffer, file);
        }
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d, BulkRetrievalListener bulkRetrievalListener) {
        PlaceNameLayerBulkDownloader placeNameLayerBulkDownloader = new PlaceNameLayerBulkDownloader(this, sector, d, this.getDataFileStore(), bulkRetrievalListener);
        placeNameLayerBulkDownloader.setDaemon(true);
        placeNameLayerBulkDownloader.start();
        return placeNameLayerBulkDownloader;
    }

    @Override
    public BulkRetrievalThread makeLocal(Sector sector, double d, FileStore fileStore, BulkRetrievalListener bulkRetrievalListener) {
        PlaceNameLayerBulkDownloader placeNameLayerBulkDownloader = new PlaceNameLayerBulkDownloader(this, sector, d, fileStore != null ? fileStore : this.getDataFileStore(), bulkRetrievalListener);
        placeNameLayerBulkDownloader.setDaemon(true);
        placeNameLayerBulkDownloader.start();
        return placeNameLayerBulkDownloader;
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d) {
        return this.getEstimatedMissingDataSize(sector, d, this.getDataFileStore());
    }

    @Override
    public long getEstimatedMissingDataSize(Sector sector, double d, FileStore fileStore) {
        try {
            PlaceNameLayerBulkDownloader placeNameLayerBulkDownloader = new PlaceNameLayerBulkDownloader(this, sector, d, fileStore != null ? fileStore : this.getDataFileStore(), null);
            return placeNameLayerBulkDownloader.getEstimatedMissingDataSize();
        }
        catch (Exception exception) {
            String string = Logging.getMessage("generic.ExceptionDuringDataSizeEstimate", this.getName());
            Logging.logger().severe(string);
            throw new RuntimeException(string);
        }
    }

    protected static class DownloadPostProcessor
    extends AbstractRetrievalPostProcessor {
        protected final PlaceNameLayer layer;
        protected final Tile tile;
        protected final FileStore fileStore;

        public DownloadPostProcessor(PlaceNameLayer placeNameLayer, Tile tile) {
            this(placeNameLayer, tile, null);
        }

        public DownloadPostProcessor(PlaceNameLayer placeNameLayer, Tile tile, FileStore fileStore) {
            super(placeNameLayer);
            this.layer = placeNameLayer;
            this.tile = tile;
            this.fileStore = fileStore;
        }

        protected FileStore getFileStore() {
            return this.fileStore != null ? this.fileStore : this.layer.getDataFileStore();
        }

        @Override
        protected void markResourceAbsent() {
            this.tile.getPlaceNameService().markResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
        }

        @Override
        protected Object getFileLock() {
            return this.layer.fileLock;
        }

        @Override
        protected File doGetOutputFile() {
            return this.getFileStore().newFile(this.tile.getFileCachePath());
        }

        @Override
        protected ByteBuffer handleSuccessfulRetrieval() {
            ByteBuffer byteBuffer = super.handleSuccessfulRetrieval();
            if (byteBuffer != null) {
                this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
            }
            return byteBuffer;
        }

        @Override
        protected ByteBuffer handleXMLContent() throws IOException {
            String string = WWIO.byteBufferToString(this.getRetriever().getBuffer(), 1024, null);
            if (string.contains("<ExceptionReport>")) {
                StringBuilder stringBuilder = new StringBuilder(this.getRetriever().getName());
                stringBuilder.append("\n");
                stringBuilder.append(WWIO.byteBufferToString(this.getRetriever().getBuffer(), 2048, null));
                Logging.logger().warning(stringBuilder.toString());
                return null;
            }
            this.saveBuffer();
            return this.getRetriever().getBuffer();
        }
    }

    protected static class GMLPlaceNameSAXHandler
    extends DefaultHandler {
        protected static final String GML_FEATURE_MEMBER = "gml:featureMember";
        protected static final String TOPP_FULL_NAME_ND = "topp:full_name_nd";
        protected static final String TOPP_LATITUDE = "topp:latitude";
        protected static final String TOPP_LONGITUDE = "topp:longitude";
        protected final LinkedList<String> internedQNameStack = new LinkedList();
        protected boolean inBeginEndPair = false;
        protected StringBuilder latBuffer = new StringBuilder();
        protected StringBuilder lonBuffer = new StringBuilder();
        StringBuilder textArray = new StringBuilder();
        int[] textIndexArray = new int[16];
        double[] latlonArray = new double[16];
        int numEntries = 0;

        protected GMLPlaceNameSAXHandler() {
        }

        protected PlaceNameChunk createPlaceNameChunk(PlaceNameService placeNameService) {
            int n = this.textArray.length();
            CharBuffer charBuffer = PlaceNameLayer.newCharBuffer(n);
            charBuffer.put(this.textArray.toString());
            charBuffer.rewind();
            return new PlaceNameChunk(placeNameService, charBuffer, this.textIndexArray, this.latlonArray, this.numEntries);
        }

        protected void beginEntry() {
            int n = this.textArray.length();
            this.textIndexArray = this.append(this.textIndexArray, this.numEntries, n);
            this.inBeginEndPair = true;
        }

        protected void endEntry() {
            double d = this.parseDouble(this.latBuffer);
            double d2 = this.parseDouble(this.lonBuffer);
            int n = 2 * this.numEntries;
            this.latlonArray = this.append(this.latlonArray, n, d);
            this.latlonArray = this.append(this.latlonArray, ++n, d2);
            this.latBuffer.delete(0, this.latBuffer.length());
            this.lonBuffer.delete(0, this.lonBuffer.length());
            this.inBeginEndPair = false;
            ++this.numEntries;
        }

        protected double parseDouble(StringBuilder stringBuilder) {
            double d = 0.0;
            try {
                d = Double.parseDouble(stringBuilder.toString());
            }
            catch (NumberFormatException numberFormatException) {
                Logging.logger().log(Level.FINE, Logging.getMessage("layers.PlaceNameLayer.ExceptionAttemptingToReadFile", ""), numberFormatException);
            }
            return d;
        }

        protected int[] append(int[] nArray, int n, int n2) {
            if (n >= nArray.length) {
                nArray = this.resizeArray(nArray);
            }
            nArray[n] = n2;
            return nArray;
        }

        protected int[] resizeArray(int[] nArray) {
            int n = 2 * nArray.length;
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }

        protected double[] append(double[] dArray, int n, double d) {
            if (n >= dArray.length) {
                dArray = this.resizeArray(dArray);
            }
            dArray[n] = d;
            return dArray;
        }

        protected double[] resizeArray(double[] dArray) {
            int n = 2 * dArray.length;
            double[] dArray2 = new double[n];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.inBeginEndPair) {
                return;
            }
            String string = this.internedQNameStack.getFirst();
            StringBuilder stringBuilder = null;
            if (TOPP_LATITUDE == string) {
                stringBuilder = this.latBuffer;
            } else if (TOPP_LONGITUDE == string) {
                stringBuilder = this.lonBuffer;
            } else if (TOPP_FULL_NAME_ND == string) {
                stringBuilder = this.textArray;
            }
            if (stringBuilder != null) {
                stringBuilder.append(cArray, n, n2);
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            String string4 = string3.intern();
            if (GML_FEATURE_MEMBER == string4) {
                this.beginEntry();
            }
            this.internedQNameStack.addFirst(string4);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            String string4 = string3.intern();
            if (GML_FEATURE_MEMBER == string4) {
                this.endEntry();
            }
            this.internedQNameStack.removeFirst();
        }
    }

    protected static class RequestTask
    implements Runnable,
    Comparable<RequestTask> {
        protected final PlaceNameLayer layer;
        protected final Tile tile;

        RequestTask(Tile tile, PlaceNameLayer placeNameLayer) {
            this.layer = placeNameLayer;
            this.tile = tile;
        }

        @Override
        public void run() {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (this.tile.isTileInMemoryWithData()) {
                return;
            }
            URL uRL = this.layer.getDataFileStore().findFile(this.tile.getFileCachePath(), false);
            if (uRL != null && this.layer.loadTile(this.tile, uRL)) {
                this.tile.getPlaceNameService().unmarkResourceAbsent(this.tile.getPlaceNameService().getTileNumber(this.tile.row, this.tile.column));
                this.layer.firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, this);
                return;
            }
            this.layer.downloadTile(this.tile);
        }

        @Override
        public int compareTo(RequestTask requestTask) {
            if (requestTask == null) {
                String string = Logging.getMessage("nullValue.RequestTaskIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return this.tile.getPriority() == requestTask.tile.getPriority() ? 0 : (this.tile.getPriority() < requestTask.tile.getPriority() ? -1 : 1);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            RequestTask requestTask = (RequestTask)object;
            return !(this.tile == null ? requestTask.tile != null : !this.tile.equals(requestTask.tile));
        }

        public int hashCode() {
            return this.tile != null ? this.tile.hashCode() : 0;
        }

        public String toString() {
            return this.tile.toString();
        }
    }

    protected static class PlaceNameChunk
    implements Cacheable {
        protected final PlaceNameService placeNameService;
        protected final CharBuffer textArray;
        protected final int[] textIndexArray;
        protected final double[] latlonArray;
        protected final int numEntries;
        protected final long estimatedMemorySize;

        protected PlaceNameChunk(PlaceNameService placeNameService, CharBuffer charBuffer, int[] nArray, double[] dArray, int n) {
            this.placeNameService = placeNameService;
            this.textArray = charBuffer;
            this.textIndexArray = nArray;
            this.latlonArray = dArray;
            this.numEntries = n;
            this.estimatedMemorySize = this.computeEstimatedMemorySize();
        }

        protected long computeEstimatedMemorySize() {
            long l = 0L;
            if (!this.textArray.isDirect()) {
                l += (long)(2 * this.textArray.capacity());
            }
            l += (long)(4 * this.textIndexArray.length);
            return l += (long)(8 * this.latlonArray.length);
        }

        protected Position getPosition(int n) {
            int n2 = 2 * n;
            return Position.fromDegrees(this.latlonArray[n2], this.latlonArray[n2 + 1], 0.0);
        }

        protected PlaceNameService getPlaceNameService() {
            return this.placeNameService;
        }

        protected CharSequence getText(int n) {
            int n2 = this.textIndexArray[n];
            int n3 = n + 1 < this.numEntries ? this.textIndexArray[n + 1] : this.textArray.length();
            return this.textArray.subSequence(n2, n3);
        }

        @Override
        public long getSizeInBytes() {
            return this.estimatedMemorySize;
        }

        protected Iterable<GeographicText> makeIterable(DrawContext drawContext) {
            double d = this.getPlaceNameService().getMaxDisplayDistance();
            ArrayList<GeographicText> arrayList = new ArrayList<GeographicText>();
            for (int i = 0; i < this.numEntries; ++i) {
                CharSequence charSequence = this.getText(i);
                Position position = this.getPosition(i);
                UserFacingText userFacingText = new UserFacingText(charSequence, position);
                userFacingText.setFont(this.placeNameService.getFont());
                userFacingText.setColor(this.placeNameService.getColor());
                userFacingText.setBackgroundColor(this.placeNameService.getBackgroundColor());
                userFacingText.setVisible(PlaceNameLayer.isNameVisible(drawContext, this.placeNameService, position));
                userFacingText.setPriority(d);
                arrayList.add(userFacingText);
            }
            return arrayList;
        }
    }

    protected static class Tile
    implements Cacheable {
        protected final PlaceNameService placeNameService;
        protected final Sector sector;
        protected final int row;
        protected final int column;
        private Integer hashInt = null;
        protected String fileCachePath = null;
        protected double extentVerticalExaggeration = Double.MIN_VALUE;
        protected double priority = Double.MAX_VALUE;
        protected PlaceNameChunk dataChunk = null;

        Tile(PlaceNameService placeNameService, Sector sector, int n, int n2) {
            this.placeNameService = placeNameService;
            this.sector = sector;
            this.row = n;
            this.column = n2;
            this.fileCachePath = this.placeNameService.createFileCachePathFromTile(this.row, this.column);
            this.hashInt = this.computeHash();
        }

        public void setDataChunk(PlaceNameChunk placeNameChunk) {
            this.dataChunk = placeNameChunk;
        }

        public PlaceNameChunk getDataChunk() {
            return this.dataChunk;
        }

        @Override
        public long getSizeInBytes() {
            long l = 32L;
            l += this.getSector().getSizeInBytes();
            if (this.getFileCachePath() != null) {
                l += (long)this.getFileCachePath().length();
            }
            if (this.dataChunk != null) {
                l += this.dataChunk.estimatedMemorySize;
            }
            return l;
        }

        static int computeRow(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle2.getDegrees() + 90.0) / angle.getDegrees());
        }

        static int computeColumn(Angle angle, Angle angle2) {
            if (angle == null || angle2 == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return (int)((angle2.getDegrees() + 180.0) / angle.getDegrees());
        }

        static Angle computeRowLatitude(int n, Angle angle) {
            if (angle == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return Angle.fromDegrees(-90.0 + angle.getDegrees() * (double)n);
        }

        static Angle computeColumnLongitude(int n, Angle angle) {
            if (angle == null) {
                String string = Logging.getMessage("nullValue.AngleIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            return Angle.fromDegrees(-180.0 + angle.getDegrees() * (double)n);
        }

        public Integer getHashInt() {
            return this.hashInt;
        }

        int computeHash() {
            return this.getFileCachePath() != null ? this.getFileCachePath().hashCode() : 0;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Tile tile = (Tile)object;
            return !(this.getFileCachePath() == null ? tile.getFileCachePath() != null : !this.getFileCachePath().equals(tile.getFileCachePath()));
        }

        public String getFileCachePath() {
            if (this.fileCachePath == null) {
                this.fileCachePath = this.placeNameService.createFileCachePathFromTile(this.row, this.column);
            }
            return this.fileCachePath;
        }

        public PlaceNameService getPlaceNameService() {
            return this.placeNameService;
        }

        public URL getRequestURL() throws MalformedURLException {
            return this.placeNameService.createServiceURLFromSector(this.sector);
        }

        public Sector getSector() {
            return this.sector;
        }

        public int hashCode() {
            return this.hashInt;
        }

        protected boolean isTileInMemoryWithData() {
            Tile tile = (Tile)WorldWind.getMemoryCache(Tile.class.getName()).getObject(this.getFileCachePath());
            return tile != null && tile.getDataChunk() != null;
        }

        public double getPriority() {
            return this.priority;
        }

        public void setPriority(double d) {
            this.priority = d;
        }
    }

    protected class NavigationTile {
        String id;
        protected PlaceNameService placeNameService;
        public Sector navSector;
        protected List<NavigationTile> subNavTiles = new ArrayList<NavigationTile>();
        protected List<String> tileKeys = new ArrayList<String>();
        protected int level;

        NavigationTile(PlaceNameService placeNameService, Sector sector, int n, String string) {
            this.placeNameService = placeNameService;
            this.id = string;
            this.navSector = sector;
            this.level = n;
        }

        protected void buildSubNavTiles() {
            if (this.level > 0) {
                Sector[] sectorArray = this.navSector.subdivide();
                for (int i = 0; i < sectorArray.length; ++i) {
                    this.subNavTiles.add(new NavigationTile(this.placeNameService, sectorArray[i], this.level - 1, this.id + "." + i));
                }
            }
        }

        public List<NavigationTile> navTilesVisible(DrawContext drawContext, double d, double d2) {
            ArrayList<NavigationTile> arrayList = new ArrayList<NavigationTile>();
            if (this.isNavSectorVisible(drawContext, d, d2)) {
                if (this.level > 0 && !this.hasSubTiles()) {
                    this.buildSubNavTiles();
                }
                if (this.hasSubTiles()) {
                    for (NavigationTile navigationTile : this.subNavTiles) {
                        arrayList.addAll(navigationTile.navTilesVisible(drawContext, d, d2));
                    }
                } else {
                    arrayList.add(this);
                }
            }
            return arrayList;
        }

        public boolean hasSubTiles() {
            return !this.subNavTiles.isEmpty();
        }

        protected boolean isNavSectorVisible(DrawContext drawContext, double d, double d2) {
            if (!this.navSector.intersects(drawContext.getVisibleSector())) {
                return false;
            }
            View view = drawContext.getView();
            Position position = view.getEyePosition();
            if (position == null) {
                return false;
            }
            if (Double.isNaN(position.getLatitude().getDegrees()) || Double.isNaN(position.getLongitude().getDegrees())) {
                return false;
            }
            Angle angle = PlaceNameLayer.clampAngle(position.getLatitude(), this.navSector.getMinLatitude(), this.navSector.getMaxLatitude());
            Angle angle2 = PlaceNameLayer.clampAngle(position.getLongitude(), this.navSector.getMinLongitude(), this.navSector.getMaxLongitude());
            Vec4 vec4 = drawContext.getGlobe().computePointFromPosition(angle, angle2, 0.0);
            double d3 = drawContext.getView().getEyePoint().distanceToSquared3(vec4);
            return !(d > d3) && !(d2 < d3);
        }

        public List<Tile> getTiles() {
            if (this.tileKeys.isEmpty()) {
                Tile[] tileArray;
                for (Tile tile : tileArray = PlaceNameLayer.this.buildTiles(this.placeNameService, this)) {
                    this.tileKeys.add(tile.getFileCachePath());
                    WorldWind.getMemoryCache(Tile.class.getName()).add(tile.getFileCachePath(), tile);
                }
                return Arrays.asList(tileArray);
            }
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (String string : this.tileKeys) {
                Tile tile = (Tile)WorldWind.getMemoryCache(Tile.class.getName()).getObject(string);
                if (tile == null) continue;
                arrayList.add(tile);
            }
            return arrayList;
        }
    }
}

