/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.BasicMemoryCache;
import gov.nasa.worldwind.cache.GpuResourceCache;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.util.Level;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileKey;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class TextureTile
extends Tile
implements SurfaceTile {
    private volatile TextureData textureData;
    private TextureTile fallbackTile = null;
    protected boolean hasMipmapData = false;
    protected AtomicLong updateTime = new AtomicLong(0L);

    public static synchronized MemoryCache getMemoryCache() {
        if (!WorldWind.getMemoryCacheSet().containsCache(TextureTile.class.getName())) {
            long l = Configuration.getLongValue("gov.nasa.worldwind.avkey.TextureTileCacheSize", 3000000L);
            BasicMemoryCache basicMemoryCache = new BasicMemoryCache((long)(0.85 * (double)l), l);
            basicMemoryCache.setName("Texture Tiles");
            WorldWind.getMemoryCacheSet().addCache(TextureTile.class.getName(), basicMemoryCache);
        }
        return WorldWind.getMemoryCacheSet().getCache(TextureTile.class.getName());
    }

    public TextureTile(Sector sector) {
        super(sector);
    }

    public TextureTile(Sector sector, Level level, int n, int n2) {
        super(sector, level, n, n2);
    }

    public TextureTile(Sector sector, Level level, int n, int n2, String string) {
        super(sector, level, n, n2, string);
    }

    @Override
    public long getSizeInBytes() {
        long l = super.getSizeInBytes();
        if (this.textureData != null) {
            l += (long)this.textureData.getEstimatedMemorySize();
        }
        return l;
    }

    @Override
    public List<? extends LatLon> getCorners() {
        ArrayList<LatLon> arrayList = new ArrayList<LatLon>(4);
        for (LatLon latLon : this.getSector()) {
            arrayList.add(latLon);
        }
        return arrayList;
    }

    public TextureTile getFallbackTile() {
        return this.fallbackTile;
    }

    public void setFallbackTile(TextureTile textureTile) {
        this.fallbackTile = textureTile;
    }

    public TextureData getTextureData() {
        return this.textureData;
    }

    public void setTextureData(TextureData textureData) {
        this.textureData = textureData;
        if (textureData.getMipmapData() != null) {
            this.hasMipmapData = true;
        }
    }

    public Texture getTexture(GpuResourceCache gpuResourceCache) {
        if (gpuResourceCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return gpuResourceCache.getTexture(this.getTileKey());
    }

    public boolean isTextureInMemory(GpuResourceCache gpuResourceCache) {
        if (gpuResourceCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return this.getTexture(gpuResourceCache) != null || this.getTextureData() != null;
    }

    public long getUpdateTime() {
        return this.updateTime.get();
    }

    public boolean isTextureExpired() {
        return this.isTextureExpired(this.getLevel().getExpiryTime());
    }

    public boolean isTextureExpired(long l) {
        return this.updateTime.get() > 0L && this.updateTime.get() < l;
    }

    public void setTexture(GpuResourceCache gpuResourceCache, Texture texture) {
        if (gpuResourceCache == null) {
            String string = Logging.getMessage("nullValue.TextureCacheIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        gpuResourceCache.put(this.getTileKey(), texture);
        this.updateTime.set(System.currentTimeMillis());
        this.textureData = null;
        this.updateMemoryCache();
    }

    public Vec4 getCentroidPoint(Globe globe) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return globe.computePointFromLocation(this.getSector().getCentroid());
    }

    @Override
    public Extent getExtent(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Sector.computeBoundingBox(drawContext.getGlobe(), drawContext.getVerticalExaggeration(), this.getSector());
    }

    public TextureTile[] createSubTiles(Level level) {
        if (level == null) {
            String string = Logging.getMessage("nullValue.LevelIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle = this.getSector().getMinLatitude();
        Angle angle2 = this.getSector().getMaxLatitude();
        Angle angle3 = Angle.midAngle(angle, angle2);
        Angle angle4 = this.getSector().getMinLongitude();
        Angle angle5 = this.getSector().getMaxLongitude();
        Angle angle6 = Angle.midAngle(angle4, angle5);
        int n = this.getRow();
        int n2 = this.getColumn();
        TextureTile[] textureTileArray = new TextureTile[4];
        TileKey tileKey = this.createSubTileKey(level, 2 * n, 2 * n2);
        TextureTile textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[0] = textureTile != null ? textureTile : this.createSubTile(new Sector(angle, angle3, angle4, angle6), level, 2 * n, 2 * n2);
        tileKey = this.createSubTileKey(level, 2 * n, 2 * n2 + 1);
        textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[1] = textureTile != null ? textureTile : this.createSubTile(new Sector(angle, angle3, angle6, angle5), level, 2 * n, 2 * n2 + 1);
        tileKey = this.createSubTileKey(level, 2 * n + 1, 2 * n2);
        textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[2] = textureTile != null ? textureTile : this.createSubTile(new Sector(angle3, angle2, angle4, angle6), level, 2 * n + 1, 2 * n2);
        tileKey = this.createSubTileKey(level, 2 * n + 1, 2 * n2 + 1);
        textureTile = this.getTileFromMemoryCache(tileKey);
        textureTileArray[3] = textureTile != null ? textureTile : this.createSubTile(new Sector(angle3, angle2, angle6, angle5), level, 2 * n + 1, 2 * n2 + 1);
        return textureTileArray;
    }

    protected TextureTile createSubTile(Sector sector, Level level, int n, int n2) {
        return new TextureTile(sector, level, n, n2);
    }

    protected TileKey createSubTileKey(Level level, int n, int n2) {
        return new TileKey(level.getLevelNumber(), n, n2, level.getCacheName());
    }

    protected TextureTile getTileFromMemoryCache(TileKey tileKey) {
        return (TextureTile)TextureTile.getMemoryCache().getObject(tileKey);
    }

    protected void updateMemoryCache() {
        if (this.getTileFromMemoryCache(this.getTileKey()) != null) {
            TextureTile.getMemoryCache().add(this.getTileKey(), this);
        }
    }

    protected Texture initializeTexture(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTexture(drawContext.getTextureCache());
        if (texture != null && this.getTextureData() == null) {
            return texture;
        }
        if (this.getTextureData() == null) {
            String string = Logging.getMessage("nullValue.TextureDataIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        try {
            texture = TextureIO.newTexture((TextureData)this.getTextureData());
        }
        catch (Exception exception) {
            String string = Logging.getMessage("layers.TextureLayer.ExceptionAttemptingToReadTextureFile", "");
            Logging.logger().log(java.util.logging.Level.SEVERE, string, exception);
            return null;
        }
        this.setTexture(drawContext.getTextureCache(), texture);
        texture.bind();
        this.setTextureParameters(drawContext, texture);
        return texture;
    }

    protected void setTextureParameters(DrawContext drawContext, Texture texture) {
        boolean bl;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        boolean bl2 = bl = (this.hasMipmapData || texture.isUsingAutoMipmapGeneration()) && this.getSector().getMaxLatitude().degrees < 80.0 && this.getSector().getMinLatitude().degrees > -80.0;
        if (bl) {
            gL.glTexParameteri(3553, 10241, 9987);
            double d = drawContext.getGLRuntimeCapabilities().getMaxTextureAnisotropy();
            if (drawContext.getGLRuntimeCapabilities().isUseAnisotropicTextureFilter() && d >= 2.0) {
                gL.glTexParameterf(3553, 34046, (float)d);
            }
        } else {
            gL.glTexParameteri(3553, 10241, 9729);
        }
        gL.glTexParameteri(3553, 10240, 9729);
        gL.glTexParameteri(3553, 10242, 33071);
        gL.glTexParameteri(3553, 10243, 33071);
    }

    @Override
    public boolean bind(DrawContext drawContext) {
        TextureTile textureTile;
        Texture texture;
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.getTextureData() != null && (texture = this.initializeTexture(drawContext)) != null) {
            return true;
        }
        texture = this.getTexture(drawContext.getTextureCache());
        if (texture == null && this.getFallbackTile() != null && (texture = (textureTile = this.getFallbackTile()).getTexture(drawContext.getTextureCache())) == null && (texture = textureTile.initializeTexture(drawContext)) != null) {
            return true;
        }
        if (texture != null) {
            texture.bind();
        }
        return texture != null;
    }

    @Override
    public void applyInternalTransform(DrawContext drawContext, boolean bl) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        Texture texture = this.getTextureData() != null ? this.initializeTexture(drawContext) : this.getTexture(drawContext.getTextureCache());
        if (texture != null) {
            if (texture.getMustFlipVertically()) {
                GL gL = GLContext.getCurrent().getGL();
                if (!bl) {
                    gL.glMatrixMode(5890);
                    gL.glLoadIdentity();
                }
                gL.glScaled(1.0, -1.0, 1.0);
                gL.glTranslated(0.0, -1.0, 0.0);
            }
            return;
        }
        TextureTile textureTile = this.getFallbackTile();
        if (textureTile == null) {
            return;
        }
        texture = textureTile.getTexture(drawContext.getTextureCache());
        if (texture == null && textureTile.getTextureData() != null) {
            texture = textureTile.initializeTexture(drawContext);
        }
        if (texture == null) {
            return;
        }
        GL gL = GLContext.getCurrent().getGL();
        if (!bl) {
            gL.glMatrixMode(5890);
            gL.glLoadIdentity();
        }
        if (texture.getMustFlipVertically()) {
            gL.glScaled(1.0, -1.0, 1.0);
            gL.glTranslated(0.0, -1.0, 0.0);
        }
        this.applyResourceTextureTransform(drawContext);
    }

    protected void applyResourceTextureTransform(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (this.getLevel() == null) {
            return;
        }
        int n = this.getLevelNumber() - this.getFallbackTile().getLevelNumber();
        if (n <= 0) {
            return;
        }
        double d = Math.pow(2.0, n);
        double d2 = 1.0 / d;
        double d3 = d2 * ((double)this.getColumn() % d);
        double d4 = d2 * ((double)this.getRow() % d);
        drawContext.getGL().glTranslated(d3, d4, 0.0);
        drawContext.getGL().glScaled(d2, d2, 1.0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TextureTile textureTile = (TextureTile)object;
        return !(this.getTileKey() == null ? textureTile.getTileKey() != null : !this.getTileKey().equals(textureTile.getTileKey()));
    }

    @Override
    public int hashCode() {
        return this.getTileKey() != null ? this.getTileKey().hashCode() : 0;
    }

    @Override
    public String toString() {
        return this.getSector().toString();
    }
}

