/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.StarsConvertor;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.media.opengl.GL;

public class StarsLayer
extends RenderableLayer {
    protected static final String DEFAULT_STARS_FILE = "config/Hipparcos_Stars_Mag6x5044.dat";
    protected static final double DEFAULT_MIN_ACTIVE_ALTITUDE = 100000.0;
    protected String starsFileName = Configuration.getStringValue("gov.nasa.worldwind.StarsLayer.StarsFileName", "config/Hipparcos_Stars_Mag6x5044.dat");
    protected FloatBuffer starsBuffer;
    protected int numStars;
    protected boolean rebuild;
    protected Double radius;
    protected Angle longitudeOffset = Angle.ZERO;
    protected Angle latitudeOffset = Angle.ZERO;
    protected Object vboCacheKey = new Object();

    public StarsLayer() {
        this.initialize(null, null);
    }

    public StarsLayer(String string) {
        this.initialize(string, null);
    }

    public StarsLayer(String string, Double d) {
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.initialize(string, d);
    }

    protected void initialize(String string, Double d) {
        if (string != null) {
            this.setStarsFileName(string);
        }
        if (d != null) {
            this.radius = d;
        }
        this.setPickEnabled(false);
        this.setMinActiveAltitude(100000.0);
    }

    public String getStarsFileName() {
        return this.starsFileName;
    }

    public void setStarsFileName(String string) {
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.starsFileName = string;
        this.rebuild = true;
    }

    public Angle getLatitudeOffset() {
        return this.latitudeOffset;
    }

    public void setLatitudeOffset(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitudeOffset = angle;
    }

    public Angle getLongitudeOffset() {
        return this.longitudeOffset;
    }

    public void setLongitudeOffset(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.longitudeOffset = angle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRender(DrawContext drawContext) {
        if (this.starsBuffer == null || this.rebuild) {
            this.loadStars();
            this.rebuild = false;
        }
        if (this.starsBuffer == null) {
            return;
        }
        GL gL = drawContext.getGL();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        try {
            double d;
            gL.glDisable(2929);
            oGLStackHandler.pushProjectionIdentity(gL);
            double d2 = d = drawContext.getView().getEyePoint().getLength3();
            double d3 = this.radius + d;
            drawContext.getGLU().gluPerspective(drawContext.getView().getFieldOfView().degrees, drawContext.getView().getViewport().getWidth() / drawContext.getView().getViewport().getHeight(), d2, d3);
            oGLStackHandler.pushModelview(gL);
            gL.glRotatef((float)this.longitudeOffset.degrees, 0.0f, 1.0f, 0.0f);
            gL.glRotatef((float)(-this.latitudeOffset.degrees), 1.0f, 0.0f, 0.0f);
            oGLStackHandler.pushClientAttrib(gL, 2);
            if (drawContext.getGLRuntimeCapabilities().isUseVertexBufferObject()) {
                if (!this.drawWithVBO(drawContext)) {
                    this.drawWithVertexArray(drawContext);
                }
            } else {
                this.drawWithVertexArray(drawContext);
            }
        }
        finally {
            drawContext.restoreDefaultDepthTesting();
            oGLStackHandler.pop(gL);
        }
    }

    protected void drawWithVertexArray(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glInterleavedArrays(10788, 0, (Buffer)this.starsBuffer);
        gL.glDrawArrays(0, 0, this.numStars);
    }

    protected boolean drawWithVBO(DrawContext drawContext) {
        int[] nArray = (int[])drawContext.getGpuResourceCache().get(this.vboCacheKey);
        if (nArray == null) {
            this.fillVbo(drawContext);
            nArray = (int[])drawContext.getGpuResourceCache().get(this.vboCacheKey);
            if (nArray == null) {
                return false;
            }
        }
        GL gL = drawContext.getGL();
        gL.glBindBuffer(34962, nArray[0]);
        gL.glInterleavedArrays(10788, 0, 0L);
        gL.glDrawArrays(0, 0, this.numStars);
        gL.glBindBuffer(34962, 0);
        return true;
    }

    protected void fillVbo(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int[] nArray = new int[1];
        gL.glGenBuffers(1, nArray, 0);
        gL.glBindBuffer(34962, nArray[0]);
        gL.glBufferData(34962, this.starsBuffer.limit() * 4, (Buffer)this.starsBuffer, 35044);
        drawContext.getGpuResourceCache().put(this.vboCacheKey, nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", this.starsBuffer.limit() * 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadStars() {
        Object object;
        Object object2;
        ByteBuffer byteBuffer = null;
        if (WWIO.getSuffix(this.starsFileName).equals("dat")) {
            try {
                object2 = WWIO.openFileOrResourceStream(this.starsFileName, this.getClass());
                if (object2 == null) {
                    String string = Logging.getMessage("layers.StarLayer.CannotReadStarFile");
                    Logging.logger().severe(string);
                    return;
                }
                try {
                    byteBuffer = WWIO.readStreamToBuffer((InputStream)object2, true);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                }
                finally {
                    WWIO.closeStream(object2, this.starsFileName);
                }
            }
            catch (IOException iOException) {
                object = "IOException while loading stars data from " + this.starsFileName;
                Logging.logger().severe((String)object);
            }
        } else {
            byteBuffer = StarsConvertor.convertTsvToByteBuffer(this.starsFileName);
        }
        if (byteBuffer == null) {
            object2 = "IOException while loading stars data from " + this.starsFileName;
            Logging.logger().severe((String)object2);
            return;
        }
        if (this.radius == null) {
            this.radius = byteBuffer.getFloat();
        } else {
            byteBuffer.getFloat();
        }
        this.starsBuffer = byteBuffer.asFloatBuffer();
        if (byteBuffer.order() != ByteOrder.nativeOrder()) {
            object2 = ByteBuffer.allocateDirect(byteBuffer.limit());
            object = ((ByteBuffer)object2).asFloatBuffer();
            for (int i = 0; i < ((Buffer)object).limit(); ++i) {
                ((FloatBuffer)object).put(this.starsBuffer.get(i));
            }
            ((FloatBuffer)object).flip();
            this.starsBuffer = object;
        }
        this.numStars = this.starsBuffer.limit() / 6;
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.Earth.StarsLayer.Name");
    }
}

