/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.BasicFactory;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Sphere;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.globes.GlobeStateKey;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.terrain.Tessellator;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.util.List;

public class EllipsoidalGlobe
extends WWObjectImpl
implements Globe {
    protected final double equatorialRadius;
    protected final double polarRadius;
    protected final double es;
    private final Vec4 center;
    private ElevationModel elevationModel;
    private Tessellator tessellator;

    public EllipsoidalGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = Vec4.ZERO;
        this.elevationModel = elevationModel;
        this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
    }

    public EllipsoidalGlobe(double d, double d2, double d3, ElevationModel elevationModel, Vec4 vec4) {
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = vec4;
        this.elevationModel = elevationModel;
        this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return this.getGlobeStateKey(drawContext);
    }

    @Override
    public GlobeStateKey getGlobeStateKey(DrawContext drawContext) {
        return new StateKey(drawContext);
    }

    @Override
    public GlobeStateKey getGlobeStateKey() {
        return new StateKey(this);
    }

    @Override
    public Tessellator getTessellator() {
        return this.tessellator;
    }

    @Override
    public void setTessellator(Tessellator tessellator) {
        this.tessellator = tessellator;
    }

    @Override
    public ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    @Override
    public void setElevationModel(ElevationModel elevationModel) {
        this.elevationModel = elevationModel;
    }

    @Override
    public double getRadius() {
        return this.equatorialRadius;
    }

    @Override
    public double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    @Override
    public double getPolarRadius() {
        return this.polarRadius;
    }

    @Override
    public double getMaximumRadius() {
        return this.equatorialRadius;
    }

    @Override
    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(angle, angle2, 0.0).getLength3();
    }

    @Override
    public double getRadiusAt(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0).getLength3();
    }

    @Override
    public double getEccentricitySquared() {
        return this.es;
    }

    @Override
    public double getDiameter() {
        return this.equatorialRadius * 2.0;
    }

    @Override
    public Vec4 getCenter() {
        return this.center;
    }

    @Override
    public double getMaxElevation() {
        return this.elevationModel != null ? this.elevationModel.getMaxElevation() : 0.0;
    }

    @Override
    public double getMinElevation() {
        return this.elevationModel != null ? this.elevationModel.getMinElevation() : 0.0;
    }

    @Override
    public double[] getMinAndMaxElevations(Angle angle, Angle angle2) {
        double[] dArray;
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.elevationModel != null) {
            dArray = this.elevationModel.getExtremeElevations(angle, angle2);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        return dArray;
    }

    @Override
    public double[] getMinAndMaxElevations(Sector sector) {
        double[] dArray;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.elevationModel != null) {
            dArray = this.elevationModel.getExtremeElevations(sector);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        return dArray;
    }

    @Override
    public Extent getExtent() {
        return this;
    }

    @Override
    public double getEffectiveRadius(Plane plane) {
        return this.getRadius();
    }

    @Override
    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(new Sphere(Vec4.ZERO, this.getRadius()));
    }

    @Override
    public Intersection[] intersect(Line line) {
        return this.intersect(line, this.equatorialRadius, this.polarRadius);
    }

    @Override
    public Intersection[] intersect(Line line, double d) {
        return this.intersect(line, this.equatorialRadius + d, this.polarRadius + d);
    }

    protected Intersection[] intersect(Line line, double d, double d2) {
        if (line == null) {
            return null;
        }
        double d3 = line.getDirection().x;
        double d4 = d / d2;
        double d5 = d4 * d4;
        double d6 = line.getDirection().y;
        double d7 = 1.0;
        double d8 = d7 * d7;
        double d9 = line.getDirection().z;
        double d10 = d3 * d3 + d5 * d6 * d6 + d8 * d9 * d9;
        double d11 = line.getOrigin().x;
        double d12 = line.getOrigin().y;
        double d13 = line.getOrigin().z;
        double d14 = 2.0 * (d11 * d3 + d5 * d12 * d6 + d8 * d13 * d9);
        double d15 = d * d;
        double d16 = d11 * d11 + d5 * d12 * d12 + d8 * d13 * d13 - d15;
        double d17 = EllipsoidalGlobe.discriminant(d10, d14, d16);
        if (d17 < 0.0) {
            return null;
        }
        double d18 = Math.sqrt(d17);
        if (d17 == 0.0) {
            Vec4 vec4 = line.getPointAt((-d14 - d18) / (2.0 * d10));
            return new Intersection[]{new Intersection(vec4, true)};
        }
        Vec4 vec4 = line.getPointAt((-d14 - d18) / (2.0 * d10));
        Vec4 vec42 = line.getPointAt((-d14 + d18) / (2.0 * d10));
        if (d16 >= 0.0) {
            return new Intersection[]{new Intersection(vec4, false), new Intersection(vec42, false)};
        }
        return new Intersection[]{new Intersection(vec42, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    @Override
    public Intersection[] intersect(Triangle triangle, double d) {
        if (triangle == null) {
            return null;
        }
        boolean bl = this.isPointAboveElevation(triangle.getA(), d);
        boolean bl2 = this.isPointAboveElevation(triangle.getB(), d);
        boolean bl3 = this.isPointAboveElevation(triangle.getC(), d);
        if (!(bl ^ bl2) && !(bl2 ^ bl3)) {
            return null;
        }
        Intersection[] intersectionArray = new Intersection[2];
        int n = 0;
        if (bl ^ bl2) {
            intersectionArray[n++] = bl ? this.intersect(new Line(triangle.getB(), triangle.getA().subtract3(triangle.getB())), d)[0] : this.intersect(new Line(triangle.getA(), triangle.getB().subtract3(triangle.getA())), d)[0];
        }
        if (bl2 ^ bl3) {
            intersectionArray[n++] = bl2 ? this.intersect(new Line(triangle.getC(), triangle.getB().subtract3(triangle.getC())), d)[0] : this.intersect(new Line(triangle.getB(), triangle.getC().subtract3(triangle.getB())), d)[0];
        }
        if (bl3 ^ bl) {
            intersectionArray[n] = bl3 ? this.intersect(new Line(triangle.getA(), triangle.getC().subtract3(triangle.getA())), d)[0] : this.intersect(new Line(triangle.getC(), triangle.getA().subtract3(triangle.getC())), d)[0];
        }
        return intersectionArray;
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            return false;
        }
        return line.distanceTo(this.center) <= this.equatorialRadius;
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            return false;
        }
        double d = plane.dot(this.center);
        return d <= this.equatorialRadius;
    }

    @Override
    public double getProjectedArea(View view) {
        if (view == null) {
            String string = Logging.getMessage("nullValue.ViewIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return WWMath.computeSphereProjectedArea(view, this.getCenter(), this.getRadius());
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.elevationModel != null ? this.elevationModel.getElevations(sector, list, d, dArray) : 0.0;
    }

    @Override
    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel != null ? this.elevationModel.getElevation(angle, angle2) : 0.0;
    }

    @Override
    public Vec4 computePointFromPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    @Override
    public Vec4 computePointFromLocation(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(latLon.getLatitude(), latLon.getLongitude(), 0.0);
    }

    @Override
    public Vec4 computePointFromPosition(LatLon latLon, double d) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(latLon.getLatitude(), latLon.getLongitude(), d);
    }

    @Override
    public Vec4 computePointFromPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(angle, angle2, d);
    }

    @Override
    public Position computePositionFromPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.cartesianToGeodetic(vec4);
    }

    @Override
    public Vec4 computeSurfaceNormalAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle2.cos();
        double d3 = angle.sin();
        double d4 = angle2.sin();
        double d5 = this.equatorialRadius * this.equatorialRadius;
        double d6 = this.polarRadius * this.polarRadius;
        double d7 = d * d4 / d5;
        double d8 = (1.0 - this.es) * d3 / d6;
        double d9 = d * d2 / d5;
        return new Vec4(d7, d8, d9).normalize3();
    }

    @Override
    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.equatorialRadius * this.equatorialRadius;
        double d2 = this.polarRadius * this.polarRadius;
        double d3 = (vec4.x - this.center.x) / d;
        double d4 = (vec4.y - this.center.y) / d2;
        double d5 = (vec4.z - this.center.z) / d;
        return new Vec4(d3, d4, d5).normalize3();
    }

    @Override
    public Vec4 computeNorthPointingTangentAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        angle = angle.multiply(-1.0);
        double d = angle.cos();
        double d2 = angle.sin();
        double d3 = angle2.cos();
        double d4 = angle2.sin();
        double d5 = d2 * d4;
        double d6 = d;
        double d7 = d2 * d3;
        return new Vec4(d5, d6, d7).normalize3();
    }

    @Override
    public Matrix computeModelCoordinateOriginTransform(Angle angle, Angle angle2, double d) {
        return this.computeSurfaceOrientationAtPosition(angle, angle2, d);
    }

    @Override
    public Matrix computeModelCoordinateOriginTransform(Position position) {
        return this.computeSurfaceOrientationAtPosition(position);
    }

    @Override
    public Matrix computeSurfaceOrientationAtPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.geodeticToCartesian(angle, angle2, d);
        Matrix matrix = Matrix.fromTranslation(vec4);
        matrix = matrix.multiply(Matrix.fromRotationY(angle2));
        matrix = matrix.multiply(Matrix.fromRotationX(angle.multiply(-1.0)));
        return matrix;
    }

    @Override
    public Matrix computeSurfaceOrientationAtPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeSurfaceOrientationAtPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    @Override
    public Position getIntersectionPosition(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Intersection[] intersectionArray = this.intersect(line);
        if (intersectionArray == null) {
            return null;
        }
        return this.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
    }

    protected Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = Math.cos(angle.radians);
        double d3 = Math.sin(angle.radians);
        double d4 = Math.cos(angle2.radians);
        double d5 = Math.sin(angle2.radians);
        double d6 = this.equatorialRadius / Math.sqrt(1.0 - this.es * d3 * d3);
        double d7 = (d6 + d) * d2 * d5;
        double d8 = (d6 * (1.0 - this.es) + d) * d3;
        double d9 = (d6 + d) * d2 * d4;
        return new Vec4(d7, d8, d9);
    }

    protected Position cartesianToGeodetic(Vec4 vec4) {
        double d;
        double d2;
        double d3;
        double d4;
        if (null == vec4) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d5 = vec4.z;
        double d6 = vec4.x;
        double d7 = vec4.y;
        double d8 = d5 * d5 + d6 * d6;
        double d9 = Math.sqrt(d8);
        double d10 = this.equatorialRadius;
        double d11 = 1.0 / (d10 * d10);
        double d12 = d8 * d11;
        double d13 = this.es;
        double d14 = d7 * d7 * (1.0 - d13) * d11;
        double d15 = d13 * d13;
        double d16 = (d12 + d14 - d15) / 6.0;
        double d17 = 8.0 * d16 * d16 * d16 + d15 * d12 * d14;
        if (d17 > 0.0 || d14 != 0.0) {
            double d18;
            double d19;
            double d20;
            if (d17 > 0.0) {
                d4 = Math.sqrt(d17);
                d20 = Math.sqrt(d15 * d12 * d14);
                if (d17 > 10.0 * d13) {
                    d19 = Math.cbrt((d4 + d20) * (d4 + d20));
                    d3 = d16 + 0.5 * d19 + 2.0 * d16 * d16 / d19;
                } else {
                    d3 = d16 + 0.5 * Math.cbrt((d4 + d20) * (d4 + d20)) + 0.5 * Math.cbrt((d4 - d20) * (d4 - d20));
                }
            } else {
                d4 = Math.sqrt(-d17);
                d20 = Math.sqrt(-8.0 * d16 * d16 * d16);
                d19 = Math.sqrt(d15 * d12 * d14);
                d18 = 2.0 * Math.atan2(d19, d4 + d20) / 3.0;
                d3 = -4.0 * d16 * Math.sin(d18) * Math.cos(0.5235987755982988 + d18);
            }
            d4 = Math.sqrt(d3 * d3 + d15 * d14);
            d20 = d13 * (d3 + d4 - d14) / (2.0 * d4);
            d19 = (d3 + d4) / (Math.sqrt(d20 * d20 + d3 + d4) + d20);
            d18 = d19 * d9 / (d19 + d13);
            double d21 = Math.sqrt(d18 * d18 + d7 * d7);
            d2 = (d19 + d13 - 1.0) * d21 / d19;
            d = 2.0 * Math.atan2(d7, d21 + d18);
        } else {
            d3 = Math.sqrt(1.0 - d13);
            d4 = Math.sqrt(d13 - d12);
            double d22 = Math.sqrt(d13);
            d2 = -d10 * d3 * d4 / d22;
            d = d4 / (d22 * d4 + d3 * Math.sqrt(d12));
        }
        d4 = Math.sqrt(2.0);
        d3 = (d4 - 1.0) * d6 < d9 + d5 ? 2.0 * Math.atan2(d6, d9 + d5) : (d9 + d6 < (d4 + 1.0) * d5 ? -1.5707963267948966 + 2.0 * Math.atan2(d5, d9 - d6) : 1.5707963267948966 - 2.0 * Math.atan2(d5, d9 + d6));
        return Position.fromRadians(d, d3, d2);
    }

    @Override
    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (this.tessellator == null) {
            this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
            if (this.tessellator == null) {
                String string = Logging.getMessage("Tessellator.TessellatorUnavailable");
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
        }
        return this.tessellator.tessellate(drawContext);
    }

    @Override
    public boolean isPointAboveElevation(Vec4 vec4, double d) {
        if (vec4 == null) {
            return false;
        }
        return vec4.x() * vec4.x() / ((this.equatorialRadius + d) * (this.equatorialRadius + d)) + vec4.y() * vec4.y() / ((this.polarRadius + d) * (this.polarRadius + d)) + vec4.z() * vec4.z() / ((this.equatorialRadius + d) * (this.equatorialRadius + d)) - 1.0 > 0.0;
    }

    public static ElevationModel makeElevationModel(String string, String string2) {
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.KeyIsNull");
            throw new IllegalArgumentException(string3);
        }
        String string4 = Configuration.getStringValue(string, string2);
        return (ElevationModel)BasicFactory.create("gov.nasa.worldwind.avkey.ElevationModelFactory", string4);
    }

    protected class StateKey
    implements GlobeStateKey {
        protected Globe globe;
        protected final Tessellator tessellator;
        protected double verticalExaggeration;
        protected ElevationModel elevationModel;

        public StateKey(DrawContext drawContext) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.globe = drawContext.getGlobe();
            this.tessellator = EllipsoidalGlobe.this.tessellator;
            this.verticalExaggeration = drawContext.getVerticalExaggeration();
            this.elevationModel = this.globe.getElevationModel();
        }

        public StateKey(Globe globe) {
            this.globe = globe;
            this.tessellator = EllipsoidalGlobe.this.tessellator;
            this.verticalExaggeration = 1.0;
            this.elevationModel = this.globe.getElevationModel();
        }

        @Override
        public Globe getGlobe() {
            return this.globe;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StateKey stateKey = (StateKey)object;
            if (Double.compare(stateKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            if (this.elevationModel != null ? !this.elevationModel.equals(stateKey.elevationModel) : stateKey.elevationModel != null) {
                return false;
            }
            if (this.globe != null ? !this.globe.equals(stateKey.globe) : stateKey.globe != null) {
                return false;
            }
            return !(this.tessellator != null ? !this.tessellator.equals(stateKey.tessellator) : stateKey.tessellator != null);
        }

        public int hashCode() {
            int n = this.globe != null ? this.globe.hashCode() : 0;
            n = 31 * n + (this.tessellator != null ? this.tessellator.hashCode() : 0);
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            n = 31 * n + (this.elevationModel != null ? this.elevationModel.hashCode() : 0);
            return n;
        }
    }
}

