/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.shapefile;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.formats.shapefile.DBaseFile;
import gov.nasa.worldwind.util.Logging;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;

public class DBaseField {
    public static final String TYPE_CHAR = "DBase.FieldTypeChar";
    public static final String TYPE_NUMBER = "DBase.FieldTypeNumber";
    public static final String TYPE_DATE = "DBase.FieldTypeDate";
    public static final String TYPE_BOOLEAN = "DBase.FieldTypeBoolean";
    protected static final int FIELD_NAME_LENGTH = 11;
    private String name;
    private String type;
    private int length;
    private int decimals;

    public DBaseField(DBaseFile dBaseFile, ByteBuffer byteBuffer) {
        if (dBaseFile == null) {
            String string = Logging.getMessage("nullValue.DBaseFileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.readFromBuffer(dBaseFile, byteBuffer);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimals() {
        return this.decimals;
    }

    protected void readFromBuffer(DBaseFile dBaseFile, ByteBuffer byteBuffer) {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n = byteBuffer.position();
        byte[] byArray = new byte[11];
        int n2 = dBaseFile.readZeroTerminatedString(byteBuffer, byArray, 11);
        this.name = dBaseFile.decodeString(byArray, n2);
        char c = (char)byteBuffer.get();
        this.type = DBaseField.getFieldType(c);
        if (this.type == null) {
            String string = Logging.getMessage("SHP.UnsupportedDBaseFieldType", Character.valueOf(c));
            Logging.logger().log(Level.SEVERE, string);
            throw new WWRuntimeException(string);
        }
        byteBuffer.getInt();
        this.length = 0xFF & byteBuffer.get();
        this.decimals = 0xFF & byteBuffer.get();
        byteBuffer.position(n + 32);
    }

    public static String getFieldType(char c) {
        switch (c) {
            case 'C': {
                return TYPE_CHAR;
            }
            case 'D': {
                return TYPE_DATE;
            }
            case 'F': {
                return TYPE_NUMBER;
            }
            case 'L': {
                return TYPE_BOOLEAN;
            }
            case 'N': {
                return TYPE_NUMBER;
            }
        }
        return null;
    }
}

