/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nitfs;

import gov.nasa.worldwind.formats.nitfs.CompressionLookupRecord;
import gov.nasa.worldwind.formats.nitfs.NITFSImageBand;
import gov.nasa.worldwind.formats.nitfs.NITFSRuntimeException;
import gov.nasa.worldwind.formats.nitfs.NITFSSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.nitfs.NITFSUtil;
import gov.nasa.worldwind.formats.nitfs.UserDefinedImageSubheader;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RPFImageType;
import gov.nasa.worldwind.formats.rpf.RPFLocationSection;
import gov.nasa.worldwind.geom.LatLon;
import java.nio.ByteBuffer;

public class NITFSImageSegment
extends NITFSSegment {
    public static final String[] SupportedFormats = new String[]{"CIB", "CADRG", "ADRG"};
    public String partType;
    public String imageID;
    public String dateTime;
    public String targetID;
    public String imageTitle;
    public String securityClass;
    public String codewords;
    public String controlAndHandling;
    public String releaseInstructions;
    public String classAuthority;
    public String securityCtrlNum;
    public String ISDWNG;
    public String ISDEVT;
    public short encryption;
    public String imageSource;
    public int numSignificantRows;
    public int numSignificantCols;
    public String pixelValueType;
    public String imageRepresentation;
    public String imageCategory;
    public short bitsPerPixelPerBand;
    public String pixelJustification;
    public String imageCoordSystem;
    public LatLon[] imageCoords;
    public String[] imageCommentRecords;
    public String imageCompression;
    public String compressionRateCode;
    public short NBANDS;
    public NITFSImageBand[] imageBands;
    public short imageSyncCode;
    public String imageMode;
    public short numOfBlocksPerRow;
    public short numOfBlocksPerCol;
    public short numOfPixelsPerBlockH;
    public short numOfPixelsPerBlockV;
    public short numOfBitsPerPixelPerBand;
    public short displayLevel;
    public short attachmentLevel;
    public short imageRowOffset;
    public short imageColOffset;
    public String imageMagnification;
    public short userDefinedSubheaderLength;
    private UserDefinedImageSubheader userDefSubheader;
    private long numOfImageRows;
    private long numOfImageCodesPerRow;
    private short imageCodeBitLength;
    private int compressionAlgorithmID;
    private int numOfCompressionLookupOffsetRecords;
    private int numOfCompressionParameterOffsetRecords;
    private long compressionLookupOffsetTableOffset;
    private int compressionLookupTableOffsetRecordLength;
    private int subframeSequenceRecordLength;
    private int transparencySequenceRecordLength;
    private int transparentOutputPixelCodeLength;
    private int transparentOutputPixelCode;
    private int[] subFrameOffsets = null;
    private boolean hasTransparentPixels = false;
    private boolean hasMaskedSubframes = false;
    private CompressionLookupRecord[] compressionLUTS;

    public static String[] getSupportedFormats() {
        return SupportedFormats;
    }

    public boolean hasTransparentPixels() {
        return this.hasTransparentPixels;
    }

    public boolean hasMaskedSubframes() {
        return this.hasMaskedSubframes;
    }

    public UserDefinedImageSubheader getUserDefinedImageSubheader() {
        return this.userDefSubheader;
    }

    public RPFFrameFileComponents getRPFFrameFileComponents() {
        return null != this.userDefSubheader ? this.userDefSubheader.getRPFFrameFileComponents() : null;
    }

    public NITFSImageSegment(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        super(NITFSSegmentType.IMAGE_SEGMENT, byteBuffer, n, n2, n3, n4);
        int n5 = byteBuffer.position();
        byteBuffer.position(n);
        this.parseIdentificationSecurityStructureFields(byteBuffer);
        this.parseImageGeographicLocation(byteBuffer);
        this.parseCommentRecords(byteBuffer);
        this.parseImageCompressionStructure(byteBuffer);
        this.parseImageBands(byteBuffer);
        this.parseImageTableStructure(byteBuffer);
        this.parseImageLocation(byteBuffer);
        this.parseImageSubheaders(byteBuffer);
        this.parseImageData(byteBuffer);
        this.validateImage();
        byteBuffer.position(n5);
    }

    private void decompressBlock4x4(byte[][] byArray, short s) {
        this.compressionLUTS[0].copyValues(byArray[0], 0, s, 4);
        this.compressionLUTS[1].copyValues(byArray[1], 0, s, 4);
        this.compressionLUTS[2].copyValues(byArray[2], 0, s, 4);
        this.compressionLUTS[3].copyValues(byArray[3], 0, s, 4);
    }

    private void decompressBlock16(byte[] byArray, short s) {
        this.compressionLUTS[0].copyValues(byArray, 0, s, 4);
        this.compressionLUTS[1].copyValues(byArray, 4, s, 4);
        this.compressionLUTS[2].copyValues(byArray, 8, s, 4);
        this.compressionLUTS[3].copyValues(byArray, 12, s, 4);
    }

    public int[] getImagePixelsAsArray(int[] nArray, RPFImageType rPFImageType) throws NITFSRuntimeException {
        RPFFrameFileComponents rPFFrameFileComponents = this.getRPFFrameFileComponents();
        RPFLocationSection rPFLocationSection = rPFFrameFileComponents.componentLocationTable;
        int n = rPFLocationSection.getSpatialDataSubsectionLocation();
        this.buffer.position(n);
        int n2 = 0;
        NITFSImageBand nITFSImageBand = this.imageBands[n2];
        short[] sArray = new short[(int)this.numOfImageCodesPerRow];
        byte[][] byArray = new byte[4][4];
        short s = (short)(this.numOfImageCodesPerRow * (long)this.imageCodeBitLength / 8L);
        byte[] byArray2 = new byte[s];
        int n3 = 0;
        for (int i = 0; i < this.numOfBlocksPerCol; ++i) {
            int n4 = 0;
            while (n4 < this.numOfBlocksPerRow) {
                block17: {
                    int n5;
                    int n6;
                    block16: {
                        n6 = (int)((long)i * rPFFrameFileComponents.numOfOutputRowsPerSubframe);
                        n5 = (int)((long)n4 * rPFFrameFileComponents.numOfOutputColumnsPerSubframe);
                        if (!this.hasMaskedSubframes) break block16;
                        int n7 = this.subFrameOffsets[n3];
                        if (-1 == n7) break block17;
                        this.buffer.position(n + n7);
                    }
                    int n8 = 0;
                    while ((long)n8 < this.numOfImageRows) {
                        int n9;
                        int n10 = n6 + n8 * 4;
                        this.buffer.get(byArray2, 0, s);
                        int n11 = 0;
                        int n12 = 0;
                        for (n9 = 0; n9 < (int)this.numOfImageCodesPerRow / 2; ++n9) {
                            short s2 = (short)((0xFF & (short)byArray2[n12++]) << 4);
                            short s3 = (short)(0xFF & (short)byArray2[n12++]);
                            short s4 = (short)(0xFF & (short)byArray2[n12++]);
                            sArray[n11++] = (short)(s2 | (0xF0 & s3) >> 4);
                            sArray[n11++] = (short)(s4 | (0xF & s3) << 8);
                        }
                        n9 = 0;
                        while ((long)n9 < this.numOfImageCodesPerRow) {
                            if (!this.hasTransparentPixels || 4095 != sArray[n9]) {
                                this.decompressBlock4x4(byArray, sArray[n9]);
                                n11 = n5 + n9 * 4;
                                for (n12 = 0; n12 < 4; ++n12) {
                                    for (int j = 0; j < 4; ++j) {
                                        int n13 = 0xFF & byArray[n12][j];
                                        if (this.hasTransparentPixels && this.transparentOutputPixelCode == n13 || nITFSImageBand.isReservedApplicationCode(n13)) continue;
                                        int n14 = nITFSImageBand.lookupRGB(n13);
                                        switch (rPFImageType) {
                                            case IMAGE_TYPE_ALPHA_RGB: {
                                                n14 = -16777216 + n14;
                                                break;
                                            }
                                            case IMAGE_TYPE_GRAY_ALPHA: {
                                                n14 = (n14 << 8) + 255;
                                                break;
                                            }
                                            case IMAGE_TYPE_RGB_ALPHA: {
                                                n14 = (n14 << 8) + 255;
                                            }
                                        }
                                        nArray[(n10 + n12) * this.numSignificantCols + (n11 + j)] = n14;
                                    }
                                }
                            }
                            ++n9;
                        }
                        ++n8;
                    }
                }
                ++n4;
                n3 = (short)(n3 + 1);
            }
        }
        return nArray;
    }

    private void validateImage() throws NITFSRuntimeException {
        RPFFrameFileComponents rPFFrameFileComponents = this.getRPFFrameFileComponents();
        if (1 != this.compressionAlgorithmID) {
            throw new NITFSRuntimeException("NITFSReader.UnsupportedCompressionAlgorithm");
        }
        if (!"B".equals(this.imageMode)) {
            throw new NITFSRuntimeException("NITFSReader.UnsupportedImageMode");
        }
        if (1 != rPFFrameFileComponents.numOfSpectralGroups) {
            throw new NITFSRuntimeException("NITFSReader.UnsupportedNumberOfSpectralGroups.");
        }
        if (12 != this.imageCodeBitLength) {
            throw new NITFSRuntimeException("NITFSReader.UnsupportedImageCodeBitLength.");
        }
    }

    private void parseRPFMaskSubsection(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        Object object;
        int n = byteBuffer.position();
        int n2 = (int)this.getRPFFrameFileComponents().subframeMaskTableOffset;
        int n3 = (int)this.getRPFFrameFileComponents().transparencyMaskTableOffset;
        this.subframeSequenceRecordLength = NITFSUtil.getUShort(byteBuffer);
        this.transparencySequenceRecordLength = NITFSUtil.getUShort(byteBuffer);
        this.transparentOutputPixelCodeLength = NITFSUtil.getUShort(byteBuffer);
        if (0 != this.transparentOutputPixelCodeLength) {
            object = NITFSUtil.getBitString(byteBuffer, this.transparentOutputPixelCodeLength);
            this.transparentOutputPixelCode = Integer.parseInt((String)object, 2);
        }
        if (-1 != n2 || 0 < this.subframeSequenceRecordLength) {
            if (-1 != n2) {
                byteBuffer.position(n + n2);
            }
            object = this.getRPFFrameFileComponents();
            this.subFrameOffsets = new int[this.numOfBlocksPerCol * this.numOfBlocksPerRow];
            int n4 = 0;
            for (int i = 0; i < ((RPFFrameFileComponents)object).numOfSpectralGroups; ++i) {
                for (int j = 0; j < this.numOfBlocksPerCol; ++j) {
                    for (int k = 0; k < this.numOfBlocksPerRow; ++k) {
                        this.subFrameOffsets[n4++] = (int)NITFSUtil.getUInt(byteBuffer);
                    }
                }
            }
        } else {
            this.subFrameOffsets = null;
        }
        if (-1 != n3 || 0 < this.transparencySequenceRecordLength) {
            // empty if block
        }
        this.hasMaskedSubframes = null != this.subFrameOffsets && 0 < this.subFrameOffsets.length;
        this.hasTransparentPixels = 0 < this.transparencySequenceRecordLength || 0 < this.transparentOutputPixelCodeLength;
    }

    private void parseImageData(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        RPFLocationSection rPFLocationSection = this.getRPFFrameFileComponents().componentLocationTable;
        byteBuffer.position(this.dataStartOffset);
        long l = NITFSUtil.getUInt(byteBuffer);
        if (0 < rPFLocationSection.getMaskSubsectionLength()) {
            byteBuffer.position(rPFLocationSection.getMaskSubsectionLocation());
            this.parseRPFMaskSubsection(byteBuffer);
        }
        if (0 >= rPFLocationSection.getImageDisplayParametersSubheaderLength()) {
            throw new NITFSRuntimeException("NITFSReader.ImageDisplayParametersSubheaderNotFound");
        }
        byteBuffer.position(rPFLocationSection.getImageDisplayParametersSubheaderLocation());
        this.parseImageDisplayParametersSubheader(byteBuffer);
        if (0 >= rPFLocationSection.getCompressionSectionSubheaderLength()) {
            throw new NITFSRuntimeException("NITFSReader.RPFCompressionSectionSubheaderNotFound");
        }
        byteBuffer.position(rPFLocationSection.getCompressionSectionSubheaderLocation());
        this.parseRPFCompressionSectionSubheader(byteBuffer);
        if (0 >= rPFLocationSection.getCompressionLookupSubsectionLength()) {
            throw new NITFSRuntimeException("NITFSReader.RPFCompressionLookupSubsectionNotFound");
        }
        byteBuffer.position(rPFLocationSection.getCompressionLookupSubsectionLocation());
        this.parseRPFCompressionLookupSubsection(byteBuffer);
        if (0 < rPFLocationSection.getCompressionParameterSubsectionLength()) {
            throw new NITFSRuntimeException("NITFSReader.RPFCompressionParameterSubsectionNotImplemented");
        }
        if (0 >= rPFLocationSection.getSpatialDataSubsectionLength()) {
            throw new NITFSRuntimeException("NITFSReader.RPFSpatialDataSubsectionNotFound");
        }
        byteBuffer.position(rPFLocationSection.getSpatialDataSubsectionLocation());
        this.parseRPFSpatialDataSubsection(byteBuffer);
    }

    private void parseRPFSpatialDataSubsection(ByteBuffer byteBuffer) throws NITFSRuntimeException {
    }

    private void parseRPFCompressionLookupSubsection(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        int n = byteBuffer.position();
        this.compressionLookupOffsetTableOffset = NITFSUtil.getUInt(byteBuffer);
        this.compressionLookupTableOffsetRecordLength = NITFSUtil.getUShort(byteBuffer);
        this.compressionLUTS = new CompressionLookupRecord[this.numOfCompressionLookupOffsetRecords];
        for (int i = 0; i < this.numOfCompressionLookupOffsetRecords; ++i) {
            this.compressionLUTS[i] = new CompressionLookupRecord(byteBuffer, n, this.getRPFFrameFileComponents().rpfColorMaps);
        }
    }

    private void parseRPFCompressionSectionSubheader(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.compressionAlgorithmID = NITFSUtil.getUShort(byteBuffer);
        this.numOfCompressionLookupOffsetRecords = NITFSUtil.getUShort(byteBuffer);
        this.numOfCompressionParameterOffsetRecords = NITFSUtil.getUShort(byteBuffer);
    }

    private void parseImageDisplayParametersSubheader(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.numOfImageRows = NITFSUtil.getUInt(byteBuffer);
        this.numOfImageCodesPerRow = NITFSUtil.getUInt(byteBuffer);
        this.imageCodeBitLength = NITFSUtil.getByteAsShort(byteBuffer);
    }

    private void parseImageSubheaders(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.userDefinedSubheaderLength = NITFSUtil.getShortNumeric(byteBuffer, 5);
        if (0 == this.userDefinedSubheaderLength) {
            this.userDefSubheader = null;
            return;
        }
        this.userDefSubheader = new UserDefinedImageSubheader(byteBuffer);
    }

    private void parseImageLocation(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.imageRowOffset = NITFSUtil.getShortNumeric(byteBuffer, 5);
        this.imageColOffset = NITFSUtil.getShortNumeric(byteBuffer, 5);
        this.imageMagnification = NITFSUtil.getString(byteBuffer, 4);
    }

    private void parseImageTableStructure(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.imageSyncCode = NITFSUtil.getShortNumeric(byteBuffer, 1);
        this.imageMode = NITFSUtil.getString(byteBuffer, 1);
        this.numOfBlocksPerRow = NITFSUtil.getShortNumeric(byteBuffer, 4);
        this.numOfBlocksPerCol = NITFSUtil.getShortNumeric(byteBuffer, 4);
        this.numOfPixelsPerBlockH = NITFSUtil.getShortNumeric(byteBuffer, 4);
        this.numOfPixelsPerBlockV = NITFSUtil.getShortNumeric(byteBuffer, 4);
        this.numOfBitsPerPixelPerBand = NITFSUtil.getShortNumeric(byteBuffer, 2);
        this.displayLevel = NITFSUtil.getShortNumeric(byteBuffer, 3);
        this.attachmentLevel = NITFSUtil.getShortNumeric(byteBuffer, 3);
    }

    private void parseImageBands(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        if (0 == this.NBANDS) {
            throw new NITFSRuntimeException("NITFSReader.InvalidNumberOfImageBands");
        }
        this.imageBands = new NITFSImageBand[this.NBANDS];
        for (int i = 0; i < this.NBANDS; ++i) {
            this.imageBands[i] = new NITFSImageBand(byteBuffer);
        }
    }

    private void parseImageCompressionStructure(ByteBuffer byteBuffer) {
        this.imageCompression = NITFSUtil.getString(byteBuffer, 2);
        this.compressionRateCode = NITFSUtil.getString(byteBuffer, 4);
        this.NBANDS = NITFSUtil.getShortNumeric(byteBuffer, 1);
    }

    private void parseCommentRecords(ByteBuffer byteBuffer) {
        int n = NITFSUtil.getShortNumeric(byteBuffer, 1);
        if (0 < n) {
            this.imageCommentRecords = new String[n];
            for (int i = 0; i < n; ++i) {
                this.imageCommentRecords[i] = NITFSUtil.getString(byteBuffer, 80);
            }
        } else {
            this.imageCommentRecords = null;
        }
    }

    private void parseImageGeographicLocation(ByteBuffer byteBuffer) {
        int n = 15;
        byte[] byArray = new byte[n];
        double d = 60.0;
        this.imageCoords = new LatLon[4];
        for (int i = 0; i < 4; ++i) {
            byteBuffer.get(byArray, 0, n);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray, 0, n);
            double d2 = NITFSUtil.getShortNumeric(byteBuffer2, 2);
            double d3 = NITFSUtil.getShortNumeric(byteBuffer2, 2);
            double d4 = NITFSUtil.getShortNumeric(byteBuffer2, 2);
            String string = NITFSUtil.getString(byteBuffer2, 1);
            double d5 = d2 + (d3 + d4 / d) / d;
            if ("S".equals(string)) {
                d5 *= -1.0;
            }
            int n2 = byArray[14] != 0 ? 3 : 2;
            d2 = NITFSUtil.getShortNumeric(byteBuffer2, n2);
            d3 = NITFSUtil.getShortNumeric(byteBuffer2, 2);
            d4 = NITFSUtil.getShortNumeric(byteBuffer2, 2);
            string = NITFSUtil.getString(byteBuffer2, 1);
            double d6 = d2 + (d3 + d4 / d) / d;
            if ("W".equals(string)) {
                d6 *= -1.0;
            }
            this.imageCoords[i] = LatLon.fromDegrees(d5, d6);
        }
    }

    private void parseIdentificationSecurityStructureFields(ByteBuffer byteBuffer) throws NITFSRuntimeException {
        this.partType = NITFSUtil.getString(byteBuffer, 2);
        if (!"IM".equals(this.partType)) {
            throw new NITFSRuntimeException("NITFSReader.UnexpectedSegmentType", this.partType);
        }
        this.imageID = NITFSUtil.getString(byteBuffer, 10);
        boolean bl = false;
        for (String string : SupportedFormats) {
            if (0 != string.compareTo(this.imageID)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new NITFSRuntimeException("NITFSReader.UnsupportedImageFormat", this.imageID);
        }
        this.dateTime = NITFSUtil.getString(byteBuffer, 14);
        this.targetID = NITFSUtil.getString(byteBuffer, 17);
        this.imageTitle = NITFSUtil.getString(byteBuffer, 80);
        this.securityClass = NITFSUtil.getString(byteBuffer, 1);
        this.codewords = NITFSUtil.getString(byteBuffer, 40);
        this.controlAndHandling = NITFSUtil.getString(byteBuffer, 40);
        this.releaseInstructions = NITFSUtil.getString(byteBuffer, 40);
        this.classAuthority = NITFSUtil.getString(byteBuffer, 20);
        this.securityCtrlNum = NITFSUtil.getString(byteBuffer, 20);
        this.ISDWNG = NITFSUtil.getString(byteBuffer, 6);
        this.ISDEVT = "999998".equals(this.ISDWNG) ? NITFSUtil.getString(byteBuffer, 40) : "";
        this.encryption = NITFSUtil.getShortNumeric(byteBuffer, 1);
        this.imageSource = NITFSUtil.getString(byteBuffer, 42);
        this.numSignificantRows = NITFSUtil.getNumeric(byteBuffer, 8);
        this.numSignificantCols = NITFSUtil.getNumeric(byteBuffer, 8);
        this.pixelValueType = NITFSUtil.getString(byteBuffer, 3);
        this.imageRepresentation = NITFSUtil.getString(byteBuffer, 8);
        this.imageCategory = NITFSUtil.getString(byteBuffer, 8);
        this.bitsPerPixelPerBand = NITFSUtil.getShortNumeric(byteBuffer, 2);
        this.pixelJustification = NITFSUtil.getString(byteBuffer, 1);
        this.imageCoordSystem = NITFSUtil.getString(byteBuffer, 1);
    }
}

