/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.geojson;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.formats.geojson.GeoJSONEventParser;
import gov.nasa.worldwind.formats.geojson.GeoJSONPositionArray;
import gov.nasa.worldwind.formats.json.JSONEvent;
import gov.nasa.worldwind.formats.json.JSONEventParserContext;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.List;

public class GeoJSONCoordinateParser
extends GeoJSONEventParser {
    protected static final int INITIAL_POSITION_BUFFER_CAPACITY = 2;
    protected DoubleBuffer posBuffer;
    protected int startPos;
    protected int endPos;

    @Override
    protected Object parseArray(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        JSONEvent jSONEvent2 = jSONEventParserContext.peek();
        if (jSONEvent2 != null && jSONEvent2.isNumericValue()) {
            return this.parseSimpleArray(jSONEventParserContext, jSONEvent);
        }
        if (jSONEvent2 != null && jSONEvent2.isStartArray()) {
            return this.parseComplexArray(jSONEventParserContext, jSONEvent);
        }
        Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent));
        return null;
    }

    protected void startPositionArray() {
        this.startPos = this.posBuffer != null ? this.posBuffer.position() : 0;
    }

    protected void endPositionArray() {
        this.endPos = this.posBuffer != null ? this.posBuffer.position() : 0;
    }

    protected int parsePosition(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = 0;
        jSONEvent = jSONEventParserContext.nextEvent();
        while (jSONEventParserContext.hasNext()) {
            if (jSONEvent != null) {
                if (jSONEvent.isEndArray()) break;
                if (!jSONEvent.isNumericValue()) {
                    Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent));
                } else {
                    if (this.posBuffer == null) {
                        this.posBuffer = this.allocatePositionBuffer(2);
                    } else if (this.posBuffer.remaining() == 0) {
                        this.expandPositionBuffer(1 + this.posBuffer.capacity());
                    }
                    this.posBuffer.put(jSONEvent.asNumericValue());
                    ++n;
                }
            }
            jSONEvent = jSONEventParserContext.nextEvent();
        }
        return n;
    }

    protected Object resolvePositionArray(int n) {
        if (this.posBuffer == null || this.startPos == this.endPos) {
            return null;
        }
        return new GeoJSONPositionArray(n, this.posBuffer, this.startPos, this.endPos);
    }

    protected DoubleBuffer allocatePositionBuffer(int n) {
        return BufferUtil.newDoubleBuffer((int)n);
    }

    protected void expandPositionBuffer(int n) {
        int n2 = 2 * this.posBuffer.capacity();
        if (n2 < 0) {
            n2 = Integer.MAX_VALUE;
        } else if (n2 < n) {
            n2 = n;
        }
        this.posBuffer.flip();
        this.posBuffer = this.allocatePositionBuffer(n2).put(this.posBuffer);
    }

    protected Object parseSimpleArray(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.startPositionArray();
        int n = this.parsePosition(jSONEventParserContext, jSONEvent);
        this.endPositionArray();
        return this.resolvePositionArray(n);
    }

    protected Object parseComplexArray(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        jSONEvent = jSONEventParserContext.nextEvent();
        if (jSONEvent == null || !jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().warning(string);
            throw new IllegalArgumentException(string);
        }
        JSONEvent jSONEvent2 = jSONEventParserContext.peek();
        if (jSONEvent2 != null && jSONEvent2.isNumericValue()) {
            return this.parseArrayOfPositions(jSONEventParserContext, jSONEvent);
        }
        if (jSONEvent2 != null && jSONEvent2.isStartArray()) {
            return this.parseArrayOfArrays(jSONEventParserContext, jSONEvent);
        }
        Logging.logger().warning(Logging.getMessage("generic.UnexpectedEvent", jSONEvent2));
        return null;
    }

    protected Object parseArrayOfPositions(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = -1;
        this.startPositionArray();
        while (jSONEventParserContext.hasNext()) {
            if (jSONEvent != null) {
                if (jSONEvent.isEndArray()) break;
                int n2 = this.parsePosition(jSONEventParserContext, jSONEvent);
                if (n < 0) {
                    n = n2;
                }
            }
            jSONEvent = jSONEventParserContext.nextEvent();
        }
        this.endPositionArray();
        return this.resolvePositionArray(n);
    }

    protected Object parseArrayOfArrays(JSONEventParserContext jSONEventParserContext, JSONEvent jSONEvent) throws IOException {
        if (!jSONEvent.isStartArray()) {
            String string = Logging.getMessage("generic.InvalidEvent", jSONEvent);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Object> arrayList = null;
        while (jSONEventParserContext.hasNext()) {
            if (jSONEvent != null) {
                if (jSONEvent.isEndArray()) break;
                Object object = this.parseComplexArray(jSONEventParserContext, jSONEvent);
                if (object != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>();
                    }
                    arrayList.add(object);
                }
            }
            jSONEvent = jSONEventParserContext.nextEvent();
        }
        return this.resolveArrayOfArrays(arrayList);
    }

    protected Object resolveArrayOfArrays(List<?> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        if (list.get(0) instanceof GeoJSONPositionArray) {
            GeoJSONPositionArray[] geoJSONPositionArrayArray = new GeoJSONPositionArray[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                geoJSONPositionArrayArray[i] = (GeoJSONPositionArray)list.get(i);
            }
            return geoJSONPositionArrayArray;
        }
        if (list.get(0) instanceof List) {
            GeoJSONPositionArray[][] geoJSONPositionArrayArrayArray = new GeoJSONPositionArray[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                for (int j = 0; j < ((List)list.get(i)).size(); ++j) {
                    geoJSONPositionArrayArrayArray[i][j] = (GeoJSONPositionArray)((List)list.get(i)).get(j);
                }
            }
            return geoJSONPositionArrayArrayArray;
        }
        Logging.logger().warning(Logging.getMessage("generic.UnexpectedObjectType", list.get(0)));
        return null;
    }
}

