/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.database;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.database.DatabaseConnectionPool;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;

public class BasicDatabaseConnectionPool
implements DatabaseConnectionPool {
    public static final int DEFAULT_POLICY_INITIAL_CONNECTIONS = 1;
    public static final int DEFAULT_POLICY_MAXIMUM_CONNECTIONS = 5;
    public static final boolean DEFAULT_POLICY_WAIT_IF_BUSY = true;
    public static final long DEFAULT_POLICY_CONNECTION_WAIT_TIMEOUT = 5L;
    protected String driverClassName = null;
    protected String connectionString = null;
    protected String username = null;
    protected String password = null;
    protected int initialConnections = 1;
    protected int maximumConnections = 5;
    protected boolean waitIfBusy = true;
    protected CopyOnWriteArrayList<Connection> availableConnections = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<Connection> loanedConnections = new CopyOnWriteArrayList();

    public BasicDatabaseConnectionPool() {
    }

    public BasicDatabaseConnectionPool(String string, String string2, String string3, String string4, int n, int n2, boolean bl) throws IllegalArgumentException, SQLException {
        this.initialize(string, string2, string3, string4, n, n2, bl);
    }

    @Override
    public void initialize(AVList aVList) throws IllegalArgumentException, SQLException {
        if (null == aVList) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        String string = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.Database.DriverClassName", null);
        if (WWUtil.isEmpty(string)) {
            String string2 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Database.DriverClassName");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        String string3 = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.Database.ConnectionString", null);
        if (WWUtil.isEmpty(string3)) {
            String string4 = Logging.getMessage("generic.MissingRequiredParameter", "gov.nasa.worldwind.avkey.Database.ConnectionString");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        int n = AVListImpl.getIntegerValue(aVList, "gov.nasa.worldwind.avkey.DatabasePolicy.InitialConnections", 1);
        int n2 = AVListImpl.getIntegerValue(aVList, "gov.nasa.worldwind.avkey.DatabasePolicy.MaximumConnections", 5);
        boolean bl = AVListImpl.getBooleanValue(aVList, "gov.nasa.worldwind.avkey.DatabasePolicy.WaitIfBusy", true);
        String string5 = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.Database.Username", null);
        String string6 = AVListImpl.getStringValue(aVList, "gov.nasa.worldwind.avkey.Database.Password", null);
        this.initialize(string, string3, string5, string6, n, n2, bl);
    }

    protected void initialize(String string, String string2, String string3, String string4, int n, int n2, boolean bl) throws IllegalArgumentException, SQLException {
        if (WWUtil.isEmpty(string)) {
            String string5 = Logging.getMessage("nullValue.ClassNameIsNull");
            Logging.logger().severe(string5);
            throw new IllegalArgumentException(string5);
        }
        if (WWUtil.isEmpty(string2)) {
            String string6 = Logging.getMessage("nullValue.ConnectionStringIsNull");
            Logging.logger().severe(string6);
            throw new IllegalArgumentException(string6);
        }
        if (n < 0) {
            String string7 = Logging.getMessage("generic.UnexpectedLesserValue", n, 0);
            Logging.logger().severe(string7);
            throw new IllegalArgumentException(string7);
        }
        if (n2 < n) {
            String string8 = Logging.getMessage("generic.UnexpectedLesserValue", n2, n);
            Logging.logger().severe(string8);
            throw new IllegalArgumentException(string8);
        }
        this.driverClassName = string;
        this.connectionString = string2;
        this.initialConnections = n;
        this.maximumConnections = n2;
        this.waitIfBusy = bl;
        this.username = string3;
        this.password = string4;
        this.loadDriver();
        while (this.availableConnections.size() < this.initialConnections) {
            this.createConnection();
        }
    }

    protected void loadDriver() throws SQLException {
        WorldWind.createComponent(this.driverClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnection() throws SQLException {
        BasicDatabaseConnectionPool basicDatabaseConnectionPool = this;
        synchronized (basicDatabaseConnectionPool) {
            if (!this.maximumConnectionsLimitReached()) {
                try {
                    Connection connection;
                    Connection connection2 = connection = WWUtil.isEmpty(this.username) ? DriverManager.getConnection(this.connectionString) : DriverManager.getConnection(this.connectionString, this.username, this.password);
                    if (null != connection) {
                        this.availableConnections.add(connection);
                    }
                }
                catch (Throwable throwable) {
                    Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
                }
            }
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        String string;
        try {
            while (true) {
                String string2 = string = this.availableConnections.isEmpty() ? null : this.grabFirstConnection(this.availableConnections);
                if (null != string) {
                    this.loanedConnections.add((Connection)((Object)string));
                    return string;
                }
                if (this.waitIfBusy) {
                    this.createConnection();
                    if (!this.availableConnections.isEmpty()) continue;
                    Thread.sleep(5L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        string = Logging.getMessage("generic.ConnectionIsNotAvailable");
        Logging.logger().severe(string);
        throw new SQLException(string);
    }

    protected Connection grabFirstConnection(CopyOnWriteArrayList<? extends Connection> copyOnWriteArrayList) {
        try {
            return copyOnWriteArrayList.remove(0);
        }
        catch (Throwable throwable) {
            Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
            return null;
        }
    }

    @Override
    public void releaseConnection(Connection connection) {
        if (WWUtil.isEmpty(connection)) {
            String string = Logging.getMessage("nullValue.ConnectionIsNull");
            Logging.logger().severe(string);
            return;
        }
        try {
            this.loanedConnections.remove(connection);
        }
        catch (Throwable throwable) {
            Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
        }
        try {
            if (!connection.isClosed()) {
                if (this.maximumConnectionsLimitReached()) {
                    connection.close();
                } else {
                    this.availableConnections.add(connection);
                }
            }
        }
        catch (Throwable throwable) {
            Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
        }
    }

    @Override
    public void closeAllConnections() {
        this.closeAllConnections(this.availableConnections);
        this.closeAllConnections(this.loanedConnections);
    }

    protected void closeAllConnections(CopyOnWriteArrayList<? extends Connection> copyOnWriteArrayList) {
        while (null != copyOnWriteArrayList && !copyOnWriteArrayList.isEmpty()) {
            try {
                Connection connection = this.grabFirstConnection(copyOnWriteArrayList);
                if (null == connection || connection.isClosed()) continue;
                connection.close();
            }
            catch (Throwable throwable) {
                Logging.logger().finest(WWUtil.extractExceptionReason(throwable));
            }
        }
    }

    protected boolean maximumConnectionsLimitReached() {
        return this.maximumConnections != 0 && this.availableConnections.size() + this.loanedConnections.size() >= this.maximumConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        DatabaseConnectionPool databaseConnectionPool = null;
        try {
            databaseConnectionPool = new BasicDatabaseConnectionPool("org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:/depot/WorldWindJ/myDatabase;create=true", null, null, 1, 2, true);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.FINEST, WWUtil.extractExceptionReason(exception), exception);
        }
        finally {
            if (databaseConnectionPool != null) {
                databaseConnectionPool.closeAllConnections();
            }
        }
    }
}

