/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.BILRasterReader;
import gov.nasa.worldwind.data.BILRasterWriter;
import gov.nasa.worldwind.data.BufferWrapperRaster;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DTEDRasterReader;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.data.GDALDataRasterReader;
import gov.nasa.worldwind.data.GeotiffRasterReader;
import gov.nasa.worldwind.data.TiledRasterProducer;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.util.WWUtil;
import java.io.IOException;
import org.w3c.dom.Document;

public class TiledElevationProducer
extends TiledRasterProducer {
    protected double[] extremes = null;
    protected static final String DEFAULT_IMAGE_FORMAT = "application/bil32";
    protected static final double DEFAULT_MISSING_DATA_SIGNAL = -32768.0;
    protected static DataRasterReader[] readers = new DataRasterReader[]{new GDALDataRasterReader(), new BILRasterReader(), new DTEDRasterReader(), new GeotiffRasterReader()};

    public TiledElevationProducer(MemoryCache memoryCache, int n) {
        super(memoryCache, n);
    }

    public TiledElevationProducer() {
    }

    @Override
    protected void doStartProduction(AVList aVList) throws Exception {
        this.extremes = null;
        super.doStartProduction(aVList);
    }

    @Override
    public String getDataSourceDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("TiledElevationProducer.Description"));
        stringBuilder.append(" (").append(super.getDataSourceDescription()).append(")");
        return stringBuilder.toString();
    }

    @Override
    protected DataRaster createDataRaster(int n, int n2, Sector sector, AVList aVList) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", aVList.getValue("gov.nasa.worldwind.avkey.DataType"));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder"));
        ByteBufferRaster byteBufferRaster = new ByteBufferRaster(n, n2, sector, aVListImpl);
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue");
        if (object != null && object instanceof Double) {
            Double d = (Double)object;
            byteBufferRaster.fill(d);
            byteBufferRaster.setTransparentValue(d);
        }
        return byteBufferRaster;
    }

    @Override
    protected DataRasterReader[] getDataRasterReaders() {
        return readers;
    }

    @Override
    protected DataRasterWriter[] getDataRasterWriters() {
        return new DataRasterWriter[]{new BILRasterWriter(true)};
    }

    @Override
    protected String validateDataSource(Object object, AVList aVList) {
        if (object == null) {
            return Logging.getMessage("nullValue.SourceIsNull");
        }
        if (object instanceof DataRaster) {
            DataRaster dataRaster = (DataRaster)object;
            if (!(dataRaster instanceof BufferWrapperRaster)) {
                return Logging.getMessage("TiledRasterProducer.UnrecognizedDataSource", dataRaster);
            }
            String string = this.validateDataSourceParams(dataRaster, String.valueOf(dataRaster));
            if (string != null) {
                return string;
            }
        } else {
            DataRasterReader dataRasterReader = this.getReaderFactory().findReaderFor(object, aVList, this.getDataRasterReaders());
            if (dataRasterReader == null) {
                return Logging.getMessage("TiledRasterProducer.UnrecognizedDataSource", object);
            }
            aVList = aVList != null ? aVList.copy() : new AVListImpl();
            try {
                dataRasterReader.readMetadata(object, aVList);
            }
            catch (IOException iOException) {
                return Logging.getMessage("TiledRasterProducer.ExceptionWhileReading", object, iOException.getMessage());
            }
            String string = this.validateDataSourceParams(aVList, String.valueOf(object));
            if (string != null) {
                return string;
            }
        }
        return null;
    }

    protected String validateDataSourceParams(AVList aVList, String string) {
        if (aVList.hasKey("gov.nasa.worldwind.avkey.PixelFormat") && aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") != "gov.nasa.worldwind.avkey.Elevation") {
            return Logging.getMessage("TiledRasterProducer.UnrecognizedRasterType", aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat"), string);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.CoordinateSystem") && aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem") != "gov.nasa.worldwind.avkey.CoordinateSystem.Geographic" && aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem") != "gov.nasa.worldwind.avkey.CoordinateSystem.Projected") {
            return Logging.getMessage("TiledRasterProducer.UnrecognizedCoordinateSystem", aVList.getValue("gov.nasa.worldwind.avkey.CoordinateSystem"), string);
        }
        if (aVList.hasKey("gov.nasa.worldwind.avkey.ElevationUnit") && aVList.getValue("gov.nasa.worldwind.avkey.ElevationUnit") != "gov.nasa.worldwind.avkey.Unit.Meter" && aVList.getValue("gov.nasa.worldwind.avkey.ElevationUnit") != "gov.nasa.worldwind.avkey.Unit.Foot") {
            return Logging.getMessage("TiledElevationProducer.UnrecognizedElevationUnit", aVList.getValue("gov.nasa.worldwind.avkey.ElevationUnit"), string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avKey.Sector") == null) {
            return Logging.getMessage("TiledRasterProducer.NoSector", string);
        }
        return null;
    }

    @Override
    protected void initProductionParameters(AVList aVList) {
        String string;
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") != null && (string = WWIO.makeMimeTypeForSuffix(aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey").toString())) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", string);
            aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{string});
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.PixelFormat") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", "gov.nasa.worldwind.avkey.Elevation");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ImageFormat", DEFAULT_IMAGE_FORMAT);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.AvailableImageFormats") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.AvailableImageFormats", new String[]{aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString()});
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", WWIO.makeSuffixForMimeType(aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString()));
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null && aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat") != null && (string = WWIO.makeDataTypeForMimeType(aVList.getValue("gov.nasa.worldwind.avkey.ImageFormat").toString())) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", string);
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.DataType") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.Int16");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.LittleEndian");
        }
        if (aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue") == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataValue", -32768.0);
        }
    }

    @Override
    protected LatLon computeRasterTileDelta(int n, int n2, Iterable<? extends DataRaster> iterable) {
        LatLon latLon = this.computeSmallestPixelSize(iterable);
        double d = (double)(n2 - 1) * latLon.getLatitude().degrees;
        double d2 = (double)(n - 1) * latLon.getLongitude().degrees;
        return LatLon.fromDegrees(d, d2);
    }

    @Override
    protected void installTileRasterLater(LevelSet levelSet, Tile tile, DataRaster dataRaster, AVList aVList) {
        if (levelSet.isFinalLevel(tile.getLevelNumber())) {
            this.updateExtremeElevations(dataRaster);
        }
        super.installTileRasterLater(levelSet, tile, dataRaster, aVList);
    }

    protected void updateExtremeElevations(DataRaster dataRaster) {
        if (!(dataRaster instanceof BufferWrapperRaster)) {
            String string = Logging.getMessage("DataRaster.IncompatibleRaster", dataRaster);
            Logging.logger().severe(string);
            return;
        }
        if (this.extremes == null) {
            this.extremes = WWUtil.defaultMinMix();
        }
        double[] dArray = new double[2];
        if (dataRaster.hasKey("gov.nasa.worldwind.avkey.ElevationMinKey") && dataRaster.hasKey("gov.nasa.worldwind.avkey.ElevationMaxKey")) {
            dArray[0] = (Double)dataRaster.getValue("gov.nasa.worldwind.avkey.ElevationMaxKey");
            dArray[1] = (Double)dataRaster.getValue("gov.nasa.worldwind.avkey.ElevationMinKey");
        } else {
            dArray = ((BufferWrapperRaster)dataRaster).getExtremes();
            if (dArray == null || dArray.length < 2) {
                return;
            }
        }
        if (this.extremes[0] > dArray[0]) {
            this.extremes[0] = dArray[0];
        }
        if (this.extremes[1] < dArray[1]) {
            this.extremes[1] = dArray[1];
        }
    }

    @Override
    protected Document createConfigDoc(AVList aVList) {
        AVList aVList2 = aVList.copy();
        if (aVList2.getValue("gov.nasa.worldwind.avkey.DisplayName") == null) {
            aVList2.setValue("gov.nasa.worldwind.avkey.DisplayName", aVList.getValue("gov.nasa.worldwind.avkey.DatasetNameKey"));
        }
        if (aVList2.getValue("gov.nasa.worldwind.avkey.ServiceName") == null) {
            aVList2.setValue("gov.nasa.worldwind.avkey.ServiceName", "Offline");
        }
        aVList2.setValue("gov.nasa.worldwind.avkey.NetworkRetrievalEnabled", Boolean.FALSE);
        aVList2.removeKey("gov.nasa.worldwind.avkey.MissingDataValue");
        aVList2.setValue("gov.nasa.worldwind.avkey.MissingDataFlag", aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue"));
        if (this.extremes != null && this.extremes.length >= 2) {
            aVList2.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", this.extremes[0]);
            aVList2.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", this.extremes[1]);
        }
        return BasicElevationModel.createBasicElevationModelConfigDocument(aVList2);
    }
}

