/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.SceneController;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.cache.GpuResourceCache;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.DrawContextImpl;
import gov.nasa.worldwind.render.GLRuntimeCapabilities;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.PreRenderable;
import gov.nasa.worldwind.render.ScreenCreditController;
import gov.nasa.worldwind.render.SurfaceObjectTileBuilder;
import gov.nasa.worldwind.render.SurfaceTile;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.PerformanceStatistic;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public abstract class AbstractSceneController
extends WWObjectImpl
implements SceneController {
    protected Model model;
    protected View view;
    protected double verticalExaggeration = 1.0;
    protected DrawContext dc = new DrawContextImpl();
    protected PickedObjectList lastPickedObjects;
    protected PickedObjectList lastObjectsInPickRect;
    protected Map<Integer, PickedObject> pickableObjects = new HashMap<Integer, PickedObject>();
    protected long frame = 0L;
    protected long timebase = System.currentTimeMillis();
    protected double framesPerSecond;
    protected double frameTime;
    protected double pickTime;
    protected Point pickPoint = null;
    protected Rectangle pickRect = null;
    protected boolean deepPick = false;
    protected GpuResourceCache gpuResourceCache;
    protected TextRendererCache textRendererCache = new TextRendererCache();
    protected Set<String> perFrameStatisticsKeys = new HashSet<String>();
    protected Collection<PerformanceStatistic> perFrameStatistics = new ArrayList<PerformanceStatistic>();
    protected Collection<Throwable> renderingExceptions = new ArrayList<Throwable>();
    protected ScreenCreditController screenCreditController;
    protected GLRuntimeCapabilities glRuntimeCaps = new GLRuntimeCapabilities();
    protected ArrayList<Point> pickPoints = new ArrayList();
    protected SurfaceObjectTileBuilder surfaceObjectTileBuilder;
    protected Collection<SurfaceTile> surfaceObjectTiles = new ArrayList<SurfaceTile>();
    protected static final String SURFACE_OBJECT_TILE_COUNT_NAME = "Surface Object Tiles";

    public AbstractSceneController() {
        this.setVerticalExaggeration(Configuration.getDoubleValue("gov.nasa.worldwind.avkey.VerticalExaggeration", 1.0));
    }

    @Override
    public void reinitialize() {
        if (this.textRendererCache != null) {
            this.textRendererCache.dispose();
        }
        this.textRendererCache = new TextRendererCache();
    }

    @Override
    public void dispose() {
        if (this.lastPickedObjects != null) {
            this.lastPickedObjects.clear();
        }
        this.lastPickedObjects = null;
        if (this.lastObjectsInPickRect != null) {
            this.lastObjectsInPickRect.clear();
        }
        this.lastObjectsInPickRect = null;
        if (this.dc != null) {
            this.dc.dispose();
        }
        if (this.textRendererCache != null) {
            this.textRendererCache.dispose();
        }
    }

    @Override
    public GpuResourceCache getGpuResourceCache() {
        return this.gpuResourceCache;
    }

    @Override
    public void setGpuResourceCache(GpuResourceCache gpuResourceCache) {
        this.gpuResourceCache = gpuResourceCache;
    }

    public TextRendererCache getTextRendererCache() {
        return this.textRendererCache;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void setModel(Model model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this);
        }
        if (model != null) {
            model.addPropertyChangeListener(this);
        }
        Model model2 = this.model;
        this.model = model;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ModelObject", model2, model);
    }

    @Override
    public void setView(View view) {
        if (this.view != null) {
            this.view.removePropertyChangeListener(this);
        }
        if (view != null) {
            view.addPropertyChangeListener(this);
        }
        View view2 = this.view;
        this.view = view;
        this.firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", view2, view);
    }

    @Override
    public void setVerticalExaggeration(double d) {
        Double d2 = this.verticalExaggeration;
        this.verticalExaggeration = d;
        this.firePropertyChange("gov.nasa.worldwind.avkey.VerticalExaggeration", d2, d);
    }

    @Override
    public double getVerticalExaggeration() {
        return this.verticalExaggeration;
    }

    @Override
    public void setPickPoint(Point point) {
        this.pickPoint = point;
    }

    @Override
    public Point getPickPoint() {
        return this.pickPoint;
    }

    @Override
    public void setPickRectangle(Rectangle rectangle) {
        this.pickRect = rectangle;
    }

    @Override
    public Rectangle getPickRectangle() {
        return this.pickRect;
    }

    @Override
    public PickedObjectList getPickedObjectList() {
        return this.lastPickedObjects;
    }

    protected void setPickedObjectList(PickedObjectList pickedObjectList) {
        this.lastPickedObjects = pickedObjectList;
    }

    @Override
    public PickedObjectList getObjectsInPickRectangle() {
        return this.lastObjectsInPickRect;
    }

    @Override
    public void setDeepPickEnabled(boolean bl) {
        this.deepPick = bl;
    }

    @Override
    public boolean isDeepPickEnabled() {
        return this.deepPick;
    }

    @Override
    public SectorGeometryList getTerrain() {
        return this.dc.getSurfaceGeometry();
    }

    @Override
    public DrawContext getDrawContext() {
        return this.dc;
    }

    @Override
    public double getFramesPerSecond() {
        return this.framesPerSecond;
    }

    @Override
    public double getFrameTime() {
        return this.frameTime;
    }

    @Override
    public void setPerFrameStatisticsKeys(Set<String> set) {
        this.perFrameStatisticsKeys.clear();
        if (set == null) {
            return;
        }
        for (String string : set) {
            if (string == null) continue;
            this.perFrameStatisticsKeys.add(string);
        }
    }

    @Override
    public Collection<PerformanceStatistic> getPerFrameStatistics() {
        return this.perFrameStatistics;
    }

    @Override
    public Collection<Throwable> getRenderingExceptions() {
        return this.renderingExceptions;
    }

    @Override
    public ScreenCreditController getScreenCreditController() {
        return this.screenCreditController;
    }

    @Override
    public void setScreenCreditController(ScreenCreditController screenCreditController) {
        this.screenCreditController = screenCreditController;
    }

    @Override
    public GLRuntimeCapabilities getGLRuntimeCapabilities() {
        return this.glRuntimeCaps;
    }

    @Override
    public void setGLRuntimeCapabilities(GLRuntimeCapabilities gLRuntimeCapabilities) {
        if (gLRuntimeCapabilities == null) {
            String string = Logging.getMessage("nullValue.GLRuntimeCapabilitiesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.glRuntimeCaps = gLRuntimeCapabilities;
    }

    @Override
    public int repaint() {
        this.frameTime = System.currentTimeMillis();
        this.perFrameStatistics.clear();
        this.renderingExceptions.clear();
        this.surfaceObjectTiles.clear();
        this.glRuntimeCaps.initialize(GLContext.getCurrent());
        this.initializeDrawContext(this.dc);
        this.doRepaint(this.dc);
        ++this.frame;
        long l = System.currentTimeMillis();
        this.frameTime = (double)System.currentTimeMillis() - this.frameTime;
        if (l - this.timebase > 2000L) {
            this.framesPerSecond = (double)this.frame * 1000.0 / (double)(l - this.timebase);
            this.timebase = l;
            this.frame = 0L;
        }
        this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.FrameTime", "Frame Time (ms)", (int)this.frameTime);
        this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.FrameRate", "Frame Rate (fps)", (int)this.framesPerSecond);
        this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.PickTime", "Pick Time (ms)", (int)this.pickTime);
        Set<String> set = this.dc.getPerFrameStatisticsKeys();
        if (set == null) {
            return this.dc.getRedrawRequested();
        }
        if (set.contains("gov.nasa.worldwind.perfstat.MemoryCache") || set.contains("gov.nasa.worldwind.perfstat.All")) {
            this.dc.setPerFrameStatistics(WorldWind.getMemoryCacheSet().getPerformanceStatistics());
        }
        if ((set.contains("gov.nasa.worldwind.perfstat.TextureCache") || set.contains("gov.nasa.worldwind.perfstat.All")) && this.dc.getTextureCache() != null) {
            this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.TextureCache", "Texture Cache size (Kb)", this.dc.getTextureCache().getUsedCapacity() / 1000L);
        }
        if (set.contains("gov.nasa.worldwind.perfstat.JvmHeap") || set.contains("gov.nasa.worldwind.perfstat.All")) {
            long l2 = Runtime.getRuntime().totalMemory();
            this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.JvmHeap", "JVM total memory (Kb)", l2 / 1000L);
            this.dc.setPerFrameStatistic("gov.nasa.worldwind.perfstat.JvmHeapUsed", "JVM used memory (Kb)", (l2 - Runtime.getRuntime().freeMemory()) / 1000L);
        }
        return this.dc.getRedrawRequested();
    }

    protected abstract void doRepaint(DrawContext var1);

    protected void initializeDrawContext(DrawContext drawContext) {
        drawContext.initialize(GLContext.getCurrent());
        drawContext.setGLRuntimeCapabilities(this.glRuntimeCaps);
        drawContext.setPerFrameStatisticsKeys(this.perFrameStatisticsKeys, this.perFrameStatistics);
        drawContext.setRenderingExceptions(this.renderingExceptions);
        drawContext.setGpuResourceCache(this.gpuResourceCache);
        drawContext.setTextRendererCache(this.textRendererCache);
        drawContext.setModel(this.model);
        drawContext.setView(this.view);
        drawContext.setVerticalExaggeration(this.verticalExaggeration);
        drawContext.setPickPoint(this.pickPoint);
        drawContext.setPickRectangle(this.pickRect);
        drawContext.setViewportCenterScreenPoint(this.getViewportCenter(drawContext));
        long l = System.currentTimeMillis();
        drawContext.setFrameTimeStamp(l);
        this.setValue("gov.nasa.worldwind.avkey.FrameTimestamp", l);
    }

    protected Point getViewportCenter(DrawContext drawContext) {
        View view = drawContext.getView();
        if (view == null) {
            return null;
        }
        Rectangle rectangle = view.getViewport();
        if (rectangle == null) {
            return null;
        }
        return new Point((int)(rectangle.getCenterX() + 0.5), (int)(rectangle.getCenterY() + 0.5));
    }

    protected void initializeFrame(DrawContext drawContext) {
        if (drawContext.getGLContext() == null) {
            String string = Logging.getMessage("BasicSceneController.GLContextNullStartRedisplay");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        GL gL = drawContext.getGL();
        gL.glPushAttrib(14336);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glEnable(2929);
    }

    protected void clearFrame(DrawContext drawContext) {
        Color color = drawContext.getClearColor();
        drawContext.getGL().glClearColor((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)color.getAlpha());
        drawContext.getGL().glClear(16640);
    }

    protected void finalizeFrame(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glMatrixMode(5888);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glPopAttrib();
    }

    protected void applyView(DrawContext drawContext) {
        if (drawContext.getView() != null) {
            drawContext.getView().apply(drawContext);
        }
    }

    protected void createPickFrustum(DrawContext drawContext) {
        drawContext.addPickPointFrustum();
        drawContext.addPickRectangleFrustum();
    }

    protected void createTerrain(DrawContext drawContext) {
        if (drawContext.getSurfaceGeometry() == null) {
            if (drawContext.getModel() != null && drawContext.getModel().getGlobe() != null) {
                SectorGeometryList sectorGeometryList = drawContext.getModel().getGlobe().tessellate(drawContext);
                drawContext.setSurfaceGeometry(sectorGeometryList);
                drawContext.setVisibleSector(sectorGeometryList.getSector());
            }
            if (drawContext.getSurfaceGeometry() == null) {
                Logging.logger().warning("generic.NoSurfaceGeometry");
                drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.TerrainTileCount", "Terrain Tiles", 0);
            }
            drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.TerrainTileCount", "Terrain Tiles", drawContext.getSurfaceGeometry().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preRender(DrawContext drawContext) {
        try {
            drawContext.setPreRenderMode(true);
            if (drawContext.getLayers() != null) {
                for (Layer layer : drawContext.getLayers()) {
                    try {
                        drawContext.setCurrentLayer(layer);
                        layer.preRender(drawContext);
                    }
                    catch (Exception exception) {
                        String string = Logging.getMessage("SceneController.ExceptionWhilePreRenderingLayer", layer != null ? layer.getClass().getName() : Logging.getMessage("term.unknown"));
                        Logging.logger().log(Level.SEVERE, string, exception);
                    }
                }
                drawContext.setCurrentLayer(null);
            }
            this.preRenderOrderedSurfaceRenderables(drawContext);
        }
        catch (Exception exception) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicSceneController.ExceptionDuringPreRendering"), exception);
        }
        finally {
            drawContext.setPreRenderMode(false);
        }
    }

    protected void pickTerrain(DrawContext drawContext) {
        if (drawContext.isPickingMode() && drawContext.getVisibleSector() != null && drawContext.getSurfaceGeometry() != null && drawContext.getSurfaceGeometry().size() > 0) {
            this.pickPoints.clear();
            if (drawContext.getPickPoint() != null) {
                this.pickPoints.add(drawContext.getPickPoint());
            }
            drawContext.setViewportCenterPosition(null);
            Point point = drawContext.getViewportCenterScreenPoint();
            if (point != null) {
                this.pickPoints.add(point);
            }
            if (this.pickPoints.size() == 0) {
                return;
            }
            List<PickedObject> list = drawContext.getSurfaceGeometry().pick(drawContext, this.pickPoints);
            if (list == null || list.size() == 0) {
                return;
            }
            for (PickedObject pickedObject : list) {
                if (pickedObject == null) continue;
                if (pickedObject.getPickPoint().equals(drawContext.getPickPoint())) {
                    drawContext.addPickedObject(pickedObject);
                    continue;
                }
                if (!pickedObject.getPickPoint().equals(point)) continue;
                drawContext.setViewportCenterPosition((Position)pickedObject.getObject());
            }
        }
    }

    protected void pickLayers(DrawContext drawContext) {
        if (drawContext.getLayers() != null) {
            for (Layer layer : drawContext.getLayers()) {
                try {
                    if (layer == null || !layer.isPickEnabled()) continue;
                    drawContext.setCurrentLayer(layer);
                    layer.pick(drawContext, drawContext.getPickPoint());
                }
                catch (Exception exception) {
                    String string = Logging.getMessage("SceneController.ExceptionWhilePickingInLayer", layer != null ? layer.getClass().getName() : Logging.getMessage("term.unknown"));
                    Logging.logger().log(Level.SEVERE, string, exception);
                }
            }
            drawContext.setCurrentLayer(null);
        }
    }

    protected void resolveTopPick(DrawContext drawContext) {
        if (drawContext.getPickPoint() != null) {
            this.doResolveTopPick(drawContext, drawContext.getPickPoint());
        }
        if (drawContext.getPickRectangle() != null && !drawContext.getPickRectangle().isEmpty()) {
            this.doResolveTopPick(drawContext, drawContext.getPickRectangle());
        }
    }

    protected void doResolveTopPick(DrawContext drawContext, Point point) {
        int n;
        PickedObjectList pickedObjectList = drawContext.getPickedObjects();
        if (pickedObjectList != null && pickedObjectList.size() == 1) {
            ((PickedObject)pickedObjectList.get(0)).setOnTop();
        } else if (pickedObjectList != null && pickedObjectList.size() > 1 && (n = drawContext.getPickColorAtPoint(point)) != 0) {
            for (PickedObject pickedObject : pickedObjectList) {
                if (pickedObject == null || pickedObject.getColorCode() != n) continue;
                pickedObject.setOnTop();
                break;
            }
        }
    }

    protected void doResolveTopPick(DrawContext drawContext, Rectangle rectangle) {
        PickedObjectList pickedObjectList = drawContext.getObjectsInPickRectangle();
        if (pickedObjectList != null && pickedObjectList.size() == 1) {
            ((PickedObject)pickedObjectList.get(0)).setOnTop();
        } else if (pickedObjectList != null && pickedObjectList.size() > 1) {
            int[] nArray = null;
            for (Object object : pickedObjectList) {
                int n = ((PickedObject)object).getColorCode();
                this.pickableObjects.put(n, (PickedObject)object);
                if (nArray == null) {
                    nArray = new int[]{n, n};
                    continue;
                }
                if (nArray[0] > n) {
                    nArray[0] = n;
                }
                if (nArray[1] >= n) continue;
                nArray[1] = n;
            }
            Object object = drawContext.getPickColorsInRectangle(rectangle, nArray);
            if (object != null && ((Object)object).length > 0) {
                for (Object object2 : object) {
                    PickedObject pickedObject;
                    if (object2 == false || (pickedObject = this.pickableObjects.get((int)object2)) == null) continue;
                    pickedObject.setOnTop();
                }
            }
            this.pickableObjects.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pick(DrawContext drawContext) {
        this.pickTime = System.currentTimeMillis();
        this.lastPickedObjects = null;
        this.lastObjectsInPickRect = null;
        try {
            drawContext.enablePickingMode();
            this.pickTerrain(drawContext);
            this.doNonTerrainPick(drawContext);
            this.resolveTopPick(drawContext);
            this.lastPickedObjects = new PickedObjectList(drawContext.getPickedObjects());
            this.lastObjectsInPickRect = new PickedObjectList(drawContext.getObjectsInPickRectangle());
            if (this.isDeepPickEnabled() && (this.lastPickedObjects.hasNonTerrainObjects() || this.lastObjectsInPickRect.hasNonTerrainObjects())) {
                this.doDeepPick(drawContext);
            }
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicSceneController.ExceptionDuringPick"), throwable);
        }
        finally {
            drawContext.disablePickingMode();
            this.pickTime = (double)System.currentTimeMillis() - this.pickTime;
        }
    }

    protected void doNonTerrainPick(DrawContext drawContext) {
        if (drawContext.getPickPoint() == null && (drawContext.getPickRectangle() == null || drawContext.getPickRectangle().isEmpty())) {
            return;
        }
        this.pickLayers(drawContext);
        this.pickOrderedSurfaceRenderables(drawContext);
        if (this.screenCreditController != null) {
            this.screenCreditController.pick(drawContext, drawContext.getPickPoint());
        }
        drawContext.setOrderedRenderingMode(true);
        while (drawContext.peekOrderedRenderables() != null) {
            drawContext.pollOrderedRenderables().pick(drawContext, drawContext.getPickPoint());
        }
        drawContext.setOrderedRenderingMode(false);
    }

    protected void doDeepPick(DrawContext drawContext) {
        PickedObjectList pickedObjectList = this.lastPickedObjects;
        PickedObjectList pickedObjectList2 = this.lastObjectsInPickRect;
        drawContext.setDeepPickingEnabled(true);
        this.doNonTerrainPick(drawContext);
        drawContext.setDeepPickingEnabled(false);
        this.lastPickedObjects = this.mergePickedObjectLists(pickedObjectList, drawContext.getPickedObjects());
        this.lastObjectsInPickRect = this.mergePickedObjectLists(pickedObjectList2, drawContext.getObjectsInPickRectangle());
    }

    protected PickedObjectList mergePickedObjectLists(PickedObjectList pickedObjectList, PickedObjectList pickedObjectList2) {
        if (pickedObjectList == null || pickedObjectList2 == null || !pickedObjectList.hasNonTerrainObjects() || !pickedObjectList2.hasNonTerrainObjects()) {
            return pickedObjectList;
        }
        for (PickedObject pickedObject : pickedObjectList2) {
            if (pickedObject.isTerrain()) continue;
            boolean bl = false;
            for (PickedObject pickedObject2 : pickedObjectList) {
                if (pickedObject2.isTerrain() || pickedObject2.getObject() != pickedObject.getObject()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            pickedObjectList.add(pickedObject);
        }
        return pickedObjectList;
    }

    protected void draw(DrawContext drawContext) {
        try {
            if (drawContext.getLayers() != null) {
                for (Object object : drawContext.getLayers()) {
                    try {
                        if (object == null) continue;
                        drawContext.setCurrentLayer((Layer)object);
                        object.render(drawContext);
                    }
                    catch (Exception exception) {
                        Object object2 = Logging.getMessage("SceneController.ExceptionWhileRenderingLayer", object != null ? object.getClass().getName() : Logging.getMessage("term.unknown"));
                        Logging.logger().log(Level.SEVERE, (String)object2, exception);
                    }
                }
                drawContext.setCurrentLayer(null);
            }
            this.drawOrderedSurfaceRenderables(drawContext);
            if (this.screenCreditController != null) {
                this.screenCreditController.render(drawContext);
            }
            drawContext.setOrderedRenderingMode(true);
            while (drawContext.peekOrderedRenderables() != null) {
                try {
                    drawContext.pollOrderedRenderables().render(drawContext);
                }
                catch (Exception exception) {
                    Logging.logger().log(Level.WARNING, Logging.getMessage("BasicSceneController.ExceptionDuringRendering"), exception);
                }
            }
            drawContext.setOrderedRenderingMode(false);
            if (drawContext.getSurfaceGeometry() != null && drawContext.getModel() != null && (drawContext.getModel().isShowWireframeExterior() || drawContext.getModel().isShowWireframeInterior() || drawContext.getModel().isShowTessellationBoundingVolumes())) {
                Object object;
                Model model = drawContext.getModel();
                object = new float[4];
                drawContext.getGL().glGetFloatv(2816, (float[])object, 0);
                for (Object object2 : drawContext.getSurfaceGeometry()) {
                    if (model.isShowWireframeInterior() || model.isShowWireframeExterior()) {
                        object2.renderWireframe(drawContext, model.isShowWireframeInterior(), model.isShowWireframeExterior());
                    }
                    if (!model.isShowTessellationBoundingVolumes()) continue;
                    drawContext.getGL().glColor3d(1.0, 0.0, 0.0);
                    object2.renderBoundingVolume(drawContext);
                }
                drawContext.getGL().glColor4fv((float[])object, 0);
            }
        }
        catch (Throwable throwable) {
            Logging.logger().log(Level.SEVERE, Logging.getMessage("BasicSceneController.ExceptionDuringRendering"), throwable);
        }
    }

    protected void checkGLErrors(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        int n = gL.glGetError();
        while (n != 0) {
            String string = drawContext.getGLU().gluErrorString(n);
            string = string + n;
            Logging.logger().severe(string);
            n = gL.glGetError();
        }
    }

    protected void preRenderOrderedSurfaceRenderables(DrawContext drawContext) {
        if (drawContext.getOrderedSurfaceRenderables().isEmpty()) {
            return;
        }
        drawContext.setOrderedRenderingMode(true);
        this.buildCompositeSurfaceObjects(drawContext);
        int n = 0;
        while (drawContext.getOrderedSurfaceRenderables().peek() != null) {
            try {
                OrderedRenderable orderedRenderable = drawContext.getOrderedSurfaceRenderables().poll();
                if (!(orderedRenderable instanceof PreRenderable)) continue;
                ((PreRenderable)((Object)orderedRenderable)).preRender(drawContext);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("BasicSceneController.ExceptionDuringPreRendering"), exception);
                if (++n <= Logging.getMaxMessageRepeatCount()) continue;
                break;
            }
        }
        drawContext.setOrderedRenderingMode(false);
    }

    protected void pickOrderedSurfaceRenderables(DrawContext drawContext) {
        drawContext.setOrderedRenderingMode(true);
        while (drawContext.getOrderedSurfaceRenderables().peek() != null) {
            drawContext.getOrderedSurfaceRenderables().poll().pick(drawContext, drawContext.getPickPoint());
        }
        drawContext.setOrderedRenderingMode(false);
    }

    protected void drawOrderedSurfaceRenderables(DrawContext drawContext) {
        drawContext.setOrderedRenderingMode(true);
        this.drawCompositeSurfaceObjects(drawContext);
        while (drawContext.getOrderedSurfaceRenderables().peek() != null) {
            try {
                drawContext.getOrderedSurfaceRenderables().poll().render(drawContext);
            }
            catch (Exception exception) {
                Logging.logger().log(Level.WARNING, Logging.getMessage("BasicSceneController.ExceptionDuringRendering"), exception);
            }
        }
        drawContext.setOrderedRenderingMode(false);
    }

    protected void buildCompositeSurfaceObjects(DrawContext drawContext) {
        List<SurfaceTile> list;
        if (drawContext.getOrderedSurfaceRenderables().isEmpty()) {
            return;
        }
        if (this.surfaceObjectTileBuilder == null) {
            this.surfaceObjectTileBuilder = this.createSurfaceObjectTileBuilder();
        }
        if ((list = this.surfaceObjectTileBuilder.buildTiles(drawContext, drawContext.getOrderedSurfaceRenderables())) != null) {
            this.surfaceObjectTiles.addAll(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCompositeSurfaceObjects(DrawContext drawContext) {
        if (this.surfaceObjectTiles.isEmpty()) {
            return;
        }
        int n = 16392;
        GL gL = drawContext.getGL();
        OGLStackHandler oGLStackHandler = new OGLStackHandler();
        oGLStackHandler.pushAttrib(gL, n);
        try {
            gL.glEnable(3042);
            gL.glEnable(2884);
            gL.glCullFace(1029);
            gL.glPolygonMode(1028, 6914);
            OGLUtil.applyBlending(gL, true);
            drawContext.getGeographicSurfaceTileRenderer().renderTiles(drawContext, this.surfaceObjectTiles);
            drawContext.setPerFrameStatistic("gov.nasa.worldwind.perfstat.ImageTileCount", SURFACE_OBJECT_TILE_COUNT_NAME, this.surfaceObjectTiles.size());
        }
        finally {
            oGLStackHandler.pop(drawContext.getGL());
        }
    }

    protected SurfaceObjectTileBuilder createSurfaceObjectTileBuilder() {
        return new SurfaceObjectTileBuilder();
    }
}

