/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.weld;

import griffon.core.AddonManager;
import griffon.core.ArtifactManager;
import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.UIThreadManager;
import griffon.plugins.weld.BeanFactory;
import griffon.util.ApplicationHolder;
import griffon.util.GriffonNameUtils;
import groovy.lang.Script;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class GriffonExtension
implements Extension {
    private static final List<String> SKIP_LIST = Arrays.asList("Application", "Builder", "Config", "Events", "Initialize", "Startup", "Ready", "Shutdown", "Stop");
    private static final Map<String, Object> ADDITIONAL_BEANS = new LinkedHashMap<String, Object>();

    public static void registerBean(String beanName, Object bean) {
        if (!GriffonNameUtils.isBlank((String)beanName) && bean != null) {
            ADDITIONAL_BEANS.put(beanName, bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        GriffonApplication app = ApplicationHolder.getApplication();
        abd.addBean(new BeanFactory<GriffonApplication>(bm, app.getClass(), "app", app));
        abd.addBean(new BeanFactory<ConfigObject>(bm, ConfigObject.class, "appConfig", app.getConfig()));
        abd.addBean(new BeanFactory<ArtifactManager>(bm, app.getArtifactManager().getClass(), "artifactManager", app.getArtifactManager()));
        abd.addBean(new BeanFactory<AddonManager>(bm, app.getAddonManager().getClass(), "addonManager", app.getAddonManager()));
        abd.addBean(new BeanFactory<UIThreadManager>(bm, UIThreadManager.class, "uiThreadManager", UIThreadManager.getInstance()));
        for (GriffonClass griffonClass : app.getArtifactManager().getAllClasses()) {
            abd.addBean(new BeanFactory<GriffonClass>(bm, griffonClass.getClass(), griffonClass.getPropertyName() + "Class", griffonClass));
        }
        for (Map.Entry entry : ADDITIONAL_BEANS.entrySet()) {
            abd.addBean(new BeanFactory(bm, entry.getValue().getClass(), (String)entry.getKey(), entry.getValue()));
        }
    }

    <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class clazz = annotatedType.getJavaClass();
        GriffonApplication app = ApplicationHolder.getApplication();
        if (SKIP_LIST.contains(clazz.getCanonicalName()) || Script.class.isAssignableFrom(clazz) || app.getArtifactManager().findGriffonClass(clazz) != null) {
            pat.veto();
            return;
        }
    }
}

