/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.weld;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Singleton;

public class BeanFactory<T>
implements Bean<T> {
    private final T instance;
    private final Class<T> clazz;
    private final String name;
    private final Class<? extends Annotation> scope;
    private final AnnotatedType<T> annotatedType;
    private final InjectionTarget<T> injectionTarget;
    private final Set<Type> types = new HashSet<Type>();

    public BeanFactory(BeanManager beanManager, Class<T> clazz, String name, T instance) {
        this(beanManager, clazz, name, instance, Singleton.class);
    }

    public BeanFactory(BeanManager beanManager, Class<T> clazz, String name, T instance, Class<? extends Annotation> scope) {
        this.instance = instance;
        this.clazz = clazz;
        this.name = name;
        this.scope = scope;
        this.annotatedType = beanManager.createAnnotatedType(clazz);
        this.injectionTarget = beanManager.createInjectionTarget(this.annotatedType);
        this.collectTypes(clazz);
    }

    private void collectTypes(Class c) {
        if (c == null || this.types.contains(c)) {
            return;
        }
        this.types.add(c);
        for (Class<?> i : c.getInterfaces()) {
            this.collectTypes(i);
        }
        this.collectTypes(c.getSuperclass());
    }

    public String toString() {
        return "BeanFactory[name=" + this.name + ", class=" + this.clazz.getName() + ", instance=" + this.instance + ", scope=" + this.scope.getName() + "]";
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return this.clazz;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionTarget.getInjectionPoints();
    }

    public T create(CreationalContext<T> context) {
        this.injectionTarget.inject(this.instance, context);
        this.injectionTarget.postConstruct(this.instance);
        return this.instance;
    }

    public void destroy(T t, CreationalContext<T> context) {
        this.injectionTarget.preDestroy(this.instance);
        this.injectionTarget.dispose(this.instance);
        context.release();
    }
}

