/*
 * Decompiled with CFR 0.152.
 */
package voldemort.xml;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.JDOMSource;
import org.xml.sax.SAXException;
import voldemort.client.RoutingTier;
import voldemort.serialization.Compression;
import voldemort.serialization.SerializerDefinition;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreDefinitionBuilder;
import voldemort.store.StoreUtils;
import voldemort.store.slop.strategy.HintedHandoffStrategyType;
import voldemort.utils.Utils;
import voldemort.xml.MappingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreDefinitionsMapper {
    public static final String STORES_ELMT = "stores";
    public static final String STORE_ELMT = "store";
    public static final String STORE_DESCRIPTION_ELMT = "description";
    public static final String STORE_OWNERS_ELMT = "owners";
    public static final String STORE_NAME_ELMT = "name";
    public static final String STORE_PERSISTENCE_ELMT = "persistence";
    public static final String STORE_KEY_SERIALIZER_ELMT = "key-serializer";
    public static final String STORE_VALUE_SERIALIZER_ELMT = "value-serializer";
    public static final String STORE_TRANSFORM_SERIALIZER_ELMT = "transforms-serializer";
    public static final String STORE_SERIALIZATION_TYPE_ELMT = "type";
    public static final String STORE_SERIALIZATION_META_ELMT = "schema-info";
    public static final String STORE_COMPRESSION_ELMT = "compression";
    public static final String STORE_COMPRESSION_TYPE_ELMT = "type";
    public static final String STORE_COMPRESSION_OPTIONS_ELMT = "options";
    public static final String STORE_ROUTING_TIER_ELMT = "routing";
    public static final String STORE_REPLICATION_FACTOR_ELMT = "replication-factor";
    public static final String STORE_REQUIRED_WRITES_ELMT = "required-writes";
    public static final String STORE_PREFERRED_WRITES_ELMT = "preferred-writes";
    public static final String STORE_REQUIRED_READS_ELMT = "required-reads";
    public static final String STORE_PREFERRED_READS_ELMT = "preferred-reads";
    public static final String STORE_RETENTION_POLICY_ELMT = "retention-days";
    public static final String STORE_RETENTION_SCAN_THROTTLE_RATE_ELMT = "retention-scan-throttle-rate";
    public static final String STORE_ROUTING_STRATEGY = "routing-strategy";
    public static final String STORE_ZONE_ID_ELMT = "zone-id";
    public static final String STORE_ZONE_REPLICATION_FACTOR_ELMT = "zone-replication-factor";
    public static final String STORE_ZONE_COUNT_READS = "zone-count-reads";
    public static final String STORE_ZONE_COUNT_WRITES = "zone-count-writes";
    public static final String HINTED_HANDOFF_STRATEGY = "hinted-handoff-strategy";
    public static final String HINT_PREFLIST_SIZE = "hint-preflist-size";
    public static final String VIEW_ELMT = "view";
    public static final String VIEW_TARGET_ELMT = "view-of";
    public static final String VIEW_TRANS_ELMT = "view-class";
    public static final String VIEW_SERIALIZER_FACTORY_ELMT = "view-serializer-factory";
    private static final String STORE_VERSION_ATTR = "version";
    private final Schema schema;

    public StoreDefinitionsMapper() {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource source = new StreamSource(StoreDefinitionsMapper.class.getResourceAsStream("stores.xsd"));
            this.schema = factory.newSchema(source);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreDefinition> readStoreList(File f) throws IOException {
        FileReader reader = null;
        try {
            reader = new FileReader(f);
            List<StoreDefinition> list = this.readStoreList(reader);
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public List<StoreDefinition> readStoreList(Reader input) {
        return this.readStoreList(input, true);
    }

    public List<StoreDefinition> readStoreList(Reader input, boolean verifySchema) {
        try {
            Element root;
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(input);
            if (verifySchema) {
                Validator validator = this.schema.newValidator();
                validator.validate((Source)new JDOMSource(doc));
            }
            if (!(root = doc.getRootElement()).getName().equals(STORES_ELMT)) {
                throw new MappingException("Invalid root element: " + doc.getRootElement().getName());
            }
            ArrayList<StoreDefinition> stores = new ArrayList<StoreDefinition>();
            for (Object store : root.getChildren(STORE_ELMT)) {
                stores.add(this.readStore((Element)store));
            }
            for (Object view : root.getChildren(VIEW_ELMT)) {
                stores.add(this.readView((Element)view, stores));
            }
            return stores;
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (SAXException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    public StoreDefinition readStore(Reader input) {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document doc = builder.build(input);
            Element root = doc.getRootElement();
            return this.readStore(root);
        }
        catch (JDOMException e) {
            throw new MappingException(e);
        }
        catch (IOException e) {
            throw new MappingException(e);
        }
    }

    private StoreDefinition readStore(Element store) {
        String hintPrefListSizeStr;
        SerializerDefinition keySerializer;
        String name = store.getChildText(STORE_NAME_ELMT);
        String storeType = store.getChildText(STORE_PERSISTENCE_ELMT);
        String description = store.getChildText(STORE_DESCRIPTION_ELMT);
        String ownerText = store.getChildText(STORE_OWNERS_ELMT);
        ArrayList owners = Lists.newArrayList();
        if (ownerText != null) {
            for (String owner : Utils.COMMA_SEP.split(ownerText.trim())) {
                if (owner.trim().length() <= 0) continue;
                owners.add(owner);
            }
        }
        int replicationFactor = Integer.parseInt(store.getChildText(STORE_REPLICATION_FACTOR_ELMT));
        HashMap<Integer, Integer> zoneReplicationFactor = null;
        Element zoneReplicationFactorNode = store.getChild(STORE_ZONE_REPLICATION_FACTOR_ELMT);
        if (zoneReplicationFactorNode != null) {
            zoneReplicationFactor = new HashMap<Integer, Integer>();
            for (Element node : zoneReplicationFactorNode.getChildren(STORE_REPLICATION_FACTOR_ELMT)) {
                int zone = Integer.parseInt(node.getAttribute(STORE_ZONE_ID_ELMT).getValue());
                int repFactor = Integer.parseInt(node.getText());
                zoneReplicationFactor.put(zone, repFactor);
            }
        }
        String zoneCountReadsStr = store.getChildText(STORE_ZONE_COUNT_READS);
        Integer zoneCountReads = null;
        if (zoneCountReadsStr != null) {
            zoneCountReads = Integer.parseInt(zoneCountReadsStr);
        }
        String zoneCountWritesStr = store.getChildText(STORE_ZONE_COUNT_WRITES);
        Integer zoneCountWrites = null;
        if (zoneCountWritesStr != null) {
            zoneCountWrites = Integer.parseInt(zoneCountWritesStr);
        }
        int requiredReads = Integer.parseInt(store.getChildText(STORE_REQUIRED_READS_ELMT));
        int requiredWrites = Integer.parseInt(store.getChildText(STORE_REQUIRED_WRITES_ELMT));
        String preferredReadsStr = store.getChildText(STORE_PREFERRED_READS_ELMT);
        Integer preferredReads = null;
        if (preferredReadsStr != null) {
            preferredReads = Integer.parseInt(preferredReadsStr);
        }
        String preferredWritesStr = store.getChildText(STORE_PREFERRED_WRITES_ELMT);
        Integer preferredWrites = null;
        if (preferredWritesStr != null) {
            preferredWrites = Integer.parseInt(preferredWritesStr);
        }
        if ((keySerializer = this.readSerializer(store.getChild(STORE_KEY_SERIALIZER_ELMT))).getAllSchemaInfoVersions().size() > 1) {
            throw new MappingException("Only a single schema is allowed for the store key.");
        }
        SerializerDefinition valueSerializer = this.readSerializer(store.getChild(STORE_VALUE_SERIALIZER_ELMT));
        RoutingTier routingTier = RoutingTier.fromDisplay(store.getChildText(STORE_ROUTING_TIER_ELMT));
        String routingStrategyType = null != store.getChildText(STORE_ROUTING_STRATEGY) ? store.getChildText(STORE_ROUTING_STRATEGY) : "consistent-routing";
        Element retention = store.getChild(STORE_RETENTION_POLICY_ELMT);
        Integer retentionPolicyDays = null;
        Integer retentionThrottleRate = null;
        if (retention != null) {
            retentionPolicyDays = Integer.parseInt(retention.getText());
            Element throttleRate = store.getChild(STORE_RETENTION_SCAN_THROTTLE_RATE_ELMT);
            if (throttleRate != null) {
                retentionThrottleRate = Integer.parseInt(throttleRate.getText());
            }
        }
        if (routingStrategyType.compareTo("zone-routing") == 0 && (zoneCountReads == null || zoneCountWrites == null || zoneReplicationFactor == null)) {
            throw new MappingException("Have not set one of the following correctly for store '" + name + "' - " + STORE_ZONE_COUNT_READS + ", " + STORE_ZONE_COUNT_WRITES + ", " + STORE_ZONE_REPLICATION_FACTOR_ELMT);
        }
        HintedHandoffStrategyType hintedHandoffStrategy = null;
        if (store.getChildText(HINTED_HANDOFF_STRATEGY) != null) {
            hintedHandoffStrategy = HintedHandoffStrategyType.fromDisplay(store.getChildText(HINTED_HANDOFF_STRATEGY));
        }
        Integer hintPrefListSize = null != (hintPrefListSizeStr = store.getChildText(HINT_PREFLIST_SIZE)) ? Integer.valueOf(Integer.parseInt(hintPrefListSizeStr)) : null;
        return new StoreDefinitionBuilder().setName(name).setType(storeType).setDescription(description).setOwners(owners).setKeySerializer(keySerializer).setValueSerializer(valueSerializer).setRoutingPolicy(routingTier).setRoutingStrategyType(routingStrategyType).setReplicationFactor(replicationFactor).setPreferredReads(preferredReads).setRequiredReads(requiredReads).setPreferredWrites(preferredWrites).setRequiredWrites(requiredWrites).setRetentionPeriodDays(retentionPolicyDays).setRetentionScanThrottleRate(retentionThrottleRate).setZoneReplicationFactor(zoneReplicationFactor).setZoneCountReads(zoneCountReads).setZoneCountWrites(zoneCountWrites).setHintedHandoffStrategy(hintedHandoffStrategy).setHintPrefListSize(hintPrefListSize).build();
    }

    private StoreDefinition readView(Element store, List<StoreDefinition> stores) {
        StoreDefinition target;
        String name = store.getChildText(STORE_NAME_ELMT);
        String targetName = store.getChildText(VIEW_TARGET_ELMT);
        String description = store.getChildText(STORE_DESCRIPTION_ELMT);
        String ownerText = store.getChildText(STORE_OWNERS_ELMT);
        ArrayList owners = Lists.newArrayList();
        if (ownerText != null) {
            for (String owner : Utils.COMMA_SEP.split(ownerText.trim())) {
                if (owner.trim().length() <= 0) continue;
                owners.add(owner);
            }
        }
        if ((target = StoreUtils.getStoreDef(stores, targetName)) == null) {
            throw new MappingException("View \"" + name + "\" has target store \"" + targetName + "\" but no such store exists");
        }
        int requiredReads = this.getChildWithDefault(store, STORE_REQUIRED_READS_ELMT, target.getRequiredReads());
        int preferredReads = this.getChildWithDefault(store, STORE_PREFERRED_READS_ELMT, target.getRequiredReads());
        int requiredWrites = this.getChildWithDefault(store, STORE_REQUIRED_WRITES_ELMT, target.getRequiredReads());
        int preferredWrites = this.getChildWithDefault(store, STORE_PREFERRED_WRITES_ELMT, target.getRequiredReads());
        Integer zoneCountReads = this.getChildWithDefault(store, STORE_ZONE_COUNT_READS, target.getZoneCountReads());
        Integer zoneCountWrites = this.getChildWithDefault(store, STORE_ZONE_COUNT_WRITES, target.getZoneCountWrites());
        String viewSerializerFactoryName = null;
        if (store.getChildText(VIEW_SERIALIZER_FACTORY_ELMT) != null) {
            viewSerializerFactoryName = store.getChild(VIEW_SERIALIZER_FACTORY_ELMT).getText();
        }
        SerializerDefinition keySerializer = target.getKeySerializer();
        SerializerDefinition valueSerializer = target.getValueSerializer();
        if (store.getChild(STORE_VALUE_SERIALIZER_ELMT) != null) {
            valueSerializer = this.readSerializer(store.getChild(STORE_VALUE_SERIALIZER_ELMT));
        }
        SerializerDefinition transformSerializer = target.getTransformsSerializer();
        if (store.getChild(STORE_TRANSFORM_SERIALIZER_ELMT) != null) {
            transformSerializer = this.readSerializer(store.getChild(STORE_TRANSFORM_SERIALIZER_ELMT));
        }
        RoutingTier routingTier = null;
        routingTier = store.getChildText(STORE_ROUTING_TIER_ELMT) != null ? RoutingTier.fromDisplay(store.getChildText(STORE_ROUTING_TIER_ELMT)) : target.getRoutingPolicy();
        String viewClass = store.getChildText(VIEW_TRANS_ELMT);
        return new StoreDefinitionBuilder().setName(name).setViewOf(targetName).setType(VIEW_ELMT).setDescription(description).setOwners(owners).setRoutingPolicy(routingTier).setRoutingStrategyType(target.getRoutingStrategyType()).setKeySerializer(keySerializer).setValueSerializer(valueSerializer).setTransformsSerializer(transformSerializer).setReplicationFactor(target.getReplicationFactor()).setZoneReplicationFactor(target.getZoneReplicationFactor()).setPreferredReads(preferredReads).setRequiredReads(requiredReads).setPreferredWrites(preferredWrites).setRequiredWrites(requiredWrites).setZoneCountReads(zoneCountReads).setZoneCountWrites(zoneCountWrites).setView(viewClass).setSerializerFactory(viewSerializerFactoryName).build();
    }

    private SerializerDefinition readSerializer(Element elmt) {
        String name = elmt.getChild("type").getText();
        boolean hasVersion = true;
        HashMap<Integer, String> schemaInfosByVersion = new HashMap<Integer, String>();
        for (Object schemaInfo : elmt.getChildren(STORE_SERIALIZATION_META_ELMT)) {
            int version;
            Element schemaInfoElmt = (Element)schemaInfo;
            String versionStr = schemaInfoElmt.getAttributeValue(STORE_VERSION_ATTR);
            if (versionStr == null) {
                version = 0;
            } else if (versionStr.equals("none")) {
                version = 0;
                hasVersion = false;
            } else {
                version = Integer.parseInt(versionStr);
            }
            String info = schemaInfoElmt.getText();
            String previous = schemaInfosByVersion.put(version, info);
            if (previous == null) continue;
            throw new MappingException("Duplicate version " + version + " found in schema info.");
        }
        if (!hasVersion && schemaInfosByVersion.size() > 1) {
            throw new IllegalArgumentException("Specified multiple schemas AND version=none, which is not permitted.");
        }
        Element compressionElmt = elmt.getChild(STORE_COMPRESSION_ELMT);
        Compression compression = null;
        if (compressionElmt != null) {
            compression = new Compression(compressionElmt.getChildText("type"), compressionElmt.getChildText(STORE_COMPRESSION_OPTIONS_ELMT));
        }
        return new SerializerDefinition(name, schemaInfosByVersion, hasVersion, compression);
    }

    public String writeStoreList(List<StoreDefinition> stores) {
        Element root = new Element(STORES_ELMT);
        for (StoreDefinition def : stores) {
            if (def.isView()) {
                root.addContent((Content)this.viewToElement(def));
                continue;
            }
            root.addContent((Content)this.storeToElement(def));
        }
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        return serializer.outputString(root);
    }

    public String writeStore(StoreDefinition store) {
        XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());
        if (store.isView()) {
            return serializer.outputString(this.viewToElement(store));
        }
        return serializer.outputString(this.storeToElement(store));
    }

    private Element storeToElement(StoreDefinition storeDefinition) {
        Element store = new Element(STORE_ELMT);
        store.addContent((Content)new Element(STORE_NAME_ELMT).setText(storeDefinition.getName()));
        store.addContent((Content)new Element(STORE_PERSISTENCE_ELMT).setText(storeDefinition.getType()));
        if (storeDefinition.getDescription() != null) {
            store.addContent((Content)new Element(STORE_DESCRIPTION_ELMT).setText(storeDefinition.getDescription()));
        }
        if (storeDefinition.getOwners() != null && storeDefinition.getOwners().size() > 0) {
            String ownersText = StringUtils.join((Object[])storeDefinition.getOwners().toArray(), (String)", ");
            store.addContent((Content)new Element(STORE_OWNERS_ELMT).setText(ownersText));
        }
        store.addContent((Content)new Element(STORE_ROUTING_STRATEGY).setText(storeDefinition.getRoutingStrategyType()));
        store.addContent((Content)new Element(STORE_ROUTING_TIER_ELMT).setText(storeDefinition.getRoutingPolicy().toDisplay()));
        store.addContent((Content)new Element(STORE_REPLICATION_FACTOR_ELMT).setText(Integer.toString(storeDefinition.getReplicationFactor())));
        HashMap<Integer, Integer> zoneReplicationFactor = storeDefinition.getZoneReplicationFactor();
        if (zoneReplicationFactor != null) {
            Element zoneReplicationFactorNode = new Element(STORE_ZONE_REPLICATION_FACTOR_ELMT);
            for (Integer zone : zoneReplicationFactor.keySet()) {
                zoneReplicationFactorNode.addContent((Content)new Element(STORE_REPLICATION_FACTOR_ELMT).setText(Integer.toString(zoneReplicationFactor.get(zone))).setAttribute(STORE_ZONE_ID_ELMT, Integer.toString(zone)));
            }
            store.addContent((Content)zoneReplicationFactorNode);
        }
        if (storeDefinition.hasPreferredReads()) {
            store.addContent((Content)new Element(STORE_PREFERRED_READS_ELMT).setText(Integer.toString(storeDefinition.getPreferredReads())));
        }
        store.addContent((Content)new Element(STORE_REQUIRED_READS_ELMT).setText(Integer.toString(storeDefinition.getRequiredReads())));
        if (storeDefinition.hasPreferredWrites()) {
            store.addContent((Content)new Element(STORE_PREFERRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getPreferredWrites())));
        }
        store.addContent((Content)new Element(STORE_REQUIRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getRequiredWrites())));
        if (storeDefinition.hasZoneCountReads()) {
            store.addContent((Content)new Element(STORE_ZONE_COUNT_READS).setText(Integer.toString(storeDefinition.getZoneCountReads())));
        }
        if (storeDefinition.hasZoneCountWrites()) {
            store.addContent((Content)new Element(STORE_ZONE_COUNT_WRITES).setText(Integer.toString(storeDefinition.getZoneCountWrites())));
        }
        if (storeDefinition.hasHintedHandoffStrategyType()) {
            store.addContent((Content)new Element(HINTED_HANDOFF_STRATEGY).setText(storeDefinition.getHintedHandoffStrategyType().toDisplay()));
        }
        if (storeDefinition.hasHintPreflistSize()) {
            store.addContent((Content)new Element(HINT_PREFLIST_SIZE).setText(Integer.toString(storeDefinition.getHintPrefListSize())));
        }
        Element keySerializer = new Element(STORE_KEY_SERIALIZER_ELMT);
        this.addSerializer(keySerializer, storeDefinition.getKeySerializer());
        store.addContent((Content)keySerializer);
        Element valueSerializer = new Element(STORE_VALUE_SERIALIZER_ELMT);
        this.addSerializer(valueSerializer, storeDefinition.getValueSerializer());
        store.addContent((Content)valueSerializer);
        if (storeDefinition.hasRetentionPeriod()) {
            store.addContent((Content)new Element(STORE_RETENTION_POLICY_ELMT).setText(Integer.toString(storeDefinition.getRetentionDays())));
        }
        if (storeDefinition.hasRetentionScanThrottleRate()) {
            store.addContent((Content)new Element(STORE_RETENTION_SCAN_THROTTLE_RATE_ELMT).setText(Integer.toString(storeDefinition.getRetentionScanThrottleRate())));
        }
        return store;
    }

    private Element viewToElement(StoreDefinition storeDefinition) {
        Element store = new Element(VIEW_ELMT);
        store.addContent((Content)new Element(STORE_NAME_ELMT).setText(storeDefinition.getName()));
        store.addContent((Content)new Element(VIEW_TARGET_ELMT).setText(storeDefinition.getViewTargetStoreName()));
        if (storeDefinition.getDescription() != null) {
            store.addContent((Content)new Element(STORE_DESCRIPTION_ELMT).setText(storeDefinition.getDescription()));
        }
        if (storeDefinition.getOwners() != null && storeDefinition.getOwners().size() > 0) {
            String ownersText = StringUtils.join((Object[])storeDefinition.getOwners().toArray(), (String)", ");
            store.addContent((Content)new Element(STORE_OWNERS_ELMT).setText(ownersText));
        }
        if (storeDefinition.getValueTransformation() == null) {
            throw new MappingException("View " + storeDefinition.getName() + " has no defined transformation class.");
        }
        store.addContent((Content)new Element(VIEW_TRANS_ELMT).setText(storeDefinition.getValueTransformation()));
        store.addContent((Content)new Element(STORE_ROUTING_TIER_ELMT).setText(storeDefinition.getRoutingPolicy().toDisplay()));
        if (storeDefinition.hasPreferredReads()) {
            store.addContent((Content)new Element(STORE_PREFERRED_READS_ELMT).setText(Integer.toString(storeDefinition.getPreferredReads())));
        }
        store.addContent((Content)new Element(STORE_REQUIRED_READS_ELMT).setText(Integer.toString(storeDefinition.getRequiredReads())));
        if (storeDefinition.hasPreferredWrites()) {
            store.addContent((Content)new Element(STORE_PREFERRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getPreferredWrites())));
        }
        store.addContent((Content)new Element(STORE_REQUIRED_WRITES_ELMT).setText(Integer.toString(storeDefinition.getRequiredWrites())));
        if (storeDefinition.hasZoneCountReads()) {
            store.addContent((Content)new Element(STORE_ZONE_COUNT_READS).setText(Integer.toString(storeDefinition.getZoneCountReads())));
        }
        if (storeDefinition.hasZoneCountWrites()) {
            store.addContent((Content)new Element(STORE_ZONE_COUNT_WRITES).setText(Integer.toString(storeDefinition.getZoneCountWrites())));
        }
        Element valueSerializer = new Element(STORE_VALUE_SERIALIZER_ELMT);
        this.addSerializer(valueSerializer, storeDefinition.getValueSerializer());
        store.addContent((Content)valueSerializer);
        Element transformsSerializer = new Element(STORE_TRANSFORM_SERIALIZER_ELMT);
        if (storeDefinition.getTransformsSerializer() != null) {
            this.addSerializer(transformsSerializer, storeDefinition.getTransformsSerializer());
            store.addContent((Content)transformsSerializer);
        }
        Element serializerFactory = new Element(VIEW_SERIALIZER_FACTORY_ELMT);
        if (storeDefinition.getSerializerFactory() != null) {
            serializerFactory.setText(storeDefinition.getSerializerFactory());
            store.addContent((Content)serializerFactory);
        }
        return store;
    }

    private void addSerializer(Element parent, SerializerDefinition def) {
        parent.addContent((Content)new Element("type").setText(def.getName()));
        if (def.hasSchemaInfo()) {
            for (Map.Entry<Integer, String> entry : def.getAllSchemaInfoVersions().entrySet()) {
                Element schemaElmt = new Element(STORE_SERIALIZATION_META_ELMT);
                if (def.hasVersion()) {
                    schemaElmt.setAttribute(STORE_VERSION_ATTR, Integer.toString(entry.getKey()));
                } else {
                    schemaElmt.setAttribute(STORE_VERSION_ATTR, "none");
                }
                schemaElmt.setText(entry.getValue());
                parent.addContent((Content)schemaElmt);
            }
        }
        if (def.hasCompression()) {
            Compression compression = def.getCompression();
            Element compressionElmt = new Element(STORE_COMPRESSION_ELMT);
            Element type = new Element("type");
            type.setText(compression.getType());
            compressionElmt.addContent((Content)type);
            String optionsText = compression.getOptions();
            if (optionsText != null) {
                Element options = new Element(STORE_COMPRESSION_OPTIONS_ELMT);
                options.setText(optionsText);
                compressionElmt.addContent((Content)options);
            }
            parent.addContent((Content)compressionElmt);
        }
    }

    public Integer getChildWithDefault(Element elmt, String property, Integer defaultVal) {
        if (elmt.getChildText(property) == null) {
            return defaultVal;
        }
        return Integer.parseInt(elmt.getChildText(property));
    }
}

