/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Comparator;
import voldemort.utils.Utils;
import voldemort.versioning.Occured;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Versioned<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final VectorClock version;
    private volatile T object;

    public Versioned(T object) {
        this(object, new VectorClock());
    }

    public Versioned(T object, Version version) {
        this.version = version == null ? new VectorClock() : (VectorClock)version;
        this.object = object;
    }

    public Version getVersion() {
        return this.version;
    }

    public T getValue() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Versioned)) {
            return false;
        }
        Versioned versioned = (Versioned)o;
        return Objects.equal((Object)this.getVersion(), (Object)versioned.getVersion()) && Utils.deepEquals(this.getValue(), versioned.getValue());
    }

    public int hashCode() {
        int value = 31 + this.version.hashCode();
        if (this.object != null) {
            value += 31 * this.object.hashCode();
        }
        return value;
    }

    public String toString() {
        return "[" + this.object + ", " + this.version + "]";
    }

    public Versioned<T> cloneVersioned() {
        return new Versioned<T>(this.getValue(), this.version.clone());
    }

    public static <S> Versioned<S> value(S s) {
        return new Versioned<S>(s, new VectorClock());
    }

    public static <S> Versioned<S> value(S s, Version v) {
        return new Versioned<S>(s, v);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class HappenedBeforeComparator<S>
    implements Comparator<Versioned<S>> {
        @Override
        public int compare(Versioned<S> v1, Versioned<S> v2) {
            Occured occured = v1.getVersion().compare(v2.getVersion());
            if (occured == Occured.BEFORE) {
                return -1;
            }
            if (occured == Occured.AFTER) {
                return 1;
            }
            return 0;
        }
    }
}

