/*
 * Decompiled with CFR 0.152.
 */
package voldemort.versioning;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import voldemort.annotations.concurrency.NotThreadsafe;
import voldemort.utils.ByteUtils;
import voldemort.versioning.ClockEntry;
import voldemort.versioning.Occured;
import voldemort.versioning.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadsafe
public class VectorClock
implements Version,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUMBER_OF_VERSIONS = Short.MAX_VALUE;
    private final List<ClockEntry> versions;
    private volatile long timestamp;

    public VectorClock() {
        this(new ArrayList<ClockEntry>(0), System.currentTimeMillis());
    }

    public VectorClock(long timestamp) {
        this(new ArrayList<ClockEntry>(0), timestamp);
    }

    public VectorClock(List<ClockEntry> versions, long timestamp) {
        this.versions = versions;
        this.timestamp = timestamp;
    }

    public VectorClock(byte[] bytes) {
        this(bytes, 0);
    }

    public VectorClock(byte[] bytes, int offset) {
        byte versionSize;
        int entrySize;
        if (bytes == null || bytes.length <= offset) {
            throw new IllegalArgumentException("Invalid byte array for serialization--no bytes to read.");
        }
        int numEntries = ByteUtils.readShort(bytes, offset);
        int minimumBytes = offset + 2 + 1 + numEntries * (entrySize = 2 + (versionSize = bytes[offset + 2])) + 8;
        if (bytes.length < minimumBytes) {
            throw new IllegalArgumentException("Too few bytes: expected at least " + minimumBytes + " but found only " + bytes.length + ".");
        }
        this.versions = new ArrayList<ClockEntry>(numEntries);
        int index = 3 + offset;
        for (int i = 0; i < numEntries; ++i) {
            short nodeId = ByteUtils.readShort(bytes, index);
            long version = ByteUtils.readBytes(bytes, index + 2, versionSize);
            this.versions.add(new ClockEntry(nodeId, version));
            index += entrySize;
        }
        this.timestamp = ByteUtils.readLong(bytes, index);
    }

    public byte[] toBytes() {
        byte versionSize;
        byte[] serialized = new byte[this.sizeInBytes()];
        ByteUtils.writeShort(serialized, (short)this.versions.size(), 0);
        serialized[2] = versionSize = ByteUtils.numberOfBytesRequired(this.getMaxVersion());
        int clockEntrySize = 2 + versionSize;
        int start = 3;
        for (ClockEntry v : this.versions) {
            ByteUtils.writeShort(serialized, v.getNodeId(), start);
            ByteUtils.writeBytes(serialized, v.getVersion(), start + 2, versionSize);
            start += clockEntrySize;
        }
        ByteUtils.writeLong(serialized, this.timestamp, start);
        return serialized;
    }

    public int sizeInBytes() {
        byte versionSize = ByteUtils.numberOfBytesRequired(this.getMaxVersion());
        return 3 + this.versions.size() * (2 + versionSize) + 8;
    }

    public void incrementVersion(int node, long time) {
        int index;
        if (node < 0 || node > Short.MAX_VALUE) {
            throw new IllegalArgumentException(node + " is outside the acceptable range of node ids.");
        }
        this.timestamp = time;
        boolean found = false;
        for (index = 0; index < this.versions.size(); ++index) {
            if (this.versions.get(index).getNodeId() == node) {
                found = true;
                break;
            }
            if (this.versions.get(index).getNodeId() <= node) continue;
            found = false;
            break;
        }
        if (found) {
            this.versions.set(index, this.versions.get(index).incremented());
        } else if (index < this.versions.size() - 1) {
            this.versions.add(index, new ClockEntry((short)node, 1L));
        } else {
            if (this.versions.size() > Short.MAX_VALUE) {
                throw new IllegalStateException("Vector clock is full!");
            }
            this.versions.add(index, new ClockEntry((short)node, 1L));
        }
    }

    public VectorClock incremented(int nodeId, long time) {
        VectorClock copyClock = this.clone();
        copyClock.incrementVersion(nodeId, time);
        return copyClock;
    }

    public VectorClock clone() {
        return new VectorClock(Lists.newArrayList(this.versions), this.timestamp);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(VectorClock.class)) {
            return false;
        }
        VectorClock clock = (VectorClock)object;
        return ((Object)this.versions).equals(clock.versions);
    }

    public int hashCode() {
        return ((Object)this.versions).hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("version(");
        if (this.versions.size() > 0) {
            for (int i = 0; i < this.versions.size() - 1; ++i) {
                builder.append(this.versions.get(i));
                builder.append(", ");
            }
            builder.append(this.versions.get(this.versions.size() - 1));
        }
        builder.append(")");
        return builder.toString();
    }

    public long getMaxVersion() {
        long max = -1L;
        for (ClockEntry entry : this.versions) {
            max = Math.max(entry.getVersion(), max);
        }
        return max;
    }

    public VectorClock merge(VectorClock clock) {
        int k;
        VectorClock newClock = new VectorClock();
        int i = 0;
        int j = 0;
        while (i < this.versions.size() && j < clock.versions.size()) {
            ClockEntry v1 = this.versions.get(i);
            ClockEntry v2 = clock.versions.get(j);
            if (v1.getNodeId() == v2.getNodeId()) {
                newClock.versions.add(new ClockEntry(v1.getNodeId(), Math.max(v1.getVersion(), v2.getVersion())));
                ++i;
                ++j;
                continue;
            }
            if (v1.getNodeId() < v2.getNodeId()) {
                newClock.versions.add(v1.clone());
                ++i;
                continue;
            }
            newClock.versions.add(v2.clone());
            ++j;
        }
        for (k = i; k < this.versions.size(); ++k) {
            newClock.versions.add(this.versions.get(k).clone());
        }
        for (k = j; k < clock.versions.size(); ++k) {
            newClock.versions.add(clock.versions.get(k).clone());
        }
        return newClock;
    }

    @Override
    public Occured compare(Version v) {
        if (!(v instanceof VectorClock)) {
            throw new IllegalArgumentException("Cannot compare Versions of different types.");
        }
        return VectorClock.compare(this, (VectorClock)v);
    }

    public static Occured compare(VectorClock v1, VectorClock v2) {
        if (v1 == null || v2 == null) {
            throw new IllegalArgumentException("Can't compare null vector clocks!");
        }
        boolean v1Bigger = false;
        boolean v2Bigger = false;
        int p1 = 0;
        int p2 = 0;
        while (p1 < v1.versions.size() && p2 < v2.versions.size()) {
            ClockEntry ver1 = v1.versions.get(p1);
            ClockEntry ver2 = v2.versions.get(p2);
            if (ver1.getNodeId() == ver2.getNodeId()) {
                if (ver1.getVersion() > ver2.getVersion()) {
                    v1Bigger = true;
                } else if (ver2.getVersion() > ver1.getVersion()) {
                    v2Bigger = true;
                }
                ++p1;
                ++p2;
                continue;
            }
            if (ver1.getNodeId() > ver2.getNodeId()) {
                v2Bigger = true;
                ++p2;
                continue;
            }
            v1Bigger = true;
            ++p1;
        }
        if (p1 < v1.versions.size()) {
            v1Bigger = true;
        } else if (p2 < v2.versions.size()) {
            v2Bigger = true;
        }
        if (!v1Bigger && !v2Bigger) {
            return Occured.BEFORE;
        }
        if (v1Bigger && !v2Bigger) {
            return Occured.AFTER;
        }
        if (!v1Bigger && v2Bigger) {
            return Occured.BEFORE;
        }
        return Occured.CONCURRENTLY;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public List<ClockEntry> getEntries() {
        return this.versions;
    }
}

