/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;

public class SelectorManager
implements Runnable {
    public static final int SELECTOR_POLL_MS = 500;
    protected final Selector selector;
    protected final AtomicBoolean isClosed;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public SelectorManager() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new VoldemortException(e);
        }
        this.isClosed = new AtomicBoolean(false);
    }

    public void close() {
        block14: {
            block13: {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                try {
                    for (SelectionKey sk : this.selector.keys()) {
                        block12: {
                            try {
                                if (this.logger.isTraceEnabled()) {
                                    this.logger.trace((Object)"Closing SelectionKey's channel");
                                }
                                sk.channel().close();
                            }
                            catch (Exception e) {
                                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block12;
                                this.logger.warn((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                        try {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace((Object)"Cancelling SelectionKey");
                            }
                            sk.cancel();
                        }
                        catch (Exception e) {
                            if (!this.logger.isEnabledFor((Priority)Level.WARN)) continue;
                            this.logger.warn((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block13;
                    this.logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block14;
                this.logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void processEvents() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block14: while (true) {
                if (this.isClosed.get()) {
                    if (!this.logger.isInfoEnabled()) return;
                    this.logger.info((Object)"Closed, exiting");
                    return;
                }
                this.processEvents();
                try {
                    int selected = this.selector.select(500L);
                    if (this.isClosed.get()) {
                        if (!this.logger.isInfoEnabled()) return;
                        this.logger.info((Object)"Closed, exiting");
                        return;
                    }
                    if (selected <= 0) continue;
                    Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!i.hasNext()) continue block14;
                        SelectionKey selectionKey = i.next();
                        i.remove();
                        if (!selectionKey.isReadable() && !selectionKey.isWritable()) continue;
                        Runnable worker = (Runnable)selectionKey.attachment();
                        worker.run();
                    }
                }
                catch (ClosedSelectorException e) {
                    if (!this.logger.isDebugEnabled()) return;
                    this.logger.debug((Object)"Selector is closed, exiting");
                    return;
                }
                catch (Throwable t) {
                    if (!this.logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    this.logger.error((Object)t.getMessage(), t);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            if (!this.logger.isEnabledFor((Priority)Level.ERROR)) return;
            this.logger.error((Object)t.getMessage(), t);
            return;
        }
        finally {
            block18: {
                try {
                    this.close();
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor((Priority)Level.ERROR)) break block18;
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

