/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtils {
    public static String getPropertyName(String name) {
        if (name != null && (name.startsWith("get") || name.startsWith("set"))) {
            StringBuilder b = new StringBuilder(name);
            b.delete(0, 3);
            b.setCharAt(0, Character.toLowerCase(b.charAt(0)));
            return b.toString();
        }
        return name;
    }

    public static Class<?> loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Class<?> loadClass(String className, ClassLoader cl) {
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T callConstructor(Class<T> klass) {
        return ReflectUtils.callConstructor(klass, new Class[0], new Object[0]);
    }

    public static <T> T callConstructor(Class<T> klass, Object[] args) {
        Class[] klasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            klasses[i] = args[i].getClass();
        }
        return ReflectUtils.callConstructor(klass, klasses, args);
    }

    public static <T> T callConstructor(Class<T> c, Class<?>[] argTypes, Object[] args) {
        try {
            Constructor<T> cons = c.getConstructor(argTypes);
            return cons.newInstance(args);
        }
        catch (InvocationTargetException e) {
            throw ReflectUtils.getCause(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> Object callMethod(Object obj, Class<T> c, String name, Class<?>[] classes, Object[] args) {
        try {
            Method m = ReflectUtils.getMethod(c, name, classes);
            return m.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            throw ReflectUtils.getCause(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> Method getMethod(Class<T> c, String name, Class<?> ... argTypes) {
        try {
            return c.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static RuntimeException getCause(InvocationTargetException e) {
        Throwable cause = e.getCause();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        throw new IllegalArgumentException(e.getCause());
    }
}

