/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.store.StoreDefinition;
import voldemort.utils.ByteArray;
import voldemort.utils.CmdUtils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDistributionGenerator {
    private static final DecimalFormat formatter = new DecimalFormat("#.##");
    public static final int DEFAULT_NUM_KEYS = 10000;

    public static void main(String[] args) throws IOException {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print help information");
        parser.accepts("cluster-xml", "[REQUIRED] cluster xml file location").withRequiredArg().describedAs("path");
        parser.accepts("stores-xml", "[REQUIRED] stores xml file location").withRequiredArg().describedAs("path");
        parser.accepts("num-keys", "Number of keys to query [Default : 10000]").withRequiredArg().describedAs("number").ofType(Integer.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing(options, "cluster-xml", "stores-xml")).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String clusterXml = (String)options.valueOf("cluster-xml");
        String storesXml = (String)options.valueOf("stores-xml");
        Integer numKeys = CmdUtils.valueOf(options, "num-keys", Integer.valueOf(10000));
        if (numKeys <= 0) {
            System.err.println("Number of keys should be greater than 0");
            System.exit(1);
        }
        Cluster cluster = new ClusterMapper().readCluster(new File(clusterXml));
        List<StoreDefinition> storeDefs = new StoreDefinitionsMapper().readStoreList(new File(storesXml));
        List<ByteArray> keys = KeyDistributionGenerator.generateKeys(numKeys);
        for (StoreDefinition def : storeDefs) {
            HashMap<Integer, Double> storeDistribution = KeyDistributionGenerator.generateDistribution(cluster, def, keys);
            System.out.println("For Store " + def.getName());
            KeyDistributionGenerator.printDistribution(storeDistribution);
            System.out.println("Std dev - " + KeyDistributionGenerator.getStdDeviation(storeDistribution));
            System.out.println("=========================");
        }
        HashMap<Integer, Double> overallDistribution = KeyDistributionGenerator.generateOverallDistribution(cluster, storeDefs, keys);
        System.out.println("Overall distribution ");
        KeyDistributionGenerator.printDistribution(overallDistribution);
        System.out.println("Std dev - " + KeyDistributionGenerator.getStdDeviation(overallDistribution));
    }

    public static String printStoreWiseDistribution(Cluster cluster, List<StoreDefinition> storeDefs, List<ByteArray> keys) {
        StringBuilder builder = new StringBuilder();
        for (StoreDefinition def : storeDefs) {
            HashMap<Integer, Double> storeDistribution = KeyDistributionGenerator.generateDistribution(cluster, def, keys);
            builder.append("\nFor Store '" + def.getName() + "' \n");
            for (int nodeId : storeDistribution.keySet()) {
                builder.append("Node " + nodeId + " - " + formatter.format(storeDistribution.get(nodeId)) + " \n");
            }
            builder.append("Std dev - " + KeyDistributionGenerator.getStdDeviation(storeDistribution) + "\n");
        }
        return builder.toString();
    }

    public static String printOverallDistribution(Cluster cluster, List<StoreDefinition> storeDefs, List<ByteArray> keys) {
        StringBuilder builder = new StringBuilder();
        HashMap<Integer, Double> distribution = KeyDistributionGenerator.generateOverallDistribution(cluster, storeDefs, keys);
        builder.append("Cluster('");
        builder.append(cluster.getName());
        builder.append("', [ ");
        for (Node n : cluster.getNodes()) {
            builder.append(n.toString());
            builder.append(" (" + formatter.format(distribution.get(n.getId())) + ")");
            builder.append(", ");
        }
        builder.append("], Std dev - " + KeyDistributionGenerator.getStdDeviation(distribution) + ")");
        return builder.toString();
    }

    public static HashMap<Integer, Double> generateOverallDistribution(Cluster cluster, List<StoreDefinition> storeDefs, List<ByteArray> keys) {
        return KeyDistributionGenerator.generateOverallDistributionWithUniqueStores(cluster, KeyDistributionGenerator.getUniqueStoreDefinitionsWithCounts(storeDefs), keys);
    }

    public static HashMap<Integer, Double> generateOverallDistributionWithUniqueStores(Cluster cluster, HashMap<StoreDefinition, Integer> uniqueStoreDefsWithCount, List<ByteArray> keys) {
        HashMap overallDistributionCount = Maps.newHashMap();
        for (Node node : cluster.getNodes()) {
            overallDistributionCount.put(node.getId(), 0.0);
        }
        int totalStores = 0;
        for (Map.Entry<StoreDefinition, Integer> entry : uniqueStoreDefsWithCount.entrySet()) {
            HashMap<Integer, Double> nodeDistribution = KeyDistributionGenerator.generateDistribution(cluster, entry.getKey(), keys);
            for (int nodeId : nodeDistribution.keySet()) {
                overallDistributionCount.put(nodeId, (Double)overallDistributionCount.get(nodeId) + nodeDistribution.get(nodeId) * (double)entry.getValue().intValue());
            }
            totalStores += entry.getValue().intValue();
        }
        Iterator<Map.Entry<StoreDefinition, Integer>> i$ = overallDistributionCount.keySet().iterator();
        while (i$.hasNext()) {
            int nodeId = (Integer)((Object)i$.next());
            overallDistributionCount.put(nodeId, (Double)overallDistributionCount.get(nodeId) / ((double)totalStores * 100.0) * 100.0);
        }
        return overallDistributionCount;
    }

    public static HashMap<Integer, Double> generateDistribution(Cluster cluster, StoreDefinition storeDef, List<ByteArray> keys) {
        RoutingStrategyFactory factory = new RoutingStrategyFactory();
        RoutingStrategy strategy = factory.updateRoutingStrategy(storeDef, cluster);
        HashMap requestRouting = Maps.newHashMap();
        Long total = new Long(0L);
        for (ByteArray key : keys) {
            List<Node> nodes = strategy.routeRequest(key.get());
            for (Node node : nodes) {
                Long count = (Long)requestRouting.get(node.getId());
                if (count == null) {
                    count = new Long(0L);
                }
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
                requestRouting.put(node.getId(), count);
                l = total;
                l2 = total = Long.valueOf(total + 1L);
            }
        }
        HashMap finalDistribution = Maps.newHashMap();
        Iterator i$ = requestRouting.keySet().iterator();
        while (i$.hasNext()) {
            int nodeId = (Integer)i$.next();
            finalDistribution.put(nodeId, new Double((double)((Long)requestRouting.get(nodeId)).longValue() * 100.0 / (double)total.longValue()));
        }
        return finalDistribution;
    }

    public static HashMap<StoreDefinition, Integer> getUniqueStoreDefinitionsWithCounts(List<StoreDefinition> storeDefs) {
        HashMap uniqueStoreDefs = Maps.newHashMap();
        for (StoreDefinition storeDef : storeDefs) {
            if (uniqueStoreDefs.isEmpty()) {
                uniqueStoreDefs.put(storeDef, 1);
                continue;
            }
            StoreDefinition sameStore = null;
            for (StoreDefinition uniqueStoreDef : uniqueStoreDefs.keySet()) {
                if (uniqueStoreDef.getReplicationFactor() != storeDef.getReplicationFactor() || uniqueStoreDef.getRoutingStrategyType().compareTo(storeDef.getRoutingStrategyType()) != 0) continue;
                if (uniqueStoreDef.getRoutingStrategyType().compareTo("zone-routing") == 0) {
                    boolean zonesSame = true;
                    for (int zoneId : uniqueStoreDef.getZoneReplicationFactor().keySet()) {
                        if (storeDef.getZoneReplicationFactor().get(zoneId) != null && storeDef.getZoneReplicationFactor().get(zoneId) == uniqueStoreDef.getZoneReplicationFactor().get(zoneId)) continue;
                        zonesSame = false;
                        break;
                    }
                    if (zonesSame) {
                        sameStore = uniqueStoreDef;
                    }
                } else {
                    sameStore = uniqueStoreDef;
                }
                if (sameStore == null) continue;
                int currentCount = (Integer)uniqueStoreDefs.get(sameStore);
                uniqueStoreDefs.put(sameStore, currentCount + 1);
                break;
            }
            if (sameStore != null) continue;
            uniqueStoreDefs.put(storeDef, 1);
        }
        return uniqueStoreDefs;
    }

    public static List<ByteArray> generateKeys(int numKeys) {
        ArrayList keys = Lists.newArrayList();
        for (int i = 0; i < numKeys; ++i) {
            keys.add(new ByteArray(("key" + i).getBytes()));
        }
        return keys;
    }

    public static void printDistribution(HashMap<Integer, Double> distribution) {
        for (int nodeId : distribution.keySet()) {
            System.out.println("Node " + nodeId + " - " + formatter.format(distribution.get(nodeId)));
        }
    }

    public static double getStdDeviation(HashMap<Integer, Double> distribution) {
        HashMap expectedDistribution = Maps.newHashMap();
        int numberOfNodes = distribution.keySet().size();
        double distributionPerNode = 100.0 / (double)numberOfNodes;
        for (int nodeId = 0; nodeId < numberOfNodes; ++nodeId) {
            expectedDistribution.put(nodeId, distributionPerNode);
        }
        return KeyDistributionGenerator.getStdDeviation(distribution, expectedDistribution);
    }

    private static double getStdDeviation(HashMap<Integer, Double> distribution, HashMap<Integer, Double> expectedDistribution) {
        HashMap offBy = Maps.newHashMap();
        for (Integer nodeId : distribution.keySet()) {
            offBy.put(nodeId, new Double(expectedDistribution.get(nodeId) - distribution.get(nodeId)));
        }
        double sum = 0.0;
        double squareSum = 0.0;
        Iterator i$ = offBy.values().iterator();
        while (i$.hasNext()) {
            double num = (Double)i$.next();
            squareSum += num * num;
            sum += num;
        }
        double mean = sum / (double)distribution.size();
        return Math.sqrt(squareSum / (double)distribution.size() - mean * mean);
    }
}

