/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ByteUtils {
    public static final int SIZE_OF_BYTE = 1;
    public static final int SIZE_OF_SHORT = 2;
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int MASK_00000000 = Integer.parseInt("00000000", 2);
    public static final int MASK_10000000 = Integer.parseInt("10000000", 2);
    public static final int MASK_11000000 = Integer.parseInt("11000000", 2);
    public static final int MASK_11100000 = Integer.parseInt("11100000", 2);
    public static final int MASK_10111111 = Integer.parseInt("10111111", 2);
    public static final int MASK_11011111 = Integer.parseInt("11011111", 2);
    public static final int MASK_01000000 = Integer.parseInt("10000000", 2);
    public static final int MASK_01100000 = Integer.parseInt("11000000", 2);
    public static final int MASK_01110000 = Integer.parseInt("11100000", 2);
    public static final int MASK_01011111 = Integer.parseInt("10111111", 2);
    public static final int MASK_01101111 = Integer.parseInt("11011111", 2);
    public static final int MASK_11111111 = Integer.parseInt("11111111", 2);
    public static final int MASK_01111111 = Integer.parseInt("01111111", 2);
    public static final int MASK_00111111 = Integer.parseInt("00111111", 2);
    public static final int MASK_00011111 = Integer.parseInt("00011111", 2);

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unknown algorithm: " + algorithm, e);
        }
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            if ((hex = hex.substring(0, Math.min(hex.length(), 2))).length() == 1) {
                buffer.append("0");
            }
            buffer.append(hex);
        }
        return buffer.toString();
    }

    public static String toBinaryString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        for (byte b : bytes) {
            String bin = Integer.toBinaryString(0xFF & b);
            bin = bin.substring(0, Math.min(bin.length(), 8));
            for (int j = 0; j < 8 - bin.length(); ++j) {
                buffer.append('0');
            }
            buffer.append(bin);
        }
        return buffer.toString();
    }

    public static byte[] cat(byte[] ... arrays) {
        int size = 0;
        for (byte[] a : arrays) {
            if (a == null) continue;
            size += a.length;
        }
        byte[] cated = new byte[size];
        int pos = 0;
        for (byte[] a : arrays) {
            if (a == null) continue;
            System.arraycopy(a, 0, cated, pos, a.length);
            pos += a.length;
        }
        return cated;
    }

    public static byte[] copy(byte[] array, int from, int to) {
        if (to - from < 0) {
            return new byte[0];
        }
        byte[] a = new byte[to - from];
        System.arraycopy(array, from, a, 0, to - from);
        return a;
    }

    public static short readShort(byte[] bytes, int offset) {
        return (short)(bytes[offset] << 8 | bytes[offset + 1] & 0xFF);
    }

    public static int readInt(byte[] bytes, int offset) {
        return (bytes[offset + 0] & 0xFF) << 24 | (bytes[offset + 1] & 0xFF) << 16 | (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
    }

    public static long readUnsignedInt(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
    }

    public static long readLong(byte[] bytes, int offset) {
        return (long)(bytes[offset + 0] & 0xFF) << 56 | (long)(bytes[offset + 1] & 0xFF) << 48 | (long)(bytes[offset + 2] & 0xFF) << 40 | (long)(bytes[offset + 3] & 0xFF) << 32 | (long)(bytes[offset + 4] & 0xFF) << 24 | (long)(bytes[offset + 5] & 0xFF) << 16 | (long)(bytes[offset + 6] & 0xFF) << 8 | (long)bytes[offset + 7] & 0xFFL;
    }

    public static long readBytes(byte[] bytes, int offset, int numBytes) {
        int shift = 0;
        long value = 0L;
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            value |= ((long)bytes[i] & 0xFFL) << shift;
            shift += 8;
        }
        return value;
    }

    public static void writeShort(byte[] bytes, short value, int offset) {
        bytes[offset] = (byte)(0xFF & value >> 8);
        bytes[offset + 1] = (byte)(0xFF & value);
    }

    public static void writeInt(byte[] bytes, int value, int offset) {
        bytes[offset] = (byte)(0xFF & value >> 24);
        bytes[offset + 1] = (byte)(0xFF & value >> 16);
        bytes[offset + 2] = (byte)(0xFF & value >> 8);
        bytes[offset + 3] = (byte)(0xFF & value);
    }

    public static void writeLong(byte[] bytes, long value, int offset) {
        bytes[offset] = (byte)(0xFFL & value >> 56);
        bytes[offset + 1] = (byte)(0xFFL & value >> 48);
        bytes[offset + 2] = (byte)(0xFFL & value >> 40);
        bytes[offset + 3] = (byte)(0xFFL & value >> 32);
        bytes[offset + 4] = (byte)(0xFFL & value >> 24);
        bytes[offset + 5] = (byte)(0xFFL & value >> 16);
        bytes[offset + 6] = (byte)(0xFFL & value >> 8);
        bytes[offset + 7] = (byte)(0xFFL & value);
    }

    public static void writeBytes(byte[] bytes, long value, int offset, int numBytes) {
        int shift = 0;
        for (int i = offset + numBytes - 1; i >= offset; --i) {
            bytes[i] = (byte)(0xFFL & value >> shift);
            shift += 8;
        }
    }

    public static byte numberOfBytesRequired(long number) {
        if (number < 0L) {
            number = -number;
        }
        for (byte i = 1; i <= 8; i = (byte)(i + 1)) {
            if (number >= 1L << 8 * i) continue;
            return i;
        }
        throw new IllegalStateException("Should never happen.");
    }

    public static long readVarNumber(DataInputStream input) throws IOException {
        int b = 0xFF & input.readByte();
        if ((b & MASK_10000000) == 0) {
            return MASK_01111111 & b;
        }
        if ((b & MASK_11000000) == MASK_10000000) {
            long val = (b & MASK_00111111) << 8;
            return val |= (long)(0xFF & input.readByte());
        }
        if ((b & MASK_11100000) == MASK_11000000) {
            long val = b & MASK_00011111;
            for (int i = 0; i < 3; ++i) {
                val <<= 8;
                val |= (long)(0xFF & input.readByte());
            }
            return val;
        }
        if ((b & MASK_11100000) == MASK_11100000) {
            long val = b & MASK_00011111;
            for (int i = 0; i < 7; ++i) {
                val <<= 8;
                val |= (long)(0xFF & input.readByte());
            }
            return val;
        }
        throw new IllegalArgumentException("Unknown prefix!");
    }

    public static byte readNthByte(long l, int n) {
        return (byte)(0xFFL & l >> n * 8);
    }

    public static void read(InputStream stream, byte[] buffer) throws IOException {
        int newlyRead;
        for (int read = 0; read < buffer.length; read += newlyRead) {
            newlyRead = stream.read(buffer, read, buffer.length - read);
            if (newlyRead != -1) continue;
            throw new EOFException("Attempt to read " + buffer.length + " bytes failed due to EOF.");
        }
    }

    public static byte[] getBytes(String string, String encoding) {
        try {
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(encoding + " is not a known encoding name.", e);
        }
    }

    public static String getString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(encoding + " is not a known encoding name.", e);
        }
    }

    public static byte[] md5(byte[] input) {
        return ByteUtils.getDigest("MD5").digest(input);
    }

    public static byte[] sha1(byte[] input) {
        return ByteUtils.getDigest("SHA-1").digest(input);
    }

    public static int compare(byte[] b1, byte[] b2) {
        return ByteUtils.compare(b1, b2, 0, b2.length);
    }

    public static int compare(byte[] b1, byte[] b2, int offset, int to) {
        int j = offset;
        int b2Length = to - offset;
        if (to > b2.length) {
            throw new IllegalArgumentException("To offset (" + to + ") should be <= than length (" + b2.length + ")");
        }
        for (int i = 0; i < b1.length && j < to; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return (a - b) / Math.abs(a - b);
        }
        return (b1.length - b2Length) / Math.max(1, Math.abs(b1.length - b2Length));
    }

    public static ByteBuffer expand(ByteBuffer buffer, int newCapacity) {
        if (newCapacity < buffer.capacity()) {
            throw new IllegalArgumentException("newCapacity (" + newCapacity + ") must be larger than existing capacity (" + buffer.capacity() + ")");
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        int position = buffer.position();
        buffer.rewind();
        newBuffer.put(buffer);
        newBuffer.position(position);
        return newBuffer;
    }
}

