/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import voldemort.annotations.concurrency.NotThreadsafe;

@NotThreadsafe
public class ByteBufferBackedInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferBackedInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buffer.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.buffer.remaining());
        this.buffer.get(bytes, off, len);
        return len;
    }
}

