/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.versioned;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InconsistencyResolvingStore<K, V, T>
extends DelegatingStore<K, V, T> {
    private final InconsistencyResolver<Versioned<V>> resolver;

    public InconsistencyResolvingStore(Store<K, V, T> innerStore, InconsistencyResolver<Versioned<V>> resolver) {
        super(innerStore);
        this.resolver = resolver;
    }

    @Override
    public List<Versioned<V>> get(K key, T transforms) throws VoldemortException {
        return this.resolver.resolveConflicts(super.get(key, transforms));
    }

    @Override
    public Map<K, List<Versioned<V>>> getAll(Iterable<K> keys, Map<K, T> transforms) throws VoldemortException {
        Map m = super.getAll(keys, transforms);
        for (Map.Entry entry : m.entrySet()) {
            m.put(entry.getKey(), this.resolver.resolveConflicts(entry.getValue()));
        }
        return m;
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (capability == StoreCapabilityType.INCONSISTENCY_RESOLVER) {
            return this.resolver;
        }
        return super.getCapability(capability);
    }
}

