/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import org.apache.log4j.Logger;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.store.stats.StreamStats;

@JmxManaged(description="Streaming related statistics")
public class StreamStatsJmx {
    private static final Logger logger = Logger.getLogger(StreamStatsJmx.class);
    private final StreamStats stats;

    public StreamStatsJmx(StreamStats stats) {
        this.stats = stats;
    }

    @JmxGetter(name="streamOperationIds", description="Get a list of all stream operations.")
    public String getStreamOperationIds() {
        try {
            return this.stats.getHandleIds().toString();
        }
        catch (Exception e) {
            logger.error((Object)"Exception in JMX call", (Throwable)e);
            return e.getMessage();
        }
    }

    @JmxGetter(name="allStreamOperations", description="Get status of all stream operations.")
    public String getAllStreamOperations() {
        try {
            return this.stats.getHandles().toString();
        }
        catch (Exception e) {
            logger.error((Object)"Exception in JMX call", (Throwable)e);
            return e.getMessage();
        }
    }

    @JmxOperation(description="Get the status of a stream operation with specified id.")
    public String getStreamOperation(long handleId) {
        try {
            return this.stats.getHandle(handleId).toString();
        }
        catch (Exception e) {
            logger.error((Object)"Exception in JMX call", (Throwable)e);
            return e.getMessage();
        }
    }

    @JmxOperation(description="Clear out finished tasks.")
    public void clearFinished() {
        this.stats.clearFinished();
    }

    @JmxGetter(name="averageFetchKeysDiskTimeMs", description="The avg. disk time in ms per FETCH_KEYS operation.")
    public double getAvgFetchKeysDiskTimeMs() {
        return this.stats.getDiskCounter(StreamStats.Operation.FETCH_KEYS).getAverageTimeInMs();
    }

    @JmxGetter(name="averageFetchEntriesDiskTimeMs", description="The avg. disk time in ms per FETCH_ENTRIES operation.")
    public double getAvgFetchEntriesDiskTimeMs() {
        return this.stats.getDiskCounter(StreamStats.Operation.FETCH_ENTRIES).getAverageTimeInMs();
    }

    @JmxGetter(name="averageFetchFileDiskTimeMs", description="The avg. disk time in ms per FETCH_FILE operation.")
    public double getAvgFetchFileDiskTimeMs() {
        return this.stats.getDiskCounter(StreamStats.Operation.FETCH_FILE).getAverageTimeInMs();
    }

    @JmxGetter(name="averageUpdateDiskTimeMs", description="The avg. disk time in ms per UPDATE operation.")
    public double getAvgUpdateDiskTimeMs() {
        return this.stats.getDiskCounter(StreamStats.Operation.UPDATE).getAverageTimeInMs();
    }

    @JmxGetter(name="averageSlopDiskTimeMs", description="The avg. disk time in ms per UPDATE_SLOP operation.")
    public double getAvgSlopDiskTimeMs() {
        return this.stats.getDiskCounter(StreamStats.Operation.SLOP).getAverageTimeInMs();
    }

    @JmxGetter(name="averageFetchKeysNetworkTimeMs", description="The avg. network time in ms per FETCH_KEYS operation.")
    public double getAvgFetchKeysNetworkTimeMs() {
        return this.stats.getNetworkCounter(StreamStats.Operation.FETCH_KEYS).getAverageTimeInMs();
    }

    @JmxGetter(name="averageFetchEntriesNetworkTimeMs", description="The avg. network time in ms per FETCH_ENTRIES operation.")
    public double getAvgFetchEntriesNetworkTimeMs() {
        return this.stats.getNetworkCounter(StreamStats.Operation.FETCH_ENTRIES).getAverageTimeInMs();
    }

    @JmxGetter(name="averageFetchFileNetworkTimeMs", description="The avg. network time in ms per FETCH_FILE operation.")
    public double getAvgFetchFileNetworkTimeMs() {
        return this.stats.getNetworkCounter(StreamStats.Operation.FETCH_FILE).getAverageTimeInMs();
    }

    @JmxGetter(name="averageUpdateNetworkTimeMs", description="The avg. network time in ms per UPDATE operation.")
    public double getAvgUpdateNetworkTimeMs() {
        return this.stats.getNetworkCounter(StreamStats.Operation.UPDATE).getAverageTimeInMs();
    }

    @JmxGetter(name="averageSlopNetworkTimeMs", description="The avg. network time in ms per UPDATE_SLOP operation.")
    public double getAvgSlopNetworkTimeMs() {
        return this.stats.getNetworkCounter(StreamStats.Operation.SLOP).getAverageTimeInMs();
    }
}

