/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.store.DelegatingStore;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.Tracked;
import voldemort.utils.ByteArray;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatTrackingStore
extends DelegatingStore<ByteArray, byte[], byte[]> {
    private StoreStats stats;

    public StatTrackingStore(Store<ByteArray, byte[], byte[]> innerStore, StoreStats parentStats) {
        super(innerStore);
        this.stats = new StoreStats(parentStats);
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        boolean bl;
        long start = System.nanoTime();
        try {
            bl = super.delete(key, version);
            Object var7_6 = null;
        }
        catch (VoldemortException e) {
            try {
                this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
                throw e;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.stats.recordTime(Tracked.DELETE, System.nanoTime() - start);
                throw throwable;
            }
        }
        this.stats.recordTime(Tracked.DELETE, System.nanoTime() - start);
        return bl;
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        List<Versioned<byte[]>> list;
        List<Versioned<byte[]>> result = null;
        long start = System.nanoTime();
        try {
            list = result = super.get(key, transforms);
            Object var8_7 = null;
        }
        catch (VoldemortException e) {
            try {
                this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
                throw e;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                long duration = System.nanoTime() - start;
                long totalBytes = 0L;
                boolean returningEmpty = true;
                if (result != null) {
                    returningEmpty = result.size() == 0;
                    for (Versioned versioned : result) {
                        totalBytes += (long)((byte[])versioned.getValue()).length;
                    }
                }
                this.stats.recordGetTime(duration, returningEmpty, totalBytes);
                throw throwable;
            }
        }
        long duration = System.nanoTime() - start;
        long totalBytes = 0L;
        boolean returningEmpty = true;
        if (result != null) {
            returningEmpty = result.size() == 0;
            for (Versioned versioned : result) {
                totalBytes += (long)((byte[])versioned.getValue()).length;
            }
        }
        this.stats.recordGetTime(duration, returningEmpty, totalBytes);
        return list;
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        Map<ByteArray, List<Versioned<byte[]>>> map;
        Map<ByteArray, List<Versioned<byte[]>>> result = null;
        long start = System.nanoTime();
        try {
            map = result = super.getAll(keys, transforms);
            Object var8_7 = null;
        }
        catch (VoldemortException e) {
            try {
                this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
                throw e;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                long duration = System.nanoTime() - start;
                long totalBytes = 0L;
                int requestedValues = 0;
                int returnedValues = 0;
                for (ByteArray byteArray : keys) {
                    ++requestedValues;
                }
                if (result != null) {
                    returnedValues = result.keySet().size();
                    for (List list : result.values()) {
                        for (Versioned bytes : list) {
                            totalBytes += (long)((byte[])bytes.getValue()).length;
                        }
                    }
                }
                this.stats.recordGetAllTime(duration, requestedValues, returnedValues, totalBytes);
                throw throwable;
            }
        }
        long duration = System.nanoTime() - start;
        long totalBytes = 0L;
        int requestedValues = 0;
        int returnedValues = 0;
        for (ByteArray byteArray : keys) {
            ++requestedValues;
        }
        if (result != null) {
            returnedValues = result.keySet().size();
            for (List list : result.values()) {
                for (Versioned bytes : list) {
                    totalBytes += (long)((byte[])bytes.getValue()).length;
                }
            }
        }
        this.stats.recordGetAllTime(duration, requestedValues, returnedValues, totalBytes);
        return map;
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> value, byte[] transforms) throws VoldemortException {
        long start = System.nanoTime();
        try {
            try {
                super.put(key, value, transforms);
            }
            catch (ObsoleteVersionException e) {
                this.stats.recordTime(Tracked.OBSOLETE, System.nanoTime() - start);
                throw e;
            }
            catch (VoldemortException e) {
                this.stats.recordTime(Tracked.EXCEPTION, System.nanoTime() - start);
                throw e;
            }
            Object var8_5 = null;
            this.stats.recordPutTimeAndSize(System.nanoTime() - start, value.getValue().length);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.stats.recordPutTimeAndSize(System.nanoTime() - start, value.getValue().length);
            throw throwable;
        }
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (StoreCapabilityType.STAT_TRACKER.equals((Object)capability)) {
            return this.stats;
        }
        return super.getCapability(capability);
    }

    public StoreStats getStats() {
        return this.stats;
    }

    @JmxOperation(description="Reset statistics.", impact=1)
    public void resetStatistics() {
        this.stats = new StoreStats();
    }
}

