/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.stats;

import java.util.concurrent.atomic.AtomicReference;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;

public class RequestCounter {
    private final AtomicReference<Accumulator> values;
    private final int durationMS;
    private final Time time;

    public RequestCounter(int durationMS) {
        this(durationMS, SystemTime.INSTANCE);
    }

    RequestCounter(int durationMS, Time time) {
        this.time = time;
        this.values = new AtomicReference<Accumulator>(new Accumulator());
        this.durationMS = durationMS;
    }

    public long getCount() {
        return this.getValidAccumulator().count;
    }

    public long getTotalCount() {
        return this.getValidAccumulator().total;
    }

    public float getThroughput() {
        Accumulator oldv = this.getValidAccumulator();
        double elapsed = (double)(this.time.getMilliseconds() - oldv.startTimeMS) / 1000.0;
        if (elapsed > 0.0) {
            return (float)((double)oldv.count / elapsed);
        }
        return 0.0f;
    }

    public String getDisplayThroughput() {
        return String.format("%.2f", Float.valueOf(this.getThroughput()));
    }

    public double getAverageTimeInMs() {
        return this.getValidAccumulator().getAverageTimeNS() / 1000000.0;
    }

    public String getDisplayAverageTimeInMs() {
        return String.format("%.4f", this.getAverageTimeInMs());
    }

    public int getDuration() {
        return this.durationMS;
    }

    public long getMaxLatencyInMs() {
        return this.getValidAccumulator().maxLatencyNS / 1000000L;
    }

    private Accumulator getValidAccumulator() {
        Accumulator accum = this.values.get();
        long now = this.time.getMilliseconds();
        if (now - accum.startTimeMS <= (long)this.durationMS) {
            return accum;
        }
        Accumulator newWithTotal = accum.newWithTotal();
        if (this.values.compareAndSet(accum, newWithTotal)) {
            return newWithTotal;
        }
        return this.values.get();
    }

    public void addRequest(long timeNS) {
        this.addRequest(timeNS, 0L, 0L, 0L);
    }

    public void addRequest(long timeNS, long numEmptyResponses, long bytes, long getAllAggregatedCount) {
        for (int i = 0; i < 3; ++i) {
            Accumulator newv;
            Accumulator oldv = this.getValidAccumulator();
            if (!this.values.compareAndSet(oldv, newv = new Accumulator(oldv.startTimeMS, oldv.count + 1L, oldv.totalTimeNS + timeNS, oldv.total + 1L, oldv.numEmptyResponses + numEmptyResponses, Math.max(timeNS, oldv.maxLatencyNS), oldv.totalBytes + bytes, Math.max(oldv.maxBytes, bytes), oldv.getAllAggregatedCount + getAllAggregatedCount))) continue;
            return;
        }
    }

    public long getNumEmptyResponses() {
        return this.getValidAccumulator().numEmptyResponses;
    }

    public long getMaxSizeInBytes() {
        return this.getValidAccumulator().maxBytes;
    }

    public double getAverageSizeInBytes() {
        return this.getValidAccumulator().getAverageBytes();
    }

    public long getGetAllAggregatedCount() {
        return this.getValidAccumulator().getAllAggregatedCount;
    }

    private class Accumulator {
        final long startTimeMS;
        final long count;
        final long totalTimeNS;
        final long total;
        final long numEmptyResponses;
        final long getAllAggregatedCount;
        final long maxLatencyNS;
        final long maxBytes;
        final long totalBytes;

        public Accumulator() {
            this(requestCounter.time.getMilliseconds(), 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        public Accumulator newWithTotal() {
            return new Accumulator(RequestCounter.this.time.getMilliseconds(), 0L, 0L, this.total, 0L, 0L, 0L, 0L, 0L);
        }

        public Accumulator(long startTimeMS, long count, long totalTimeNS, long total, long numEmptyResponses, long maxLatencyNS, long totalBytes, long maxBytes, long getAllAggregatedCount) {
            this.startTimeMS = startTimeMS;
            this.count = count;
            this.totalTimeNS = totalTimeNS;
            this.total = total;
            this.numEmptyResponses = numEmptyResponses;
            this.maxLatencyNS = maxLatencyNS;
            this.totalBytes = totalBytes;
            this.maxBytes = maxBytes;
            this.getAllAggregatedCount = getAllAggregatedCount;
        }

        public double getAverageTimeNS() {
            return this.count > 0L ? (double)(1.0f * (float)this.totalTimeNS / (float)this.count) : 0.0;
        }

        public double getAverageBytes() {
            return this.count > 0L ? (double)(1.0f * (float)this.totalBytes / (float)this.count) : -0.0;
        }
    }
}

