/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.socket.clientrequest.AbstractStoreClientRequest;
import voldemort.utils.ByteArray;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetClientRequest
extends AbstractStoreClientRequest<List<Versioned<byte[]>>> {
    private final ByteArray key;
    private final byte[] transforms;

    public GetClientRequest(String storeName, RequestFormat requestFormat, RequestRoutingType requestRoutingType, ByteArray key, byte[] transforms) {
        super(storeName, requestFormat, requestRoutingType);
        this.key = key;
        this.transforms = transforms;
    }

    @Override
    public boolean isCompleteResponse(ByteBuffer buffer) {
        return this.requestFormat.isCompleteGetResponse(buffer);
    }

    @Override
    protected void formatRequestInternal(DataOutputStream outputStream) throws IOException {
        this.requestFormat.writeGetRequest(outputStream, this.storeName, this.key, this.transforms, this.requestRoutingType);
    }

    @Override
    protected List<Versioned<byte[]>> parseResponseInternal(DataInputStream inputStream) throws IOException {
        return this.requestFormat.readGetResponse(inputStream);
    }
}

