/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import voldemort.VoldemortException;
import voldemort.annotations.jmx.JmxGetter;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxSetter;
import voldemort.client.protocol.RequestFormatType;
import voldemort.server.RequestRoutingType;
import voldemort.store.UnreachableStoreException;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketStore;
import voldemort.store.socket.SocketStoreFactory;
import voldemort.store.socket.clientrequest.ClientRequestExecutor;
import voldemort.store.socket.clientrequest.ClientRequestExecutorFactory;
import voldemort.utils.Utils;
import voldemort.utils.pool.KeyedResourcePool;
import voldemort.utils.pool.ResourcePoolConfig;

@JmxManaged(description="Voldemort socket pool.")
public class ClientRequestExecutorPool
implements SocketStoreFactory {
    private final AtomicInteger monitoringInterval = new AtomicInteger(10000);
    private final AtomicInteger checkouts;
    private final AtomicLong waitNs;
    private final AtomicLong avgWaitNs;
    private final KeyedResourcePool<SocketDestination, ClientRequestExecutor> pool;
    private final ClientRequestExecutorFactory factory;

    public ClientRequestExecutorPool(int selectors, int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize, boolean socketKeepAlive) {
        ResourcePoolConfig config = new ResourcePoolConfig().setIsFair(true).setMaxPoolSize(maxConnectionsPerNode).setMaxInvalidAttempts(maxConnectionsPerNode).setTimeout(connectionTimeoutMs, TimeUnit.MILLISECONDS);
        this.factory = new ClientRequestExecutorFactory(selectors, connectionTimeoutMs, soTimeoutMs, socketBufferSize, socketKeepAlive);
        this.pool = new KeyedResourcePool<SocketDestination, ClientRequestExecutor>(this.factory, config);
        this.checkouts = new AtomicInteger(0);
        this.waitNs = new AtomicLong(0L);
        this.avgWaitNs = new AtomicLong(0L);
    }

    public ClientRequestExecutorPool(int maxConnectionsPerNode, int connectionTimeoutMs, int soTimeoutMs, int socketBufferSize) {
        this(2, maxConnectionsPerNode, connectionTimeoutMs, soTimeoutMs, socketBufferSize, false);
    }

    public ClientRequestExecutorFactory getFactory() {
        return this.factory;
    }

    public SocketStore create(String storeName, String hostName, int port, RequestFormatType requestFormatType, RequestRoutingType requestRoutingType) {
        SocketDestination dest = new SocketDestination(Utils.notNull(hostName), port, requestFormatType);
        return new SocketStore(Utils.notNull(storeName), this.factory.getTimeout(), dest, this, requestRoutingType);
    }

    public ClientRequestExecutor checkout(SocketDestination destination) {
        try {
            long start = System.nanoTime();
            ClientRequestExecutor clientRequestExecutor = this.pool.checkout(destination);
            this.updateStats(System.nanoTime() - start);
            return clientRequestExecutor;
        }
        catch (Exception e) {
            throw new UnreachableStoreException("Failure while checking out socket for " + destination + ": ", e);
        }
    }

    private void updateStats(long checkoutTimeNs) {
        int interval;
        long wait = this.waitNs.getAndAdd(checkoutTimeNs);
        int count = this.checkouts.getAndIncrement();
        if (count % (interval = this.monitoringInterval.get()) == interval - 1) {
            this.waitNs.set(0L);
            this.checkouts.set(0);
            this.avgWaitNs.set(wait / (long)count);
        }
    }

    public void checkin(SocketDestination destination, ClientRequestExecutor clientRequestExecutor) {
        try {
            this.pool.checkin(destination, clientRequestExecutor);
        }
        catch (Exception e) {
            throw new VoldemortException("Failure while checking in socket for " + destination + ": ", e);
        }
    }

    public void close(SocketDestination destination) {
        this.factory.setLastClosedTimestamp(destination);
        this.pool.close(destination);
    }

    public void close() {
        this.factory.close();
        this.pool.close();
    }

    @JmxGetter(name="socketsCreated", description="The total number of sockets created by this pool.")
    public int getNumberSocketsCreated() {
        return this.factory.getNumberCreated();
    }

    @JmxGetter(name="socketsDestroyed", description="The total number of sockets destroyed by this pool.")
    public int getNumberSocketsDestroyed() {
        return this.factory.getNumberDestroyed();
    }

    @JmxGetter(name="numberOfConnections", description="The number of active connections.")
    public int getNumberOfActiveConnections() {
        return this.pool.getTotalResourceCount();
    }

    @JmxGetter(name="numberOfIdleConnections", description="The number of active connections.")
    public int getNumberOfCheckedInConnections() {
        return this.pool.getCheckedInResourceCount();
    }

    @JmxGetter(name="avgWaitTimeMs", description="The avg. ms of wait time to acquire a connection.")
    public double getAvgWaitTimeMs() {
        return this.avgWaitNs.doubleValue() / 1000000.0;
    }

    @JmxSetter(name="monitoringInterval", description="The number of checkouts over which performance statistics are calculated.")
    public void setMonitoringInterval(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Monitoring interval must be a positive number.");
        }
        this.monitoringInterval.set(count);
    }
}

