/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket.clientrequest;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import voldemort.VoldemortException;
import voldemort.store.socket.clientrequest.ClientRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingClientRequest<T>
implements ClientRequest<T> {
    private final ClientRequest<T> delegate;
    private final CountDownLatch latch;
    private final long timeoutMs;

    public BlockingClientRequest(ClientRequest<T> delegate, long timeoutMs) {
        this.delegate = delegate;
        this.timeoutMs = timeoutMs;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public void complete() {
        this.delegate.complete();
        this.latch.countDown();
    }

    @Override
    public boolean isComplete() {
        return this.delegate.isComplete() && this.latch.getCount() == 0L;
    }

    public void await() throws InterruptedException {
        this.latch.await(this.timeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public T getResult() throws VoldemortException, IOException {
        return this.delegate.getResult();
    }

    @Override
    public boolean isCompleteResponse(ByteBuffer buffer) {
        return this.delegate.isCompleteResponse(buffer);
    }

    @Override
    public void parseResponse(DataInputStream inputStream) {
        this.delegate.parseResponse(inputStream);
    }

    @Override
    public boolean formatRequest(DataOutputStream outputStream) {
        return this.delegate.formatRequest(outputStream);
    }
}

