/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import voldemort.VoldemortException;
import voldemort.client.protocol.RequestFormat;
import voldemort.client.protocol.RequestFormatFactory;
import voldemort.server.RequestRoutingType;
import voldemort.store.NoSuchCapabilityException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.store.StoreUtils;
import voldemort.store.UnreachableStoreException;
import voldemort.store.nonblockingstore.NonblockingStore;
import voldemort.store.nonblockingstore.NonblockingStoreCallback;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.clientrequest.BlockingClientRequest;
import voldemort.store.socket.clientrequest.ClientRequest;
import voldemort.store.socket.clientrequest.ClientRequestExecutor;
import voldemort.store.socket.clientrequest.ClientRequestExecutorPool;
import voldemort.store.socket.clientrequest.DeleteClientRequest;
import voldemort.store.socket.clientrequest.GetAllClientRequest;
import voldemort.store.socket.clientrequest.GetClientRequest;
import voldemort.store.socket.clientrequest.GetVersionsClientRequest;
import voldemort.store.socket.clientrequest.PutClientRequest;
import voldemort.utils.ByteArray;
import voldemort.utils.Utils;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketStore
implements Store<ByteArray, byte[], byte[]>,
NonblockingStore {
    private final RequestFormatFactory requestFormatFactory = new RequestFormatFactory();
    private final String storeName;
    private final long timeoutMs;
    private final ClientRequestExecutorPool pool;
    private final SocketDestination destination;
    private final RequestFormat requestFormat;
    private final RequestRoutingType requestRoutingType;
    private final Logger logger = Logger.getLogger(SocketStore.class);

    public SocketStore(String storeName, long timeoutMs, SocketDestination dest, ClientRequestExecutorPool pool, RequestRoutingType requestRoutingType) {
        this.storeName = Utils.notNull(storeName);
        this.timeoutMs = timeoutMs;
        this.pool = Utils.notNull(pool);
        this.destination = dest;
        this.requestFormat = this.requestFormatFactory.getRequestFormat(dest.getRequestFormatType());
        this.requestRoutingType = requestRoutingType;
    }

    @Override
    public void submitDeleteRequest(ByteArray key, Version version, NonblockingStoreCallback callback, long timeoutMs) {
        StoreUtils.assertValidKey(key);
        DeleteClientRequest clientRequest = new DeleteClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key, version);
        this.requestAsync(clientRequest, callback, timeoutMs, "delete");
    }

    @Override
    public void submitGetRequest(ByteArray key, byte[] transforms, NonblockingStoreCallback callback, long timeoutMs) {
        StoreUtils.assertValidKey(key);
        GetClientRequest clientRequest = new GetClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key, transforms);
        this.requestAsync(clientRequest, callback, timeoutMs, "get");
    }

    @Override
    public void submitGetAllRequest(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms, NonblockingStoreCallback callback, long timeoutMs) {
        StoreUtils.assertValidKeys(keys);
        GetAllClientRequest clientRequest = new GetAllClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, keys, transforms);
        this.requestAsync(clientRequest, callback, timeoutMs, "get all");
    }

    @Override
    public void submitGetVersionsRequest(ByteArray key, NonblockingStoreCallback callback, long timeoutMs) {
        StoreUtils.assertValidKey(key);
        GetVersionsClientRequest clientRequest = new GetVersionsClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key);
        this.requestAsync(clientRequest, callback, timeoutMs, "get versions");
    }

    @Override
    public void submitPutRequest(ByteArray key, Versioned<byte[]> value, byte[] transforms, NonblockingStoreCallback callback, long timeoutMs) {
        StoreUtils.assertValidKey(key);
        PutClientRequest clientRequest = new PutClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key, value, transforms);
        this.requestAsync(clientRequest, callback, timeoutMs, "put");
    }

    @Override
    public boolean delete(ByteArray key, Version version) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        DeleteClientRequest clientRequest = new DeleteClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key, version);
        return this.request(clientRequest, "delete");
    }

    @Override
    public List<Versioned<byte[]>> get(ByteArray key, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        GetClientRequest clientRequest = new GetClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key, transforms);
        return this.request(clientRequest, "get");
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> getAll(Iterable<ByteArray> keys, Map<ByteArray, byte[]> transforms) throws VoldemortException {
        StoreUtils.assertValidKeys(keys);
        GetAllClientRequest clientRequest = new GetAllClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, keys, transforms);
        return this.request(clientRequest, "getAll");
    }

    @Override
    public List<Version> getVersions(ByteArray key) {
        StoreUtils.assertValidKey(key);
        GetVersionsClientRequest clientRequest = new GetVersionsClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key);
        return this.request(clientRequest, "getVersions");
    }

    @Override
    public void put(ByteArray key, Versioned<byte[]> versioned, byte[] transforms) throws VoldemortException {
        StoreUtils.assertValidKey(key);
        PutClientRequest clientRequest = new PutClientRequest(this.storeName, this.requestFormat, this.requestRoutingType, key, versioned, transforms);
        this.request(clientRequest, "put");
    }

    @Override
    public Object getCapability(StoreCapabilityType capability) {
        if (StoreCapabilityType.SOCKET_POOL.equals((Object)capability)) {
            return this.pool;
        }
        throw new NoSuchCapabilityException(capability, this.getName());
    }

    @Override
    public String getName() {
        return this.storeName;
    }

    @Override
    public void close() throws VoldemortException {
    }

    private <T> T request(ClientRequest<T> delegate, String operationName) {
        ClientRequestExecutor clientRequestExecutor = this.pool.checkout(this.destination);
        try {
            BlockingClientRequest<T> blockingClientRequest = new BlockingClientRequest<T>(delegate, this.timeoutMs);
            clientRequestExecutor.addClientRequest(blockingClientRequest, this.timeoutMs);
            blockingClientRequest.await();
            T t = blockingClientRequest.getResult();
            return t;
        }
        catch (InterruptedException e) {
            throw new UnreachableStoreException("Failure in " + operationName + " on " + this.destination + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            clientRequestExecutor.close();
            throw new UnreachableStoreException("Failure in " + operationName + " on " + this.destination + ": " + e.getMessage(), e);
        }
        finally {
            this.pool.checkin(this.destination, clientRequestExecutor);
        }
    }

    private <T> void requestAsync(ClientRequest<T> delegate, NonblockingStoreCallback callback, long timeoutMs, String operationName) {
        ClientRequestExecutor clientRequestExecutor = null;
        try {
            clientRequestExecutor = this.pool.checkout(this.destination);
        }
        catch (Exception e2) {
            block5: {
                UnreachableStoreException e2;
                if (!(e2 instanceof UnreachableStoreException)) {
                    e2 = new UnreachableStoreException("Failure in " + operationName + ": " + e2.getMessage(), e2);
                }
                try {
                    callback.requestComplete(e2, 0L);
                }
                catch (Exception ex) {
                    if (!this.logger.isEnabledFor((Priority)Level.WARN)) break block5;
                    this.logger.warn((Object)ex, (Throwable)ex);
                }
            }
            return;
        }
        NonblockingStoreCallbackClientRequest<T> clientRequest = new NonblockingStoreCallbackClientRequest<T>(delegate, clientRequestExecutor, callback);
        clientRequestExecutor.addClientRequest(clientRequest, timeoutMs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NonblockingStoreCallbackClientRequest<T>
    implements ClientRequest<T> {
        private final ClientRequest<T> clientRequest;
        private final ClientRequestExecutor clientRequestExecutor;
        private final NonblockingStoreCallback callback;
        private final long startNs;
        private volatile boolean isComplete;

        public NonblockingStoreCallbackClientRequest(ClientRequest<T> clientRequest, ClientRequestExecutor clientRequestExecutor, NonblockingStoreCallback callback) {
            this.clientRequest = clientRequest;
            this.clientRequestExecutor = clientRequestExecutor;
            this.callback = callback;
            this.startNs = System.nanoTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() {
            try {
                this.clientRequest.complete();
                T result = this.clientRequest.getResult();
                if (this.callback != null) {
                    try {
                        this.callback.requestComplete(result, (System.nanoTime() - this.startNs) / 1000000L);
                    }
                    catch (Exception e) {
                        if (SocketStore.this.logger.isEnabledFor((Priority)Level.WARN)) {
                            SocketStore.this.logger.warn((Object)e, (Throwable)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (this.callback != null) {
                    try {
                        this.callback.requestComplete(e, (System.nanoTime() - this.startNs) / 1000000L);
                    }
                    catch (Exception ex) {
                        if (SocketStore.this.logger.isEnabledFor((Priority)Level.WARN)) {
                            SocketStore.this.logger.warn((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
            finally {
                SocketStore.this.pool.checkin(SocketStore.this.destination, this.clientRequestExecutor);
                this.isComplete = true;
            }
        }

        @Override
        public boolean isComplete() {
            return this.isComplete;
        }

        @Override
        public boolean formatRequest(DataOutputStream outputStream) {
            return this.clientRequest.formatRequest(outputStream);
        }

        @Override
        public T getResult() throws VoldemortException, IOException {
            return this.clientRequest.getResult();
        }

        @Override
        public boolean isCompleteResponse(ByteBuffer buffer) {
            return this.clientRequest.isCompleteResponse(buffer);
        }

        @Override
        public void parseResponse(DataInputStream inputStream) {
            this.clientRequest.parseResponse(inputStream);
        }
    }
}

