/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.slop.strategy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.slop.strategy.HintedHandoffStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProximityHandoffStrategy
implements HintedHandoffStrategy {
    private final Cluster cluster;
    private final int clientZoneId;
    private Map<Integer, List<Node>> zoneMapping;

    public ProximityHandoffStrategy(Cluster cluster, int clientZoneId) {
        this.cluster = cluster;
        this.clientZoneId = clientZoneId;
        this.zoneMapping = Maps.newHashMap();
        for (Node node : cluster.getNodes()) {
            ArrayList nodes = this.zoneMapping.get(node.getZoneId());
            if (nodes == null) {
                nodes = Lists.newArrayList();
                this.zoneMapping.put(node.getZoneId(), nodes);
            }
            nodes.add(node);
        }
    }

    @Override
    public List<Node> routeHint(Node origin) {
        ArrayList<Node> proximityList = new ArrayList<Node>();
        Collections.shuffle(this.zoneMapping.get(this.clientZoneId));
        proximityList.addAll((Collection)this.zoneMapping.get(this.clientZoneId));
        for (Integer zoneId : this.cluster.getZoneById(this.clientZoneId).getProximityList()) {
            Collections.shuffle(this.zoneMapping.get(zoneId));
            proximityList.addAll((Collection<Node>)this.zoneMapping.get(zoneId));
        }
        proximityList.remove(origin);
        return proximityList;
    }

    public String toString() {
        return "ProximityHandoffStrategy(" + this.cluster.getNodes() + ")";
    }
}

